/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.commons.configuration2.tree.xpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hive.org.apache.commons.configuration2.tree.xpath.ConfigurationNodeIteratorBase;
import org.apache.hive.org.apache.commons.configuration2.tree.xpath.ConfigurationNodePointer;
import org.apache.hive.org.apache.commons.jxpath.ri.QName;
import org.apache.hive.org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.hive.org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.hive.org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.hive.org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.hive.org.apache.commons.lang3.StringUtils;

class ConfigurationNodeIteratorChildren<T>
extends ConfigurationNodeIteratorBase<T> {
    private final List<T> subNodes;

    public ConfigurationNodeIteratorChildren(ConfigurationNodePointer<T> parent, NodeTest nodeTest, boolean reverse, ConfigurationNodePointer<T> startsWith) {
        super(parent, reverse);
        T root = parent.getConfigurationNode();
        this.subNodes = this.createSubNodeList(root, nodeTest);
        if (startsWith != null) {
            this.setStartOffset(this.findStartIndex(this.subNodes, startsWith.getConfigurationNode()));
        } else if (reverse) {
            this.setStartOffset(this.size());
        }
    }

    @Override
    protected NodePointer createNodePointer(int position) {
        return new ConfigurationNodePointer(this.getParent(), this.subNodes.get(position), this.getNodeHandler());
    }

    @Override
    protected int size() {
        return this.subNodes.size();
    }

    private List<T> createSubNodeList(T node, NodeTest test) {
        NodeTypeTest typeTest;
        if (test == null) {
            return this.getNodeHandler().getChildren(node);
        }
        if (test instanceof NodeNameTest) {
            NodeNameTest nameTest = (NodeNameTest)test;
            QName name = nameTest.getNodeName();
            return nameTest.isWildcard() ? this.createSubNodeListForWildcardName(node, name) : this.createSubNodeListForName(node, name);
        }
        if (test instanceof NodeTypeTest && ((typeTest = (NodeTypeTest)test).getNodeType() == 1 || typeTest.getNodeType() == 2)) {
            return this.getNodeHandler().getChildren(node);
        }
        return Collections.emptyList();
    }

    private List<T> createSubNodeListForName(T node, QName name) {
        String compareName = ConfigurationNodeIteratorChildren.qualifiedName(name);
        ArrayList result = new ArrayList();
        for (Object child : this.getNodeHandler().getChildren(node)) {
            if (!StringUtils.equals(compareName, this.getNodeHandler().nodeName(child))) continue;
            result.add(child);
        }
        return result;
    }

    private List<T> createSubNodeListForWildcardName(T node, QName name) {
        List children = this.getNodeHandler().getChildren(node);
        if (name.getPrefix() == null) {
            return children;
        }
        ArrayList prefixChildren = new ArrayList(children.size());
        String prefix = ConfigurationNodeIteratorChildren.prefixName(name.getPrefix(), null);
        for (Object child : children) {
            if (!StringUtils.startsWith(this.getNodeHandler().nodeName(child), prefix)) continue;
            prefixChildren.add(child);
        }
        return prefixChildren;
    }

    private int findStartIndex(List<T> children, T startNode) {
        int index = 0;
        for (T child : children) {
            if (child == startNode) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

