/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.common;

import java.util.Objects;
import org.apache.hive.org.apache.zookeeper.common.BCFKSFileLoader;
import org.apache.hive.org.apache.zookeeper.common.FileKeyStoreLoader;
import org.apache.hive.org.apache.zookeeper.common.JKSFileLoader;
import org.apache.hive.org.apache.zookeeper.common.KeyStoreFileType;
import org.apache.hive.org.apache.zookeeper.common.PEMFileLoader;
import org.apache.hive.org.apache.zookeeper.common.PKCS12FileLoader;

public class FileKeyStoreLoaderBuilderProvider {
    static FileKeyStoreLoader.Builder<? extends FileKeyStoreLoader> getBuilderForKeyStoreFileType(KeyStoreFileType type) {
        switch (Objects.requireNonNull(type)) {
            case JKS: {
                return new JKSFileLoader.Builder();
            }
            case PEM: {
                return new PEMFileLoader.Builder();
            }
            case PKCS12: {
                return new PKCS12FileLoader.Builder();
            }
            case BCFKS: {
                return new BCFKSFileLoader.Builder();
            }
        }
        throw new AssertionError((Object)("Unexpected StoreFileType: " + type.name()));
    }
}

