/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.hive.common.log.ProgressMonitor;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.CompositeService;
import org.apache.hive.service.ServiceException;
import org.apache.hive.service.ServiceUtils;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.FetchType;
import org.apache.hive.service.cli.GetInfoType;
import org.apache.hive.service.cli.GetInfoValue;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.ICLIService;
import org.apache.hive.service.cli.JobProgressUpdate;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationStatus;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.SessionManager;
import org.apache.hive.service.rpc.thrift.TOperationHandle;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.hive.service.server.HiveServer2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLIService
extends CompositeService
implements ICLIService {
    public static final TProtocolVersion SERVER_VERSION;
    private final Logger LOG = LoggerFactory.getLogger(CLIService.class.getName());
    private SessionManager sessionManager;
    private UserGroupInformation serviceUGI;
    private UserGroupInformation httpUGI;
    private final HiveServer2 hiveServer2;
    private int defaultFetchRows;
    private boolean allowSessionsInitial;
    private static final long PROGRESS_MAX_WAIT_NS = 30000000000L;

    public CLIService(HiveServer2 hiveServer2, boolean allowSessions) {
        super(CLIService.class.getSimpleName());
        this.hiveServer2 = hiveServer2;
        this.allowSessionsInitial = allowSessions;
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.setHiveConf(hiveConf);
        this.sessionManager = new SessionManager(this.hiveServer2, this.allowSessionsInitial);
        this.defaultFetchRows = hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_RESULTSET_DEFAULT_FETCH_SIZE);
        this.addService(this.sessionManager);
        if (UserGroupInformation.isSecurityEnabled()) {
            try {
                HiveAuthFactory.loginFromKeytab(hiveConf);
                this.serviceUGI = Utils.getUGI();
            }
            catch (IOException e) {
                throw new ServiceException("Unable to login to kerberos with given principal/keytab", e);
            }
            catch (LoginException e) {
                throw new ServiceException("Unable to login to kerberos with given principal/keytab", e);
            }
            String principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_PRINCIPAL);
            String keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_KEYTAB);
            if (principal.isEmpty() || keyTabFile.isEmpty()) {
                this.LOG.info("SPNego httpUGI not created, spNegoPrincipal: " + principal + ", ketabFile: " + keyTabFile);
            } else {
                try {
                    this.httpUGI = HiveAuthFactory.loginFromSpnegoKeytabAndReturnUGI(hiveConf);
                    this.LOG.info("SPNego httpUGI successfully created.");
                }
                catch (IOException e) {
                    this.LOG.warn("SPNego httpUGI creation failed: ", e);
                }
            }
        }
        try {
            this.applyAuthorizationConfigPolicy(hiveConf);
        }
        catch (Exception e) {
            throw new RuntimeException("Error applying authorization policy on hive configuration: " + e.getMessage(), e);
        }
        this.setupBlockedUdfs();
        super.init(hiveConf);
    }

    private void applyAuthorizationConfigPolicy(HiveConf newHiveConf) throws HiveException, MetaException {
        SessionState ss = new SessionState(newHiveConf);
        ss.setIsHiveServerQuery(true);
        SessionState.start((SessionState)ss);
        ss.applyAuthorizationPolicy();
    }

    private void setupBlockedUdfs() {
        HiveConf hiveConf = this.getHiveConf();
        FunctionRegistry.setupPermissionsForBuiltinUDFs((String)hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_BUILTIN_UDF_WHITELIST), (String)hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_BUILTIN_UDF_BLACKLIST));
    }

    public UserGroupInformation getServiceUGI() {
        return this.serviceUGI;
    }

    public UserGroupInformation getHttpUGI() {
        return this.httpUGI;
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    @Override
    public synchronized void stop() {
        super.stop();
        Hive.closeCurrent();
    }

    @Deprecated
    public SessionHandle openSession(TProtocolVersion protocol, String username, String password, Map<String, String> configuration) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(protocol, username, password, null, configuration, false, null);
        this.LOG.debug(sessionHandle + ": openSession()");
        return sessionHandle;
    }

    @Deprecated
    public SessionHandle openSessionWithImpersonation(TProtocolVersion protocol, String username, String password, Map<String, String> configuration, String delegationToken) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(protocol, username, password, null, configuration, true, delegationToken);
        this.LOG.debug(sessionHandle + ": openSessionWithImpersonation()");
        return sessionHandle;
    }

    public SessionHandle openSession(TProtocolVersion protocol, String username, String password, String ipAddress, Map<String, String> configuration) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(protocol, username, password, ipAddress, configuration, false, null);
        this.LOG.debug(sessionHandle + ": openSession()");
        return sessionHandle;
    }

    public SessionHandle openSessionWithImpersonation(TProtocolVersion protocol, String username, String password, String ipAddress, Map<String, String> configuration, String delegationToken) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(protocol, username, password, ipAddress, configuration, true, delegationToken);
        this.LOG.debug(sessionHandle + ": openSession()");
        return sessionHandle;
    }

    @Override
    public SessionHandle openSession(String username, String password, Map<String, String> configuration) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(SERVER_VERSION, username, password, null, configuration, false, null);
        this.LOG.debug(sessionHandle + ": openSession()");
        return sessionHandle;
    }

    public void createSessionWithSessionHandle(SessionHandle sessionHandle, String username, String password, Map<String, String> configuration) throws HiveSQLException {
        this.sessionManager.createSession(sessionHandle, SERVER_VERSION, username, password, null, configuration, false, null);
        this.LOG.debug(sessionHandle + ": createSessionWithSessionHandle()");
    }

    @Override
    public SessionHandle openSessionWithImpersonation(String username, String password, Map<String, String> configuration, String delegationToken) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(SERVER_VERSION, username, password, null, configuration, true, delegationToken);
        this.LOG.debug(sessionHandle + ": openSession()");
        return sessionHandle;
    }

    @Override
    public void closeSession(SessionHandle sessionHandle) throws HiveSQLException {
        this.sessionManager.closeSession(sessionHandle);
        this.LOG.debug(sessionHandle + ": closeSession()");
    }

    @Override
    public GetInfoValue getInfo(SessionHandle sessionHandle, GetInfoType getInfoType) throws HiveSQLException {
        GetInfoValue infoValue = this.sessionManager.getSession(sessionHandle).getInfo(getInfoType);
        this.LOG.debug(sessionHandle + ": getInfo()");
        return infoValue;
    }

    @Override
    public OperationHandle executeStatement(SessionHandle sessionHandle, String statement, Map<String, String> confOverlay) throws HiveSQLException {
        HiveSession session = this.sessionManager.getSession(sessionHandle);
        session.getSessionState().updateProgressMonitor(null);
        OperationHandle opHandle = session.executeStatement(statement, confOverlay);
        this.LOG.debug(sessionHandle + ": executeStatement()");
        return opHandle;
    }

    @Override
    public OperationHandle executeStatement(SessionHandle sessionHandle, String statement, Map<String, String> confOverlay, long queryTimeout) throws HiveSQLException {
        HiveSession session = this.sessionManager.getSession(sessionHandle);
        session.getSessionState().updateProgressMonitor(null);
        OperationHandle opHandle = session.executeStatement(statement, confOverlay, queryTimeout);
        this.LOG.debug(sessionHandle + ": executeStatement()");
        return opHandle;
    }

    @Override
    public OperationHandle executeStatementAsync(SessionHandle sessionHandle, String statement, Map<String, String> confOverlay) throws HiveSQLException {
        HiveSession session = this.sessionManager.getSession(sessionHandle);
        session.getSessionState().updateProgressMonitor(null);
        OperationHandle opHandle = session.executeStatementAsync(statement, confOverlay);
        this.LOG.debug(sessionHandle + ": executeStatementAsync()");
        return opHandle;
    }

    @Override
    public OperationHandle executeStatementAsync(SessionHandle sessionHandle, String statement, Map<String, String> confOverlay, long queryTimeout) throws HiveSQLException {
        HiveSession session = this.sessionManager.getSession(sessionHandle);
        session.getSessionState().updateProgressMonitor(null);
        OperationHandle opHandle = session.executeStatementAsync(statement, confOverlay, queryTimeout);
        this.LOG.debug(sessionHandle + ": executeStatementAsync()");
        return opHandle;
    }

    @Override
    public OperationHandle getTypeInfo(SessionHandle sessionHandle) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getTypeInfo();
        this.LOG.debug(sessionHandle + ": getTypeInfo()");
        return opHandle;
    }

    @Override
    public OperationHandle getCatalogs(SessionHandle sessionHandle) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getCatalogs();
        this.LOG.debug(sessionHandle + ": getCatalogs()");
        return opHandle;
    }

    @Override
    public OperationHandle getSchemas(SessionHandle sessionHandle, String catalogName, String schemaName) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getSchemas(catalogName, schemaName);
        this.LOG.debug(sessionHandle + ": getSchemas()");
        return opHandle;
    }

    @Override
    public OperationHandle getTables(SessionHandle sessionHandle, String catalogName, String schemaName, String tableName, List<String> tableTypes) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getTables(catalogName, schemaName, tableName, tableTypes);
        this.LOG.debug(sessionHandle + ": getTables()");
        return opHandle;
    }

    @Override
    public OperationHandle getTableTypes(SessionHandle sessionHandle) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getTableTypes();
        this.LOG.debug(sessionHandle + ": getTableTypes()");
        return opHandle;
    }

    @Override
    public OperationHandle getColumns(SessionHandle sessionHandle, String catalogName, String schemaName, String tableName, String columnName) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getColumns(catalogName, schemaName, tableName, columnName);
        this.LOG.debug(sessionHandle + ": getColumns()");
        return opHandle;
    }

    @Override
    public OperationHandle getFunctions(SessionHandle sessionHandle, String catalogName, String schemaName, String functionName) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getFunctions(catalogName, schemaName, functionName);
        this.LOG.debug(sessionHandle + ": getFunctions()");
        return opHandle;
    }

    @Override
    public OperationHandle getPrimaryKeys(SessionHandle sessionHandle, String catalog, String schema, String table) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getPrimaryKeys(catalog, schema, table);
        this.LOG.debug(sessionHandle + ": getPrimaryKeys()");
        return opHandle;
    }

    @Override
    public OperationHandle getCrossReference(SessionHandle sessionHandle, String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getCrossReference(primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable);
        this.LOG.debug(sessionHandle + ": getCrossReference()");
        return opHandle;
    }

    @Override
    public OperationHandle uploadData(SessionHandle sessionHandle, ByteBuffer values, String tableName, String path) throws HiveSQLException {
        this.LOG.info(sessionHandle + ": uploadData()");
        return this.sessionManager.getSession(sessionHandle).uploadData(values, tableName, path);
    }

    @Override
    public OperationHandle downloadData(SessionHandle sessionHandle, String tableName, String query, String format, Map<String, String> options) throws HiveSQLException {
        this.LOG.info(sessionHandle + ": downloadData()");
        return this.sessionManager.getSession(sessionHandle).downloadData(tableName, query, format, options);
    }

    @Override
    public OperationStatus getOperationStatus(OperationHandle opHandle, boolean getProgressUpdate) throws HiveSQLException {
        Operation operation = this.sessionManager.getOperationManager().getOperation(opHandle);
        HiveConf conf = operation.getParentSession().getHiveConf();
        if (operation.shouldRunAsync()) {
            long maxTimeout = HiveConf.getTimeVar(conf, HiveConf.ConfVars.HIVE_SERVER2_LONG_POLLING_TIMEOUT, TimeUnit.MILLISECONDS);
            long elapsed = System.currentTimeMillis() - operation.getBeginTime();
            long timeout = Math.min(maxTimeout, (elapsed / TimeUnit.SECONDS.toMillis(10L) + 1L) * 500L);
            try {
                operation.getBackgroundHandle().get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                this.LOG.trace(opHandle + ": Long polling timed out");
            }
            catch (CancellationException e) {
                this.LOG.trace(opHandle + ": The background operation was cancelled", e);
            }
            catch (ExecutionException e) {
                this.LOG.warn(opHandle + ": The background operation was aborted", e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        OperationStatus opStatus = operation.getStatus();
        this.LOG.debug(opHandle + ": getOperationStatus()");
        long numModifiedRows = operation.getNumModifiedRows();
        opStatus.setNumModifiedRows(numModifiedRows);
        opStatus.setJobProgressUpdate(this.progressUpdateLog(getProgressUpdate, operation, conf));
        return opStatus;
    }

    public HiveConf getHiveSessionConf(OperationHandle opHandle) throws HiveSQLException {
        Operation operation = this.sessionManager.getOperationManager().getOperation(opHandle);
        return operation.getParentSession().getHiveConf();
    }

    public HiveConf getSessionConf(SessionHandle sessionHandle) throws HiveSQLException {
        return this.sessionManager.getSession(sessionHandle).getSessionConf();
    }

    private JobProgressUpdate progressUpdateLog(boolean isProgressLogRequested, Operation operation, HiveConf conf) {
        if (!(isProgressLogRequested && ServiceUtils.canProvideProgressLog(conf) && OperationType.EXECUTE_STATEMENT.equals((Object)operation.getType()))) {
            return new JobProgressUpdate(ProgressMonitor.NULL);
        }
        SessionState sessionState = operation.getParentSession().getSessionState();
        long startTime = System.nanoTime();
        int timeOutMs = 8;
        boolean terminated = operation.isDone();
        try {
            while (sessionState.getProgressMonitor() == null && !terminated) {
                long remainingMs = (30000000000L - (System.nanoTime() - startTime)) / 1000000L;
                if (remainingMs <= 0L) {
                    this.LOG.debug("timed out and hence returning progress log as NULL");
                    return new JobProgressUpdate(ProgressMonitor.NULL);
                }
                terminated = operation.waitToTerminate(Math.min(remainingMs, (long)timeOutMs));
                timeOutMs <<= 1;
            }
        }
        catch (InterruptedException e) {
            this.LOG.warn("Error while getting progress update", e);
        }
        ProgressMonitor pm = sessionState.getProgressMonitor();
        return new JobProgressUpdate(pm != null ? pm : ProgressMonitor.NULL);
    }

    @Override
    public void cancelOperation(OperationHandle opHandle) throws HiveSQLException {
        this.sessionManager.getOperationManager().getOperation(opHandle).getParentSession().cancelOperation(opHandle);
        this.LOG.debug(opHandle + ": cancelOperation()");
    }

    @Override
    public void closeOperation(OperationHandle opHandle) throws HiveSQLException {
        this.sessionManager.getOperationManager().getOperation(opHandle).getParentSession().closeOperation(opHandle);
        this.LOG.debug(opHandle + ": closeOperation");
    }

    @Override
    public TableSchema getResultSetMetadata(OperationHandle opHandle) throws HiveSQLException {
        TableSchema tableSchema = this.sessionManager.getOperationManager().getOperation(opHandle).getParentSession().getResultSetMetadata(opHandle);
        this.LOG.debug(opHandle + ": getResultSetMetadata()");
        return tableSchema;
    }

    @Override
    public RowSet fetchResults(OperationHandle opHandle) throws HiveSQLException {
        return this.fetchResults(opHandle, Operation.DEFAULT_FETCH_ORIENTATION, this.defaultFetchRows, FetchType.QUERY_OUTPUT);
    }

    @Override
    public RowSet fetchResults(OperationHandle opHandle, FetchOrientation orientation, long maxRows, FetchType fetchType) throws HiveSQLException {
        RowSet rowSet = this.sessionManager.getOperationManager().getOperation(opHandle).getParentSession().fetchResults(opHandle, orientation, maxRows, fetchType);
        this.LOG.debug(opHandle + ": fetchResults()");
        return rowSet;
    }

    public String getDelegationTokenFromMetaStore(String owner) throws HiveSQLException, UnsupportedOperationException, LoginException, IOException {
        HiveConf hiveConf = this.getHiveConf();
        if (!hiveConf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL) || !hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS)) {
            throw new UnsupportedOperationException("delegation token is can only be obtained for a secure remote metastore");
        }
        try {
            Hive.closeCurrent();
            return Hive.get((HiveConf)hiveConf).getDelegationToken(owner, owner);
        }
        catch (HiveException e) {
            if (e.getCause() instanceof UnsupportedOperationException) {
                throw (UnsupportedOperationException)e.getCause();
            }
            throw new HiveSQLException("Error connect metastore to setup impersonation", e);
        }
    }

    @Override
    public String getDelegationToken(SessionHandle sessionHandle, HiveAuthFactory authFactory, String owner, String renewer) throws HiveSQLException {
        String delegationToken = this.sessionManager.getSession(sessionHandle).getDelegationToken(authFactory, owner, renewer);
        this.LOG.info(sessionHandle + ": getDelegationToken() owner: " + owner + ", renewer: " + renewer);
        return delegationToken;
    }

    @Override
    public void setApplicationName(SessionHandle sh, String value) throws HiveSQLException {
        this.sessionManager.getSession(sh).setApplicationName(value);
    }

    @Override
    public void cancelDelegationToken(SessionHandle sessionHandle, HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        this.sessionManager.getSession(sessionHandle).cancelDelegationToken(authFactory, tokenStr);
        this.LOG.info(sessionHandle + ": cancelDelegationToken()");
    }

    @Override
    public void renewDelegationToken(SessionHandle sessionHandle, HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        this.sessionManager.getSession(sessionHandle).renewDelegationToken(authFactory, tokenStr);
        this.LOG.info(sessionHandle + ": renewDelegationToken()");
    }

    @Override
    public String getQueryId(TOperationHandle opHandle) throws HiveSQLException {
        Operation operation = this.sessionManager.getOperationManager().getOperation(new OperationHandle(opHandle));
        String queryId = operation.getQueryId();
        this.LOG.debug(opHandle + ": getQueryId() " + queryId);
        return queryId;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    static {
        TProtocolVersion[] protocols = TProtocolVersion.values();
        SERVER_VERSION = protocols[protocols.length - 1];
    }
}

