/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.FetchType;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.ICLIService;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.SessionHandle;

public abstract class CLIServiceClient
implements ICLIService {
    protected int defaultFetchRows;

    public CLIServiceClient(Configuration conf) {
        this.defaultFetchRows = HiveConf.ConfVars.HIVE_SERVER2_THRIFT_RESULTSET_DEFAULT_FETCH_SIZE.defaultIntVal;
        this.defaultFetchRows = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_SERVER2_THRIFT_RESULTSET_DEFAULT_FETCH_SIZE);
    }

    public SessionHandle openSession(String username, String password) throws HiveSQLException {
        return this.openSession(username, password, Collections.emptyMap());
    }

    @Override
    public RowSet fetchResults(OperationHandle opHandle) throws HiveSQLException {
        return this.fetchResults(opHandle, FetchOrientation.FETCH_NEXT, this.defaultFetchRows, FetchType.QUERY_OUTPUT);
    }

    @Override
    public abstract String getDelegationToken(SessionHandle var1, HiveAuthFactory var2, String var3, String var4) throws HiveSQLException;

    @Override
    public abstract void cancelDelegationToken(SessionHandle var1, HiveAuthFactory var2, String var3) throws HiveSQLException;

    @Override
    public abstract void renewDelegationToken(SessionHandle var1, HiveAuthFactory var2, String var3) throws HiveSQLException;
}

