# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'AuthBackendTuneArgs',
    'AuthBackendTuneArgsDict',
    'ProviderAuthLoginArgs',
    'ProviderAuthLoginArgsDict',
    'ProviderAuthLoginAwsArgs',
    'ProviderAuthLoginAwsArgsDict',
    'ProviderAuthLoginAzureArgs',
    'ProviderAuthLoginAzureArgsDict',
    'ProviderAuthLoginCertArgs',
    'ProviderAuthLoginCertArgsDict',
    'ProviderAuthLoginGcpArgs',
    'ProviderAuthLoginGcpArgsDict',
    'ProviderAuthLoginJwtArgs',
    'ProviderAuthLoginJwtArgsDict',
    'ProviderAuthLoginKerberosArgs',
    'ProviderAuthLoginKerberosArgsDict',
    'ProviderAuthLoginOciArgs',
    'ProviderAuthLoginOciArgsDict',
    'ProviderAuthLoginOidcArgs',
    'ProviderAuthLoginOidcArgsDict',
    'ProviderAuthLoginRadiusArgs',
    'ProviderAuthLoginRadiusArgsDict',
    'ProviderAuthLoginTokenFileArgs',
    'ProviderAuthLoginTokenFileArgsDict',
    'ProviderAuthLoginUserpassArgs',
    'ProviderAuthLoginUserpassArgsDict',
    'ProviderClientAuthArgs',
    'ProviderClientAuthArgsDict',
    'ProviderHeaderArgs',
    'ProviderHeaderArgsDict',
    'GetPolicyDocumentRuleArgs',
    'GetPolicyDocumentRuleArgsDict',
    'GetPolicyDocumentRuleAllowedParameterArgs',
    'GetPolicyDocumentRuleAllowedParameterArgsDict',
    'GetPolicyDocumentRuleDeniedParameterArgs',
    'GetPolicyDocumentRuleDeniedParameterArgsDict',
]

MYPY = False

if not MYPY:
    class AuthBackendTuneArgsDict(TypedDict):
        allowed_response_headers: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of headers to whitelist and allowing
        a plugin to include them in the response.
        """
        audit_non_hmac_request_keys: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies the list of keys that will
        not be HMAC'd by audit devices in the request data object.
        """
        audit_non_hmac_response_keys: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies the list of keys that will
        not be HMAC'd by audit devices in the response data object.
        """
        default_lease_ttl: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the default time-to-live.
        If set, this overrides the global default.
        Must be a valid [duration string](https://golang.org/pkg/time/#ParseDuration)
        """
        listing_visibility: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies whether to show this mount in
        the UI-specific listing endpoint. Valid values are "unauth" or "hidden".
        """
        max_lease_ttl: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the maximum time-to-live.
        If set, this overrides the global default.
        Must be a valid [duration string](https://golang.org/pkg/time/#ParseDuration)
        """
        passthrough_request_headers: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of headers to whitelist and
        pass from the request to the backend.
        """
        token_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the type of tokens that should be returned by
        the mount. Valid values are "default-service", "default-batch", "service", "batch".
        """
elif False:
    AuthBackendTuneArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AuthBackendTuneArgs:
    def __init__(__self__, *,
                 allowed_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_lease_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 listing_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 max_lease_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 passthrough_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_response_headers: List of headers to whitelist and allowing
               a plugin to include them in the response.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_request_keys: Specifies the list of keys that will
               not be HMAC'd by audit devices in the request data object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_response_keys: Specifies the list of keys that will
               not be HMAC'd by audit devices in the response data object.
        :param pulumi.Input[_builtins.str] default_lease_ttl: Specifies the default time-to-live.
               If set, this overrides the global default.
               Must be a valid [duration string](https://golang.org/pkg/time/#ParseDuration)
        :param pulumi.Input[_builtins.str] listing_visibility: Specifies whether to show this mount in
               the UI-specific listing endpoint. Valid values are "unauth" or "hidden".
        :param pulumi.Input[_builtins.str] max_lease_ttl: Specifies the maximum time-to-live.
               If set, this overrides the global default.
               Must be a valid [duration string](https://golang.org/pkg/time/#ParseDuration)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] passthrough_request_headers: List of headers to whitelist and
               pass from the request to the backend.
        :param pulumi.Input[_builtins.str] token_type: Specifies the type of tokens that should be returned by
               the mount. Valid values are "default-service", "default-batch", "service", "batch".
        """
        if allowed_response_headers is not None:
            pulumi.set(__self__, "allowed_response_headers", allowed_response_headers)
        if audit_non_hmac_request_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_request_keys", audit_non_hmac_request_keys)
        if audit_non_hmac_response_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_response_keys", audit_non_hmac_response_keys)
        if default_lease_ttl is not None:
            pulumi.set(__self__, "default_lease_ttl", default_lease_ttl)
        if listing_visibility is not None:
            pulumi.set(__self__, "listing_visibility", listing_visibility)
        if max_lease_ttl is not None:
            pulumi.set(__self__, "max_lease_ttl", max_lease_ttl)
        if passthrough_request_headers is not None:
            pulumi.set(__self__, "passthrough_request_headers", passthrough_request_headers)
        if token_type is not None:
            pulumi.set(__self__, "token_type", token_type)

    @_builtins.property
    @pulumi.getter(name="allowedResponseHeaders")
    def allowed_response_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to whitelist and allowing
        a plugin to include them in the response.
        """
        return pulumi.get(self, "allowed_response_headers")

    @allowed_response_headers.setter
    def allowed_response_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_response_headers", value)

    @_builtins.property
    @pulumi.getter(name="auditNonHmacRequestKeys")
    def audit_non_hmac_request_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of keys that will
        not be HMAC'd by audit devices in the request data object.
        """
        return pulumi.get(self, "audit_non_hmac_request_keys")

    @audit_non_hmac_request_keys.setter
    def audit_non_hmac_request_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audit_non_hmac_request_keys", value)

    @_builtins.property
    @pulumi.getter(name="auditNonHmacResponseKeys")
    def audit_non_hmac_response_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of keys that will
        not be HMAC'd by audit devices in the response data object.
        """
        return pulumi.get(self, "audit_non_hmac_response_keys")

    @audit_non_hmac_response_keys.setter
    def audit_non_hmac_response_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audit_non_hmac_response_keys", value)

    @_builtins.property
    @pulumi.getter(name="defaultLeaseTtl")
    def default_lease_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default time-to-live.
        If set, this overrides the global default.
        Must be a valid [duration string](https://golang.org/pkg/time/#ParseDuration)
        """
        return pulumi.get(self, "default_lease_ttl")

    @default_lease_ttl.setter
    def default_lease_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_lease_ttl", value)

    @_builtins.property
    @pulumi.getter(name="listingVisibility")
    def listing_visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to show this mount in
        the UI-specific listing endpoint. Valid values are "unauth" or "hidden".
        """
        return pulumi.get(self, "listing_visibility")

    @listing_visibility.setter
    def listing_visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listing_visibility", value)

    @_builtins.property
    @pulumi.getter(name="maxLeaseTtl")
    def max_lease_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the maximum time-to-live.
        If set, this overrides the global default.
        Must be a valid [duration string](https://golang.org/pkg/time/#ParseDuration)
        """
        return pulumi.get(self, "max_lease_ttl")

    @max_lease_ttl.setter
    def max_lease_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_lease_ttl", value)

    @_builtins.property
    @pulumi.getter(name="passthroughRequestHeaders")
    def passthrough_request_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to whitelist and
        pass from the request to the backend.
        """
        return pulumi.get(self, "passthrough_request_headers")

    @passthrough_request_headers.setter
    def passthrough_request_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "passthrough_request_headers", value)

    @_builtins.property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of tokens that should be returned by
        the mount. Valid values are "default-service", "default-batch", "service", "batch".
        """
        return pulumi.get(self, "token_type")

    @token_type.setter
    def token_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_type", value)


if not MYPY:
    class ProviderAuthLoginArgsDict(TypedDict):
        path: pulumi.Input[_builtins.str]
        method: NotRequired[pulumi.Input[_builtins.str]]
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        parameters: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        use_root_namespace: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
elif False:
    ProviderAuthLoginArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProviderAuthLoginArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[_builtins.str],
                 method: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 use_root_namespace: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param pulumi.Input[_builtins.bool] use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        """
        pulumi.set(__self__, "path", path)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "method", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")

    @use_root_namespace.setter
    def use_root_namespace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_root_namespace", value)


if not MYPY:
    class ProviderAuthLoginAwsArgsDict(TypedDict):
        role: pulumi.Input[_builtins.str]
        """
        The Vault role to use when logging into Vault.
        """
        aws_access_key_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The AWS access key ID.
        """
        aws_iam_endpoint: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IAM endpoint URL.
        """
        aws_profile: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the AWS profile.
        """
        aws_region: NotRequired[pulumi.Input[_builtins.str]]
        """
        The AWS region.
        """
        aws_role_arn: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ARN of the AWS Role to assume.Used during STS AssumeRole
        """
        aws_role_session_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the name to attach to the AWS role session. Used during STS AssumeRole
        """
        aws_secret_access_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        The AWS secret access key.
        """
        aws_session_token: NotRequired[pulumi.Input[_builtins.str]]
        """
        The AWS session token.
        """
        aws_shared_credentials_file: NotRequired[pulumi.Input[_builtins.str]]
        """
        Path to the AWS shared credentials file.
        """
        aws_sts_endpoint: NotRequired[pulumi.Input[_builtins.str]]
        """
        The STS endpoint URL.
        """
        aws_web_identity_token_file: NotRequired[pulumi.Input[_builtins.str]]
        """
        Path to the file containing an OAuth 2.0 access token or OpenID Connect ID token.
        """
        header_value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Vault header value to include in the STS signing request.
        """
        mount: NotRequired[pulumi.Input[_builtins.str]]
        """
        The path where the authentication engine is mounted.
        """
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        use_root_namespace: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
elif False:
    ProviderAuthLoginAwsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProviderAuthLoginAwsArgs:
    def __init__(__self__, *,
                 role: pulumi.Input[_builtins.str],
                 aws_access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_iam_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_region: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_role_session_name: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_secret_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_session_token: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_shared_credentials_file: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_sts_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_web_identity_token_file: Optional[pulumi.Input[_builtins.str]] = None,
                 header_value: Optional[pulumi.Input[_builtins.str]] = None,
                 mount: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 use_root_namespace: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] role: The Vault role to use when logging into Vault.
        :param pulumi.Input[_builtins.str] aws_access_key_id: The AWS access key ID.
        :param pulumi.Input[_builtins.str] aws_iam_endpoint: The IAM endpoint URL.
        :param pulumi.Input[_builtins.str] aws_profile: The name of the AWS profile.
        :param pulumi.Input[_builtins.str] aws_region: The AWS region.
        :param pulumi.Input[_builtins.str] aws_role_arn: The ARN of the AWS Role to assume.Used during STS AssumeRole
        :param pulumi.Input[_builtins.str] aws_role_session_name: Specifies the name to attach to the AWS role session. Used during STS AssumeRole
        :param pulumi.Input[_builtins.str] aws_secret_access_key: The AWS secret access key.
        :param pulumi.Input[_builtins.str] aws_session_token: The AWS session token.
        :param pulumi.Input[_builtins.str] aws_shared_credentials_file: Path to the AWS shared credentials file.
        :param pulumi.Input[_builtins.str] aws_sts_endpoint: The STS endpoint URL.
        :param pulumi.Input[_builtins.str] aws_web_identity_token_file: Path to the file containing an OAuth 2.0 access token or OpenID Connect ID token.
        :param pulumi.Input[_builtins.str] header_value: The Vault header value to include in the STS signing request.
        :param pulumi.Input[_builtins.str] mount: The path where the authentication engine is mounted.
        :param pulumi.Input[_builtins.str] namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param pulumi.Input[_builtins.bool] use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        """
        pulumi.set(__self__, "role", role)
        if aws_access_key_id is not None:
            pulumi.set(__self__, "aws_access_key_id", aws_access_key_id)
        if aws_iam_endpoint is not None:
            pulumi.set(__self__, "aws_iam_endpoint", aws_iam_endpoint)
        if aws_profile is not None:
            pulumi.set(__self__, "aws_profile", aws_profile)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)
        if aws_role_arn is not None:
            pulumi.set(__self__, "aws_role_arn", aws_role_arn)
        if aws_role_session_name is not None:
            pulumi.set(__self__, "aws_role_session_name", aws_role_session_name)
        if aws_secret_access_key is not None:
            pulumi.set(__self__, "aws_secret_access_key", aws_secret_access_key)
        if aws_session_token is not None:
            pulumi.set(__self__, "aws_session_token", aws_session_token)
        if aws_shared_credentials_file is not None:
            pulumi.set(__self__, "aws_shared_credentials_file", aws_shared_credentials_file)
        if aws_sts_endpoint is not None:
            pulumi.set(__self__, "aws_sts_endpoint", aws_sts_endpoint)
        if aws_web_identity_token_file is not None:
            pulumi.set(__self__, "aws_web_identity_token_file", aws_web_identity_token_file)
        if header_value is not None:
            pulumi.set(__self__, "header_value", header_value)
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Input[_builtins.str]:
        """
        The Vault role to use when logging into Vault.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="awsAccessKeyId")
    def aws_access_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS access key ID.
        """
        return pulumi.get(self, "aws_access_key_id")

    @aws_access_key_id.setter
    def aws_access_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_access_key_id", value)

    @_builtins.property
    @pulumi.getter(name="awsIamEndpoint")
    def aws_iam_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IAM endpoint URL.
        """
        return pulumi.get(self, "aws_iam_endpoint")

    @aws_iam_endpoint.setter
    def aws_iam_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_iam_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="awsProfile")
    def aws_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the AWS profile.
        """
        return pulumi.get(self, "aws_profile")

    @aws_profile.setter
    def aws_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_profile", value)

    @_builtins.property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS region.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_region", value)

    @_builtins.property
    @pulumi.getter(name="awsRoleArn")
    def aws_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the AWS Role to assume.Used during STS AssumeRole
        """
        return pulumi.get(self, "aws_role_arn")

    @aws_role_arn.setter
    def aws_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="awsRoleSessionName")
    def aws_role_session_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name to attach to the AWS role session. Used during STS AssumeRole
        """
        return pulumi.get(self, "aws_role_session_name")

    @aws_role_session_name.setter
    def aws_role_session_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_role_session_name", value)

    @_builtins.property
    @pulumi.getter(name="awsSecretAccessKey")
    def aws_secret_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS secret access key.
        """
        return pulumi.get(self, "aws_secret_access_key")

    @aws_secret_access_key.setter
    def aws_secret_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_secret_access_key", value)

    @_builtins.property
    @pulumi.getter(name="awsSessionToken")
    def aws_session_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS session token.
        """
        return pulumi.get(self, "aws_session_token")

    @aws_session_token.setter
    def aws_session_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_session_token", value)

    @_builtins.property
    @pulumi.getter(name="awsSharedCredentialsFile")
    def aws_shared_credentials_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to the AWS shared credentials file.
        """
        return pulumi.get(self, "aws_shared_credentials_file")

    @aws_shared_credentials_file.setter
    def aws_shared_credentials_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_shared_credentials_file", value)

    @_builtins.property
    @pulumi.getter(name="awsStsEndpoint")
    def aws_sts_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The STS endpoint URL.
        """
        return pulumi.get(self, "aws_sts_endpoint")

    @aws_sts_endpoint.setter
    def aws_sts_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_sts_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="awsWebIdentityTokenFile")
    def aws_web_identity_token_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to the file containing an OAuth 2.0 access token or OpenID Connect ID token.
        """
        return pulumi.get(self, "aws_web_identity_token_file")

    @aws_web_identity_token_file.setter
    def aws_web_identity_token_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_web_identity_token_file", value)

    @_builtins.property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Vault header value to include in the STS signing request.
        """
        return pulumi.get(self, "header_value")

    @header_value.setter
    def header_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "header_value", value)

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path where the authentication engine is mounted.
        """
        return pulumi.get(self, "mount")

    @mount.setter
    def mount(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mount", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")

    @use_root_namespace.setter
    def use_root_namespace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_root_namespace", value)


if not MYPY:
    class ProviderAuthLoginAzureArgsDict(TypedDict):
        resource_group_name: pulumi.Input[_builtins.str]
        """
        The resource group for the machine that generated the MSI token. This information can be obtained through instance metadata.
        """
        role: pulumi.Input[_builtins.str]
        """
        Name of the login role.
        """
        subscription_id: pulumi.Input[_builtins.str]
        """
        The subscription ID for the machine that generated the MSI token. This information can be obtained through instance metadata.
        """
        client_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The identity's client ID.
        """
        jwt: NotRequired[pulumi.Input[_builtins.str]]
        """
        A signed JSON Web Token. If not specified on will be created automatically
        """
        mount: NotRequired[pulumi.Input[_builtins.str]]
        """
        The path where the authentication engine is mounted.
        """
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        scope: NotRequired[pulumi.Input[_builtins.str]]
        """
        The scopes to include in the token request.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Provides the tenant ID to use in a multi-tenant authentication scenario.
        """
        use_root_namespace: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        vm_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The virtual machine name for the machine that generated the MSI token. This information can be obtained through instance metadata.
        """
        vmss_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The virtual machine scale set name for the machine that generated the MSI token. This information can be obtained through instance metadata.
        """
elif False:
    ProviderAuthLoginAzureArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProviderAuthLoginAzureArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 role: pulumi.Input[_builtins.str],
                 subscription_id: pulumi.Input[_builtins.str],
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 jwt: Optional[pulumi.Input[_builtins.str]] = None,
                 mount: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 use_root_namespace: Optional[pulumi.Input[_builtins.bool]] = None,
                 vm_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vmss_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] resource_group_name: The resource group for the machine that generated the MSI token. This information can be obtained through instance metadata.
        :param pulumi.Input[_builtins.str] role: Name of the login role.
        :param pulumi.Input[_builtins.str] subscription_id: The subscription ID for the machine that generated the MSI token. This information can be obtained through instance metadata.
        :param pulumi.Input[_builtins.str] client_id: The identity's client ID.
        :param pulumi.Input[_builtins.str] jwt: A signed JSON Web Token. If not specified on will be created automatically
        :param pulumi.Input[_builtins.str] mount: The path where the authentication engine is mounted.
        :param pulumi.Input[_builtins.str] namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param pulumi.Input[_builtins.str] scope: The scopes to include in the token request.
        :param pulumi.Input[_builtins.str] tenant_id: Provides the tenant ID to use in a multi-tenant authentication scenario.
        :param pulumi.Input[_builtins.bool] use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        :param pulumi.Input[_builtins.str] vm_name: The virtual machine name for the machine that generated the MSI token. This information can be obtained through instance metadata.
        :param pulumi.Input[_builtins.str] vmss_name: The virtual machine scale set name for the machine that generated the MSI token. This information can be obtained through instance metadata.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "subscription_id", subscription_id)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if jwt is not None:
            pulumi.set(__self__, "jwt", jwt)
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)
        if vm_name is not None:
            pulumi.set(__self__, "vm_name", vm_name)
        if vmss_name is not None:
            pulumi.set(__self__, "vmss_name", vmss_name)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The resource group for the machine that generated the MSI token. This information can be obtained through instance metadata.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the login role.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Input[_builtins.str]:
        """
        The subscription ID for the machine that generated the MSI token. This information can be obtained through instance metadata.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subscription_id", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identity's client ID.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter
    def jwt(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A signed JSON Web Token. If not specified on will be created automatically
        """
        return pulumi.get(self, "jwt")

    @jwt.setter
    def jwt(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jwt", value)

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path where the authentication engine is mounted.
        """
        return pulumi.get(self, "mount")

    @mount.setter
    def mount(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mount", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scopes to include in the token request.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provides the tenant ID to use in a multi-tenant authentication scenario.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")

    @use_root_namespace.setter
    def use_root_namespace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_root_namespace", value)

    @_builtins.property
    @pulumi.getter(name="vmName")
    def vm_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The virtual machine name for the machine that generated the MSI token. This information can be obtained through instance metadata.
        """
        return pulumi.get(self, "vm_name")

    @vm_name.setter
    def vm_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_name", value)

    @_builtins.property
    @pulumi.getter(name="vmssName")
    def vmss_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The virtual machine scale set name for the machine that generated the MSI token. This information can be obtained through instance metadata.
        """
        return pulumi.get(self, "vmss_name")

    @vmss_name.setter
    def vmss_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vmss_name", value)


if not MYPY:
    class ProviderAuthLoginCertArgsDict(TypedDict):
        cert_file: pulumi.Input[_builtins.str]
        """
        Path to a file containing the client certificate.
        """
        key_file: pulumi.Input[_builtins.str]
        """
        Path to a file containing the private key that the certificate was issued for.
        """
        mount: NotRequired[pulumi.Input[_builtins.str]]
        """
        The path where the authentication engine is mounted.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the certificate's role
        """
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        use_root_namespace: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
elif False:
    ProviderAuthLoginCertArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProviderAuthLoginCertArgs:
    def __init__(__self__, *,
                 cert_file: pulumi.Input[_builtins.str],
                 key_file: pulumi.Input[_builtins.str],
                 mount: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 use_root_namespace: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] cert_file: Path to a file containing the client certificate.
        :param pulumi.Input[_builtins.str] key_file: Path to a file containing the private key that the certificate was issued for.
        :param pulumi.Input[_builtins.str] mount: The path where the authentication engine is mounted.
        :param pulumi.Input[_builtins.str] name: Name of the certificate's role
        :param pulumi.Input[_builtins.str] namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param pulumi.Input[_builtins.bool] use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        """
        pulumi.set(__self__, "cert_file", cert_file)
        pulumi.set(__self__, "key_file", key_file)
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)

    @_builtins.property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> pulumi.Input[_builtins.str]:
        """
        Path to a file containing the client certificate.
        """
        return pulumi.get(self, "cert_file")

    @cert_file.setter
    def cert_file(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cert_file", value)

    @_builtins.property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> pulumi.Input[_builtins.str]:
        """
        Path to a file containing the private key that the certificate was issued for.
        """
        return pulumi.get(self, "key_file")

    @key_file.setter
    def key_file(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_file", value)

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path where the authentication engine is mounted.
        """
        return pulumi.get(self, "mount")

    @mount.setter
    def mount(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mount", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the certificate's role
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")

    @use_root_namespace.setter
    def use_root_namespace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_root_namespace", value)


if not MYPY:
    class ProviderAuthLoginGcpArgsDict(TypedDict):
        role: pulumi.Input[_builtins.str]
        """
        Name of the login role.
        """
        credentials: NotRequired[pulumi.Input[_builtins.str]]
        """
        Path to the Google Cloud credentials file.
        """
        jwt: NotRequired[pulumi.Input[_builtins.str]]
        """
        A signed JSON Web Token.
        """
        mount: NotRequired[pulumi.Input[_builtins.str]]
        """
        The path where the authentication engine is mounted.
        """
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        service_account: NotRequired[pulumi.Input[_builtins.str]]
        """
        IAM service account.
        """
        use_root_namespace: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
elif False:
    ProviderAuthLoginGcpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProviderAuthLoginGcpArgs:
    def __init__(__self__, *,
                 role: pulumi.Input[_builtins.str],
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 jwt: Optional[pulumi.Input[_builtins.str]] = None,
                 mount: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 use_root_namespace: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] role: Name of the login role.
        :param pulumi.Input[_builtins.str] credentials: Path to the Google Cloud credentials file.
        :param pulumi.Input[_builtins.str] jwt: A signed JSON Web Token.
        :param pulumi.Input[_builtins.str] mount: The path where the authentication engine is mounted.
        :param pulumi.Input[_builtins.str] namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param pulumi.Input[_builtins.str] service_account: IAM service account.
        :param pulumi.Input[_builtins.bool] use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        """
        pulumi.set(__self__, "role", role)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if jwt is not None:
            pulumi.set(__self__, "jwt", jwt)
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the login role.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to the Google Cloud credentials file.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter
    def jwt(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A signed JSON Web Token.
        """
        return pulumi.get(self, "jwt")

    @jwt.setter
    def jwt(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jwt", value)

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path where the authentication engine is mounted.
        """
        return pulumi.get(self, "mount")

    @mount.setter
    def mount(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mount", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IAM service account.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")

    @use_root_namespace.setter
    def use_root_namespace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_root_namespace", value)


if not MYPY:
    class ProviderAuthLoginJwtArgsDict(TypedDict):
        role: pulumi.Input[_builtins.str]
        """
        Name of the login role.
        """
        jwt: NotRequired[pulumi.Input[_builtins.str]]
        """
        A signed JSON Web Token.
        """
        mount: NotRequired[pulumi.Input[_builtins.str]]
        """
        The path where the authentication engine is mounted.
        """
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        use_root_namespace: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
elif False:
    ProviderAuthLoginJwtArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProviderAuthLoginJwtArgs:
    def __init__(__self__, *,
                 role: pulumi.Input[_builtins.str],
                 jwt: Optional[pulumi.Input[_builtins.str]] = None,
                 mount: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 use_root_namespace: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] role: Name of the login role.
        :param pulumi.Input[_builtins.str] jwt: A signed JSON Web Token.
        :param pulumi.Input[_builtins.str] mount: The path where the authentication engine is mounted.
        :param pulumi.Input[_builtins.str] namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param pulumi.Input[_builtins.bool] use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        """
        pulumi.set(__self__, "role", role)
        if jwt is not None:
            pulumi.set(__self__, "jwt", jwt)
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the login role.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter
    def jwt(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A signed JSON Web Token.
        """
        return pulumi.get(self, "jwt")

    @jwt.setter
    def jwt(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jwt", value)

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path where the authentication engine is mounted.
        """
        return pulumi.get(self, "mount")

    @mount.setter
    def mount(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mount", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")

    @use_root_namespace.setter
    def use_root_namespace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_root_namespace", value)


if not MYPY:
    class ProviderAuthLoginKerberosArgsDict(TypedDict):
        disable_fast_negotiation: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Disable the Kerberos FAST negotiation.
        """
        keytab_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Kerberos keytab file containing the entry of the login entity.
        """
        krb5conf_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        A valid Kerberos configuration file e.g. /etc/krb5.conf.
        """
        mount: NotRequired[pulumi.Input[_builtins.str]]
        """
        The path where the authentication engine is mounted.
        """
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        realm: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Kerberos server's authoritative authentication domain
        """
        remove_instance_name: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Strip the host from the username found in the keytab.
        """
        service: NotRequired[pulumi.Input[_builtins.str]]
        """
        The service principle name.
        """
        token: NotRequired[pulumi.Input[_builtins.str]]
        """
        Simple and Protected GSSAPI Negotiation Mechanism (SPNEGO) token
        """
        use_root_namespace: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        username: NotRequired[pulumi.Input[_builtins.str]]
        """
        The username to login into Kerberos with.
        """
elif False:
    ProviderAuthLoginKerberosArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProviderAuthLoginKerberosArgs:
    def __init__(__self__, *,
                 disable_fast_negotiation: Optional[pulumi.Input[_builtins.bool]] = None,
                 keytab_path: Optional[pulumi.Input[_builtins.str]] = None,
                 krb5conf_path: Optional[pulumi.Input[_builtins.str]] = None,
                 mount: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 realm: Optional[pulumi.Input[_builtins.str]] = None,
                 remove_instance_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 use_root_namespace: Optional[pulumi.Input[_builtins.bool]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] disable_fast_negotiation: Disable the Kerberos FAST negotiation.
        :param pulumi.Input[_builtins.str] keytab_path: The Kerberos keytab file containing the entry of the login entity.
        :param pulumi.Input[_builtins.str] krb5conf_path: A valid Kerberos configuration file e.g. /etc/krb5.conf.
        :param pulumi.Input[_builtins.str] mount: The path where the authentication engine is mounted.
        :param pulumi.Input[_builtins.str] namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param pulumi.Input[_builtins.str] realm: The Kerberos server's authoritative authentication domain
        :param pulumi.Input[_builtins.bool] remove_instance_name: Strip the host from the username found in the keytab.
        :param pulumi.Input[_builtins.str] service: The service principle name.
        :param pulumi.Input[_builtins.str] token: Simple and Protected GSSAPI Negotiation Mechanism (SPNEGO) token
        :param pulumi.Input[_builtins.bool] use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        :param pulumi.Input[_builtins.str] username: The username to login into Kerberos with.
        """
        if disable_fast_negotiation is not None:
            pulumi.set(__self__, "disable_fast_negotiation", disable_fast_negotiation)
        if keytab_path is not None:
            pulumi.set(__self__, "keytab_path", keytab_path)
        if krb5conf_path is not None:
            pulumi.set(__self__, "krb5conf_path", krb5conf_path)
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if realm is not None:
            pulumi.set(__self__, "realm", realm)
        if remove_instance_name is not None:
            pulumi.set(__self__, "remove_instance_name", remove_instance_name)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="disableFastNegotiation")
    def disable_fast_negotiation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disable the Kerberos FAST negotiation.
        """
        return pulumi.get(self, "disable_fast_negotiation")

    @disable_fast_negotiation.setter
    def disable_fast_negotiation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_fast_negotiation", value)

    @_builtins.property
    @pulumi.getter(name="keytabPath")
    def keytab_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Kerberos keytab file containing the entry of the login entity.
        """
        return pulumi.get(self, "keytab_path")

    @keytab_path.setter
    def keytab_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "keytab_path", value)

    @_builtins.property
    @pulumi.getter(name="krb5confPath")
    def krb5conf_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A valid Kerberos configuration file e.g. /etc/krb5.conf.
        """
        return pulumi.get(self, "krb5conf_path")

    @krb5conf_path.setter
    def krb5conf_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "krb5conf_path", value)

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path where the authentication engine is mounted.
        """
        return pulumi.get(self, "mount")

    @mount.setter
    def mount(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mount", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def realm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Kerberos server's authoritative authentication domain
        """
        return pulumi.get(self, "realm")

    @realm.setter
    def realm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "realm", value)

    @_builtins.property
    @pulumi.getter(name="removeInstanceName")
    def remove_instance_name(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Strip the host from the username found in the keytab.
        """
        return pulumi.get(self, "remove_instance_name")

    @remove_instance_name.setter
    def remove_instance_name(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "remove_instance_name", value)

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service principle name.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Simple and Protected GSSAPI Negotiation Mechanism (SPNEGO) token
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")

    @use_root_namespace.setter
    def use_root_namespace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_root_namespace", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username to login into Kerberos with.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


if not MYPY:
    class ProviderAuthLoginOciArgsDict(TypedDict):
        auth_type: pulumi.Input[_builtins.str]
        """
        Authentication type to use when getting OCI credentials.
        """
        role: pulumi.Input[_builtins.str]
        """
        Name of the login role.
        """
        mount: NotRequired[pulumi.Input[_builtins.str]]
        """
        The path where the authentication engine is mounted.
        """
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        use_root_namespace: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
elif False:
    ProviderAuthLoginOciArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProviderAuthLoginOciArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[_builtins.str],
                 role: pulumi.Input[_builtins.str],
                 mount: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 use_root_namespace: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] auth_type: Authentication type to use when getting OCI credentials.
        :param pulumi.Input[_builtins.str] role: Name of the login role.
        :param pulumi.Input[_builtins.str] mount: The path where the authentication engine is mounted.
        :param pulumi.Input[_builtins.str] namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param pulumi.Input[_builtins.bool] use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        """
        pulumi.set(__self__, "auth_type", auth_type)
        pulumi.set(__self__, "role", role)
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[_builtins.str]:
        """
        Authentication type to use when getting OCI credentials.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "auth_type", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the login role.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path where the authentication engine is mounted.
        """
        return pulumi.get(self, "mount")

    @mount.setter
    def mount(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mount", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")

    @use_root_namespace.setter
    def use_root_namespace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_root_namespace", value)


if not MYPY:
    class ProviderAuthLoginOidcArgsDict(TypedDict):
        role: pulumi.Input[_builtins.str]
        """
        Name of the login role.
        """
        callback_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        The callback address. Must be a valid URI without the path.
        """
        callback_listener_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        The callback listener's address. Must be a valid URI without the path.
        """
        mount: NotRequired[pulumi.Input[_builtins.str]]
        """
        The path where the authentication engine is mounted.
        """
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        use_root_namespace: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
elif False:
    ProviderAuthLoginOidcArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProviderAuthLoginOidcArgs:
    def __init__(__self__, *,
                 role: pulumi.Input[_builtins.str],
                 callback_address: Optional[pulumi.Input[_builtins.str]] = None,
                 callback_listener_address: Optional[pulumi.Input[_builtins.str]] = None,
                 mount: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 use_root_namespace: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] role: Name of the login role.
        :param pulumi.Input[_builtins.str] callback_address: The callback address. Must be a valid URI without the path.
        :param pulumi.Input[_builtins.str] callback_listener_address: The callback listener's address. Must be a valid URI without the path.
        :param pulumi.Input[_builtins.str] mount: The path where the authentication engine is mounted.
        :param pulumi.Input[_builtins.str] namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param pulumi.Input[_builtins.bool] use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        """
        pulumi.set(__self__, "role", role)
        if callback_address is not None:
            pulumi.set(__self__, "callback_address", callback_address)
        if callback_listener_address is not None:
            pulumi.set(__self__, "callback_listener_address", callback_listener_address)
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the login role.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="callbackAddress")
    def callback_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The callback address. Must be a valid URI without the path.
        """
        return pulumi.get(self, "callback_address")

    @callback_address.setter
    def callback_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "callback_address", value)

    @_builtins.property
    @pulumi.getter(name="callbackListenerAddress")
    def callback_listener_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The callback listener's address. Must be a valid URI without the path.
        """
        return pulumi.get(self, "callback_listener_address")

    @callback_listener_address.setter
    def callback_listener_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "callback_listener_address", value)

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path where the authentication engine is mounted.
        """
        return pulumi.get(self, "mount")

    @mount.setter
    def mount(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mount", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")

    @use_root_namespace.setter
    def use_root_namespace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_root_namespace", value)


if not MYPY:
    class ProviderAuthLoginRadiusArgsDict(TypedDict):
        mount: NotRequired[pulumi.Input[_builtins.str]]
        """
        The path where the authentication engine is mounted.
        """
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        password: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Radius password for username.
        """
        use_root_namespace: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        username: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Radius username.
        """
elif False:
    ProviderAuthLoginRadiusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProviderAuthLoginRadiusArgs:
    def __init__(__self__, *,
                 mount: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 use_root_namespace: Optional[pulumi.Input[_builtins.bool]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] mount: The path where the authentication engine is mounted.
        :param pulumi.Input[_builtins.str] namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param pulumi.Input[_builtins.str] password: The Radius password for username.
        :param pulumi.Input[_builtins.bool] use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        :param pulumi.Input[_builtins.str] username: The Radius username.
        """
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path where the authentication engine is mounted.
        """
        return pulumi.get(self, "mount")

    @mount.setter
    def mount(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mount", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Radius password for username.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")

    @use_root_namespace.setter
    def use_root_namespace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_root_namespace", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Radius username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


if not MYPY:
    class ProviderAuthLoginTokenFileArgsDict(TypedDict):
        filename: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of a file containing a single line that is a valid Vault token
        """
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        use_root_namespace: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
elif False:
    ProviderAuthLoginTokenFileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProviderAuthLoginTokenFileArgs:
    def __init__(__self__, *,
                 filename: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 use_root_namespace: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] filename: The name of a file containing a single line that is a valid Vault token
        :param pulumi.Input[_builtins.str] namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param pulumi.Input[_builtins.bool] use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        """
        if filename is not None:
            pulumi.set(__self__, "filename", filename)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)

    @_builtins.property
    @pulumi.getter
    def filename(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a file containing a single line that is a valid Vault token
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filename", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")

    @use_root_namespace.setter
    def use_root_namespace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_root_namespace", value)


if not MYPY:
    class ProviderAuthLoginUserpassArgsDict(TypedDict):
        mount: NotRequired[pulumi.Input[_builtins.str]]
        """
        The path where the authentication engine is mounted.
        """
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        password: NotRequired[pulumi.Input[_builtins.str]]
        """
        Login with password
        """
        password_file: NotRequired[pulumi.Input[_builtins.str]]
        """
        Login with password from a file
        """
        use_root_namespace: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        username: NotRequired[pulumi.Input[_builtins.str]]
        """
        Login with username
        """
elif False:
    ProviderAuthLoginUserpassArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProviderAuthLoginUserpassArgs:
    def __init__(__self__, *,
                 mount: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_file: Optional[pulumi.Input[_builtins.str]] = None,
                 use_root_namespace: Optional[pulumi.Input[_builtins.bool]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] mount: The path where the authentication engine is mounted.
        :param pulumi.Input[_builtins.str] namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param pulumi.Input[_builtins.str] password: Login with password
        :param pulumi.Input[_builtins.str] password_file: Login with password from a file
        :param pulumi.Input[_builtins.bool] use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        :param pulumi.Input[_builtins.str] username: Login with username
        """
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_file is not None:
            pulumi.set(__self__, "password_file", password_file)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path where the authentication engine is mounted.
        """
        return pulumi.get(self, "mount")

    @mount.setter
    def mount(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mount", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Login with password
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="passwordFile")
    def password_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Login with password from a file
        """
        return pulumi.get(self, "password_file")

    @password_file.setter
    def password_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_file", value)

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")

    @use_root_namespace.setter
    def use_root_namespace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_root_namespace", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Login with username
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


if not MYPY:
    class ProviderClientAuthArgsDict(TypedDict):
        cert_file: pulumi.Input[_builtins.str]
        """
        Path to a file containing the client certificate.
        """
        key_file: pulumi.Input[_builtins.str]
        """
        Path to a file containing the private key that the certificate was issued for.
        """
elif False:
    ProviderClientAuthArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProviderClientAuthArgs:
    def __init__(__self__, *,
                 cert_file: pulumi.Input[_builtins.str],
                 key_file: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] cert_file: Path to a file containing the client certificate.
        :param pulumi.Input[_builtins.str] key_file: Path to a file containing the private key that the certificate was issued for.
        """
        pulumi.set(__self__, "cert_file", cert_file)
        pulumi.set(__self__, "key_file", key_file)

    @_builtins.property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> pulumi.Input[_builtins.str]:
        """
        Path to a file containing the client certificate.
        """
        return pulumi.get(self, "cert_file")

    @cert_file.setter
    def cert_file(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cert_file", value)

    @_builtins.property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> pulumi.Input[_builtins.str]:
        """
        Path to a file containing the private key that the certificate was issued for.
        """
        return pulumi.get(self, "key_file")

    @key_file.setter
    def key_file(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_file", value)


if not MYPY:
    class ProviderHeaderArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The header name
        """
        value: pulumi.Input[_builtins.str]
        """
        The header value
        """
elif False:
    ProviderHeaderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProviderHeaderArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: The header name
        :param pulumi.Input[_builtins.str] value: The header value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The header name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        The header value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class GetPolicyDocumentRuleArgsDict(TypedDict):
        capabilities: Sequence[_builtins.str]
        """
        A list of capabilities that this rule apply to `path`. For example, ["read", "write"].
        """
        path: _builtins.str
        """
        A path in Vault that this rule applies to.
        """
        allowed_parameters: NotRequired[Sequence['GetPolicyDocumentRuleAllowedParameterArgsDict']]
        """
        Whitelists a list of keys and values that are permitted on the given path. See Parameters below.
        """
        denied_parameters: NotRequired[Sequence['GetPolicyDocumentRuleDeniedParameterArgsDict']]
        """
        Blacklists a list of parameter and values. Any values specified here take precedence over `allowed_parameter`. See Parameters below.
        """
        description: NotRequired[_builtins.str]
        """
        Description of the rule. Will be added as a comment to rendered rule.
        """
        max_wrapping_ttl: NotRequired[_builtins.str]
        """
        The maximum allowed TTL that clients can specify for a wrapped response.
        """
        min_wrapping_ttl: NotRequired[_builtins.str]
        """
        The minimum allowed TTL that clients can specify for a wrapped response.
        """
        required_parameters: NotRequired[Sequence[_builtins.str]]
        """
        A list of parameters that must be specified.
        """
        subscribe_event_types: NotRequired[Sequence[_builtins.str]]
        """
        A list of event types to subscribe to when using `subscribe` capability.
        """
elif False:
    GetPolicyDocumentRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetPolicyDocumentRuleArgs:
    def __init__(__self__, *,
                 capabilities: Sequence[_builtins.str],
                 path: _builtins.str,
                 allowed_parameters: Optional[Sequence['GetPolicyDocumentRuleAllowedParameterArgs']] = None,
                 denied_parameters: Optional[Sequence['GetPolicyDocumentRuleDeniedParameterArgs']] = None,
                 description: Optional[_builtins.str] = None,
                 max_wrapping_ttl: Optional[_builtins.str] = None,
                 min_wrapping_ttl: Optional[_builtins.str] = None,
                 required_parameters: Optional[Sequence[_builtins.str]] = None,
                 subscribe_event_types: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] capabilities: A list of capabilities that this rule apply to `path`. For example, ["read", "write"].
        :param _builtins.str path: A path in Vault that this rule applies to.
        :param Sequence['GetPolicyDocumentRuleAllowedParameterArgs'] allowed_parameters: Whitelists a list of keys and values that are permitted on the given path. See Parameters below.
        :param Sequence['GetPolicyDocumentRuleDeniedParameterArgs'] denied_parameters: Blacklists a list of parameter and values. Any values specified here take precedence over `allowed_parameter`. See Parameters below.
        :param _builtins.str description: Description of the rule. Will be added as a comment to rendered rule.
        :param _builtins.str max_wrapping_ttl: The maximum allowed TTL that clients can specify for a wrapped response.
        :param _builtins.str min_wrapping_ttl: The minimum allowed TTL that clients can specify for a wrapped response.
        :param Sequence[_builtins.str] required_parameters: A list of parameters that must be specified.
        :param Sequence[_builtins.str] subscribe_event_types: A list of event types to subscribe to when using `subscribe` capability.
        """
        pulumi.set(__self__, "capabilities", capabilities)
        pulumi.set(__self__, "path", path)
        if allowed_parameters is not None:
            pulumi.set(__self__, "allowed_parameters", allowed_parameters)
        if denied_parameters is not None:
            pulumi.set(__self__, "denied_parameters", denied_parameters)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if max_wrapping_ttl is not None:
            pulumi.set(__self__, "max_wrapping_ttl", max_wrapping_ttl)
        if min_wrapping_ttl is not None:
            pulumi.set(__self__, "min_wrapping_ttl", min_wrapping_ttl)
        if required_parameters is not None:
            pulumi.set(__self__, "required_parameters", required_parameters)
        if subscribe_event_types is not None:
            pulumi.set(__self__, "subscribe_event_types", subscribe_event_types)

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> Sequence[_builtins.str]:
        """
        A list of capabilities that this rule apply to `path`. For example, ["read", "write"].
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "capabilities", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        A path in Vault that this rule applies to.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: _builtins.str):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="allowedParameters")
    def allowed_parameters(self) -> Optional[Sequence['GetPolicyDocumentRuleAllowedParameterArgs']]:
        """
        Whitelists a list of keys and values that are permitted on the given path. See Parameters below.
        """
        return pulumi.get(self, "allowed_parameters")

    @allowed_parameters.setter
    def allowed_parameters(self, value: Optional[Sequence['GetPolicyDocumentRuleAllowedParameterArgs']]):
        pulumi.set(self, "allowed_parameters", value)

    @_builtins.property
    @pulumi.getter(name="deniedParameters")
    def denied_parameters(self) -> Optional[Sequence['GetPolicyDocumentRuleDeniedParameterArgs']]:
        """
        Blacklists a list of parameter and values. Any values specified here take precedence over `allowed_parameter`. See Parameters below.
        """
        return pulumi.get(self, "denied_parameters")

    @denied_parameters.setter
    def denied_parameters(self, value: Optional[Sequence['GetPolicyDocumentRuleDeniedParameterArgs']]):
        pulumi.set(self, "denied_parameters", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description of the rule. Will be added as a comment to rendered rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="maxWrappingTtl")
    def max_wrapping_ttl(self) -> Optional[_builtins.str]:
        """
        The maximum allowed TTL that clients can specify for a wrapped response.
        """
        return pulumi.get(self, "max_wrapping_ttl")

    @max_wrapping_ttl.setter
    def max_wrapping_ttl(self, value: Optional[_builtins.str]):
        pulumi.set(self, "max_wrapping_ttl", value)

    @_builtins.property
    @pulumi.getter(name="minWrappingTtl")
    def min_wrapping_ttl(self) -> Optional[_builtins.str]:
        """
        The minimum allowed TTL that clients can specify for a wrapped response.
        """
        return pulumi.get(self, "min_wrapping_ttl")

    @min_wrapping_ttl.setter
    def min_wrapping_ttl(self, value: Optional[_builtins.str]):
        pulumi.set(self, "min_wrapping_ttl", value)

    @_builtins.property
    @pulumi.getter(name="requiredParameters")
    def required_parameters(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of parameters that must be specified.
        """
        return pulumi.get(self, "required_parameters")

    @required_parameters.setter
    def required_parameters(self, value: Optional[Sequence[_builtins.str]]):
        pulumi.set(self, "required_parameters", value)

    @_builtins.property
    @pulumi.getter(name="subscribeEventTypes")
    def subscribe_event_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of event types to subscribe to when using `subscribe` capability.
        """
        return pulumi.get(self, "subscribe_event_types")

    @subscribe_event_types.setter
    def subscribe_event_types(self, value: Optional[Sequence[_builtins.str]]):
        pulumi.set(self, "subscribe_event_types", value)


if not MYPY:
    class GetPolicyDocumentRuleAllowedParameterArgsDict(TypedDict):
        key: _builtins.str
        """
        Name of permitted key.
        """
        values: Sequence[_builtins.str]
        """
        A list of values what are permitted by policy rule.
        """
elif False:
    GetPolicyDocumentRuleAllowedParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetPolicyDocumentRuleAllowedParameterArgs:
    def __init__(__self__, *,
                 key: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str key: Name of permitted key.
        :param Sequence[_builtins.str] values: A list of values what are permitted by policy rule.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Name of permitted key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: _builtins.str):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        A list of values what are permitted by policy rule.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetPolicyDocumentRuleDeniedParameterArgsDict(TypedDict):
        key: _builtins.str
        """
        Name of denied key.
        """
        values: Sequence[_builtins.str]
        """
        A list of values what are denied by policy rule.
        """
elif False:
    GetPolicyDocumentRuleDeniedParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetPolicyDocumentRuleDeniedParameterArgs:
    def __init__(__self__, *,
                 key: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str key: Name of denied key.
        :param Sequence[_builtins.str] values: A list of values what are denied by policy rule.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Name of denied key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: _builtins.str):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        A list of values what are denied by policy rule.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)


