# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretRoleArgs', 'SecretRole']

@pulumi.input_type
class SecretRoleArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[_builtins.str],
                 role: pulumi.Input[_builtins.str],
                 service_account_name: pulumi.Input[_builtins.str],
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a SecretRole resource.
        :param pulumi.Input[_builtins.str] backend: The path the AD secret backend is mounted at,
               with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.str] role: The name to identify this role within the backend.
               Must be unique within the backend.
        :param pulumi.Input[_builtins.str] service_account_name: Specifies the name of the Active Directory service
               account mapped to this role.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] ttl: The password time-to-live in seconds. Defaults to the configuration
               ttl if not provided.
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "service_account_name", service_account_name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Input[_builtins.str]:
        """
        The path the AD secret backend is mounted at,
        with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Input[_builtins.str]:
        """
        The name to identify this role within the backend.
        Must be unique within the backend.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Active Directory service
        account mapped to this role.
        """
        return pulumi.get(self, "service_account_name")

    @service_account_name.setter
    def service_account_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_account_name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The password time-to-live in seconds. Defaults to the configuration
        ttl if not provided.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _SecretRoleState:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 last_vault_rotation: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 password_last_set: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering SecretRole resources.
        :param pulumi.Input[_builtins.str] backend: The path the AD secret backend is mounted at,
               with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.str] last_vault_rotation: Timestamp of the last password rotation by Vault.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] password_last_set: Timestamp of the last password set by Vault.
        :param pulumi.Input[_builtins.str] role: The name to identify this role within the backend.
               Must be unique within the backend.
        :param pulumi.Input[_builtins.str] service_account_name: Specifies the name of the Active Directory service
               account mapped to this role.
        :param pulumi.Input[_builtins.int] ttl: The password time-to-live in seconds. Defaults to the configuration
               ttl if not provided.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if last_vault_rotation is not None:
            pulumi.set(__self__, "last_vault_rotation", last_vault_rotation)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if password_last_set is not None:
            pulumi.set(__self__, "password_last_set", password_last_set)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if service_account_name is not None:
            pulumi.set(__self__, "service_account_name", service_account_name)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path the AD secret backend is mounted at,
        with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="lastVaultRotation")
    def last_vault_rotation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp of the last password rotation by Vault.
        """
        return pulumi.get(self, "last_vault_rotation")

    @last_vault_rotation.setter
    def last_vault_rotation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_vault_rotation", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="passwordLastSet")
    def password_last_set(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp of the last password set by Vault.
        """
        return pulumi.get(self, "password_last_set")

    @password_last_set.setter
    def password_last_set(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_last_set", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name to identify this role within the backend.
        Must be unique within the backend.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Active Directory service
        account mapped to this role.
        """
        return pulumi.get(self, "service_account_name")

    @service_account_name.setter
    def service_account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_name", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The password time-to-live in seconds. Defaults to the configuration
        ttl if not provided.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)


@pulumi.type_token("vault:ad/secretRole:SecretRole")
class SecretRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        config = vault.ad.SecretBackend("config",
            backend="ad",
            binddn="CN=Administrator,CN=Users,DC=corp,DC=example,DC=net",
            bindpass="SuperSecretPassw0rd",
            url="ldaps://ad",
            insecure_tls=True,
            userdn="CN=Users,DC=corp,DC=example,DC=net")
        role = vault.ad.SecretRole("role",
            backend=config.backend,
            role="bob",
            service_account_name="Bob",
            ttl=60)
        ```

        ## Import

        AD secret backend roles can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:ad/secretRole:SecretRole role ad/roles/bob
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend: The path the AD secret backend is mounted at,
               with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] role: The name to identify this role within the backend.
               Must be unique within the backend.
        :param pulumi.Input[_builtins.str] service_account_name: Specifies the name of the Active Directory service
               account mapped to this role.
        :param pulumi.Input[_builtins.int] ttl: The password time-to-live in seconds. Defaults to the configuration
               ttl if not provided.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        config = vault.ad.SecretBackend("config",
            backend="ad",
            binddn="CN=Administrator,CN=Users,DC=corp,DC=example,DC=net",
            bindpass="SuperSecretPassw0rd",
            url="ldaps://ad",
            insecure_tls=True,
            userdn="CN=Users,DC=corp,DC=example,DC=net")
        role = vault.ad.SecretRole("role",
            backend=config.backend,
            role="bob",
            service_account_name="Bob",
            ttl=60)
        ```

        ## Import

        AD secret backend roles can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:ad/secretRole:SecretRole role ad/roles/bob
        ```

        :param str resource_name: The name of the resource.
        :param SecretRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretRoleArgs.__new__(SecretRoleArgs)

            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            __props__.__dict__["namespace"] = namespace
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            if service_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_account_name'")
            __props__.__dict__["service_account_name"] = service_account_name
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["last_vault_rotation"] = None
            __props__.__dict__["password_last_set"] = None
        super(SecretRole, __self__).__init__(
            'vault:ad/secretRole:SecretRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            last_vault_rotation: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            password_last_set: Optional[pulumi.Input[_builtins.str]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None,
            service_account_name: Optional[pulumi.Input[_builtins.str]] = None,
            ttl: Optional[pulumi.Input[_builtins.int]] = None) -> 'SecretRole':
        """
        Get an existing SecretRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend: The path the AD secret backend is mounted at,
               with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.str] last_vault_rotation: Timestamp of the last password rotation by Vault.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] password_last_set: Timestamp of the last password set by Vault.
        :param pulumi.Input[_builtins.str] role: The name to identify this role within the backend.
               Must be unique within the backend.
        :param pulumi.Input[_builtins.str] service_account_name: Specifies the name of the Active Directory service
               account mapped to this role.
        :param pulumi.Input[_builtins.int] ttl: The password time-to-live in seconds. Defaults to the configuration
               ttl if not provided.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretRoleState.__new__(_SecretRoleState)

        __props__.__dict__["backend"] = backend
        __props__.__dict__["last_vault_rotation"] = last_vault_rotation
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["password_last_set"] = password_last_set
        __props__.__dict__["role"] = role
        __props__.__dict__["service_account_name"] = service_account_name
        __props__.__dict__["ttl"] = ttl
        return SecretRole(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[_builtins.str]:
        """
        The path the AD secret backend is mounted at,
        with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="lastVaultRotation")
    def last_vault_rotation(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp of the last password rotation by Vault.
        """
        return pulumi.get(self, "last_vault_rotation")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="passwordLastSet")
    def password_last_set(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp of the last password set by Vault.
        """
        return pulumi.get(self, "password_last_set")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[_builtins.str]:
        """
        The name to identify this role within the backend.
        Must be unique within the backend.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Active Directory service
        account mapped to this role.
        """
        return pulumi.get(self, "service_account_name")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The password time-to-live in seconds. Defaults to the configuration
        ttl if not provided.
        """
        return pulumi.get(self, "ttl")

