# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AuthBackendRoleArgs', 'AuthBackendRole']

@pulumi.input_type
class AuthBackendRoleArgs:
    def __init__(__self__, *,
                 role_name: pulumi.Input[_builtins.str],
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 bind_secret_id: Optional[pulumi.Input[_builtins.bool]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_id_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secret_id_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_id_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 token_period: Optional[pulumi.Input[_builtins.int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AuthBackendRole resource.
        :param pulumi.Input[_builtins.str] role_name: The name of the role.
        :param pulumi.Input[_builtins.str] backend: The unique name of the auth backend to configure.
               Defaults to `approle`.
        :param pulumi.Input[_builtins.bool] bind_secret_id: Whether or not to require `secret_id` to be
               presented when logging in using this AppRole. Defaults to `true`.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] role_id: The RoleID of this role. If not specified, one will be
               auto-generated.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secret_id_bound_cidrs: If set,
               specifies blocks of IP addresses which can perform the login operation.
        :param pulumi.Input[_builtins.int] secret_id_num_uses: The number of times any particular SecretID
               can be used to fetch a token from this AppRole, after which the SecretID will
               expire. A value of zero will allow unlimited uses.
        :param pulumi.Input[_builtins.int] secret_id_ttl: The number of seconds after which any SecretID
               expires.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[_builtins.int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[_builtins.int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[_builtins.bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[_builtins.int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[_builtins.int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[_builtins.int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[_builtins.str] token_type: The type of token to generate, service or batch
        """
        pulumi.set(__self__, "role_name", role_name)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if bind_secret_id is not None:
            pulumi.set(__self__, "bind_secret_id", bind_secret_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)
        if secret_id_bound_cidrs is not None:
            pulumi.set(__self__, "secret_id_bound_cidrs", secret_id_bound_cidrs)
        if secret_id_num_uses is not None:
            pulumi.set(__self__, "secret_id_num_uses", secret_id_num_uses)
        if secret_id_ttl is not None:
            pulumi.set(__self__, "secret_id_ttl", secret_id_ttl)
        if token_bound_cidrs is not None:
            pulumi.set(__self__, "token_bound_cidrs", token_bound_cidrs)
        if token_explicit_max_ttl is not None:
            pulumi.set(__self__, "token_explicit_max_ttl", token_explicit_max_ttl)
        if token_max_ttl is not None:
            pulumi.set(__self__, "token_max_ttl", token_max_ttl)
        if token_no_default_policy is not None:
            pulumi.set(__self__, "token_no_default_policy", token_no_default_policy)
        if token_num_uses is not None:
            pulumi.set(__self__, "token_num_uses", token_num_uses)
        if token_period is not None:
            pulumi.set(__self__, "token_period", token_period)
        if token_policies is not None:
            pulumi.set(__self__, "token_policies", token_policies)
        if token_ttl is not None:
            pulumi.set(__self__, "token_ttl", token_ttl)
        if token_type is not None:
            pulumi.set(__self__, "token_type", token_type)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the role.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the auth backend to configure.
        Defaults to `approle`.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="bindSecretId")
    def bind_secret_id(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to require `secret_id` to be
        presented when logging in using this AppRole. Defaults to `true`.
        """
        return pulumi.get(self, "bind_secret_id")

    @bind_secret_id.setter
    def bind_secret_id(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bind_secret_id", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The RoleID of this role. If not specified, one will be
        auto-generated.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_id", value)

    @_builtins.property
    @pulumi.getter(name="secretIdBoundCidrs")
    def secret_id_bound_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        If set,
        specifies blocks of IP addresses which can perform the login operation.
        """
        return pulumi.get(self, "secret_id_bound_cidrs")

    @secret_id_bound_cidrs.setter
    def secret_id_bound_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "secret_id_bound_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="secretIdNumUses")
    def secret_id_num_uses(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of times any particular SecretID
        can be used to fetch a token from this AppRole, after which the SecretID will
        expire. A value of zero will allow unlimited uses.
        """
        return pulumi.get(self, "secret_id_num_uses")

    @secret_id_num_uses.setter
    def secret_id_num_uses(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "secret_id_num_uses", value)

    @_builtins.property
    @pulumi.getter(name="secretIdTtl")
    def secret_id_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds after which any SecretID
        expires.
        """
        return pulumi.get(self, "secret_id_ttl")

    @secret_id_ttl.setter
    def secret_id_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "secret_id_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the blocks of IP addresses which are allowed to use the generated token
        """
        return pulumi.get(self, "token_bound_cidrs")

    @token_bound_cidrs.setter
    def token_bound_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_bound_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generated Token's Explicit Maximum TTL in seconds
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @token_explicit_max_ttl.setter
    def token_explicit_max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_explicit_max_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum lifetime of the generated token
        """
        return pulumi.get(self, "token_max_ttl")

    @token_max_ttl.setter
    def token_max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_max_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the 'default' policy will not automatically be added to generated tokens
        """
        return pulumi.get(self, "token_no_default_policy")

    @token_no_default_policy.setter
    def token_no_default_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "token_no_default_policy", value)

    @_builtins.property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of times a token may be used, a value of zero means unlimited
        """
        return pulumi.get(self, "token_num_uses")

    @token_num_uses.setter
    def token_num_uses(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_num_uses", value)

    @_builtins.property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generated Token's Period
        """
        return pulumi.get(self, "token_period")

    @token_period.setter
    def token_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_period", value)

    @_builtins.property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Generated Token's Policies
        """
        return pulumi.get(self, "token_policies")

    @token_policies.setter
    def token_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_policies", value)

    @_builtins.property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @token_ttl.setter
    def token_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of token to generate, service or batch
        """
        return pulumi.get(self, "token_type")

    @token_type.setter
    def token_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_type", value)


@pulumi.input_type
class _AuthBackendRoleState:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 bind_secret_id: Optional[pulumi.Input[_builtins.bool]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_id_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secret_id_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_id_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 token_period: Optional[pulumi.Input[_builtins.int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuthBackendRole resources.
        :param pulumi.Input[_builtins.str] backend: The unique name of the auth backend to configure.
               Defaults to `approle`.
        :param pulumi.Input[_builtins.bool] bind_secret_id: Whether or not to require `secret_id` to be
               presented when logging in using this AppRole. Defaults to `true`.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] role_id: The RoleID of this role. If not specified, one will be
               auto-generated.
        :param pulumi.Input[_builtins.str] role_name: The name of the role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secret_id_bound_cidrs: If set,
               specifies blocks of IP addresses which can perform the login operation.
        :param pulumi.Input[_builtins.int] secret_id_num_uses: The number of times any particular SecretID
               can be used to fetch a token from this AppRole, after which the SecretID will
               expire. A value of zero will allow unlimited uses.
        :param pulumi.Input[_builtins.int] secret_id_ttl: The number of seconds after which any SecretID
               expires.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[_builtins.int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[_builtins.int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[_builtins.bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[_builtins.int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[_builtins.int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[_builtins.int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[_builtins.str] token_type: The type of token to generate, service or batch
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if bind_secret_id is not None:
            pulumi.set(__self__, "bind_secret_id", bind_secret_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if secret_id_bound_cidrs is not None:
            pulumi.set(__self__, "secret_id_bound_cidrs", secret_id_bound_cidrs)
        if secret_id_num_uses is not None:
            pulumi.set(__self__, "secret_id_num_uses", secret_id_num_uses)
        if secret_id_ttl is not None:
            pulumi.set(__self__, "secret_id_ttl", secret_id_ttl)
        if token_bound_cidrs is not None:
            pulumi.set(__self__, "token_bound_cidrs", token_bound_cidrs)
        if token_explicit_max_ttl is not None:
            pulumi.set(__self__, "token_explicit_max_ttl", token_explicit_max_ttl)
        if token_max_ttl is not None:
            pulumi.set(__self__, "token_max_ttl", token_max_ttl)
        if token_no_default_policy is not None:
            pulumi.set(__self__, "token_no_default_policy", token_no_default_policy)
        if token_num_uses is not None:
            pulumi.set(__self__, "token_num_uses", token_num_uses)
        if token_period is not None:
            pulumi.set(__self__, "token_period", token_period)
        if token_policies is not None:
            pulumi.set(__self__, "token_policies", token_policies)
        if token_ttl is not None:
            pulumi.set(__self__, "token_ttl", token_ttl)
        if token_type is not None:
            pulumi.set(__self__, "token_type", token_type)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the auth backend to configure.
        Defaults to `approle`.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="bindSecretId")
    def bind_secret_id(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to require `secret_id` to be
        presented when logging in using this AppRole. Defaults to `true`.
        """
        return pulumi.get(self, "bind_secret_id")

    @bind_secret_id.setter
    def bind_secret_id(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bind_secret_id", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The RoleID of this role. If not specified, one will be
        auto-generated.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_id", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the role.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter(name="secretIdBoundCidrs")
    def secret_id_bound_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        If set,
        specifies blocks of IP addresses which can perform the login operation.
        """
        return pulumi.get(self, "secret_id_bound_cidrs")

    @secret_id_bound_cidrs.setter
    def secret_id_bound_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "secret_id_bound_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="secretIdNumUses")
    def secret_id_num_uses(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of times any particular SecretID
        can be used to fetch a token from this AppRole, after which the SecretID will
        expire. A value of zero will allow unlimited uses.
        """
        return pulumi.get(self, "secret_id_num_uses")

    @secret_id_num_uses.setter
    def secret_id_num_uses(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "secret_id_num_uses", value)

    @_builtins.property
    @pulumi.getter(name="secretIdTtl")
    def secret_id_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds after which any SecretID
        expires.
        """
        return pulumi.get(self, "secret_id_ttl")

    @secret_id_ttl.setter
    def secret_id_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "secret_id_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the blocks of IP addresses which are allowed to use the generated token
        """
        return pulumi.get(self, "token_bound_cidrs")

    @token_bound_cidrs.setter
    def token_bound_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_bound_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generated Token's Explicit Maximum TTL in seconds
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @token_explicit_max_ttl.setter
    def token_explicit_max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_explicit_max_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum lifetime of the generated token
        """
        return pulumi.get(self, "token_max_ttl")

    @token_max_ttl.setter
    def token_max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_max_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the 'default' policy will not automatically be added to generated tokens
        """
        return pulumi.get(self, "token_no_default_policy")

    @token_no_default_policy.setter
    def token_no_default_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "token_no_default_policy", value)

    @_builtins.property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of times a token may be used, a value of zero means unlimited
        """
        return pulumi.get(self, "token_num_uses")

    @token_num_uses.setter
    def token_num_uses(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_num_uses", value)

    @_builtins.property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generated Token's Period
        """
        return pulumi.get(self, "token_period")

    @token_period.setter
    def token_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_period", value)

    @_builtins.property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Generated Token's Policies
        """
        return pulumi.get(self, "token_policies")

    @token_policies.setter
    def token_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_policies", value)

    @_builtins.property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @token_ttl.setter
    def token_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of token to generate, service or batch
        """
        return pulumi.get(self, "token_type")

    @token_type.setter
    def token_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_type", value)


@pulumi.type_token("vault:appRole/authBackendRole:AuthBackendRole")
class AuthBackendRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 bind_secret_id: Optional[pulumi.Input[_builtins.bool]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_id_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secret_id_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_id_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 token_period: Optional[pulumi.Input[_builtins.int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an AppRole auth backend role in a Vault server. See the [Vault
        documentation](https://www.vaultproject.io/docs/auth/approle) for more
        information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        approle = vault.AuthBackend("approle", type="approle")
        example = vault.approle.AuthBackendRole("example",
            backend=approle.path,
            role_name="test-role",
            token_policies=[
                "default",
                "dev",
                "prod",
            ])
        ```

        ## Import

        AppRole authentication backend roles can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:appRole/authBackendRole:AuthBackendRole example auth/approle/role/test-role
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend: The unique name of the auth backend to configure.
               Defaults to `approle`.
        :param pulumi.Input[_builtins.bool] bind_secret_id: Whether or not to require `secret_id` to be
               presented when logging in using this AppRole. Defaults to `true`.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] role_id: The RoleID of this role. If not specified, one will be
               auto-generated.
        :param pulumi.Input[_builtins.str] role_name: The name of the role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secret_id_bound_cidrs: If set,
               specifies blocks of IP addresses which can perform the login operation.
        :param pulumi.Input[_builtins.int] secret_id_num_uses: The number of times any particular SecretID
               can be used to fetch a token from this AppRole, after which the SecretID will
               expire. A value of zero will allow unlimited uses.
        :param pulumi.Input[_builtins.int] secret_id_ttl: The number of seconds after which any SecretID
               expires.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[_builtins.int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[_builtins.int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[_builtins.bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[_builtins.int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[_builtins.int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[_builtins.int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[_builtins.str] token_type: The type of token to generate, service or batch
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthBackendRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AppRole auth backend role in a Vault server. See the [Vault
        documentation](https://www.vaultproject.io/docs/auth/approle) for more
        information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        approle = vault.AuthBackend("approle", type="approle")
        example = vault.approle.AuthBackendRole("example",
            backend=approle.path,
            role_name="test-role",
            token_policies=[
                "default",
                "dev",
                "prod",
            ])
        ```

        ## Import

        AppRole authentication backend roles can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:appRole/authBackendRole:AuthBackendRole example auth/approle/role/test-role
        ```

        :param str resource_name: The name of the resource.
        :param AuthBackendRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthBackendRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 bind_secret_id: Optional[pulumi.Input[_builtins.bool]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_id_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secret_id_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_id_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 token_period: Optional[pulumi.Input[_builtins.int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthBackendRoleArgs.__new__(AuthBackendRoleArgs)

            __props__.__dict__["backend"] = backend
            __props__.__dict__["bind_secret_id"] = bind_secret_id
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["role_id"] = role_id
            if role_name is None and not opts.urn:
                raise TypeError("Missing required property 'role_name'")
            __props__.__dict__["role_name"] = role_name
            __props__.__dict__["secret_id_bound_cidrs"] = secret_id_bound_cidrs
            __props__.__dict__["secret_id_num_uses"] = secret_id_num_uses
            __props__.__dict__["secret_id_ttl"] = secret_id_ttl
            __props__.__dict__["token_bound_cidrs"] = token_bound_cidrs
            __props__.__dict__["token_explicit_max_ttl"] = token_explicit_max_ttl
            __props__.__dict__["token_max_ttl"] = token_max_ttl
            __props__.__dict__["token_no_default_policy"] = token_no_default_policy
            __props__.__dict__["token_num_uses"] = token_num_uses
            __props__.__dict__["token_period"] = token_period
            __props__.__dict__["token_policies"] = token_policies
            __props__.__dict__["token_ttl"] = token_ttl
            __props__.__dict__["token_type"] = token_type
        super(AuthBackendRole, __self__).__init__(
            'vault:appRole/authBackendRole:AuthBackendRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            bind_secret_id: Optional[pulumi.Input[_builtins.bool]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            role_id: Optional[pulumi.Input[_builtins.str]] = None,
            role_name: Optional[pulumi.Input[_builtins.str]] = None,
            secret_id_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            secret_id_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
            secret_id_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
            token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
            token_period: Optional[pulumi.Input[_builtins.int]] = None,
            token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            token_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'AuthBackendRole':
        """
        Get an existing AuthBackendRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend: The unique name of the auth backend to configure.
               Defaults to `approle`.
        :param pulumi.Input[_builtins.bool] bind_secret_id: Whether or not to require `secret_id` to be
               presented when logging in using this AppRole. Defaults to `true`.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] role_id: The RoleID of this role. If not specified, one will be
               auto-generated.
        :param pulumi.Input[_builtins.str] role_name: The name of the role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secret_id_bound_cidrs: If set,
               specifies blocks of IP addresses which can perform the login operation.
        :param pulumi.Input[_builtins.int] secret_id_num_uses: The number of times any particular SecretID
               can be used to fetch a token from this AppRole, after which the SecretID will
               expire. A value of zero will allow unlimited uses.
        :param pulumi.Input[_builtins.int] secret_id_ttl: The number of seconds after which any SecretID
               expires.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[_builtins.int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[_builtins.int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[_builtins.bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[_builtins.int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[_builtins.int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[_builtins.int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[_builtins.str] token_type: The type of token to generate, service or batch
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthBackendRoleState.__new__(_AuthBackendRoleState)

        __props__.__dict__["backend"] = backend
        __props__.__dict__["bind_secret_id"] = bind_secret_id
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["role_id"] = role_id
        __props__.__dict__["role_name"] = role_name
        __props__.__dict__["secret_id_bound_cidrs"] = secret_id_bound_cidrs
        __props__.__dict__["secret_id_num_uses"] = secret_id_num_uses
        __props__.__dict__["secret_id_ttl"] = secret_id_ttl
        __props__.__dict__["token_bound_cidrs"] = token_bound_cidrs
        __props__.__dict__["token_explicit_max_ttl"] = token_explicit_max_ttl
        __props__.__dict__["token_max_ttl"] = token_max_ttl
        __props__.__dict__["token_no_default_policy"] = token_no_default_policy
        __props__.__dict__["token_num_uses"] = token_num_uses
        __props__.__dict__["token_period"] = token_period
        __props__.__dict__["token_policies"] = token_policies
        __props__.__dict__["token_ttl"] = token_ttl
        __props__.__dict__["token_type"] = token_type
        return AuthBackendRole(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unique name of the auth backend to configure.
        Defaults to `approle`.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="bindSecretId")
    def bind_secret_id(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether or not to require `secret_id` to be
        presented when logging in using this AppRole. Defaults to `true`.
        """
        return pulumi.get(self, "bind_secret_id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Output[_builtins.str]:
        """
        The RoleID of this role. If not specified, one will be
        auto-generated.
        """
        return pulumi.get(self, "role_id")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the role.
        """
        return pulumi.get(self, "role_name")

    @_builtins.property
    @pulumi.getter(name="secretIdBoundCidrs")
    def secret_id_bound_cidrs(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        If set,
        specifies blocks of IP addresses which can perform the login operation.
        """
        return pulumi.get(self, "secret_id_bound_cidrs")

    @_builtins.property
    @pulumi.getter(name="secretIdNumUses")
    def secret_id_num_uses(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of times any particular SecretID
        can be used to fetch a token from this AppRole, after which the SecretID will
        expire. A value of zero will allow unlimited uses.
        """
        return pulumi.get(self, "secret_id_num_uses")

    @_builtins.property
    @pulumi.getter(name="secretIdTtl")
    def secret_id_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of seconds after which any SecretID
        expires.
        """
        return pulumi.get(self, "secret_id_ttl")

    @_builtins.property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the blocks of IP addresses which are allowed to use the generated token
        """
        return pulumi.get(self, "token_bound_cidrs")

    @_builtins.property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Generated Token's Explicit Maximum TTL in seconds
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @_builtins.property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum lifetime of the generated token
        """
        return pulumi.get(self, "token_max_ttl")

    @_builtins.property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, the 'default' policy will not automatically be added to generated tokens
        """
        return pulumi.get(self, "token_no_default_policy")

    @_builtins.property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum number of times a token may be used, a value of zero means unlimited
        """
        return pulumi.get(self, "token_num_uses")

    @_builtins.property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Generated Token's Period
        """
        return pulumi.get(self, "token_period")

    @_builtins.property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Generated Token's Policies
        """
        return pulumi.get(self, "token_policies")

    @_builtins.property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @_builtins.property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of token to generate, service or batch
        """
        return pulumi.get(self, "token_type")

