# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuthBackendArgs', 'AuthBackend']

@pulumi.input_type
class AuthBackendArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 tune: Optional[pulumi.Input['AuthBackendTuneArgs']] = None):
        """
        The set of arguments for constructing a AuthBackend resource.
        :param pulumi.Input[_builtins.str] type: The name of the auth method type.
        :param pulumi.Input[_builtins.str] description: A description of the auth method.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing identity tokens.
        :param pulumi.Input[_builtins.bool] local: Specifies if the auth method is local only.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: The path to mount the auth method — this defaults to the name of the type.
        :param pulumi.Input['AuthBackendTuneArgs'] tune: Extra configuration block. Structure is documented below.
               
               The `tune` block is used to tune the auth backend:
        """
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_remount is not None:
            pulumi.set(__self__, "disable_remount", disable_remount)
        if identity_token_key is not None:
            pulumi.set(__self__, "identity_token_key", identity_token_key)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if tune is not None:
            pulumi.set(__self__, "tune", tune)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the auth method type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the auth method.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        """
        return pulumi.get(self, "disable_remount")

    @disable_remount.setter
    def disable_remount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_remount", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenKey")
    def identity_token_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key to use for signing identity tokens.
        """
        return pulumi.get(self, "identity_token_key")

    @identity_token_key.setter
    def identity_token_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_token_key", value)

    @_builtins.property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the auth method is local only.
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to mount the auth method — this defaults to the name of the type.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter
    def tune(self) -> Optional[pulumi.Input['AuthBackendTuneArgs']]:
        """
        Extra configuration block. Structure is documented below.

        The `tune` block is used to tune the auth backend:
        """
        return pulumi.get(self, "tune")

    @tune.setter
    def tune(self, value: Optional[pulumi.Input['AuthBackendTuneArgs']]):
        pulumi.set(self, "tune", value)


@pulumi.input_type
class _AuthBackendState:
    def __init__(__self__, *,
                 accessor: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 tune: Optional[pulumi.Input['AuthBackendTuneArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuthBackend resources.
        :param pulumi.Input[_builtins.str] accessor: The accessor for this auth method
        :param pulumi.Input[_builtins.str] description: A description of the auth method.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing identity tokens.
        :param pulumi.Input[_builtins.bool] local: Specifies if the auth method is local only.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: The path to mount the auth method — this defaults to the name of the type.
        :param pulumi.Input['AuthBackendTuneArgs'] tune: Extra configuration block. Structure is documented below.
               
               The `tune` block is used to tune the auth backend:
        :param pulumi.Input[_builtins.str] type: The name of the auth method type.
        """
        if accessor is not None:
            pulumi.set(__self__, "accessor", accessor)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_remount is not None:
            pulumi.set(__self__, "disable_remount", disable_remount)
        if identity_token_key is not None:
            pulumi.set(__self__, "identity_token_key", identity_token_key)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if tune is not None:
            pulumi.set(__self__, "tune", tune)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def accessor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The accessor for this auth method
        """
        return pulumi.get(self, "accessor")

    @accessor.setter
    def accessor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessor", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the auth method.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        """
        return pulumi.get(self, "disable_remount")

    @disable_remount.setter
    def disable_remount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_remount", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenKey")
    def identity_token_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key to use for signing identity tokens.
        """
        return pulumi.get(self, "identity_token_key")

    @identity_token_key.setter
    def identity_token_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_token_key", value)

    @_builtins.property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the auth method is local only.
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to mount the auth method — this defaults to the name of the type.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter
    def tune(self) -> Optional[pulumi.Input['AuthBackendTuneArgs']]:
        """
        Extra configuration block. Structure is documented below.

        The `tune` block is used to tune the auth backend:
        """
        return pulumi.get(self, "tune")

    @tune.setter
    def tune(self, value: Optional[pulumi.Input['AuthBackendTuneArgs']]):
        pulumi.set(self, "tune", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the auth method type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("vault:index/authBackend:AuthBackend")
class AuthBackend(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 tune: Optional[pulumi.Input[Union['AuthBackendTuneArgs', 'AuthBackendTuneArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        Auth methods can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:index/authBackend:AuthBackend example github
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description of the auth method.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing identity tokens.
        :param pulumi.Input[_builtins.bool] local: Specifies if the auth method is local only.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: The path to mount the auth method — this defaults to the name of the type.
        :param pulumi.Input[Union['AuthBackendTuneArgs', 'AuthBackendTuneArgsDict']] tune: Extra configuration block. Structure is documented below.
               
               The `tune` block is used to tune the auth backend:
        :param pulumi.Input[_builtins.str] type: The name of the auth method type.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthBackendArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Auth methods can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:index/authBackend:AuthBackend example github
        ```

        :param str resource_name: The name of the resource.
        :param AuthBackendArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthBackendArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 tune: Optional[pulumi.Input[Union['AuthBackendTuneArgs', 'AuthBackendTuneArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthBackendArgs.__new__(AuthBackendArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["disable_remount"] = disable_remount
            __props__.__dict__["identity_token_key"] = identity_token_key
            __props__.__dict__["local"] = local
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["path"] = path
            __props__.__dict__["tune"] = tune
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["accessor"] = None
        super(AuthBackend, __self__).__init__(
            'vault:index/authBackend:AuthBackend',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessor: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
            identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
            local: Optional[pulumi.Input[_builtins.bool]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None,
            tune: Optional[pulumi.Input[Union['AuthBackendTuneArgs', 'AuthBackendTuneArgsDict']]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'AuthBackend':
        """
        Get an existing AuthBackend resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessor: The accessor for this auth method
        :param pulumi.Input[_builtins.str] description: A description of the auth method.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing identity tokens.
        :param pulumi.Input[_builtins.bool] local: Specifies if the auth method is local only.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: The path to mount the auth method — this defaults to the name of the type.
        :param pulumi.Input[Union['AuthBackendTuneArgs', 'AuthBackendTuneArgsDict']] tune: Extra configuration block. Structure is documented below.
               
               The `tune` block is used to tune the auth backend:
        :param pulumi.Input[_builtins.str] type: The name of the auth method type.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthBackendState.__new__(_AuthBackendState)

        __props__.__dict__["accessor"] = accessor
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_remount"] = disable_remount
        __props__.__dict__["identity_token_key"] = identity_token_key
        __props__.__dict__["local"] = local
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["path"] = path
        __props__.__dict__["tune"] = tune
        __props__.__dict__["type"] = type
        return AuthBackend(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def accessor(self) -> pulumi.Output[_builtins.str]:
        """
        The accessor for this auth method
        """
        return pulumi.get(self, "accessor")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of the auth method.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        """
        return pulumi.get(self, "disable_remount")

    @_builtins.property
    @pulumi.getter(name="identityTokenKey")
    def identity_token_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The key to use for signing identity tokens.
        """
        return pulumi.get(self, "identity_token_key")

    @_builtins.property
    @pulumi.getter
    def local(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if the auth method is local only.
        """
        return pulumi.get(self, "local")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[_builtins.str]:
        """
        The path to mount the auth method — this defaults to the name of the type.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def tune(self) -> pulumi.Output['outputs.AuthBackendTune']:
        """
        Extra configuration block. Structure is documented below.

        The `tune` block is used to tune the auth backend:
        """
        return pulumi.get(self, "tune")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the auth method type.
        """
        return pulumi.get(self, "type")

