# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretBackendStaticRoleArgs', 'SecretBackendStaticRole']

@pulumi.input_type
class SecretBackendStaticRoleArgs:
    def __init__(__self__, *,
                 rotation_period: pulumi.Input[_builtins.int],
                 username: pulumi.Input[_builtins.str],
                 assume_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 assume_role_session_name: Optional[pulumi.Input[_builtins.str]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SecretBackendStaticRole resource.
        :param pulumi.Input[_builtins.int] rotation_period: How often Vault should rotate the password of the user entry.
        :param pulumi.Input[_builtins.str] username: The username of the existing AWS IAM to manage password rotation for.
        :param pulumi.Input[_builtins.str] assume_role_arn: Specifies the ARN of the role that Vault should assume.
               When provided, Vault will use AWS STS to assume this role and generate temporary credentials.
               If `assume_role_arn` is provided, `assume_role_session_name` must also be provided.
               Requires Vault 1.19+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] assume_role_session_name: Specifies the session name to use when assuming the role.
               If `assume_role_session_name` is provided, `assume_role_arn` must also be provided.
               Requires Vault 1.19+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] backend: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `aws`
        :param pulumi.Input[_builtins.str] external_id: Specifies the external ID to use when assuming the role.
               Requires Vault 1.19+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] name: The name to identify this role within the backend.
               Must be unique within the backend.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        """
        pulumi.set(__self__, "rotation_period", rotation_period)
        pulumi.set(__self__, "username", username)
        if assume_role_arn is not None:
            pulumi.set(__self__, "assume_role_arn", assume_role_arn)
        if assume_role_session_name is not None:
            pulumi.set(__self__, "assume_role_session_name", assume_role_session_name)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> pulumi.Input[_builtins.int]:
        """
        How often Vault should rotate the password of the user entry.
        """
        return pulumi.get(self, "rotation_period")

    @rotation_period.setter
    def rotation_period(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "rotation_period", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        The username of the existing AWS IAM to manage password rotation for.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="assumeRoleArn")
    def assume_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ARN of the role that Vault should assume.
        When provided, Vault will use AWS STS to assume this role and generate temporary credentials.
        If `assume_role_arn` is provided, `assume_role_session_name` must also be provided.
        Requires Vault 1.19+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "assume_role_arn")

    @assume_role_arn.setter
    def assume_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assume_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="assumeRoleSessionName")
    def assume_role_session_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the session name to use when assuming the role.
        If `assume_role_session_name` is provided, `assume_role_arn` must also be provided.
        Requires Vault 1.19+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "assume_role_session_name")

    @assume_role_session_name.setter
    def assume_role_session_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assume_role_session_name", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `aws`
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the external ID to use when assuming the role.
        Requires Vault 1.19+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name to identify this role within the backend.
        Must be unique within the backend.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class _SecretBackendStaticRoleState:
    def __init__(__self__, *,
                 assume_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 assume_role_session_name: Optional[pulumi.Input[_builtins.str]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecretBackendStaticRole resources.
        :param pulumi.Input[_builtins.str] assume_role_arn: Specifies the ARN of the role that Vault should assume.
               When provided, Vault will use AWS STS to assume this role and generate temporary credentials.
               If `assume_role_arn` is provided, `assume_role_session_name` must also be provided.
               Requires Vault 1.19+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] assume_role_session_name: Specifies the session name to use when assuming the role.
               If `assume_role_session_name` is provided, `assume_role_arn` must also be provided.
               Requires Vault 1.19+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] backend: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `aws`
        :param pulumi.Input[_builtins.str] external_id: Specifies the external ID to use when assuming the role.
               Requires Vault 1.19+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] name: The name to identify this role within the backend.
               Must be unique within the backend.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] rotation_period: How often Vault should rotate the password of the user entry.
        :param pulumi.Input[_builtins.str] username: The username of the existing AWS IAM to manage password rotation for.
        """
        if assume_role_arn is not None:
            pulumi.set(__self__, "assume_role_arn", assume_role_arn)
        if assume_role_session_name is not None:
            pulumi.set(__self__, "assume_role_session_name", assume_role_session_name)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="assumeRoleArn")
    def assume_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ARN of the role that Vault should assume.
        When provided, Vault will use AWS STS to assume this role and generate temporary credentials.
        If `assume_role_arn` is provided, `assume_role_session_name` must also be provided.
        Requires Vault 1.19+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "assume_role_arn")

    @assume_role_arn.setter
    def assume_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assume_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="assumeRoleSessionName")
    def assume_role_session_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the session name to use when assuming the role.
        If `assume_role_session_name` is provided, `assume_role_arn` must also be provided.
        Requires Vault 1.19+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "assume_role_session_name")

    @assume_role_session_name.setter
    def assume_role_session_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assume_role_session_name", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `aws`
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the external ID to use when assuming the role.
        Requires Vault 1.19+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name to identify this role within the backend.
        Must be unique within the backend.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How often Vault should rotate the password of the user entry.
        """
        return pulumi.get(self, "rotation_period")

    @rotation_period.setter
    def rotation_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_period", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of the existing AWS IAM to manage password rotation for.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("vault:aws/secretBackendStaticRole:SecretBackendStaticRole")
class SecretBackendStaticRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assume_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 assume_role_session_name: Optional[pulumi.Input[_builtins.str]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        aws = vault.aws.SecretBackend("aws",
            path="my-aws",
            description="Obtain AWS credentials.")
        role = vault.aws.SecretBackendStaticRole("role",
            backend=aws.path,
            name="test",
            username="my-test-user",
            rotation_period=3600)
        ```

        ```python
        import pulumi
        import pulumi_vault as vault

        aws = vault.aws.SecretBackend("aws",
            path="my-aws",
            description="Obtain AWS credentials.")
        assume_role = vault.aws.SecretBackendStaticRole("assume-role",
            backend=aws.path,
            name="assume-role-test",
            username="my-assume-role-user",
            assume_role_arn="arn:aws:iam::123456789012:role/assume-role",
            assume_role_session_name="assume-role-session",
            external_id="test-id",
            rotation_period=3600)
        ```

        ## Import

        AWS secret backend static role can be imported using the full path to the role
        of the form: `<mount_path>/static-roles/<role_name>` e.g.

        ```sh
        $ pulumi import vault:aws/secretBackendStaticRole:SecretBackendStaticRole role aws/static-roles/example-role
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] assume_role_arn: Specifies the ARN of the role that Vault should assume.
               When provided, Vault will use AWS STS to assume this role and generate temporary credentials.
               If `assume_role_arn` is provided, `assume_role_session_name` must also be provided.
               Requires Vault 1.19+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] assume_role_session_name: Specifies the session name to use when assuming the role.
               If `assume_role_session_name` is provided, `assume_role_arn` must also be provided.
               Requires Vault 1.19+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] backend: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `aws`
        :param pulumi.Input[_builtins.str] external_id: Specifies the external ID to use when assuming the role.
               Requires Vault 1.19+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] name: The name to identify this role within the backend.
               Must be unique within the backend.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] rotation_period: How often Vault should rotate the password of the user entry.
        :param pulumi.Input[_builtins.str] username: The username of the existing AWS IAM to manage password rotation for.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendStaticRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        aws = vault.aws.SecretBackend("aws",
            path="my-aws",
            description="Obtain AWS credentials.")
        role = vault.aws.SecretBackendStaticRole("role",
            backend=aws.path,
            name="test",
            username="my-test-user",
            rotation_period=3600)
        ```

        ```python
        import pulumi
        import pulumi_vault as vault

        aws = vault.aws.SecretBackend("aws",
            path="my-aws",
            description="Obtain AWS credentials.")
        assume_role = vault.aws.SecretBackendStaticRole("assume-role",
            backend=aws.path,
            name="assume-role-test",
            username="my-assume-role-user",
            assume_role_arn="arn:aws:iam::123456789012:role/assume-role",
            assume_role_session_name="assume-role-session",
            external_id="test-id",
            rotation_period=3600)
        ```

        ## Import

        AWS secret backend static role can be imported using the full path to the role
        of the form: `<mount_path>/static-roles/<role_name>` e.g.

        ```sh
        $ pulumi import vault:aws/secretBackendStaticRole:SecretBackendStaticRole role aws/static-roles/example-role
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendStaticRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendStaticRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assume_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 assume_role_session_name: Optional[pulumi.Input[_builtins.str]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendStaticRoleArgs.__new__(SecretBackendStaticRoleArgs)

            __props__.__dict__["assume_role_arn"] = assume_role_arn
            __props__.__dict__["assume_role_session_name"] = assume_role_session_name
            __props__.__dict__["backend"] = backend
            __props__.__dict__["external_id"] = external_id
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            if rotation_period is None and not opts.urn:
                raise TypeError("Missing required property 'rotation_period'")
            __props__.__dict__["rotation_period"] = rotation_period
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
        super(SecretBackendStaticRole, __self__).__init__(
            'vault:aws/secretBackendStaticRole:SecretBackendStaticRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assume_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            assume_role_session_name: Optional[pulumi.Input[_builtins.str]] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            external_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecretBackendStaticRole':
        """
        Get an existing SecretBackendStaticRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] assume_role_arn: Specifies the ARN of the role that Vault should assume.
               When provided, Vault will use AWS STS to assume this role and generate temporary credentials.
               If `assume_role_arn` is provided, `assume_role_session_name` must also be provided.
               Requires Vault 1.19+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] assume_role_session_name: Specifies the session name to use when assuming the role.
               If `assume_role_session_name` is provided, `assume_role_arn` must also be provided.
               Requires Vault 1.19+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] backend: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `aws`
        :param pulumi.Input[_builtins.str] external_id: Specifies the external ID to use when assuming the role.
               Requires Vault 1.19+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] name: The name to identify this role within the backend.
               Must be unique within the backend.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] rotation_period: How often Vault should rotate the password of the user entry.
        :param pulumi.Input[_builtins.str] username: The username of the existing AWS IAM to manage password rotation for.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendStaticRoleState.__new__(_SecretBackendStaticRoleState)

        __props__.__dict__["assume_role_arn"] = assume_role_arn
        __props__.__dict__["assume_role_session_name"] = assume_role_session_name
        __props__.__dict__["backend"] = backend
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["rotation_period"] = rotation_period
        __props__.__dict__["username"] = username
        return SecretBackendStaticRole(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="assumeRoleArn")
    def assume_role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ARN of the role that Vault should assume.
        When provided, Vault will use AWS STS to assume this role and generate temporary credentials.
        If `assume_role_arn` is provided, `assume_role_session_name` must also be provided.
        Requires Vault 1.19+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "assume_role_arn")

    @_builtins.property
    @pulumi.getter(name="assumeRoleSessionName")
    def assume_role_session_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the session name to use when assuming the role.
        If `assume_role_session_name` is provided, `assume_role_arn` must also be provided.
        Requires Vault 1.19+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "assume_role_session_name")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `aws`
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the external ID to use when assuming the role.
        Requires Vault 1.19+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name to identify this role within the backend.
        Must be unique within the backend.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> pulumi.Output[_builtins.int]:
        """
        How often Vault should rotate the password of the user entry.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        The username of the existing AWS IAM to manage password rotation for.
        """
        return pulumi.get(self, "username")

