# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretBackendArgs', 'SecretBackend']

@pulumi.input_type
class SecretBackendArgs:
    def __init__(__self__, *,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_audience: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SecretBackend resource.
        :param pulumi.Input[_builtins.str] credentials: JSON-encoded credentials to use to connect to GCP
        :param pulumi.Input[_builtins.int] credentials_wo_version: The version of the `credentials_wo`. For more info see updating write-only attributes.
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: The default TTL for credentials
               issued by this backend. Defaults to '0'.
        :param pulumi.Input[_builtins.str] description: A human-friendly description for this backend.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.str] identity_token_audience: The audience claim value for plugin identity
               tokens. Must match an allowed audience configured for the target [Workload Identity Pool](https://cloud.google.com/iam/docs/workload-identity-federation-with-other-providers#prepare).
               Mutually exclusive with `credentials`.  Requires Vault 1.17+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin identity
               tokens. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] identity_token_ttl: The TTL of generated tokens.
        :param pulumi.Input[_builtins.bool] local: Boolean flag that can be explicitly set to true to enforce local mount in HA environment
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: The maximum TTL that can be requested
               for credentials issued by this backend. Defaults to '0'.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `gcp`.
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] service_account_email: Service Account to impersonate for plugin workload identity federation.
               Required with `identity_token_audience`. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        """
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if credentials_wo_version is not None:
            pulumi.set(__self__, "credentials_wo_version", credentials_wo_version)
        if default_lease_ttl_seconds is not None:
            pulumi.set(__self__, "default_lease_ttl_seconds", default_lease_ttl_seconds)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if disable_remount is not None:
            pulumi.set(__self__, "disable_remount", disable_remount)
        if identity_token_audience is not None:
            pulumi.set(__self__, "identity_token_audience", identity_token_audience)
        if identity_token_key is not None:
            pulumi.set(__self__, "identity_token_key", identity_token_key)
        if identity_token_ttl is not None:
            pulumi.set(__self__, "identity_token_ttl", identity_token_ttl)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if max_lease_ttl_seconds is not None:
            pulumi.set(__self__, "max_lease_ttl_seconds", max_lease_ttl_seconds)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON-encoded credentials to use to connect to GCP
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter(name="credentialsWoVersion")
    def credentials_wo_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version of the `credentials_wo`. For more info see updating write-only attributes.
        """
        return pulumi.get(self, "credentials_wo_version")

    @credentials_wo_version.setter
    def credentials_wo_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "credentials_wo_version", value)

    @_builtins.property
    @pulumi.getter(name="defaultLeaseTtlSeconds")
    def default_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default TTL for credentials
        issued by this backend. Defaults to '0'.
        """
        return pulumi.get(self, "default_lease_ttl_seconds")

    @default_lease_ttl_seconds.setter
    def default_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-friendly description for this backend.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "disable_automated_rotation")

    @disable_automated_rotation.setter
    def disable_automated_rotation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_automated_rotation", value)

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        """
        return pulumi.get(self, "disable_remount")

    @disable_remount.setter
    def disable_remount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_remount", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenAudience")
    def identity_token_audience(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The audience claim value for plugin identity
        tokens. Must match an allowed audience configured for the target [Workload Identity Pool](https://cloud.google.com/iam/docs/workload-identity-federation-with-other-providers#prepare).
        Mutually exclusive with `credentials`.  Requires Vault 1.17+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "identity_token_audience")

    @identity_token_audience.setter
    def identity_token_audience(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_token_audience", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenKey")
    def identity_token_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key to use for signing plugin identity
        tokens. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "identity_token_key")

    @identity_token_key.setter
    def identity_token_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_token_key", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenTtl")
    def identity_token_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The TTL of generated tokens.
        """
        return pulumi.get(self, "identity_token_ttl")

    @identity_token_ttl.setter
    def identity_token_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "identity_token_ttl", value)

    @_builtins.property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag that can be explicitly set to true to enforce local mount in HA environment
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local", value)

    @_builtins.property
    @pulumi.getter(name="maxLeaseTtlSeconds")
    def max_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum TTL that can be requested
        for credentials issued by this backend. Defaults to '0'.
        """
        return pulumi.get(self, "max_lease_ttl_seconds")

    @max_lease_ttl_seconds.setter
    def max_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `gcp`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "rotation_period")

    @rotation_period.setter
    def rotation_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_period", value)

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "rotation_schedule")

    @rotation_schedule.setter
    def rotation_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotation_schedule", value)

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "rotation_window")

    @rotation_window.setter
    def rotation_window(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_window", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service Account to impersonate for plugin workload identity federation.
        Required with `identity_token_audience`. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_email", value)


@pulumi.input_type
class _SecretBackendState:
    def __init__(__self__, *,
                 accessor: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_audience: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecretBackend resources.
        :param pulumi.Input[_builtins.str] accessor: The accessor of the created GCP mount.
        :param pulumi.Input[_builtins.str] credentials: JSON-encoded credentials to use to connect to GCP
        :param pulumi.Input[_builtins.int] credentials_wo_version: The version of the `credentials_wo`. For more info see updating write-only attributes.
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: The default TTL for credentials
               issued by this backend. Defaults to '0'.
        :param pulumi.Input[_builtins.str] description: A human-friendly description for this backend.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.str] identity_token_audience: The audience claim value for plugin identity
               tokens. Must match an allowed audience configured for the target [Workload Identity Pool](https://cloud.google.com/iam/docs/workload-identity-federation-with-other-providers#prepare).
               Mutually exclusive with `credentials`.  Requires Vault 1.17+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin identity
               tokens. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] identity_token_ttl: The TTL of generated tokens.
        :param pulumi.Input[_builtins.bool] local: Boolean flag that can be explicitly set to true to enforce local mount in HA environment
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: The maximum TTL that can be requested
               for credentials issued by this backend. Defaults to '0'.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `gcp`.
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] service_account_email: Service Account to impersonate for plugin workload identity federation.
               Required with `identity_token_audience`. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        """
        if accessor is not None:
            pulumi.set(__self__, "accessor", accessor)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if credentials_wo_version is not None:
            pulumi.set(__self__, "credentials_wo_version", credentials_wo_version)
        if default_lease_ttl_seconds is not None:
            pulumi.set(__self__, "default_lease_ttl_seconds", default_lease_ttl_seconds)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if disable_remount is not None:
            pulumi.set(__self__, "disable_remount", disable_remount)
        if identity_token_audience is not None:
            pulumi.set(__self__, "identity_token_audience", identity_token_audience)
        if identity_token_key is not None:
            pulumi.set(__self__, "identity_token_key", identity_token_key)
        if identity_token_ttl is not None:
            pulumi.set(__self__, "identity_token_ttl", identity_token_ttl)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if max_lease_ttl_seconds is not None:
            pulumi.set(__self__, "max_lease_ttl_seconds", max_lease_ttl_seconds)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)

    @_builtins.property
    @pulumi.getter
    def accessor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The accessor of the created GCP mount.
        """
        return pulumi.get(self, "accessor")

    @accessor.setter
    def accessor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessor", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON-encoded credentials to use to connect to GCP
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter(name="credentialsWoVersion")
    def credentials_wo_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version of the `credentials_wo`. For more info see updating write-only attributes.
        """
        return pulumi.get(self, "credentials_wo_version")

    @credentials_wo_version.setter
    def credentials_wo_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "credentials_wo_version", value)

    @_builtins.property
    @pulumi.getter(name="defaultLeaseTtlSeconds")
    def default_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default TTL for credentials
        issued by this backend. Defaults to '0'.
        """
        return pulumi.get(self, "default_lease_ttl_seconds")

    @default_lease_ttl_seconds.setter
    def default_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-friendly description for this backend.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "disable_automated_rotation")

    @disable_automated_rotation.setter
    def disable_automated_rotation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_automated_rotation", value)

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        """
        return pulumi.get(self, "disable_remount")

    @disable_remount.setter
    def disable_remount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_remount", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenAudience")
    def identity_token_audience(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The audience claim value for plugin identity
        tokens. Must match an allowed audience configured for the target [Workload Identity Pool](https://cloud.google.com/iam/docs/workload-identity-federation-with-other-providers#prepare).
        Mutually exclusive with `credentials`.  Requires Vault 1.17+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "identity_token_audience")

    @identity_token_audience.setter
    def identity_token_audience(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_token_audience", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenKey")
    def identity_token_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key to use for signing plugin identity
        tokens. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "identity_token_key")

    @identity_token_key.setter
    def identity_token_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_token_key", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenTtl")
    def identity_token_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The TTL of generated tokens.
        """
        return pulumi.get(self, "identity_token_ttl")

    @identity_token_ttl.setter
    def identity_token_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "identity_token_ttl", value)

    @_builtins.property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag that can be explicitly set to true to enforce local mount in HA environment
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local", value)

    @_builtins.property
    @pulumi.getter(name="maxLeaseTtlSeconds")
    def max_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum TTL that can be requested
        for credentials issued by this backend. Defaults to '0'.
        """
        return pulumi.get(self, "max_lease_ttl_seconds")

    @max_lease_ttl_seconds.setter
    def max_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `gcp`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "rotation_period")

    @rotation_period.setter
    def rotation_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_period", value)

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "rotation_schedule")

    @rotation_schedule.setter
    def rotation_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotation_schedule", value)

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "rotation_window")

    @rotation_window.setter
    def rotation_window(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_window", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service Account to impersonate for plugin workload identity federation.
        Required with `identity_token_audience`. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_email", value)


@pulumi.type_token("vault:gcp/secretBackend:SecretBackend")
class SecretBackend(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_audience: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        You can setup the GCP secret backend with Workload Identity Federation (WIF) for a secret-less configuration:
        ```python
        import pulumi
        import pulumi_vault as vault

        gcp = vault.gcp.SecretBackend("gcp",
            identity_token_key="example-key",
            identity_token_ttl=1800,
            identity_token_audience="<TOKEN_AUDIENCE>",
            service_account_email="<SERVICE_ACCOUNT_EMAIL>",
            rotation_schedule="0 * * * SAT",
            rotation_window=3600)
        ```

        ```python
        import pulumi
        import pulumi_std as std
        import pulumi_vault as vault

        gcp = vault.gcp.SecretBackend("gcp",
            credentials=std.file(input="credentials.json").result,
            rotation_schedule="0 * * * SAT",
            rotation_window=3600)
        ```

        ## Ephemeral Attributes Reference

        The following write-only attributes are supported:

        * `credentials_wo` - (Optional) The GCP service account credentials in JSON format. Can be updated.
          **Note**: This property is write-only and will not be read from the API.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] credentials: JSON-encoded credentials to use to connect to GCP
        :param pulumi.Input[_builtins.int] credentials_wo_version: The version of the `credentials_wo`. For more info see updating write-only attributes.
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: The default TTL for credentials
               issued by this backend. Defaults to '0'.
        :param pulumi.Input[_builtins.str] description: A human-friendly description for this backend.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.str] identity_token_audience: The audience claim value for plugin identity
               tokens. Must match an allowed audience configured for the target [Workload Identity Pool](https://cloud.google.com/iam/docs/workload-identity-federation-with-other-providers#prepare).
               Mutually exclusive with `credentials`.  Requires Vault 1.17+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin identity
               tokens. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] identity_token_ttl: The TTL of generated tokens.
        :param pulumi.Input[_builtins.bool] local: Boolean flag that can be explicitly set to true to enforce local mount in HA environment
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: The maximum TTL that can be requested
               for credentials issued by this backend. Defaults to '0'.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `gcp`.
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] service_account_email: Service Account to impersonate for plugin workload identity federation.
               Required with `identity_token_audience`. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SecretBackendArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        You can setup the GCP secret backend with Workload Identity Federation (WIF) for a secret-less configuration:
        ```python
        import pulumi
        import pulumi_vault as vault

        gcp = vault.gcp.SecretBackend("gcp",
            identity_token_key="example-key",
            identity_token_ttl=1800,
            identity_token_audience="<TOKEN_AUDIENCE>",
            service_account_email="<SERVICE_ACCOUNT_EMAIL>",
            rotation_schedule="0 * * * SAT",
            rotation_window=3600)
        ```

        ```python
        import pulumi
        import pulumi_std as std
        import pulumi_vault as vault

        gcp = vault.gcp.SecretBackend("gcp",
            credentials=std.file(input="credentials.json").result,
            rotation_schedule="0 * * * SAT",
            rotation_window=3600)
        ```

        ## Ephemeral Attributes Reference

        The following write-only attributes are supported:

        * `credentials_wo` - (Optional) The GCP service account credentials in JSON format. Can be updated.
          **Note**: This property is write-only and will not be read from the API.

        :param str resource_name: The name of the resource.
        :param SecretBackendArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_audience: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendArgs.__new__(SecretBackendArgs)

            __props__.__dict__["credentials"] = None if credentials is None else pulumi.Output.secret(credentials)
            __props__.__dict__["credentials_wo_version"] = credentials_wo_version
            __props__.__dict__["default_lease_ttl_seconds"] = default_lease_ttl_seconds
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_automated_rotation"] = disable_automated_rotation
            __props__.__dict__["disable_remount"] = disable_remount
            __props__.__dict__["identity_token_audience"] = identity_token_audience
            __props__.__dict__["identity_token_key"] = identity_token_key
            __props__.__dict__["identity_token_ttl"] = identity_token_ttl
            __props__.__dict__["local"] = local
            __props__.__dict__["max_lease_ttl_seconds"] = max_lease_ttl_seconds
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["path"] = path
            __props__.__dict__["rotation_period"] = rotation_period
            __props__.__dict__["rotation_schedule"] = rotation_schedule
            __props__.__dict__["rotation_window"] = rotation_window
            __props__.__dict__["service_account_email"] = service_account_email
            __props__.__dict__["accessor"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["credentials"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SecretBackend, __self__).__init__(
            'vault:gcp/secretBackend:SecretBackend',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessor: Optional[pulumi.Input[_builtins.str]] = None,
            credentials: Optional[pulumi.Input[_builtins.str]] = None,
            credentials_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
            default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
            disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
            identity_token_audience: Optional[pulumi.Input[_builtins.str]] = None,
            identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
            identity_token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            local: Optional[pulumi.Input[_builtins.bool]] = None,
            max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None,
            rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
            rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
            rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
            service_account_email: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecretBackend':
        """
        Get an existing SecretBackend resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessor: The accessor of the created GCP mount.
        :param pulumi.Input[_builtins.str] credentials: JSON-encoded credentials to use to connect to GCP
        :param pulumi.Input[_builtins.int] credentials_wo_version: The version of the `credentials_wo`. For more info see updating write-only attributes.
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: The default TTL for credentials
               issued by this backend. Defaults to '0'.
        :param pulumi.Input[_builtins.str] description: A human-friendly description for this backend.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.str] identity_token_audience: The audience claim value for plugin identity
               tokens. Must match an allowed audience configured for the target [Workload Identity Pool](https://cloud.google.com/iam/docs/workload-identity-federation-with-other-providers#prepare).
               Mutually exclusive with `credentials`.  Requires Vault 1.17+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin identity
               tokens. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] identity_token_ttl: The TTL of generated tokens.
        :param pulumi.Input[_builtins.bool] local: Boolean flag that can be explicitly set to true to enforce local mount in HA environment
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: The maximum TTL that can be requested
               for credentials issued by this backend. Defaults to '0'.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `gcp`.
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] service_account_email: Service Account to impersonate for plugin workload identity federation.
               Required with `identity_token_audience`. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendState.__new__(_SecretBackendState)

        __props__.__dict__["accessor"] = accessor
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["credentials_wo_version"] = credentials_wo_version
        __props__.__dict__["default_lease_ttl_seconds"] = default_lease_ttl_seconds
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_automated_rotation"] = disable_automated_rotation
        __props__.__dict__["disable_remount"] = disable_remount
        __props__.__dict__["identity_token_audience"] = identity_token_audience
        __props__.__dict__["identity_token_key"] = identity_token_key
        __props__.__dict__["identity_token_ttl"] = identity_token_ttl
        __props__.__dict__["local"] = local
        __props__.__dict__["max_lease_ttl_seconds"] = max_lease_ttl_seconds
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["path"] = path
        __props__.__dict__["rotation_period"] = rotation_period
        __props__.__dict__["rotation_schedule"] = rotation_schedule
        __props__.__dict__["rotation_window"] = rotation_window
        __props__.__dict__["service_account_email"] = service_account_email
        return SecretBackend(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def accessor(self) -> pulumi.Output[_builtins.str]:
        """
        The accessor of the created GCP mount.
        """
        return pulumi.get(self, "accessor")

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        JSON-encoded credentials to use to connect to GCP
        """
        return pulumi.get(self, "credentials")

    @_builtins.property
    @pulumi.getter(name="credentialsWoVersion")
    def credentials_wo_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The version of the `credentials_wo`. For more info see updating write-only attributes.
        """
        return pulumi.get(self, "credentials_wo_version")

    @_builtins.property
    @pulumi.getter(name="defaultLeaseTtlSeconds")
    def default_lease_ttl_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The default TTL for credentials
        issued by this backend. Defaults to '0'.
        """
        return pulumi.get(self, "default_lease_ttl_seconds")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A human-friendly description for this backend.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        """
        return pulumi.get(self, "disable_remount")

    @_builtins.property
    @pulumi.getter(name="identityTokenAudience")
    def identity_token_audience(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The audience claim value for plugin identity
        tokens. Must match an allowed audience configured for the target [Workload Identity Pool](https://cloud.google.com/iam/docs/workload-identity-federation-with-other-providers#prepare).
        Mutually exclusive with `credentials`.  Requires Vault 1.17+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "identity_token_audience")

    @_builtins.property
    @pulumi.getter(name="identityTokenKey")
    def identity_token_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The key to use for signing plugin identity
        tokens. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "identity_token_key")

    @_builtins.property
    @pulumi.getter(name="identityTokenTtl")
    def identity_token_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The TTL of generated tokens.
        """
        return pulumi.get(self, "identity_token_ttl")

    @_builtins.property
    @pulumi.getter
    def local(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean flag that can be explicitly set to true to enforce local mount in HA environment
        """
        return pulumi.get(self, "local")

    @_builtins.property
    @pulumi.getter(name="maxLeaseTtlSeconds")
    def max_lease_ttl_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum TTL that can be requested
        for credentials issued by this backend. Defaults to '0'.
        """
        return pulumi.get(self, "max_lease_ttl_seconds")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `gcp`.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Service Account to impersonate for plugin workload identity federation.
        Required with `identity_token_audience`. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "service_account_email")

