# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AuthBackendRoleArgs', 'AuthBackendRole']

@pulumi.input_type
class AuthBackendRoleArgs:
    def __init__(__self__, *,
                 role_name: pulumi.Input[_builtins.str],
                 user_claim: pulumi.Input[_builtins.str],
                 allowed_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 bound_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_claims: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 bound_claims_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bound_subject: Optional[pulumi.Input[_builtins.str]] = None,
                 claim_mappings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 clock_skew_leeway: Optional[pulumi.Input[_builtins.int]] = None,
                 disable_bound_claims_parsing: Optional[pulumi.Input[_builtins.bool]] = None,
                 expiration_leeway: Optional[pulumi.Input[_builtins.int]] = None,
                 groups_claim: Optional[pulumi.Input[_builtins.str]] = None,
                 max_age: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 not_before_leeway: Optional[pulumi.Input[_builtins.int]] = None,
                 oidc_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role_type: Optional[pulumi.Input[_builtins.str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 token_period: Optional[pulumi.Input[_builtins.int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_claim_json_pointer: Optional[pulumi.Input[_builtins.bool]] = None,
                 verbose_oidc_logging: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a AuthBackendRole resource.
        :param pulumi.Input[_builtins.str] role_name: The name of the role.
        :param pulumi.Input[_builtins.str] user_claim: The claim to use to uniquely identify
               the user; this will be used as the name for the Identity entity alias created
               due to a successful login.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_redirect_uris: The list of allowed values for redirect_uri during OIDC logins.
               Required for OIDC roles
        :param pulumi.Input[_builtins.str] backend: The unique name of the auth backend to configure.
               Defaults to `jwt`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bound_audiences: (Required for roles of type `jwt`, optional for roles of
               type `oidc`) List of `aud` claims to match against. Any match is sufficient.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] bound_claims: If set, a map of claims to values to match against.
               A claim's value must be a string, which may contain one value or multiple
               comma-separated values, e.g. `"red"` or `"red,green,blue"`.
        :param pulumi.Input[_builtins.str] bound_claims_type: How to interpret values in the claims/values
               map (`bound_claims`): can be either `string` (exact match) or `glob` (wildcard
               match). Requires Vault 1.4.0 or above.
        :param pulumi.Input[_builtins.str] bound_subject: If set, requires that the `sub` claim matches
               this value.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] claim_mappings: If set, a map of claims (keys) to be copied
               to specified metadata fields (values).
        :param pulumi.Input[_builtins.int] clock_skew_leeway: The amount of leeway to add to all claims to account for clock skew, in
               seconds. Defaults to `60` seconds if set to `0` and can be disabled if set to `-1`.
               Only applicable with "jwt" roles.
        :param pulumi.Input[_builtins.bool] disable_bound_claims_parsing: Disable bound claim value parsing. Useful when values contain commas.
        :param pulumi.Input[_builtins.int] expiration_leeway: The amount of leeway to add to expiration (`exp`) claims to account for
               clock skew, in seconds. Defaults to `150` seconds if set to `0` and can be disabled if set to `-1`.
               Only applicable with "jwt" roles.
        :param pulumi.Input[_builtins.str] groups_claim: The claim to use to uniquely identify
               the set of groups to which the user belongs; this will be used as the names
               for the Identity group aliases created due to a successful login. The claim
               value must be a list of strings.
        :param pulumi.Input[_builtins.int] max_age: Specifies the allowable elapsed time in seconds since the last time 
               the user was actively authenticated with the OIDC provider.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] not_before_leeway: The amount of leeway to add to not before (`nbf`) claims to account for
               clock skew, in seconds. Defaults to `150` seconds if set to `0` and can be disabled if set to `-1`.
               Only applicable with "jwt" roles.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] oidc_scopes: If set, a list of OIDC scopes to be used with an OIDC role.
               The standard scope "openid" is automatically included and need not be specified.
        :param pulumi.Input[_builtins.str] role_type: Type of role, either "oidc" (default) or "jwt".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[_builtins.int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[_builtins.int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[_builtins.bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[_builtins.int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[_builtins.int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[_builtins.int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[_builtins.str] token_type: The type of token to generate, service or batch
        :param pulumi.Input[_builtins.bool] user_claim_json_pointer: Specifies if the `user_claim` value uses
               [JSON pointer](https://www.vaultproject.io/docs/auth/jwt#claim-specifications-and-json-pointer)
               syntax for referencing claims. By default, the `user_claim` value will not use JSON pointer.
               Requires Vault 1.11+.
        :param pulumi.Input[_builtins.bool] verbose_oidc_logging: Log received OIDC tokens and claims when debug-level
               logging is active. Not recommended in production since sensitive information may be present
               in OIDC responses.
        """
        pulumi.set(__self__, "role_name", role_name)
        pulumi.set(__self__, "user_claim", user_claim)
        if allowed_redirect_uris is not None:
            pulumi.set(__self__, "allowed_redirect_uris", allowed_redirect_uris)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if bound_audiences is not None:
            pulumi.set(__self__, "bound_audiences", bound_audiences)
        if bound_claims is not None:
            pulumi.set(__self__, "bound_claims", bound_claims)
        if bound_claims_type is not None:
            pulumi.set(__self__, "bound_claims_type", bound_claims_type)
        if bound_subject is not None:
            pulumi.set(__self__, "bound_subject", bound_subject)
        if claim_mappings is not None:
            pulumi.set(__self__, "claim_mappings", claim_mappings)
        if clock_skew_leeway is not None:
            pulumi.set(__self__, "clock_skew_leeway", clock_skew_leeway)
        if disable_bound_claims_parsing is not None:
            pulumi.set(__self__, "disable_bound_claims_parsing", disable_bound_claims_parsing)
        if expiration_leeway is not None:
            pulumi.set(__self__, "expiration_leeway", expiration_leeway)
        if groups_claim is not None:
            pulumi.set(__self__, "groups_claim", groups_claim)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if not_before_leeway is not None:
            pulumi.set(__self__, "not_before_leeway", not_before_leeway)
        if oidc_scopes is not None:
            pulumi.set(__self__, "oidc_scopes", oidc_scopes)
        if role_type is not None:
            pulumi.set(__self__, "role_type", role_type)
        if token_bound_cidrs is not None:
            pulumi.set(__self__, "token_bound_cidrs", token_bound_cidrs)
        if token_explicit_max_ttl is not None:
            pulumi.set(__self__, "token_explicit_max_ttl", token_explicit_max_ttl)
        if token_max_ttl is not None:
            pulumi.set(__self__, "token_max_ttl", token_max_ttl)
        if token_no_default_policy is not None:
            pulumi.set(__self__, "token_no_default_policy", token_no_default_policy)
        if token_num_uses is not None:
            pulumi.set(__self__, "token_num_uses", token_num_uses)
        if token_period is not None:
            pulumi.set(__self__, "token_period", token_period)
        if token_policies is not None:
            pulumi.set(__self__, "token_policies", token_policies)
        if token_ttl is not None:
            pulumi.set(__self__, "token_ttl", token_ttl)
        if token_type is not None:
            pulumi.set(__self__, "token_type", token_type)
        if user_claim_json_pointer is not None:
            pulumi.set(__self__, "user_claim_json_pointer", user_claim_json_pointer)
        if verbose_oidc_logging is not None:
            pulumi.set(__self__, "verbose_oidc_logging", verbose_oidc_logging)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the role.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter(name="userClaim")
    def user_claim(self) -> pulumi.Input[_builtins.str]:
        """
        The claim to use to uniquely identify
        the user; this will be used as the name for the Identity entity alias created
        due to a successful login.
        """
        return pulumi.get(self, "user_claim")

    @user_claim.setter
    def user_claim(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_claim", value)

    @_builtins.property
    @pulumi.getter(name="allowedRedirectUris")
    def allowed_redirect_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of allowed values for redirect_uri during OIDC logins.
        Required for OIDC roles
        """
        return pulumi.get(self, "allowed_redirect_uris")

    @allowed_redirect_uris.setter
    def allowed_redirect_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_redirect_uris", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the auth backend to configure.
        Defaults to `jwt`.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="boundAudiences")
    def bound_audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Required for roles of type `jwt`, optional for roles of
        type `oidc`) List of `aud` claims to match against. Any match is sufficient.
        """
        return pulumi.get(self, "bound_audiences")

    @bound_audiences.setter
    def bound_audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bound_audiences", value)

    @_builtins.property
    @pulumi.getter(name="boundClaims")
    def bound_claims(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        If set, a map of claims to values to match against.
        A claim's value must be a string, which may contain one value or multiple
        comma-separated values, e.g. `"red"` or `"red,green,blue"`.
        """
        return pulumi.get(self, "bound_claims")

    @bound_claims.setter
    def bound_claims(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bound_claims", value)

    @_builtins.property
    @pulumi.getter(name="boundClaimsType")
    def bound_claims_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How to interpret values in the claims/values
        map (`bound_claims`): can be either `string` (exact match) or `glob` (wildcard
        match). Requires Vault 1.4.0 or above.
        """
        return pulumi.get(self, "bound_claims_type")

    @bound_claims_type.setter
    def bound_claims_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bound_claims_type", value)

    @_builtins.property
    @pulumi.getter(name="boundSubject")
    def bound_subject(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If set, requires that the `sub` claim matches
        this value.
        """
        return pulumi.get(self, "bound_subject")

    @bound_subject.setter
    def bound_subject(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bound_subject", value)

    @_builtins.property
    @pulumi.getter(name="claimMappings")
    def claim_mappings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        If set, a map of claims (keys) to be copied
        to specified metadata fields (values).
        """
        return pulumi.get(self, "claim_mappings")

    @claim_mappings.setter
    def claim_mappings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "claim_mappings", value)

    @_builtins.property
    @pulumi.getter(name="clockSkewLeeway")
    def clock_skew_leeway(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of leeway to add to all claims to account for clock skew, in
        seconds. Defaults to `60` seconds if set to `0` and can be disabled if set to `-1`.
        Only applicable with "jwt" roles.
        """
        return pulumi.get(self, "clock_skew_leeway")

    @clock_skew_leeway.setter
    def clock_skew_leeway(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "clock_skew_leeway", value)

    @_builtins.property
    @pulumi.getter(name="disableBoundClaimsParsing")
    def disable_bound_claims_parsing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disable bound claim value parsing. Useful when values contain commas.
        """
        return pulumi.get(self, "disable_bound_claims_parsing")

    @disable_bound_claims_parsing.setter
    def disable_bound_claims_parsing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_bound_claims_parsing", value)

    @_builtins.property
    @pulumi.getter(name="expirationLeeway")
    def expiration_leeway(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of leeway to add to expiration (`exp`) claims to account for
        clock skew, in seconds. Defaults to `150` seconds if set to `0` and can be disabled if set to `-1`.
        Only applicable with "jwt" roles.
        """
        return pulumi.get(self, "expiration_leeway")

    @expiration_leeway.setter
    def expiration_leeway(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expiration_leeway", value)

    @_builtins.property
    @pulumi.getter(name="groupsClaim")
    def groups_claim(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The claim to use to uniquely identify
        the set of groups to which the user belongs; this will be used as the names
        for the Identity group aliases created due to a successful login. The claim
        value must be a list of strings.
        """
        return pulumi.get(self, "groups_claim")

    @groups_claim.setter
    def groups_claim(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "groups_claim", value)

    @_builtins.property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the allowable elapsed time in seconds since the last time 
        the user was actively authenticated with the OIDC provider.
        """
        return pulumi.get(self, "max_age")

    @max_age.setter
    def max_age(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_age", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="notBeforeLeeway")
    def not_before_leeway(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of leeway to add to not before (`nbf`) claims to account for
        clock skew, in seconds. Defaults to `150` seconds if set to `0` and can be disabled if set to `-1`.
        Only applicable with "jwt" roles.
        """
        return pulumi.get(self, "not_before_leeway")

    @not_before_leeway.setter
    def not_before_leeway(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "not_before_leeway", value)

    @_builtins.property
    @pulumi.getter(name="oidcScopes")
    def oidc_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        If set, a list of OIDC scopes to be used with an OIDC role.
        The standard scope "openid" is automatically included and need not be specified.
        """
        return pulumi.get(self, "oidc_scopes")

    @oidc_scopes.setter
    def oidc_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "oidc_scopes", value)

    @_builtins.property
    @pulumi.getter(name="roleType")
    def role_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of role, either "oidc" (default) or "jwt".
        """
        return pulumi.get(self, "role_type")

    @role_type.setter
    def role_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_type", value)

    @_builtins.property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the blocks of IP addresses which are allowed to use the generated token
        """
        return pulumi.get(self, "token_bound_cidrs")

    @token_bound_cidrs.setter
    def token_bound_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_bound_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generated Token's Explicit Maximum TTL in seconds
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @token_explicit_max_ttl.setter
    def token_explicit_max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_explicit_max_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum lifetime of the generated token
        """
        return pulumi.get(self, "token_max_ttl")

    @token_max_ttl.setter
    def token_max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_max_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the 'default' policy will not automatically be added to generated tokens
        """
        return pulumi.get(self, "token_no_default_policy")

    @token_no_default_policy.setter
    def token_no_default_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "token_no_default_policy", value)

    @_builtins.property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of times a token may be used, a value of zero means unlimited
        """
        return pulumi.get(self, "token_num_uses")

    @token_num_uses.setter
    def token_num_uses(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_num_uses", value)

    @_builtins.property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generated Token's Period
        """
        return pulumi.get(self, "token_period")

    @token_period.setter
    def token_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_period", value)

    @_builtins.property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Generated Token's Policies
        """
        return pulumi.get(self, "token_policies")

    @token_policies.setter
    def token_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_policies", value)

    @_builtins.property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @token_ttl.setter
    def token_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of token to generate, service or batch
        """
        return pulumi.get(self, "token_type")

    @token_type.setter
    def token_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_type", value)

    @_builtins.property
    @pulumi.getter(name="userClaimJsonPointer")
    def user_claim_json_pointer(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the `user_claim` value uses
        [JSON pointer](https://www.vaultproject.io/docs/auth/jwt#claim-specifications-and-json-pointer)
        syntax for referencing claims. By default, the `user_claim` value will not use JSON pointer.
        Requires Vault 1.11+.
        """
        return pulumi.get(self, "user_claim_json_pointer")

    @user_claim_json_pointer.setter
    def user_claim_json_pointer(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "user_claim_json_pointer", value)

    @_builtins.property
    @pulumi.getter(name="verboseOidcLogging")
    def verbose_oidc_logging(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Log received OIDC tokens and claims when debug-level
        logging is active. Not recommended in production since sensitive information may be present
        in OIDC responses.
        """
        return pulumi.get(self, "verbose_oidc_logging")

    @verbose_oidc_logging.setter
    def verbose_oidc_logging(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "verbose_oidc_logging", value)


@pulumi.input_type
class _AuthBackendRoleState:
    def __init__(__self__, *,
                 allowed_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 bound_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_claims: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 bound_claims_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bound_subject: Optional[pulumi.Input[_builtins.str]] = None,
                 claim_mappings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 clock_skew_leeway: Optional[pulumi.Input[_builtins.int]] = None,
                 disable_bound_claims_parsing: Optional[pulumi.Input[_builtins.bool]] = None,
                 expiration_leeway: Optional[pulumi.Input[_builtins.int]] = None,
                 groups_claim: Optional[pulumi.Input[_builtins.str]] = None,
                 max_age: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 not_before_leeway: Optional[pulumi.Input[_builtins.int]] = None,
                 oidc_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_type: Optional[pulumi.Input[_builtins.str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 token_period: Optional[pulumi.Input[_builtins.int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_claim: Optional[pulumi.Input[_builtins.str]] = None,
                 user_claim_json_pointer: Optional[pulumi.Input[_builtins.bool]] = None,
                 verbose_oidc_logging: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering AuthBackendRole resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_redirect_uris: The list of allowed values for redirect_uri during OIDC logins.
               Required for OIDC roles
        :param pulumi.Input[_builtins.str] backend: The unique name of the auth backend to configure.
               Defaults to `jwt`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bound_audiences: (Required for roles of type `jwt`, optional for roles of
               type `oidc`) List of `aud` claims to match against. Any match is sufficient.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] bound_claims: If set, a map of claims to values to match against.
               A claim's value must be a string, which may contain one value or multiple
               comma-separated values, e.g. `"red"` or `"red,green,blue"`.
        :param pulumi.Input[_builtins.str] bound_claims_type: How to interpret values in the claims/values
               map (`bound_claims`): can be either `string` (exact match) or `glob` (wildcard
               match). Requires Vault 1.4.0 or above.
        :param pulumi.Input[_builtins.str] bound_subject: If set, requires that the `sub` claim matches
               this value.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] claim_mappings: If set, a map of claims (keys) to be copied
               to specified metadata fields (values).
        :param pulumi.Input[_builtins.int] clock_skew_leeway: The amount of leeway to add to all claims to account for clock skew, in
               seconds. Defaults to `60` seconds if set to `0` and can be disabled if set to `-1`.
               Only applicable with "jwt" roles.
        :param pulumi.Input[_builtins.bool] disable_bound_claims_parsing: Disable bound claim value parsing. Useful when values contain commas.
        :param pulumi.Input[_builtins.int] expiration_leeway: The amount of leeway to add to expiration (`exp`) claims to account for
               clock skew, in seconds. Defaults to `150` seconds if set to `0` and can be disabled if set to `-1`.
               Only applicable with "jwt" roles.
        :param pulumi.Input[_builtins.str] groups_claim: The claim to use to uniquely identify
               the set of groups to which the user belongs; this will be used as the names
               for the Identity group aliases created due to a successful login. The claim
               value must be a list of strings.
        :param pulumi.Input[_builtins.int] max_age: Specifies the allowable elapsed time in seconds since the last time 
               the user was actively authenticated with the OIDC provider.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] not_before_leeway: The amount of leeway to add to not before (`nbf`) claims to account for
               clock skew, in seconds. Defaults to `150` seconds if set to `0` and can be disabled if set to `-1`.
               Only applicable with "jwt" roles.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] oidc_scopes: If set, a list of OIDC scopes to be used with an OIDC role.
               The standard scope "openid" is automatically included and need not be specified.
        :param pulumi.Input[_builtins.str] role_name: The name of the role.
        :param pulumi.Input[_builtins.str] role_type: Type of role, either "oidc" (default) or "jwt".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[_builtins.int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[_builtins.int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[_builtins.bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[_builtins.int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[_builtins.int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[_builtins.int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[_builtins.str] token_type: The type of token to generate, service or batch
        :param pulumi.Input[_builtins.str] user_claim: The claim to use to uniquely identify
               the user; this will be used as the name for the Identity entity alias created
               due to a successful login.
        :param pulumi.Input[_builtins.bool] user_claim_json_pointer: Specifies if the `user_claim` value uses
               [JSON pointer](https://www.vaultproject.io/docs/auth/jwt#claim-specifications-and-json-pointer)
               syntax for referencing claims. By default, the `user_claim` value will not use JSON pointer.
               Requires Vault 1.11+.
        :param pulumi.Input[_builtins.bool] verbose_oidc_logging: Log received OIDC tokens and claims when debug-level
               logging is active. Not recommended in production since sensitive information may be present
               in OIDC responses.
        """
        if allowed_redirect_uris is not None:
            pulumi.set(__self__, "allowed_redirect_uris", allowed_redirect_uris)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if bound_audiences is not None:
            pulumi.set(__self__, "bound_audiences", bound_audiences)
        if bound_claims is not None:
            pulumi.set(__self__, "bound_claims", bound_claims)
        if bound_claims_type is not None:
            pulumi.set(__self__, "bound_claims_type", bound_claims_type)
        if bound_subject is not None:
            pulumi.set(__self__, "bound_subject", bound_subject)
        if claim_mappings is not None:
            pulumi.set(__self__, "claim_mappings", claim_mappings)
        if clock_skew_leeway is not None:
            pulumi.set(__self__, "clock_skew_leeway", clock_skew_leeway)
        if disable_bound_claims_parsing is not None:
            pulumi.set(__self__, "disable_bound_claims_parsing", disable_bound_claims_parsing)
        if expiration_leeway is not None:
            pulumi.set(__self__, "expiration_leeway", expiration_leeway)
        if groups_claim is not None:
            pulumi.set(__self__, "groups_claim", groups_claim)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if not_before_leeway is not None:
            pulumi.set(__self__, "not_before_leeway", not_before_leeway)
        if oidc_scopes is not None:
            pulumi.set(__self__, "oidc_scopes", oidc_scopes)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if role_type is not None:
            pulumi.set(__self__, "role_type", role_type)
        if token_bound_cidrs is not None:
            pulumi.set(__self__, "token_bound_cidrs", token_bound_cidrs)
        if token_explicit_max_ttl is not None:
            pulumi.set(__self__, "token_explicit_max_ttl", token_explicit_max_ttl)
        if token_max_ttl is not None:
            pulumi.set(__self__, "token_max_ttl", token_max_ttl)
        if token_no_default_policy is not None:
            pulumi.set(__self__, "token_no_default_policy", token_no_default_policy)
        if token_num_uses is not None:
            pulumi.set(__self__, "token_num_uses", token_num_uses)
        if token_period is not None:
            pulumi.set(__self__, "token_period", token_period)
        if token_policies is not None:
            pulumi.set(__self__, "token_policies", token_policies)
        if token_ttl is not None:
            pulumi.set(__self__, "token_ttl", token_ttl)
        if token_type is not None:
            pulumi.set(__self__, "token_type", token_type)
        if user_claim is not None:
            pulumi.set(__self__, "user_claim", user_claim)
        if user_claim_json_pointer is not None:
            pulumi.set(__self__, "user_claim_json_pointer", user_claim_json_pointer)
        if verbose_oidc_logging is not None:
            pulumi.set(__self__, "verbose_oidc_logging", verbose_oidc_logging)

    @_builtins.property
    @pulumi.getter(name="allowedRedirectUris")
    def allowed_redirect_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of allowed values for redirect_uri during OIDC logins.
        Required for OIDC roles
        """
        return pulumi.get(self, "allowed_redirect_uris")

    @allowed_redirect_uris.setter
    def allowed_redirect_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_redirect_uris", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the auth backend to configure.
        Defaults to `jwt`.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="boundAudiences")
    def bound_audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Required for roles of type `jwt`, optional for roles of
        type `oidc`) List of `aud` claims to match against. Any match is sufficient.
        """
        return pulumi.get(self, "bound_audiences")

    @bound_audiences.setter
    def bound_audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bound_audiences", value)

    @_builtins.property
    @pulumi.getter(name="boundClaims")
    def bound_claims(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        If set, a map of claims to values to match against.
        A claim's value must be a string, which may contain one value or multiple
        comma-separated values, e.g. `"red"` or `"red,green,blue"`.
        """
        return pulumi.get(self, "bound_claims")

    @bound_claims.setter
    def bound_claims(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bound_claims", value)

    @_builtins.property
    @pulumi.getter(name="boundClaimsType")
    def bound_claims_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How to interpret values in the claims/values
        map (`bound_claims`): can be either `string` (exact match) or `glob` (wildcard
        match). Requires Vault 1.4.0 or above.
        """
        return pulumi.get(self, "bound_claims_type")

    @bound_claims_type.setter
    def bound_claims_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bound_claims_type", value)

    @_builtins.property
    @pulumi.getter(name="boundSubject")
    def bound_subject(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If set, requires that the `sub` claim matches
        this value.
        """
        return pulumi.get(self, "bound_subject")

    @bound_subject.setter
    def bound_subject(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bound_subject", value)

    @_builtins.property
    @pulumi.getter(name="claimMappings")
    def claim_mappings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        If set, a map of claims (keys) to be copied
        to specified metadata fields (values).
        """
        return pulumi.get(self, "claim_mappings")

    @claim_mappings.setter
    def claim_mappings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "claim_mappings", value)

    @_builtins.property
    @pulumi.getter(name="clockSkewLeeway")
    def clock_skew_leeway(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of leeway to add to all claims to account for clock skew, in
        seconds. Defaults to `60` seconds if set to `0` and can be disabled if set to `-1`.
        Only applicable with "jwt" roles.
        """
        return pulumi.get(self, "clock_skew_leeway")

    @clock_skew_leeway.setter
    def clock_skew_leeway(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "clock_skew_leeway", value)

    @_builtins.property
    @pulumi.getter(name="disableBoundClaimsParsing")
    def disable_bound_claims_parsing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disable bound claim value parsing. Useful when values contain commas.
        """
        return pulumi.get(self, "disable_bound_claims_parsing")

    @disable_bound_claims_parsing.setter
    def disable_bound_claims_parsing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_bound_claims_parsing", value)

    @_builtins.property
    @pulumi.getter(name="expirationLeeway")
    def expiration_leeway(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of leeway to add to expiration (`exp`) claims to account for
        clock skew, in seconds. Defaults to `150` seconds if set to `0` and can be disabled if set to `-1`.
        Only applicable with "jwt" roles.
        """
        return pulumi.get(self, "expiration_leeway")

    @expiration_leeway.setter
    def expiration_leeway(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expiration_leeway", value)

    @_builtins.property
    @pulumi.getter(name="groupsClaim")
    def groups_claim(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The claim to use to uniquely identify
        the set of groups to which the user belongs; this will be used as the names
        for the Identity group aliases created due to a successful login. The claim
        value must be a list of strings.
        """
        return pulumi.get(self, "groups_claim")

    @groups_claim.setter
    def groups_claim(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "groups_claim", value)

    @_builtins.property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the allowable elapsed time in seconds since the last time 
        the user was actively authenticated with the OIDC provider.
        """
        return pulumi.get(self, "max_age")

    @max_age.setter
    def max_age(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_age", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="notBeforeLeeway")
    def not_before_leeway(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of leeway to add to not before (`nbf`) claims to account for
        clock skew, in seconds. Defaults to `150` seconds if set to `0` and can be disabled if set to `-1`.
        Only applicable with "jwt" roles.
        """
        return pulumi.get(self, "not_before_leeway")

    @not_before_leeway.setter
    def not_before_leeway(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "not_before_leeway", value)

    @_builtins.property
    @pulumi.getter(name="oidcScopes")
    def oidc_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        If set, a list of OIDC scopes to be used with an OIDC role.
        The standard scope "openid" is automatically included and need not be specified.
        """
        return pulumi.get(self, "oidc_scopes")

    @oidc_scopes.setter
    def oidc_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "oidc_scopes", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the role.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter(name="roleType")
    def role_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of role, either "oidc" (default) or "jwt".
        """
        return pulumi.get(self, "role_type")

    @role_type.setter
    def role_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_type", value)

    @_builtins.property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the blocks of IP addresses which are allowed to use the generated token
        """
        return pulumi.get(self, "token_bound_cidrs")

    @token_bound_cidrs.setter
    def token_bound_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_bound_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generated Token's Explicit Maximum TTL in seconds
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @token_explicit_max_ttl.setter
    def token_explicit_max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_explicit_max_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum lifetime of the generated token
        """
        return pulumi.get(self, "token_max_ttl")

    @token_max_ttl.setter
    def token_max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_max_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the 'default' policy will not automatically be added to generated tokens
        """
        return pulumi.get(self, "token_no_default_policy")

    @token_no_default_policy.setter
    def token_no_default_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "token_no_default_policy", value)

    @_builtins.property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of times a token may be used, a value of zero means unlimited
        """
        return pulumi.get(self, "token_num_uses")

    @token_num_uses.setter
    def token_num_uses(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_num_uses", value)

    @_builtins.property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generated Token's Period
        """
        return pulumi.get(self, "token_period")

    @token_period.setter
    def token_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_period", value)

    @_builtins.property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Generated Token's Policies
        """
        return pulumi.get(self, "token_policies")

    @token_policies.setter
    def token_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_policies", value)

    @_builtins.property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @token_ttl.setter
    def token_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of token to generate, service or batch
        """
        return pulumi.get(self, "token_type")

    @token_type.setter
    def token_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_type", value)

    @_builtins.property
    @pulumi.getter(name="userClaim")
    def user_claim(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The claim to use to uniquely identify
        the user; this will be used as the name for the Identity entity alias created
        due to a successful login.
        """
        return pulumi.get(self, "user_claim")

    @user_claim.setter
    def user_claim(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_claim", value)

    @_builtins.property
    @pulumi.getter(name="userClaimJsonPointer")
    def user_claim_json_pointer(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the `user_claim` value uses
        [JSON pointer](https://www.vaultproject.io/docs/auth/jwt#claim-specifications-and-json-pointer)
        syntax for referencing claims. By default, the `user_claim` value will not use JSON pointer.
        Requires Vault 1.11+.
        """
        return pulumi.get(self, "user_claim_json_pointer")

    @user_claim_json_pointer.setter
    def user_claim_json_pointer(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "user_claim_json_pointer", value)

    @_builtins.property
    @pulumi.getter(name="verboseOidcLogging")
    def verbose_oidc_logging(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Log received OIDC tokens and claims when debug-level
        logging is active. Not recommended in production since sensitive information may be present
        in OIDC responses.
        """
        return pulumi.get(self, "verbose_oidc_logging")

    @verbose_oidc_logging.setter
    def verbose_oidc_logging(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "verbose_oidc_logging", value)


@pulumi.type_token("vault:jwt/authBackendRole:AuthBackendRole")
class AuthBackendRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 bound_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_claims: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 bound_claims_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bound_subject: Optional[pulumi.Input[_builtins.str]] = None,
                 claim_mappings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 clock_skew_leeway: Optional[pulumi.Input[_builtins.int]] = None,
                 disable_bound_claims_parsing: Optional[pulumi.Input[_builtins.bool]] = None,
                 expiration_leeway: Optional[pulumi.Input[_builtins.int]] = None,
                 groups_claim: Optional[pulumi.Input[_builtins.str]] = None,
                 max_age: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 not_before_leeway: Optional[pulumi.Input[_builtins.int]] = None,
                 oidc_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_type: Optional[pulumi.Input[_builtins.str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 token_period: Optional[pulumi.Input[_builtins.int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_claim: Optional[pulumi.Input[_builtins.str]] = None,
                 user_claim_json_pointer: Optional[pulumi.Input[_builtins.bool]] = None,
                 verbose_oidc_logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages an JWT/OIDC auth backend role in a Vault server. See the [Vault
        documentation](https://www.vaultproject.io/docs/auth/jwt.html) for more
        information.

        ## Example Usage

        Role for JWT backend:

        ```python
        import pulumi
        import pulumi_vault as vault

        jwt = vault.jwt.AuthBackend("jwt", path="jwt")
        example = vault.jwt.AuthBackendRole("example",
            backend=jwt.path,
            role_name="test-role",
            token_policies=[
                "default",
                "dev",
                "prod",
            ],
            bound_audiences=["https://myco.test"],
            bound_claims={
                "color": "red,green,blue",
            },
            user_claim="https://vault/user",
            role_type="jwt")
        ```

        Role for OIDC backend:

        ```python
        import pulumi
        import pulumi_vault as vault

        oidc = vault.jwt.AuthBackend("oidc",
            path="oidc",
            default_role="test-role")
        example = vault.jwt.AuthBackendRole("example",
            backend=oidc.path,
            role_name="test-role",
            token_policies=[
                "default",
                "dev",
                "prod",
            ],
            user_claim="https://vault/user",
            role_type="oidc",
            allowed_redirect_uris=["http://localhost:8200/ui/vault/auth/oidc/oidc/callback"])
        ```

        ## Import

        JWT authentication backend roles can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:jwt/authBackendRole:AuthBackendRole example auth/jwt/role/test-role
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_redirect_uris: The list of allowed values for redirect_uri during OIDC logins.
               Required for OIDC roles
        :param pulumi.Input[_builtins.str] backend: The unique name of the auth backend to configure.
               Defaults to `jwt`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bound_audiences: (Required for roles of type `jwt`, optional for roles of
               type `oidc`) List of `aud` claims to match against. Any match is sufficient.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] bound_claims: If set, a map of claims to values to match against.
               A claim's value must be a string, which may contain one value or multiple
               comma-separated values, e.g. `"red"` or `"red,green,blue"`.
        :param pulumi.Input[_builtins.str] bound_claims_type: How to interpret values in the claims/values
               map (`bound_claims`): can be either `string` (exact match) or `glob` (wildcard
               match). Requires Vault 1.4.0 or above.
        :param pulumi.Input[_builtins.str] bound_subject: If set, requires that the `sub` claim matches
               this value.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] claim_mappings: If set, a map of claims (keys) to be copied
               to specified metadata fields (values).
        :param pulumi.Input[_builtins.int] clock_skew_leeway: The amount of leeway to add to all claims to account for clock skew, in
               seconds. Defaults to `60` seconds if set to `0` and can be disabled if set to `-1`.
               Only applicable with "jwt" roles.
        :param pulumi.Input[_builtins.bool] disable_bound_claims_parsing: Disable bound claim value parsing. Useful when values contain commas.
        :param pulumi.Input[_builtins.int] expiration_leeway: The amount of leeway to add to expiration (`exp`) claims to account for
               clock skew, in seconds. Defaults to `150` seconds if set to `0` and can be disabled if set to `-1`.
               Only applicable with "jwt" roles.
        :param pulumi.Input[_builtins.str] groups_claim: The claim to use to uniquely identify
               the set of groups to which the user belongs; this will be used as the names
               for the Identity group aliases created due to a successful login. The claim
               value must be a list of strings.
        :param pulumi.Input[_builtins.int] max_age: Specifies the allowable elapsed time in seconds since the last time 
               the user was actively authenticated with the OIDC provider.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] not_before_leeway: The amount of leeway to add to not before (`nbf`) claims to account for
               clock skew, in seconds. Defaults to `150` seconds if set to `0` and can be disabled if set to `-1`.
               Only applicable with "jwt" roles.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] oidc_scopes: If set, a list of OIDC scopes to be used with an OIDC role.
               The standard scope "openid" is automatically included and need not be specified.
        :param pulumi.Input[_builtins.str] role_name: The name of the role.
        :param pulumi.Input[_builtins.str] role_type: Type of role, either "oidc" (default) or "jwt".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[_builtins.int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[_builtins.int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[_builtins.bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[_builtins.int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[_builtins.int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[_builtins.int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[_builtins.str] token_type: The type of token to generate, service or batch
        :param pulumi.Input[_builtins.str] user_claim: The claim to use to uniquely identify
               the user; this will be used as the name for the Identity entity alias created
               due to a successful login.
        :param pulumi.Input[_builtins.bool] user_claim_json_pointer: Specifies if the `user_claim` value uses
               [JSON pointer](https://www.vaultproject.io/docs/auth/jwt#claim-specifications-and-json-pointer)
               syntax for referencing claims. By default, the `user_claim` value will not use JSON pointer.
               Requires Vault 1.11+.
        :param pulumi.Input[_builtins.bool] verbose_oidc_logging: Log received OIDC tokens and claims when debug-level
               logging is active. Not recommended in production since sensitive information may be present
               in OIDC responses.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthBackendRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an JWT/OIDC auth backend role in a Vault server. See the [Vault
        documentation](https://www.vaultproject.io/docs/auth/jwt.html) for more
        information.

        ## Example Usage

        Role for JWT backend:

        ```python
        import pulumi
        import pulumi_vault as vault

        jwt = vault.jwt.AuthBackend("jwt", path="jwt")
        example = vault.jwt.AuthBackendRole("example",
            backend=jwt.path,
            role_name="test-role",
            token_policies=[
                "default",
                "dev",
                "prod",
            ],
            bound_audiences=["https://myco.test"],
            bound_claims={
                "color": "red,green,blue",
            },
            user_claim="https://vault/user",
            role_type="jwt")
        ```

        Role for OIDC backend:

        ```python
        import pulumi
        import pulumi_vault as vault

        oidc = vault.jwt.AuthBackend("oidc",
            path="oidc",
            default_role="test-role")
        example = vault.jwt.AuthBackendRole("example",
            backend=oidc.path,
            role_name="test-role",
            token_policies=[
                "default",
                "dev",
                "prod",
            ],
            user_claim="https://vault/user",
            role_type="oidc",
            allowed_redirect_uris=["http://localhost:8200/ui/vault/auth/oidc/oidc/callback"])
        ```

        ## Import

        JWT authentication backend roles can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:jwt/authBackendRole:AuthBackendRole example auth/jwt/role/test-role
        ```

        :param str resource_name: The name of the resource.
        :param AuthBackendRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthBackendRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 bound_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_claims: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 bound_claims_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bound_subject: Optional[pulumi.Input[_builtins.str]] = None,
                 claim_mappings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 clock_skew_leeway: Optional[pulumi.Input[_builtins.int]] = None,
                 disable_bound_claims_parsing: Optional[pulumi.Input[_builtins.bool]] = None,
                 expiration_leeway: Optional[pulumi.Input[_builtins.int]] = None,
                 groups_claim: Optional[pulumi.Input[_builtins.str]] = None,
                 max_age: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 not_before_leeway: Optional[pulumi.Input[_builtins.int]] = None,
                 oidc_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_type: Optional[pulumi.Input[_builtins.str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 token_period: Optional[pulumi.Input[_builtins.int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_claim: Optional[pulumi.Input[_builtins.str]] = None,
                 user_claim_json_pointer: Optional[pulumi.Input[_builtins.bool]] = None,
                 verbose_oidc_logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthBackendRoleArgs.__new__(AuthBackendRoleArgs)

            __props__.__dict__["allowed_redirect_uris"] = allowed_redirect_uris
            __props__.__dict__["backend"] = backend
            __props__.__dict__["bound_audiences"] = bound_audiences
            __props__.__dict__["bound_claims"] = bound_claims
            __props__.__dict__["bound_claims_type"] = bound_claims_type
            __props__.__dict__["bound_subject"] = bound_subject
            __props__.__dict__["claim_mappings"] = claim_mappings
            __props__.__dict__["clock_skew_leeway"] = clock_skew_leeway
            __props__.__dict__["disable_bound_claims_parsing"] = disable_bound_claims_parsing
            __props__.__dict__["expiration_leeway"] = expiration_leeway
            __props__.__dict__["groups_claim"] = groups_claim
            __props__.__dict__["max_age"] = max_age
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["not_before_leeway"] = not_before_leeway
            __props__.__dict__["oidc_scopes"] = oidc_scopes
            if role_name is None and not opts.urn:
                raise TypeError("Missing required property 'role_name'")
            __props__.__dict__["role_name"] = role_name
            __props__.__dict__["role_type"] = role_type
            __props__.__dict__["token_bound_cidrs"] = token_bound_cidrs
            __props__.__dict__["token_explicit_max_ttl"] = token_explicit_max_ttl
            __props__.__dict__["token_max_ttl"] = token_max_ttl
            __props__.__dict__["token_no_default_policy"] = token_no_default_policy
            __props__.__dict__["token_num_uses"] = token_num_uses
            __props__.__dict__["token_period"] = token_period
            __props__.__dict__["token_policies"] = token_policies
            __props__.__dict__["token_ttl"] = token_ttl
            __props__.__dict__["token_type"] = token_type
            if user_claim is None and not opts.urn:
                raise TypeError("Missing required property 'user_claim'")
            __props__.__dict__["user_claim"] = user_claim
            __props__.__dict__["user_claim_json_pointer"] = user_claim_json_pointer
            __props__.__dict__["verbose_oidc_logging"] = verbose_oidc_logging
        super(AuthBackendRole, __self__).__init__(
            'vault:jwt/authBackendRole:AuthBackendRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            bound_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            bound_claims: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            bound_claims_type: Optional[pulumi.Input[_builtins.str]] = None,
            bound_subject: Optional[pulumi.Input[_builtins.str]] = None,
            claim_mappings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            clock_skew_leeway: Optional[pulumi.Input[_builtins.int]] = None,
            disable_bound_claims_parsing: Optional[pulumi.Input[_builtins.bool]] = None,
            expiration_leeway: Optional[pulumi.Input[_builtins.int]] = None,
            groups_claim: Optional[pulumi.Input[_builtins.str]] = None,
            max_age: Optional[pulumi.Input[_builtins.int]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            not_before_leeway: Optional[pulumi.Input[_builtins.int]] = None,
            oidc_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            role_name: Optional[pulumi.Input[_builtins.str]] = None,
            role_type: Optional[pulumi.Input[_builtins.str]] = None,
            token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
            token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
            token_period: Optional[pulumi.Input[_builtins.int]] = None,
            token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            token_type: Optional[pulumi.Input[_builtins.str]] = None,
            user_claim: Optional[pulumi.Input[_builtins.str]] = None,
            user_claim_json_pointer: Optional[pulumi.Input[_builtins.bool]] = None,
            verbose_oidc_logging: Optional[pulumi.Input[_builtins.bool]] = None) -> 'AuthBackendRole':
        """
        Get an existing AuthBackendRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_redirect_uris: The list of allowed values for redirect_uri during OIDC logins.
               Required for OIDC roles
        :param pulumi.Input[_builtins.str] backend: The unique name of the auth backend to configure.
               Defaults to `jwt`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bound_audiences: (Required for roles of type `jwt`, optional for roles of
               type `oidc`) List of `aud` claims to match against. Any match is sufficient.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] bound_claims: If set, a map of claims to values to match against.
               A claim's value must be a string, which may contain one value or multiple
               comma-separated values, e.g. `"red"` or `"red,green,blue"`.
        :param pulumi.Input[_builtins.str] bound_claims_type: How to interpret values in the claims/values
               map (`bound_claims`): can be either `string` (exact match) or `glob` (wildcard
               match). Requires Vault 1.4.0 or above.
        :param pulumi.Input[_builtins.str] bound_subject: If set, requires that the `sub` claim matches
               this value.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] claim_mappings: If set, a map of claims (keys) to be copied
               to specified metadata fields (values).
        :param pulumi.Input[_builtins.int] clock_skew_leeway: The amount of leeway to add to all claims to account for clock skew, in
               seconds. Defaults to `60` seconds if set to `0` and can be disabled if set to `-1`.
               Only applicable with "jwt" roles.
        :param pulumi.Input[_builtins.bool] disable_bound_claims_parsing: Disable bound claim value parsing. Useful when values contain commas.
        :param pulumi.Input[_builtins.int] expiration_leeway: The amount of leeway to add to expiration (`exp`) claims to account for
               clock skew, in seconds. Defaults to `150` seconds if set to `0` and can be disabled if set to `-1`.
               Only applicable with "jwt" roles.
        :param pulumi.Input[_builtins.str] groups_claim: The claim to use to uniquely identify
               the set of groups to which the user belongs; this will be used as the names
               for the Identity group aliases created due to a successful login. The claim
               value must be a list of strings.
        :param pulumi.Input[_builtins.int] max_age: Specifies the allowable elapsed time in seconds since the last time 
               the user was actively authenticated with the OIDC provider.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] not_before_leeway: The amount of leeway to add to not before (`nbf`) claims to account for
               clock skew, in seconds. Defaults to `150` seconds if set to `0` and can be disabled if set to `-1`.
               Only applicable with "jwt" roles.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] oidc_scopes: If set, a list of OIDC scopes to be used with an OIDC role.
               The standard scope "openid" is automatically included and need not be specified.
        :param pulumi.Input[_builtins.str] role_name: The name of the role.
        :param pulumi.Input[_builtins.str] role_type: Type of role, either "oidc" (default) or "jwt".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[_builtins.int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[_builtins.int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[_builtins.bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[_builtins.int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[_builtins.int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[_builtins.int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[_builtins.str] token_type: The type of token to generate, service or batch
        :param pulumi.Input[_builtins.str] user_claim: The claim to use to uniquely identify
               the user; this will be used as the name for the Identity entity alias created
               due to a successful login.
        :param pulumi.Input[_builtins.bool] user_claim_json_pointer: Specifies if the `user_claim` value uses
               [JSON pointer](https://www.vaultproject.io/docs/auth/jwt#claim-specifications-and-json-pointer)
               syntax for referencing claims. By default, the `user_claim` value will not use JSON pointer.
               Requires Vault 1.11+.
        :param pulumi.Input[_builtins.bool] verbose_oidc_logging: Log received OIDC tokens and claims when debug-level
               logging is active. Not recommended in production since sensitive information may be present
               in OIDC responses.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthBackendRoleState.__new__(_AuthBackendRoleState)

        __props__.__dict__["allowed_redirect_uris"] = allowed_redirect_uris
        __props__.__dict__["backend"] = backend
        __props__.__dict__["bound_audiences"] = bound_audiences
        __props__.__dict__["bound_claims"] = bound_claims
        __props__.__dict__["bound_claims_type"] = bound_claims_type
        __props__.__dict__["bound_subject"] = bound_subject
        __props__.__dict__["claim_mappings"] = claim_mappings
        __props__.__dict__["clock_skew_leeway"] = clock_skew_leeway
        __props__.__dict__["disable_bound_claims_parsing"] = disable_bound_claims_parsing
        __props__.__dict__["expiration_leeway"] = expiration_leeway
        __props__.__dict__["groups_claim"] = groups_claim
        __props__.__dict__["max_age"] = max_age
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["not_before_leeway"] = not_before_leeway
        __props__.__dict__["oidc_scopes"] = oidc_scopes
        __props__.__dict__["role_name"] = role_name
        __props__.__dict__["role_type"] = role_type
        __props__.__dict__["token_bound_cidrs"] = token_bound_cidrs
        __props__.__dict__["token_explicit_max_ttl"] = token_explicit_max_ttl
        __props__.__dict__["token_max_ttl"] = token_max_ttl
        __props__.__dict__["token_no_default_policy"] = token_no_default_policy
        __props__.__dict__["token_num_uses"] = token_num_uses
        __props__.__dict__["token_period"] = token_period
        __props__.__dict__["token_policies"] = token_policies
        __props__.__dict__["token_ttl"] = token_ttl
        __props__.__dict__["token_type"] = token_type
        __props__.__dict__["user_claim"] = user_claim
        __props__.__dict__["user_claim_json_pointer"] = user_claim_json_pointer
        __props__.__dict__["verbose_oidc_logging"] = verbose_oidc_logging
        return AuthBackendRole(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowedRedirectUris")
    def allowed_redirect_uris(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of allowed values for redirect_uri during OIDC logins.
        Required for OIDC roles
        """
        return pulumi.get(self, "allowed_redirect_uris")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unique name of the auth backend to configure.
        Defaults to `jwt`.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="boundAudiences")
    def bound_audiences(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        (Required for roles of type `jwt`, optional for roles of
        type `oidc`) List of `aud` claims to match against. Any match is sufficient.
        """
        return pulumi.get(self, "bound_audiences")

    @_builtins.property
    @pulumi.getter(name="boundClaims")
    def bound_claims(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        If set, a map of claims to values to match against.
        A claim's value must be a string, which may contain one value or multiple
        comma-separated values, e.g. `"red"` or `"red,green,blue"`.
        """
        return pulumi.get(self, "bound_claims")

    @_builtins.property
    @pulumi.getter(name="boundClaimsType")
    def bound_claims_type(self) -> pulumi.Output[_builtins.str]:
        """
        How to interpret values in the claims/values
        map (`bound_claims`): can be either `string` (exact match) or `glob` (wildcard
        match). Requires Vault 1.4.0 or above.
        """
        return pulumi.get(self, "bound_claims_type")

    @_builtins.property
    @pulumi.getter(name="boundSubject")
    def bound_subject(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If set, requires that the `sub` claim matches
        this value.
        """
        return pulumi.get(self, "bound_subject")

    @_builtins.property
    @pulumi.getter(name="claimMappings")
    def claim_mappings(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        If set, a map of claims (keys) to be copied
        to specified metadata fields (values).
        """
        return pulumi.get(self, "claim_mappings")

    @_builtins.property
    @pulumi.getter(name="clockSkewLeeway")
    def clock_skew_leeway(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of leeway to add to all claims to account for clock skew, in
        seconds. Defaults to `60` seconds if set to `0` and can be disabled if set to `-1`.
        Only applicable with "jwt" roles.
        """
        return pulumi.get(self, "clock_skew_leeway")

    @_builtins.property
    @pulumi.getter(name="disableBoundClaimsParsing")
    def disable_bound_claims_parsing(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Disable bound claim value parsing. Useful when values contain commas.
        """
        return pulumi.get(self, "disable_bound_claims_parsing")

    @_builtins.property
    @pulumi.getter(name="expirationLeeway")
    def expiration_leeway(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of leeway to add to expiration (`exp`) claims to account for
        clock skew, in seconds. Defaults to `150` seconds if set to `0` and can be disabled if set to `-1`.
        Only applicable with "jwt" roles.
        """
        return pulumi.get(self, "expiration_leeway")

    @_builtins.property
    @pulumi.getter(name="groupsClaim")
    def groups_claim(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The claim to use to uniquely identify
        the set of groups to which the user belongs; this will be used as the names
        for the Identity group aliases created due to a successful login. The claim
        value must be a list of strings.
        """
        return pulumi.get(self, "groups_claim")

    @_builtins.property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the allowable elapsed time in seconds since the last time 
        the user was actively authenticated with the OIDC provider.
        """
        return pulumi.get(self, "max_age")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="notBeforeLeeway")
    def not_before_leeway(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of leeway to add to not before (`nbf`) claims to account for
        clock skew, in seconds. Defaults to `150` seconds if set to `0` and can be disabled if set to `-1`.
        Only applicable with "jwt" roles.
        """
        return pulumi.get(self, "not_before_leeway")

    @_builtins.property
    @pulumi.getter(name="oidcScopes")
    def oidc_scopes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        If set, a list of OIDC scopes to be used with an OIDC role.
        The standard scope "openid" is automatically included and need not be specified.
        """
        return pulumi.get(self, "oidc_scopes")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the role.
        """
        return pulumi.get(self, "role_name")

    @_builtins.property
    @pulumi.getter(name="roleType")
    def role_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of role, either "oidc" (default) or "jwt".
        """
        return pulumi.get(self, "role_type")

    @_builtins.property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the blocks of IP addresses which are allowed to use the generated token
        """
        return pulumi.get(self, "token_bound_cidrs")

    @_builtins.property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Generated Token's Explicit Maximum TTL in seconds
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @_builtins.property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum lifetime of the generated token
        """
        return pulumi.get(self, "token_max_ttl")

    @_builtins.property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, the 'default' policy will not automatically be added to generated tokens
        """
        return pulumi.get(self, "token_no_default_policy")

    @_builtins.property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum number of times a token may be used, a value of zero means unlimited
        """
        return pulumi.get(self, "token_num_uses")

    @_builtins.property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Generated Token's Period
        """
        return pulumi.get(self, "token_period")

    @_builtins.property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Generated Token's Policies
        """
        return pulumi.get(self, "token_policies")

    @_builtins.property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @_builtins.property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of token to generate, service or batch
        """
        return pulumi.get(self, "token_type")

    @_builtins.property
    @pulumi.getter(name="userClaim")
    def user_claim(self) -> pulumi.Output[_builtins.str]:
        """
        The claim to use to uniquely identify
        the user; this will be used as the name for the Identity entity alias created
        due to a successful login.
        """
        return pulumi.get(self, "user_claim")

    @_builtins.property
    @pulumi.getter(name="userClaimJsonPointer")
    def user_claim_json_pointer(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if the `user_claim` value uses
        [JSON pointer](https://www.vaultproject.io/docs/auth/jwt#claim-specifications-and-json-pointer)
        syntax for referencing claims. By default, the `user_claim` value will not use JSON pointer.
        Requires Vault 1.11+.
        """
        return pulumi.get(self, "user_claim_json_pointer")

    @_builtins.property
    @pulumi.getter(name="verboseOidcLogging")
    def verbose_oidc_logging(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Log received OIDC tokens and claims when debug-level
        logging is active. Not recommended in production since sensitive information may be present
        in OIDC responses.
        """
        return pulumi.get(self, "verbose_oidc_logging")

