# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretBackendArgs', 'SecretBackend']

@pulumi.input_type
class SecretBackendArgs:
    def __init__(__self__, *,
                 binddn: pulumi.Input[_builtins.str],
                 bindpass: pulumi.Input[_builtins.str],
                 allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 client_tls_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_tls_key: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 delegated_auth_accessors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_entropy_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure_tls: Optional[pulumi.Input[_builtins.bool]] = None,
                 listing_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 passthrough_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 password_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_version: Optional[pulumi.Input[_builtins.str]] = None,
                 request_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 seal_wrap: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_static_role_import_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 starttls: Optional[pulumi.Input[_builtins.bool]] = None,
                 upndomain: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 userattr: Optional[pulumi.Input[_builtins.str]] = None,
                 userdn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SecretBackend resource.
        :param pulumi.Input[_builtins.str] binddn: Distinguished name of object to bind when performing user and group search.
        :param pulumi.Input[_builtins.str] bindpass: Password to use along with binddn when performing user search.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_managed_keys: List of managed key registry entry names that the mount in question is allowed to access
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_response_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_request_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_response_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        :param pulumi.Input[_builtins.str] certificate: CA certificate to use when verifying LDAP server certificate, must be
               x509 PEM encoded.
        :param pulumi.Input[_builtins.str] client_tls_cert: Client certificate to provide to the LDAP server, must be x509 PEM encoded.
        :param pulumi.Input[_builtins.str] client_tls_key: Client certificate key to provide to the LDAP server, must be x509 PEM encoded.
        :param pulumi.Input[_builtins.int] connection_timeout: Timeout, in seconds, when attempting to connect to the LDAP server before trying
               the next URL in the configuration.
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: Default lease duration for secrets in seconds.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegated_auth_accessors: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] description: Human-friendly description of the mount for the Active Directory backend.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
        :param pulumi.Input[_builtins.bool] external_entropy_access: Enable the secrets engine to access Vault's external entropy source
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin workload identity tokens
        :param pulumi.Input[_builtins.bool] insecure_tls: Skip LDAP server SSL Certificate verification. This is not recommended for production.
               Defaults to `false`.
        :param pulumi.Input[_builtins.str] listing_visibility: Specifies whether to show this mount in the UI-specific listing endpoint
        :param pulumi.Input[_builtins.bool] local: Mark the secrets engine as local-only. Local engines are not replicated or removed by
               replication.Tolerance duration to use when checking the last rotation time.
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: Maximum possible lease duration for secrets in seconds.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: Specifies mount type specific options that are passed to the backend
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] passthrough_request_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] password_policy: Name of the password policy to use to generate passwords.
        :param pulumi.Input[_builtins.str] path: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `ldap`.
        :param pulumi.Input[_builtins.str] plugin_version: Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        :param pulumi.Input[_builtins.int] request_timeout: Timeout, in seconds, for the connection when making requests against the server
               before returning back an error.
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] schema: The LDAP schema to use when storing entry passwords. Valid schemas include `openldap`, `ad`, and `racf`. Default is `openldap`.
        :param pulumi.Input[_builtins.bool] seal_wrap: Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        :param pulumi.Input[_builtins.bool] skip_static_role_import_rotation: If set to true, static roles will not be rotated during import.
               Defaults to false. Requires Vault 1.16 or above.
        :param pulumi.Input[_builtins.bool] starttls: Issue a StartTLS command after establishing unencrypted connection.
        :param pulumi.Input[_builtins.str] upndomain: Enables userPrincipalDomain login with [username]@UPNDomain.
        :param pulumi.Input[_builtins.str] url: LDAP URL to connect to. Multiple URLs can be specified by concatenating
               them with commas; they will be tried in-order. Defaults to `ldap://127.0.0.1`.
        :param pulumi.Input[_builtins.str] userattr: Attribute used when searching users. Defaults to `cn`.
        :param pulumi.Input[_builtins.str] userdn: LDAP domain to use for users (eg: ou=People,dc=example,dc=org)`.
        """
        pulumi.set(__self__, "binddn", binddn)
        pulumi.set(__self__, "bindpass", bindpass)
        if allowed_managed_keys is not None:
            pulumi.set(__self__, "allowed_managed_keys", allowed_managed_keys)
        if allowed_response_headers is not None:
            pulumi.set(__self__, "allowed_response_headers", allowed_response_headers)
        if audit_non_hmac_request_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_request_keys", audit_non_hmac_request_keys)
        if audit_non_hmac_response_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_response_keys", audit_non_hmac_response_keys)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if client_tls_cert is not None:
            pulumi.set(__self__, "client_tls_cert", client_tls_cert)
        if client_tls_key is not None:
            pulumi.set(__self__, "client_tls_key", client_tls_key)
        if connection_timeout is not None:
            pulumi.set(__self__, "connection_timeout", connection_timeout)
        if default_lease_ttl_seconds is not None:
            pulumi.set(__self__, "default_lease_ttl_seconds", default_lease_ttl_seconds)
        if delegated_auth_accessors is not None:
            pulumi.set(__self__, "delegated_auth_accessors", delegated_auth_accessors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if disable_remount is not None:
            pulumi.set(__self__, "disable_remount", disable_remount)
        if external_entropy_access is not None:
            pulumi.set(__self__, "external_entropy_access", external_entropy_access)
        if identity_token_key is not None:
            pulumi.set(__self__, "identity_token_key", identity_token_key)
        if insecure_tls is not None:
            pulumi.set(__self__, "insecure_tls", insecure_tls)
        if listing_visibility is not None:
            pulumi.set(__self__, "listing_visibility", listing_visibility)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if max_lease_ttl_seconds is not None:
            pulumi.set(__self__, "max_lease_ttl_seconds", max_lease_ttl_seconds)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if passthrough_request_headers is not None:
            pulumi.set(__self__, "passthrough_request_headers", passthrough_request_headers)
        if password_policy is not None:
            pulumi.set(__self__, "password_policy", password_policy)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if plugin_version is not None:
            pulumi.set(__self__, "plugin_version", plugin_version)
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if seal_wrap is not None:
            pulumi.set(__self__, "seal_wrap", seal_wrap)
        if skip_static_role_import_rotation is not None:
            pulumi.set(__self__, "skip_static_role_import_rotation", skip_static_role_import_rotation)
        if starttls is not None:
            pulumi.set(__self__, "starttls", starttls)
        if upndomain is not None:
            pulumi.set(__self__, "upndomain", upndomain)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if userattr is not None:
            pulumi.set(__self__, "userattr", userattr)
        if userdn is not None:
            pulumi.set(__self__, "userdn", userdn)

    @_builtins.property
    @pulumi.getter
    def binddn(self) -> pulumi.Input[_builtins.str]:
        """
        Distinguished name of object to bind when performing user and group search.
        """
        return pulumi.get(self, "binddn")

    @binddn.setter
    def binddn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "binddn", value)

    @_builtins.property
    @pulumi.getter
    def bindpass(self) -> pulumi.Input[_builtins.str]:
        """
        Password to use along with binddn when performing user search.
        """
        return pulumi.get(self, "bindpass")

    @bindpass.setter
    def bindpass(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bindpass", value)

    @_builtins.property
    @pulumi.getter(name="allowedManagedKeys")
    def allowed_managed_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of managed key registry entry names that the mount in question is allowed to access
        """
        return pulumi.get(self, "allowed_managed_keys")

    @allowed_managed_keys.setter
    def allowed_managed_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_managed_keys", value)

    @_builtins.property
    @pulumi.getter(name="allowedResponseHeaders")
    def allowed_response_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "allowed_response_headers")

    @allowed_response_headers.setter
    def allowed_response_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_response_headers", value)

    @_builtins.property
    @pulumi.getter(name="auditNonHmacRequestKeys")
    def audit_non_hmac_request_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        """
        return pulumi.get(self, "audit_non_hmac_request_keys")

    @audit_non_hmac_request_keys.setter
    def audit_non_hmac_request_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audit_non_hmac_request_keys", value)

    @_builtins.property
    @pulumi.getter(name="auditNonHmacResponseKeys")
    def audit_non_hmac_response_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        """
        return pulumi.get(self, "audit_non_hmac_response_keys")

    @audit_non_hmac_response_keys.setter
    def audit_non_hmac_response_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audit_non_hmac_response_keys", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CA certificate to use when verifying LDAP server certificate, must be
        x509 PEM encoded.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="clientTlsCert")
    def client_tls_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client certificate to provide to the LDAP server, must be x509 PEM encoded.
        """
        return pulumi.get(self, "client_tls_cert")

    @client_tls_cert.setter
    def client_tls_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_tls_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientTlsKey")
    def client_tls_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client certificate key to provide to the LDAP server, must be x509 PEM encoded.
        """
        return pulumi.get(self, "client_tls_key")

    @client_tls_key.setter
    def client_tls_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_tls_key", value)

    @_builtins.property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout, in seconds, when attempting to connect to the LDAP server before trying
        the next URL in the configuration.
        """
        return pulumi.get(self, "connection_timeout")

    @connection_timeout.setter
    def connection_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_timeout", value)

    @_builtins.property
    @pulumi.getter(name="defaultLeaseTtlSeconds")
    def default_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default lease duration for secrets in seconds.
        """
        return pulumi.get(self, "default_lease_ttl_seconds")

    @default_lease_ttl_seconds.setter
    def default_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter(name="delegatedAuthAccessors")
    def delegated_auth_accessors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "delegated_auth_accessors")

    @delegated_auth_accessors.setter
    def delegated_auth_accessors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "delegated_auth_accessors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-friendly description of the mount for the Active Directory backend.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "disable_automated_rotation")

    @disable_automated_rotation.setter
    def disable_automated_rotation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_automated_rotation", value)

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        """
        return pulumi.get(self, "disable_remount")

    @disable_remount.setter
    def disable_remount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_remount", value)

    @_builtins.property
    @pulumi.getter(name="externalEntropyAccess")
    def external_entropy_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the secrets engine to access Vault's external entropy source
        """
        return pulumi.get(self, "external_entropy_access")

    @external_entropy_access.setter
    def external_entropy_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "external_entropy_access", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenKey")
    def identity_token_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key to use for signing plugin workload identity tokens
        """
        return pulumi.get(self, "identity_token_key")

    @identity_token_key.setter
    def identity_token_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_token_key", value)

    @_builtins.property
    @pulumi.getter(name="insecureTls")
    def insecure_tls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Skip LDAP server SSL Certificate verification. This is not recommended for production.
        Defaults to `false`.
        """
        return pulumi.get(self, "insecure_tls")

    @insecure_tls.setter
    def insecure_tls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "insecure_tls", value)

    @_builtins.property
    @pulumi.getter(name="listingVisibility")
    def listing_visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to show this mount in the UI-specific listing endpoint
        """
        return pulumi.get(self, "listing_visibility")

    @listing_visibility.setter
    def listing_visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listing_visibility", value)

    @_builtins.property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Mark the secrets engine as local-only. Local engines are not replicated or removed by
        replication.Tolerance duration to use when checking the last rotation time.
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local", value)

    @_builtins.property
    @pulumi.getter(name="maxLeaseTtlSeconds")
    def max_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum possible lease duration for secrets in seconds.
        """
        return pulumi.get(self, "max_lease_ttl_seconds")

    @max_lease_ttl_seconds.setter
    def max_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies mount type specific options that are passed to the backend
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="passthroughRequestHeaders")
    def passthrough_request_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "passthrough_request_headers")

    @passthrough_request_headers.setter
    def passthrough_request_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "passthrough_request_headers", value)

    @_builtins.property
    @pulumi.getter(name="passwordPolicy")
    def password_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the password policy to use to generate passwords.
        """
        return pulumi.get(self, "password_policy")

    @password_policy.setter
    def password_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_policy", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `ldap`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        """
        return pulumi.get(self, "plugin_version")

    @plugin_version.setter
    def plugin_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_version", value)

    @_builtins.property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout, in seconds, for the connection when making requests against the server
        before returning back an error.
        """
        return pulumi.get(self, "request_timeout")

    @request_timeout.setter
    def request_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "request_timeout", value)

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @rotation_period.setter
    def rotation_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_period", value)

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @rotation_schedule.setter
    def rotation_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotation_schedule", value)

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @rotation_window.setter
    def rotation_window(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_window", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The LDAP schema to use when storing entry passwords. Valid schemas include `openldap`, `ad`, and `racf`. Default is `openldap`.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="sealWrap")
    def seal_wrap(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        """
        return pulumi.get(self, "seal_wrap")

    @seal_wrap.setter
    def seal_wrap(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "seal_wrap", value)

    @_builtins.property
    @pulumi.getter(name="skipStaticRoleImportRotation")
    def skip_static_role_import_rotation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, static roles will not be rotated during import.
        Defaults to false. Requires Vault 1.16 or above.
        """
        return pulumi.get(self, "skip_static_role_import_rotation")

    @skip_static_role_import_rotation.setter
    def skip_static_role_import_rotation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_static_role_import_rotation", value)

    @_builtins.property
    @pulumi.getter
    def starttls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Issue a StartTLS command after establishing unencrypted connection.
        """
        return pulumi.get(self, "starttls")

    @starttls.setter
    def starttls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "starttls", value)

    @_builtins.property
    @pulumi.getter
    def upndomain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables userPrincipalDomain login with [username]@UPNDomain.
        """
        return pulumi.get(self, "upndomain")

    @upndomain.setter
    def upndomain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upndomain", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        LDAP URL to connect to. Multiple URLs can be specified by concatenating
        them with commas; they will be tried in-order. Defaults to `ldap://127.0.0.1`.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter
    def userattr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Attribute used when searching users. Defaults to `cn`.
        """
        return pulumi.get(self, "userattr")

    @userattr.setter
    def userattr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "userattr", value)

    @_builtins.property
    @pulumi.getter
    def userdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        LDAP domain to use for users (eg: ou=People,dc=example,dc=org)`.
        """
        return pulumi.get(self, "userdn")

    @userdn.setter
    def userdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "userdn", value)


@pulumi.input_type
class _SecretBackendState:
    def __init__(__self__, *,
                 accessor: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 binddn: Optional[pulumi.Input[_builtins.str]] = None,
                 bindpass: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 client_tls_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_tls_key: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 delegated_auth_accessors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_entropy_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure_tls: Optional[pulumi.Input[_builtins.bool]] = None,
                 listing_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 passthrough_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 password_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_version: Optional[pulumi.Input[_builtins.str]] = None,
                 request_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 seal_wrap: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_static_role_import_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 starttls: Optional[pulumi.Input[_builtins.bool]] = None,
                 upndomain: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 userattr: Optional[pulumi.Input[_builtins.str]] = None,
                 userdn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecretBackend resources.
        :param pulumi.Input[_builtins.str] accessor: Accessor of the mount
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_managed_keys: List of managed key registry entry names that the mount in question is allowed to access
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_response_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_request_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_response_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        :param pulumi.Input[_builtins.str] binddn: Distinguished name of object to bind when performing user and group search.
        :param pulumi.Input[_builtins.str] bindpass: Password to use along with binddn when performing user search.
        :param pulumi.Input[_builtins.str] certificate: CA certificate to use when verifying LDAP server certificate, must be
               x509 PEM encoded.
        :param pulumi.Input[_builtins.str] client_tls_cert: Client certificate to provide to the LDAP server, must be x509 PEM encoded.
        :param pulumi.Input[_builtins.str] client_tls_key: Client certificate key to provide to the LDAP server, must be x509 PEM encoded.
        :param pulumi.Input[_builtins.int] connection_timeout: Timeout, in seconds, when attempting to connect to the LDAP server before trying
               the next URL in the configuration.
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: Default lease duration for secrets in seconds.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegated_auth_accessors: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] description: Human-friendly description of the mount for the Active Directory backend.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
        :param pulumi.Input[_builtins.bool] external_entropy_access: Enable the secrets engine to access Vault's external entropy source
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin workload identity tokens
        :param pulumi.Input[_builtins.bool] insecure_tls: Skip LDAP server SSL Certificate verification. This is not recommended for production.
               Defaults to `false`.
        :param pulumi.Input[_builtins.str] listing_visibility: Specifies whether to show this mount in the UI-specific listing endpoint
        :param pulumi.Input[_builtins.bool] local: Mark the secrets engine as local-only. Local engines are not replicated or removed by
               replication.Tolerance duration to use when checking the last rotation time.
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: Maximum possible lease duration for secrets in seconds.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: Specifies mount type specific options that are passed to the backend
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] passthrough_request_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] password_policy: Name of the password policy to use to generate passwords.
        :param pulumi.Input[_builtins.str] path: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `ldap`.
        :param pulumi.Input[_builtins.str] plugin_version: Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        :param pulumi.Input[_builtins.int] request_timeout: Timeout, in seconds, for the connection when making requests against the server
               before returning back an error.
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] schema: The LDAP schema to use when storing entry passwords. Valid schemas include `openldap`, `ad`, and `racf`. Default is `openldap`.
        :param pulumi.Input[_builtins.bool] seal_wrap: Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        :param pulumi.Input[_builtins.bool] skip_static_role_import_rotation: If set to true, static roles will not be rotated during import.
               Defaults to false. Requires Vault 1.16 or above.
        :param pulumi.Input[_builtins.bool] starttls: Issue a StartTLS command after establishing unencrypted connection.
        :param pulumi.Input[_builtins.str] upndomain: Enables userPrincipalDomain login with [username]@UPNDomain.
        :param pulumi.Input[_builtins.str] url: LDAP URL to connect to. Multiple URLs can be specified by concatenating
               them with commas; they will be tried in-order. Defaults to `ldap://127.0.0.1`.
        :param pulumi.Input[_builtins.str] userattr: Attribute used when searching users. Defaults to `cn`.
        :param pulumi.Input[_builtins.str] userdn: LDAP domain to use for users (eg: ou=People,dc=example,dc=org)`.
        """
        if accessor is not None:
            pulumi.set(__self__, "accessor", accessor)
        if allowed_managed_keys is not None:
            pulumi.set(__self__, "allowed_managed_keys", allowed_managed_keys)
        if allowed_response_headers is not None:
            pulumi.set(__self__, "allowed_response_headers", allowed_response_headers)
        if audit_non_hmac_request_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_request_keys", audit_non_hmac_request_keys)
        if audit_non_hmac_response_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_response_keys", audit_non_hmac_response_keys)
        if binddn is not None:
            pulumi.set(__self__, "binddn", binddn)
        if bindpass is not None:
            pulumi.set(__self__, "bindpass", bindpass)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if client_tls_cert is not None:
            pulumi.set(__self__, "client_tls_cert", client_tls_cert)
        if client_tls_key is not None:
            pulumi.set(__self__, "client_tls_key", client_tls_key)
        if connection_timeout is not None:
            pulumi.set(__self__, "connection_timeout", connection_timeout)
        if default_lease_ttl_seconds is not None:
            pulumi.set(__self__, "default_lease_ttl_seconds", default_lease_ttl_seconds)
        if delegated_auth_accessors is not None:
            pulumi.set(__self__, "delegated_auth_accessors", delegated_auth_accessors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if disable_remount is not None:
            pulumi.set(__self__, "disable_remount", disable_remount)
        if external_entropy_access is not None:
            pulumi.set(__self__, "external_entropy_access", external_entropy_access)
        if identity_token_key is not None:
            pulumi.set(__self__, "identity_token_key", identity_token_key)
        if insecure_tls is not None:
            pulumi.set(__self__, "insecure_tls", insecure_tls)
        if listing_visibility is not None:
            pulumi.set(__self__, "listing_visibility", listing_visibility)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if max_lease_ttl_seconds is not None:
            pulumi.set(__self__, "max_lease_ttl_seconds", max_lease_ttl_seconds)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if passthrough_request_headers is not None:
            pulumi.set(__self__, "passthrough_request_headers", passthrough_request_headers)
        if password_policy is not None:
            pulumi.set(__self__, "password_policy", password_policy)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if plugin_version is not None:
            pulumi.set(__self__, "plugin_version", plugin_version)
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if seal_wrap is not None:
            pulumi.set(__self__, "seal_wrap", seal_wrap)
        if skip_static_role_import_rotation is not None:
            pulumi.set(__self__, "skip_static_role_import_rotation", skip_static_role_import_rotation)
        if starttls is not None:
            pulumi.set(__self__, "starttls", starttls)
        if upndomain is not None:
            pulumi.set(__self__, "upndomain", upndomain)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if userattr is not None:
            pulumi.set(__self__, "userattr", userattr)
        if userdn is not None:
            pulumi.set(__self__, "userdn", userdn)

    @_builtins.property
    @pulumi.getter
    def accessor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Accessor of the mount
        """
        return pulumi.get(self, "accessor")

    @accessor.setter
    def accessor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessor", value)

    @_builtins.property
    @pulumi.getter(name="allowedManagedKeys")
    def allowed_managed_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of managed key registry entry names that the mount in question is allowed to access
        """
        return pulumi.get(self, "allowed_managed_keys")

    @allowed_managed_keys.setter
    def allowed_managed_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_managed_keys", value)

    @_builtins.property
    @pulumi.getter(name="allowedResponseHeaders")
    def allowed_response_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "allowed_response_headers")

    @allowed_response_headers.setter
    def allowed_response_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_response_headers", value)

    @_builtins.property
    @pulumi.getter(name="auditNonHmacRequestKeys")
    def audit_non_hmac_request_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        """
        return pulumi.get(self, "audit_non_hmac_request_keys")

    @audit_non_hmac_request_keys.setter
    def audit_non_hmac_request_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audit_non_hmac_request_keys", value)

    @_builtins.property
    @pulumi.getter(name="auditNonHmacResponseKeys")
    def audit_non_hmac_response_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        """
        return pulumi.get(self, "audit_non_hmac_response_keys")

    @audit_non_hmac_response_keys.setter
    def audit_non_hmac_response_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audit_non_hmac_response_keys", value)

    @_builtins.property
    @pulumi.getter
    def binddn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Distinguished name of object to bind when performing user and group search.
        """
        return pulumi.get(self, "binddn")

    @binddn.setter
    def binddn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "binddn", value)

    @_builtins.property
    @pulumi.getter
    def bindpass(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password to use along with binddn when performing user search.
        """
        return pulumi.get(self, "bindpass")

    @bindpass.setter
    def bindpass(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bindpass", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CA certificate to use when verifying LDAP server certificate, must be
        x509 PEM encoded.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="clientTlsCert")
    def client_tls_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client certificate to provide to the LDAP server, must be x509 PEM encoded.
        """
        return pulumi.get(self, "client_tls_cert")

    @client_tls_cert.setter
    def client_tls_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_tls_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientTlsKey")
    def client_tls_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client certificate key to provide to the LDAP server, must be x509 PEM encoded.
        """
        return pulumi.get(self, "client_tls_key")

    @client_tls_key.setter
    def client_tls_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_tls_key", value)

    @_builtins.property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout, in seconds, when attempting to connect to the LDAP server before trying
        the next URL in the configuration.
        """
        return pulumi.get(self, "connection_timeout")

    @connection_timeout.setter
    def connection_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_timeout", value)

    @_builtins.property
    @pulumi.getter(name="defaultLeaseTtlSeconds")
    def default_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default lease duration for secrets in seconds.
        """
        return pulumi.get(self, "default_lease_ttl_seconds")

    @default_lease_ttl_seconds.setter
    def default_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter(name="delegatedAuthAccessors")
    def delegated_auth_accessors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "delegated_auth_accessors")

    @delegated_auth_accessors.setter
    def delegated_auth_accessors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "delegated_auth_accessors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-friendly description of the mount for the Active Directory backend.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "disable_automated_rotation")

    @disable_automated_rotation.setter
    def disable_automated_rotation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_automated_rotation", value)

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        """
        return pulumi.get(self, "disable_remount")

    @disable_remount.setter
    def disable_remount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_remount", value)

    @_builtins.property
    @pulumi.getter(name="externalEntropyAccess")
    def external_entropy_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the secrets engine to access Vault's external entropy source
        """
        return pulumi.get(self, "external_entropy_access")

    @external_entropy_access.setter
    def external_entropy_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "external_entropy_access", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenKey")
    def identity_token_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key to use for signing plugin workload identity tokens
        """
        return pulumi.get(self, "identity_token_key")

    @identity_token_key.setter
    def identity_token_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_token_key", value)

    @_builtins.property
    @pulumi.getter(name="insecureTls")
    def insecure_tls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Skip LDAP server SSL Certificate verification. This is not recommended for production.
        Defaults to `false`.
        """
        return pulumi.get(self, "insecure_tls")

    @insecure_tls.setter
    def insecure_tls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "insecure_tls", value)

    @_builtins.property
    @pulumi.getter(name="listingVisibility")
    def listing_visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to show this mount in the UI-specific listing endpoint
        """
        return pulumi.get(self, "listing_visibility")

    @listing_visibility.setter
    def listing_visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listing_visibility", value)

    @_builtins.property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Mark the secrets engine as local-only. Local engines are not replicated or removed by
        replication.Tolerance duration to use when checking the last rotation time.
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local", value)

    @_builtins.property
    @pulumi.getter(name="maxLeaseTtlSeconds")
    def max_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum possible lease duration for secrets in seconds.
        """
        return pulumi.get(self, "max_lease_ttl_seconds")

    @max_lease_ttl_seconds.setter
    def max_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies mount type specific options that are passed to the backend
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="passthroughRequestHeaders")
    def passthrough_request_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "passthrough_request_headers")

    @passthrough_request_headers.setter
    def passthrough_request_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "passthrough_request_headers", value)

    @_builtins.property
    @pulumi.getter(name="passwordPolicy")
    def password_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the password policy to use to generate passwords.
        """
        return pulumi.get(self, "password_policy")

    @password_policy.setter
    def password_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_policy", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `ldap`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        """
        return pulumi.get(self, "plugin_version")

    @plugin_version.setter
    def plugin_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_version", value)

    @_builtins.property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout, in seconds, for the connection when making requests against the server
        before returning back an error.
        """
        return pulumi.get(self, "request_timeout")

    @request_timeout.setter
    def request_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "request_timeout", value)

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @rotation_period.setter
    def rotation_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_period", value)

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @rotation_schedule.setter
    def rotation_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotation_schedule", value)

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @rotation_window.setter
    def rotation_window(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_window", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The LDAP schema to use when storing entry passwords. Valid schemas include `openldap`, `ad`, and `racf`. Default is `openldap`.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="sealWrap")
    def seal_wrap(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        """
        return pulumi.get(self, "seal_wrap")

    @seal_wrap.setter
    def seal_wrap(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "seal_wrap", value)

    @_builtins.property
    @pulumi.getter(name="skipStaticRoleImportRotation")
    def skip_static_role_import_rotation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, static roles will not be rotated during import.
        Defaults to false. Requires Vault 1.16 or above.
        """
        return pulumi.get(self, "skip_static_role_import_rotation")

    @skip_static_role_import_rotation.setter
    def skip_static_role_import_rotation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_static_role_import_rotation", value)

    @_builtins.property
    @pulumi.getter
    def starttls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Issue a StartTLS command after establishing unencrypted connection.
        """
        return pulumi.get(self, "starttls")

    @starttls.setter
    def starttls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "starttls", value)

    @_builtins.property
    @pulumi.getter
    def upndomain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables userPrincipalDomain login with [username]@UPNDomain.
        """
        return pulumi.get(self, "upndomain")

    @upndomain.setter
    def upndomain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upndomain", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        LDAP URL to connect to. Multiple URLs can be specified by concatenating
        them with commas; they will be tried in-order. Defaults to `ldap://127.0.0.1`.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter
    def userattr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Attribute used when searching users. Defaults to `cn`.
        """
        return pulumi.get(self, "userattr")

    @userattr.setter
    def userattr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "userattr", value)

    @_builtins.property
    @pulumi.getter
    def userdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        LDAP domain to use for users (eg: ou=People,dc=example,dc=org)`.
        """
        return pulumi.get(self, "userdn")

    @userdn.setter
    def userdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "userdn", value)


@pulumi.type_token("vault:ldap/secretBackend:SecretBackend")
class SecretBackend(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 binddn: Optional[pulumi.Input[_builtins.str]] = None,
                 bindpass: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 client_tls_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_tls_key: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 delegated_auth_accessors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_entropy_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure_tls: Optional[pulumi.Input[_builtins.bool]] = None,
                 listing_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 passthrough_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 password_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_version: Optional[pulumi.Input[_builtins.str]] = None,
                 request_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 seal_wrap: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_static_role_import_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 starttls: Optional[pulumi.Input[_builtins.bool]] = None,
                 upndomain: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 userattr: Optional[pulumi.Input[_builtins.str]] = None,
                 userdn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        config = vault.ldap.SecretBackend("config",
            path="my-custom-ldap",
            binddn="CN=Administrator,CN=Users,DC=corp,DC=example,DC=net",
            bindpass="SuperSecretPassw0rd",
            url="ldaps://localhost",
            insecure_tls=True,
            userdn="CN=Users,DC=corp,DC=example,DC=net",
            rotation_schedule="0 * * * SAT",
            rotation_window=3600)
        ```

        ## Import

        LDAP secret backend can be imported using the `${mount}/config`, e.g.

        ```sh
        $ pulumi import vault:ldap/secretBackend:SecretBackend config ldap/config
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_managed_keys: List of managed key registry entry names that the mount in question is allowed to access
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_response_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_request_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_response_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        :param pulumi.Input[_builtins.str] binddn: Distinguished name of object to bind when performing user and group search.
        :param pulumi.Input[_builtins.str] bindpass: Password to use along with binddn when performing user search.
        :param pulumi.Input[_builtins.str] certificate: CA certificate to use when verifying LDAP server certificate, must be
               x509 PEM encoded.
        :param pulumi.Input[_builtins.str] client_tls_cert: Client certificate to provide to the LDAP server, must be x509 PEM encoded.
        :param pulumi.Input[_builtins.str] client_tls_key: Client certificate key to provide to the LDAP server, must be x509 PEM encoded.
        :param pulumi.Input[_builtins.int] connection_timeout: Timeout, in seconds, when attempting to connect to the LDAP server before trying
               the next URL in the configuration.
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: Default lease duration for secrets in seconds.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegated_auth_accessors: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] description: Human-friendly description of the mount for the Active Directory backend.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
        :param pulumi.Input[_builtins.bool] external_entropy_access: Enable the secrets engine to access Vault's external entropy source
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin workload identity tokens
        :param pulumi.Input[_builtins.bool] insecure_tls: Skip LDAP server SSL Certificate verification. This is not recommended for production.
               Defaults to `false`.
        :param pulumi.Input[_builtins.str] listing_visibility: Specifies whether to show this mount in the UI-specific listing endpoint
        :param pulumi.Input[_builtins.bool] local: Mark the secrets engine as local-only. Local engines are not replicated or removed by
               replication.Tolerance duration to use when checking the last rotation time.
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: Maximum possible lease duration for secrets in seconds.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: Specifies mount type specific options that are passed to the backend
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] passthrough_request_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] password_policy: Name of the password policy to use to generate passwords.
        :param pulumi.Input[_builtins.str] path: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `ldap`.
        :param pulumi.Input[_builtins.str] plugin_version: Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        :param pulumi.Input[_builtins.int] request_timeout: Timeout, in seconds, for the connection when making requests against the server
               before returning back an error.
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] schema: The LDAP schema to use when storing entry passwords. Valid schemas include `openldap`, `ad`, and `racf`. Default is `openldap`.
        :param pulumi.Input[_builtins.bool] seal_wrap: Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        :param pulumi.Input[_builtins.bool] skip_static_role_import_rotation: If set to true, static roles will not be rotated during import.
               Defaults to false. Requires Vault 1.16 or above.
        :param pulumi.Input[_builtins.bool] starttls: Issue a StartTLS command after establishing unencrypted connection.
        :param pulumi.Input[_builtins.str] upndomain: Enables userPrincipalDomain login with [username]@UPNDomain.
        :param pulumi.Input[_builtins.str] url: LDAP URL to connect to. Multiple URLs can be specified by concatenating
               them with commas; they will be tried in-order. Defaults to `ldap://127.0.0.1`.
        :param pulumi.Input[_builtins.str] userattr: Attribute used when searching users. Defaults to `cn`.
        :param pulumi.Input[_builtins.str] userdn: LDAP domain to use for users (eg: ou=People,dc=example,dc=org)`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        config = vault.ldap.SecretBackend("config",
            path="my-custom-ldap",
            binddn="CN=Administrator,CN=Users,DC=corp,DC=example,DC=net",
            bindpass="SuperSecretPassw0rd",
            url="ldaps://localhost",
            insecure_tls=True,
            userdn="CN=Users,DC=corp,DC=example,DC=net",
            rotation_schedule="0 * * * SAT",
            rotation_window=3600)
        ```

        ## Import

        LDAP secret backend can be imported using the `${mount}/config`, e.g.

        ```sh
        $ pulumi import vault:ldap/secretBackend:SecretBackend config ldap/config
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 binddn: Optional[pulumi.Input[_builtins.str]] = None,
                 bindpass: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 client_tls_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_tls_key: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 delegated_auth_accessors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_entropy_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure_tls: Optional[pulumi.Input[_builtins.bool]] = None,
                 listing_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 passthrough_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 password_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_version: Optional[pulumi.Input[_builtins.str]] = None,
                 request_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 seal_wrap: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_static_role_import_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 starttls: Optional[pulumi.Input[_builtins.bool]] = None,
                 upndomain: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 userattr: Optional[pulumi.Input[_builtins.str]] = None,
                 userdn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendArgs.__new__(SecretBackendArgs)

            __props__.__dict__["allowed_managed_keys"] = allowed_managed_keys
            __props__.__dict__["allowed_response_headers"] = allowed_response_headers
            __props__.__dict__["audit_non_hmac_request_keys"] = audit_non_hmac_request_keys
            __props__.__dict__["audit_non_hmac_response_keys"] = audit_non_hmac_response_keys
            if binddn is None and not opts.urn:
                raise TypeError("Missing required property 'binddn'")
            __props__.__dict__["binddn"] = binddn
            if bindpass is None and not opts.urn:
                raise TypeError("Missing required property 'bindpass'")
            __props__.__dict__["bindpass"] = None if bindpass is None else pulumi.Output.secret(bindpass)
            __props__.__dict__["certificate"] = certificate
            __props__.__dict__["client_tls_cert"] = None if client_tls_cert is None else pulumi.Output.secret(client_tls_cert)
            __props__.__dict__["client_tls_key"] = None if client_tls_key is None else pulumi.Output.secret(client_tls_key)
            __props__.__dict__["connection_timeout"] = connection_timeout
            __props__.__dict__["default_lease_ttl_seconds"] = default_lease_ttl_seconds
            __props__.__dict__["delegated_auth_accessors"] = delegated_auth_accessors
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_automated_rotation"] = disable_automated_rotation
            __props__.__dict__["disable_remount"] = disable_remount
            __props__.__dict__["external_entropy_access"] = external_entropy_access
            __props__.__dict__["identity_token_key"] = identity_token_key
            __props__.__dict__["insecure_tls"] = insecure_tls
            __props__.__dict__["listing_visibility"] = listing_visibility
            __props__.__dict__["local"] = local
            __props__.__dict__["max_lease_ttl_seconds"] = max_lease_ttl_seconds
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["options"] = options
            __props__.__dict__["passthrough_request_headers"] = passthrough_request_headers
            __props__.__dict__["password_policy"] = password_policy
            __props__.__dict__["path"] = path
            __props__.__dict__["plugin_version"] = plugin_version
            __props__.__dict__["request_timeout"] = request_timeout
            __props__.__dict__["rotation_period"] = rotation_period
            __props__.__dict__["rotation_schedule"] = rotation_schedule
            __props__.__dict__["rotation_window"] = rotation_window
            __props__.__dict__["schema"] = schema
            __props__.__dict__["seal_wrap"] = seal_wrap
            __props__.__dict__["skip_static_role_import_rotation"] = skip_static_role_import_rotation
            __props__.__dict__["starttls"] = starttls
            __props__.__dict__["upndomain"] = upndomain
            __props__.__dict__["url"] = url
            __props__.__dict__["userattr"] = userattr
            __props__.__dict__["userdn"] = userdn
            __props__.__dict__["accessor"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["bindpass", "clientTlsCert", "clientTlsKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SecretBackend, __self__).__init__(
            'vault:ldap/secretBackend:SecretBackend',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessor: Optional[pulumi.Input[_builtins.str]] = None,
            allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allowed_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            binddn: Optional[pulumi.Input[_builtins.str]] = None,
            bindpass: Optional[pulumi.Input[_builtins.str]] = None,
            certificate: Optional[pulumi.Input[_builtins.str]] = None,
            client_tls_cert: Optional[pulumi.Input[_builtins.str]] = None,
            client_tls_key: Optional[pulumi.Input[_builtins.str]] = None,
            connection_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            delegated_auth_accessors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
            disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
            external_entropy_access: Optional[pulumi.Input[_builtins.bool]] = None,
            identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
            insecure_tls: Optional[pulumi.Input[_builtins.bool]] = None,
            listing_visibility: Optional[pulumi.Input[_builtins.str]] = None,
            local: Optional[pulumi.Input[_builtins.bool]] = None,
            max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            passthrough_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            password_policy: Optional[pulumi.Input[_builtins.str]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None,
            plugin_version: Optional[pulumi.Input[_builtins.str]] = None,
            request_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
            rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
            rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None,
            seal_wrap: Optional[pulumi.Input[_builtins.bool]] = None,
            skip_static_role_import_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
            starttls: Optional[pulumi.Input[_builtins.bool]] = None,
            upndomain: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            userattr: Optional[pulumi.Input[_builtins.str]] = None,
            userdn: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecretBackend':
        """
        Get an existing SecretBackend resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessor: Accessor of the mount
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_managed_keys: List of managed key registry entry names that the mount in question is allowed to access
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_response_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_request_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_response_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        :param pulumi.Input[_builtins.str] binddn: Distinguished name of object to bind when performing user and group search.
        :param pulumi.Input[_builtins.str] bindpass: Password to use along with binddn when performing user search.
        :param pulumi.Input[_builtins.str] certificate: CA certificate to use when verifying LDAP server certificate, must be
               x509 PEM encoded.
        :param pulumi.Input[_builtins.str] client_tls_cert: Client certificate to provide to the LDAP server, must be x509 PEM encoded.
        :param pulumi.Input[_builtins.str] client_tls_key: Client certificate key to provide to the LDAP server, must be x509 PEM encoded.
        :param pulumi.Input[_builtins.int] connection_timeout: Timeout, in seconds, when attempting to connect to the LDAP server before trying
               the next URL in the configuration.
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: Default lease duration for secrets in seconds.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegated_auth_accessors: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] description: Human-friendly description of the mount for the Active Directory backend.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
        :param pulumi.Input[_builtins.bool] external_entropy_access: Enable the secrets engine to access Vault's external entropy source
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin workload identity tokens
        :param pulumi.Input[_builtins.bool] insecure_tls: Skip LDAP server SSL Certificate verification. This is not recommended for production.
               Defaults to `false`.
        :param pulumi.Input[_builtins.str] listing_visibility: Specifies whether to show this mount in the UI-specific listing endpoint
        :param pulumi.Input[_builtins.bool] local: Mark the secrets engine as local-only. Local engines are not replicated or removed by
               replication.Tolerance duration to use when checking the last rotation time.
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: Maximum possible lease duration for secrets in seconds.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: Specifies mount type specific options that are passed to the backend
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] passthrough_request_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] password_policy: Name of the password policy to use to generate passwords.
        :param pulumi.Input[_builtins.str] path: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `ldap`.
        :param pulumi.Input[_builtins.str] plugin_version: Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        :param pulumi.Input[_builtins.int] request_timeout: Timeout, in seconds, for the connection when making requests against the server
               before returning back an error.
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] schema: The LDAP schema to use when storing entry passwords. Valid schemas include `openldap`, `ad`, and `racf`. Default is `openldap`.
        :param pulumi.Input[_builtins.bool] seal_wrap: Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        :param pulumi.Input[_builtins.bool] skip_static_role_import_rotation: If set to true, static roles will not be rotated during import.
               Defaults to false. Requires Vault 1.16 or above.
        :param pulumi.Input[_builtins.bool] starttls: Issue a StartTLS command after establishing unencrypted connection.
        :param pulumi.Input[_builtins.str] upndomain: Enables userPrincipalDomain login with [username]@UPNDomain.
        :param pulumi.Input[_builtins.str] url: LDAP URL to connect to. Multiple URLs can be specified by concatenating
               them with commas; they will be tried in-order. Defaults to `ldap://127.0.0.1`.
        :param pulumi.Input[_builtins.str] userattr: Attribute used when searching users. Defaults to `cn`.
        :param pulumi.Input[_builtins.str] userdn: LDAP domain to use for users (eg: ou=People,dc=example,dc=org)`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendState.__new__(_SecretBackendState)

        __props__.__dict__["accessor"] = accessor
        __props__.__dict__["allowed_managed_keys"] = allowed_managed_keys
        __props__.__dict__["allowed_response_headers"] = allowed_response_headers
        __props__.__dict__["audit_non_hmac_request_keys"] = audit_non_hmac_request_keys
        __props__.__dict__["audit_non_hmac_response_keys"] = audit_non_hmac_response_keys
        __props__.__dict__["binddn"] = binddn
        __props__.__dict__["bindpass"] = bindpass
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["client_tls_cert"] = client_tls_cert
        __props__.__dict__["client_tls_key"] = client_tls_key
        __props__.__dict__["connection_timeout"] = connection_timeout
        __props__.__dict__["default_lease_ttl_seconds"] = default_lease_ttl_seconds
        __props__.__dict__["delegated_auth_accessors"] = delegated_auth_accessors
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_automated_rotation"] = disable_automated_rotation
        __props__.__dict__["disable_remount"] = disable_remount
        __props__.__dict__["external_entropy_access"] = external_entropy_access
        __props__.__dict__["identity_token_key"] = identity_token_key
        __props__.__dict__["insecure_tls"] = insecure_tls
        __props__.__dict__["listing_visibility"] = listing_visibility
        __props__.__dict__["local"] = local
        __props__.__dict__["max_lease_ttl_seconds"] = max_lease_ttl_seconds
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["options"] = options
        __props__.__dict__["passthrough_request_headers"] = passthrough_request_headers
        __props__.__dict__["password_policy"] = password_policy
        __props__.__dict__["path"] = path
        __props__.__dict__["plugin_version"] = plugin_version
        __props__.__dict__["request_timeout"] = request_timeout
        __props__.__dict__["rotation_period"] = rotation_period
        __props__.__dict__["rotation_schedule"] = rotation_schedule
        __props__.__dict__["rotation_window"] = rotation_window
        __props__.__dict__["schema"] = schema
        __props__.__dict__["seal_wrap"] = seal_wrap
        __props__.__dict__["skip_static_role_import_rotation"] = skip_static_role_import_rotation
        __props__.__dict__["starttls"] = starttls
        __props__.__dict__["upndomain"] = upndomain
        __props__.__dict__["url"] = url
        __props__.__dict__["userattr"] = userattr
        __props__.__dict__["userdn"] = userdn
        return SecretBackend(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def accessor(self) -> pulumi.Output[_builtins.str]:
        """
        Accessor of the mount
        """
        return pulumi.get(self, "accessor")

    @_builtins.property
    @pulumi.getter(name="allowedManagedKeys")
    def allowed_managed_keys(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of managed key registry entry names that the mount in question is allowed to access
        """
        return pulumi.get(self, "allowed_managed_keys")

    @_builtins.property
    @pulumi.getter(name="allowedResponseHeaders")
    def allowed_response_headers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "allowed_response_headers")

    @_builtins.property
    @pulumi.getter(name="auditNonHmacRequestKeys")
    def audit_non_hmac_request_keys(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        """
        return pulumi.get(self, "audit_non_hmac_request_keys")

    @_builtins.property
    @pulumi.getter(name="auditNonHmacResponseKeys")
    def audit_non_hmac_response_keys(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        """
        return pulumi.get(self, "audit_non_hmac_response_keys")

    @_builtins.property
    @pulumi.getter
    def binddn(self) -> pulumi.Output[_builtins.str]:
        """
        Distinguished name of object to bind when performing user and group search.
        """
        return pulumi.get(self, "binddn")

    @_builtins.property
    @pulumi.getter
    def bindpass(self) -> pulumi.Output[_builtins.str]:
        """
        Password to use along with binddn when performing user search.
        """
        return pulumi.get(self, "bindpass")

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        CA certificate to use when verifying LDAP server certificate, must be
        x509 PEM encoded.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="clientTlsCert")
    def client_tls_cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Client certificate to provide to the LDAP server, must be x509 PEM encoded.
        """
        return pulumi.get(self, "client_tls_cert")

    @_builtins.property
    @pulumi.getter(name="clientTlsKey")
    def client_tls_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Client certificate key to provide to the LDAP server, must be x509 PEM encoded.
        """
        return pulumi.get(self, "client_tls_key")

    @_builtins.property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Timeout, in seconds, when attempting to connect to the LDAP server before trying
        the next URL in the configuration.
        """
        return pulumi.get(self, "connection_timeout")

    @_builtins.property
    @pulumi.getter(name="defaultLeaseTtlSeconds")
    def default_lease_ttl_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Default lease duration for secrets in seconds.
        """
        return pulumi.get(self, "default_lease_ttl_seconds")

    @_builtins.property
    @pulumi.getter(name="delegatedAuthAccessors")
    def delegated_auth_accessors(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "delegated_auth_accessors")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human-friendly description of the mount for the Active Directory backend.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        """
        return pulumi.get(self, "disable_remount")

    @_builtins.property
    @pulumi.getter(name="externalEntropyAccess")
    def external_entropy_access(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable the secrets engine to access Vault's external entropy source
        """
        return pulumi.get(self, "external_entropy_access")

    @_builtins.property
    @pulumi.getter(name="identityTokenKey")
    def identity_token_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The key to use for signing plugin workload identity tokens
        """
        return pulumi.get(self, "identity_token_key")

    @_builtins.property
    @pulumi.getter(name="insecureTls")
    def insecure_tls(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Skip LDAP server SSL Certificate verification. This is not recommended for production.
        Defaults to `false`.
        """
        return pulumi.get(self, "insecure_tls")

    @_builtins.property
    @pulumi.getter(name="listingVisibility")
    def listing_visibility(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether to show this mount in the UI-specific listing endpoint
        """
        return pulumi.get(self, "listing_visibility")

    @_builtins.property
    @pulumi.getter
    def local(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Mark the secrets engine as local-only. Local engines are not replicated or removed by
        replication.Tolerance duration to use when checking the last rotation time.
        """
        return pulumi.get(self, "local")

    @_builtins.property
    @pulumi.getter(name="maxLeaseTtlSeconds")
    def max_lease_ttl_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum possible lease duration for secrets in seconds.
        """
        return pulumi.get(self, "max_lease_ttl_seconds")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies mount type specific options that are passed to the backend
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="passthroughRequestHeaders")
    def passthrough_request_headers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "passthrough_request_headers")

    @_builtins.property
    @pulumi.getter(name="passwordPolicy")
    def password_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the password policy to use to generate passwords.
        """
        return pulumi.get(self, "password_policy")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `ldap`.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        """
        return pulumi.get(self, "plugin_version")

    @_builtins.property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        Timeout, in seconds, for the connection when making requests against the server
        before returning back an error.
        """
        return pulumi.get(self, "request_timeout")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[_builtins.str]:
        """
        The LDAP schema to use when storing entry passwords. Valid schemas include `openldap`, `ad`, and `racf`. Default is `openldap`.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="sealWrap")
    def seal_wrap(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        """
        return pulumi.get(self, "seal_wrap")

    @_builtins.property
    @pulumi.getter(name="skipStaticRoleImportRotation")
    def skip_static_role_import_rotation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to true, static roles will not be rotated during import.
        Defaults to false. Requires Vault 1.16 or above.
        """
        return pulumi.get(self, "skip_static_role_import_rotation")

    @_builtins.property
    @pulumi.getter
    def starttls(self) -> pulumi.Output[_builtins.bool]:
        """
        Issue a StartTLS command after establishing unencrypted connection.
        """
        return pulumi.get(self, "starttls")

    @_builtins.property
    @pulumi.getter
    def upndomain(self) -> pulumi.Output[_builtins.str]:
        """
        Enables userPrincipalDomain login with [username]@UPNDomain.
        """
        return pulumi.get(self, "upndomain")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        LDAP URL to connect to. Multiple URLs can be specified by concatenating
        them with commas; they will be tried in-order. Defaults to `ldap://127.0.0.1`.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def userattr(self) -> pulumi.Output[_builtins.str]:
        """
        Attribute used when searching users. Defaults to `cn`.
        """
        return pulumi.get(self, "userattr")

    @_builtins.property
    @pulumi.getter
    def userdn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        LDAP domain to use for users (eg: ou=People,dc=example,dc=org)`.
        """
        return pulumi.get(self, "userdn")

