# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NomadSecretBackendArgs', 'NomadSecretBackend']

@pulumi.input_type
class NomadSecretBackendArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 max_token_name_length: Optional[pulumi.Input[_builtins.int]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a NomadSecretBackend resource.
        :param pulumi.Input[_builtins.str] address: Specifies the address of the Nomad instance, provided
               as "protocol://host:port" like "http://127.0.0.1:4646".
        :param pulumi.Input[_builtins.str] backend: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `nomad`.
        :param pulumi.Input[_builtins.str] ca_cert: CA certificate to use when verifying the Nomad server certificate, must be
               x509 PEM encoded.
        :param pulumi.Input[_builtins.str] client_cert: Client certificate to provide to the Nomad server, must be x509 PEM encoded.
        :param pulumi.Input[_builtins.str] client_key: Client certificate key to provide to the Nomad server, must be x509 PEM encoded.
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: Default lease duration for secrets in seconds.
        :param pulumi.Input[_builtins.str] description: Human-friendly description of the mount for the Active Directory backend.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.bool] local: Mark the secrets engine as local-only. Local engines are not replicated or removed by
               replication.Tolerance duration to use when checking the last rotation time.
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: Maximum possible lease duration for secrets in seconds.
        :param pulumi.Input[_builtins.int] max_token_name_length: Specifies the maximum length to use for the name of the Nomad token
               generated with Generate Credential. If omitted, 0 is used and ignored, defaulting to the max value allowed
               by the Nomad version.
        :param pulumi.Input[_builtins.int] max_ttl: Maximum possible lease duration for secrets in seconds.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] token: Specifies the Nomad Management token to use.
        :param pulumi.Input[_builtins.int] ttl: Specifies the ttl of the lease for the generated token.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if ca_cert is not None:
            pulumi.set(__self__, "ca_cert", ca_cert)
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if default_lease_ttl_seconds is not None:
            pulumi.set(__self__, "default_lease_ttl_seconds", default_lease_ttl_seconds)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_remount is not None:
            pulumi.set(__self__, "disable_remount", disable_remount)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if max_lease_ttl_seconds is not None:
            pulumi.set(__self__, "max_lease_ttl_seconds", max_lease_ttl_seconds)
        if max_token_name_length is not None:
            pulumi.set(__self__, "max_token_name_length", max_token_name_length)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the address of the Nomad instance, provided
        as "protocol://host:port" like "http://127.0.0.1:4646".
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `nomad`.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CA certificate to use when verifying the Nomad server certificate, must be
        x509 PEM encoded.
        """
        return pulumi.get(self, "ca_cert")

    @ca_cert.setter
    def ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client certificate to provide to the Nomad server, must be x509 PEM encoded.
        """
        return pulumi.get(self, "client_cert")

    @client_cert.setter
    def client_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client certificate key to provide to the Nomad server, must be x509 PEM encoded.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_key", value)

    @_builtins.property
    @pulumi.getter(name="defaultLeaseTtlSeconds")
    def default_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default lease duration for secrets in seconds.
        """
        return pulumi.get(self, "default_lease_ttl_seconds")

    @default_lease_ttl_seconds.setter
    def default_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-friendly description of the mount for the Active Directory backend.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        """
        return pulumi.get(self, "disable_remount")

    @disable_remount.setter
    def disable_remount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_remount", value)

    @_builtins.property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Mark the secrets engine as local-only. Local engines are not replicated or removed by
        replication.Tolerance duration to use when checking the last rotation time.
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local", value)

    @_builtins.property
    @pulumi.getter(name="maxLeaseTtlSeconds")
    def max_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum possible lease duration for secrets in seconds.
        """
        return pulumi.get(self, "max_lease_ttl_seconds")

    @max_lease_ttl_seconds.setter
    def max_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter(name="maxTokenNameLength")
    def max_token_name_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum length to use for the name of the Nomad token
        generated with Generate Credential. If omitted, 0 is used and ignored, defaulting to the max value allowed
        by the Nomad version.
        """
        return pulumi.get(self, "max_token_name_length")

    @max_token_name_length.setter
    def max_token_name_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_token_name_length", value)

    @_builtins.property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum possible lease duration for secrets in seconds.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_ttl", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Nomad Management token to use.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the ttl of the lease for the generated token.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _NomadSecretBackendState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 max_token_name_length: Optional[pulumi.Input[_builtins.int]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering NomadSecretBackend resources.
        :param pulumi.Input[_builtins.str] address: Specifies the address of the Nomad instance, provided
               as "protocol://host:port" like "http://127.0.0.1:4646".
        :param pulumi.Input[_builtins.str] backend: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `nomad`.
        :param pulumi.Input[_builtins.str] ca_cert: CA certificate to use when verifying the Nomad server certificate, must be
               x509 PEM encoded.
        :param pulumi.Input[_builtins.str] client_cert: Client certificate to provide to the Nomad server, must be x509 PEM encoded.
        :param pulumi.Input[_builtins.str] client_key: Client certificate key to provide to the Nomad server, must be x509 PEM encoded.
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: Default lease duration for secrets in seconds.
        :param pulumi.Input[_builtins.str] description: Human-friendly description of the mount for the Active Directory backend.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.bool] local: Mark the secrets engine as local-only. Local engines are not replicated or removed by
               replication.Tolerance duration to use when checking the last rotation time.
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: Maximum possible lease duration for secrets in seconds.
        :param pulumi.Input[_builtins.int] max_token_name_length: Specifies the maximum length to use for the name of the Nomad token
               generated with Generate Credential. If omitted, 0 is used and ignored, defaulting to the max value allowed
               by the Nomad version.
        :param pulumi.Input[_builtins.int] max_ttl: Maximum possible lease duration for secrets in seconds.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] token: Specifies the Nomad Management token to use.
        :param pulumi.Input[_builtins.int] ttl: Specifies the ttl of the lease for the generated token.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if ca_cert is not None:
            pulumi.set(__self__, "ca_cert", ca_cert)
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if default_lease_ttl_seconds is not None:
            pulumi.set(__self__, "default_lease_ttl_seconds", default_lease_ttl_seconds)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_remount is not None:
            pulumi.set(__self__, "disable_remount", disable_remount)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if max_lease_ttl_seconds is not None:
            pulumi.set(__self__, "max_lease_ttl_seconds", max_lease_ttl_seconds)
        if max_token_name_length is not None:
            pulumi.set(__self__, "max_token_name_length", max_token_name_length)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the address of the Nomad instance, provided
        as "protocol://host:port" like "http://127.0.0.1:4646".
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `nomad`.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CA certificate to use when verifying the Nomad server certificate, must be
        x509 PEM encoded.
        """
        return pulumi.get(self, "ca_cert")

    @ca_cert.setter
    def ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client certificate to provide to the Nomad server, must be x509 PEM encoded.
        """
        return pulumi.get(self, "client_cert")

    @client_cert.setter
    def client_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client certificate key to provide to the Nomad server, must be x509 PEM encoded.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_key", value)

    @_builtins.property
    @pulumi.getter(name="defaultLeaseTtlSeconds")
    def default_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default lease duration for secrets in seconds.
        """
        return pulumi.get(self, "default_lease_ttl_seconds")

    @default_lease_ttl_seconds.setter
    def default_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-friendly description of the mount for the Active Directory backend.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        """
        return pulumi.get(self, "disable_remount")

    @disable_remount.setter
    def disable_remount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_remount", value)

    @_builtins.property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Mark the secrets engine as local-only. Local engines are not replicated or removed by
        replication.Tolerance duration to use when checking the last rotation time.
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local", value)

    @_builtins.property
    @pulumi.getter(name="maxLeaseTtlSeconds")
    def max_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum possible lease duration for secrets in seconds.
        """
        return pulumi.get(self, "max_lease_ttl_seconds")

    @max_lease_ttl_seconds.setter
    def max_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter(name="maxTokenNameLength")
    def max_token_name_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum length to use for the name of the Nomad token
        generated with Generate Credential. If omitted, 0 is used and ignored, defaulting to the max value allowed
        by the Nomad version.
        """
        return pulumi.get(self, "max_token_name_length")

    @max_token_name_length.setter
    def max_token_name_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_token_name_length", value)

    @_builtins.property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum possible lease duration for secrets in seconds.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_ttl", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Nomad Management token to use.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the ttl of the lease for the generated token.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)


@pulumi.type_token("vault:index/nomadSecretBackend:NomadSecretBackend")
class NomadSecretBackend(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 max_token_name_length: Optional[pulumi.Input[_builtins.int]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        config = vault.NomadSecretBackend("config",
            backend="nomad",
            description="test description",
            default_lease_ttl_seconds=3600,
            max_lease_ttl_seconds=7200,
            max_ttl=240,
            address="https://127.0.0.1:4646",
            token="ae20ceaa-...",
            ttl=120)
        ```

        ## Import

        Nomad secret backend can be imported using the `backend`, e.g.

        ```sh
        $ pulumi import vault:index/nomadSecretBackend:NomadSecretBackend nomad nomad
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: Specifies the address of the Nomad instance, provided
               as "protocol://host:port" like "http://127.0.0.1:4646".
        :param pulumi.Input[_builtins.str] backend: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `nomad`.
        :param pulumi.Input[_builtins.str] ca_cert: CA certificate to use when verifying the Nomad server certificate, must be
               x509 PEM encoded.
        :param pulumi.Input[_builtins.str] client_cert: Client certificate to provide to the Nomad server, must be x509 PEM encoded.
        :param pulumi.Input[_builtins.str] client_key: Client certificate key to provide to the Nomad server, must be x509 PEM encoded.
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: Default lease duration for secrets in seconds.
        :param pulumi.Input[_builtins.str] description: Human-friendly description of the mount for the Active Directory backend.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.bool] local: Mark the secrets engine as local-only. Local engines are not replicated or removed by
               replication.Tolerance duration to use when checking the last rotation time.
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: Maximum possible lease duration for secrets in seconds.
        :param pulumi.Input[_builtins.int] max_token_name_length: Specifies the maximum length to use for the name of the Nomad token
               generated with Generate Credential. If omitted, 0 is used and ignored, defaulting to the max value allowed
               by the Nomad version.
        :param pulumi.Input[_builtins.int] max_ttl: Maximum possible lease duration for secrets in seconds.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] token: Specifies the Nomad Management token to use.
        :param pulumi.Input[_builtins.int] ttl: Specifies the ttl of the lease for the generated token.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[NomadSecretBackendArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        config = vault.NomadSecretBackend("config",
            backend="nomad",
            description="test description",
            default_lease_ttl_seconds=3600,
            max_lease_ttl_seconds=7200,
            max_ttl=240,
            address="https://127.0.0.1:4646",
            token="ae20ceaa-...",
            ttl=120)
        ```

        ## Import

        Nomad secret backend can be imported using the `backend`, e.g.

        ```sh
        $ pulumi import vault:index/nomadSecretBackend:NomadSecretBackend nomad nomad
        ```

        :param str resource_name: The name of the resource.
        :param NomadSecretBackendArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NomadSecretBackendArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 max_token_name_length: Optional[pulumi.Input[_builtins.int]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NomadSecretBackendArgs.__new__(NomadSecretBackendArgs)

            __props__.__dict__["address"] = address
            __props__.__dict__["backend"] = backend
            __props__.__dict__["ca_cert"] = ca_cert
            __props__.__dict__["client_cert"] = None if client_cert is None else pulumi.Output.secret(client_cert)
            __props__.__dict__["client_key"] = None if client_key is None else pulumi.Output.secret(client_key)
            __props__.__dict__["default_lease_ttl_seconds"] = default_lease_ttl_seconds
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_remount"] = disable_remount
            __props__.__dict__["local"] = local
            __props__.__dict__["max_lease_ttl_seconds"] = max_lease_ttl_seconds
            __props__.__dict__["max_token_name_length"] = max_token_name_length
            __props__.__dict__["max_ttl"] = max_ttl
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["token"] = None if token is None else pulumi.Output.secret(token)
            __props__.__dict__["ttl"] = ttl
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientCert", "clientKey", "token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(NomadSecretBackend, __self__).__init__(
            'vault:index/nomadSecretBackend:NomadSecretBackend',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[_builtins.str]] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
            client_cert: Optional[pulumi.Input[_builtins.str]] = None,
            client_key: Optional[pulumi.Input[_builtins.str]] = None,
            default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
            local: Optional[pulumi.Input[_builtins.bool]] = None,
            max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            max_token_name_length: Optional[pulumi.Input[_builtins.int]] = None,
            max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            token: Optional[pulumi.Input[_builtins.str]] = None,
            ttl: Optional[pulumi.Input[_builtins.int]] = None) -> 'NomadSecretBackend':
        """
        Get an existing NomadSecretBackend resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: Specifies the address of the Nomad instance, provided
               as "protocol://host:port" like "http://127.0.0.1:4646".
        :param pulumi.Input[_builtins.str] backend: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `nomad`.
        :param pulumi.Input[_builtins.str] ca_cert: CA certificate to use when verifying the Nomad server certificate, must be
               x509 PEM encoded.
        :param pulumi.Input[_builtins.str] client_cert: Client certificate to provide to the Nomad server, must be x509 PEM encoded.
        :param pulumi.Input[_builtins.str] client_key: Client certificate key to provide to the Nomad server, must be x509 PEM encoded.
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: Default lease duration for secrets in seconds.
        :param pulumi.Input[_builtins.str] description: Human-friendly description of the mount for the Active Directory backend.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.bool] local: Mark the secrets engine as local-only. Local engines are not replicated or removed by
               replication.Tolerance duration to use when checking the last rotation time.
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: Maximum possible lease duration for secrets in seconds.
        :param pulumi.Input[_builtins.int] max_token_name_length: Specifies the maximum length to use for the name of the Nomad token
               generated with Generate Credential. If omitted, 0 is used and ignored, defaulting to the max value allowed
               by the Nomad version.
        :param pulumi.Input[_builtins.int] max_ttl: Maximum possible lease duration for secrets in seconds.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] token: Specifies the Nomad Management token to use.
        :param pulumi.Input[_builtins.int] ttl: Specifies the ttl of the lease for the generated token.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NomadSecretBackendState.__new__(_NomadSecretBackendState)

        __props__.__dict__["address"] = address
        __props__.__dict__["backend"] = backend
        __props__.__dict__["ca_cert"] = ca_cert
        __props__.__dict__["client_cert"] = client_cert
        __props__.__dict__["client_key"] = client_key
        __props__.__dict__["default_lease_ttl_seconds"] = default_lease_ttl_seconds
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_remount"] = disable_remount
        __props__.__dict__["local"] = local
        __props__.__dict__["max_lease_ttl_seconds"] = max_lease_ttl_seconds
        __props__.__dict__["max_token_name_length"] = max_token_name_length
        __props__.__dict__["max_ttl"] = max_ttl
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["token"] = token
        __props__.__dict__["ttl"] = ttl
        return NomadSecretBackend(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the address of the Nomad instance, provided
        as "protocol://host:port" like "http://127.0.0.1:4646".
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `nomad`.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        CA certificate to use when verifying the Nomad server certificate, must be
        x509 PEM encoded.
        """
        return pulumi.get(self, "ca_cert")

    @_builtins.property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Client certificate to provide to the Nomad server, must be x509 PEM encoded.
        """
        return pulumi.get(self, "client_cert")

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Client certificate key to provide to the Nomad server, must be x509 PEM encoded.
        """
        return pulumi.get(self, "client_key")

    @_builtins.property
    @pulumi.getter(name="defaultLeaseTtlSeconds")
    def default_lease_ttl_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Default lease duration for secrets in seconds.
        """
        return pulumi.get(self, "default_lease_ttl_seconds")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human-friendly description of the mount for the Active Directory backend.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        """
        return pulumi.get(self, "disable_remount")

    @_builtins.property
    @pulumi.getter
    def local(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Mark the secrets engine as local-only. Local engines are not replicated or removed by
        replication.Tolerance duration to use when checking the last rotation time.
        """
        return pulumi.get(self, "local")

    @_builtins.property
    @pulumi.getter(name="maxLeaseTtlSeconds")
    def max_lease_ttl_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum possible lease duration for secrets in seconds.
        """
        return pulumi.get(self, "max_lease_ttl_seconds")

    @_builtins.property
    @pulumi.getter(name="maxTokenNameLength")
    def max_token_name_length(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the maximum length to use for the name of the Nomad token
        generated with Generate Credential. If omitted, 0 is used and ignored, defaulting to the max value allowed
        by the Nomad version.
        """
        return pulumi.get(self, "max_token_name_length")

    @_builtins.property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum possible lease duration for secrets in seconds.
        """
        return pulumi.get(self, "max_ttl")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Nomad Management token to use.
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the ttl of the lease for the generated token.
        """
        return pulumi.get(self, "ttl")

