# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackendConfigEstArgs', 'BackendConfigEst']

@pulumi.input_type
class BackendConfigEstArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[_builtins.str],
                 audit_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authenticators: Optional[pulumi.Input['BackendConfigEstAuthenticatorsArgs']] = None,
                 default_mount: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_path_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_sentinel_parsing: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 label_to_path_policy: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BackendConfigEst resource.
        :param pulumi.Input[_builtins.str] backend: The path to the PKI secret backend to
               read the EST configuration from, with no leading or trailing `/`s.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_fields: Fields parsed from the CSR that appear in the audit and can be used by sentinel policies.
               
               <a id="nestedatt--authenticators"></a>
        :param pulumi.Input['BackendConfigEstAuthenticatorsArgs'] authenticators: Lists the mount accessors EST should delegate authentication requests towards (see below for nested schema).
        :param pulumi.Input[_builtins.bool] default_mount: If set, this mount will register the default `.well-known/est` URL path. Only a single mount can enable this across a Vault cluster.
        :param pulumi.Input[_builtins.str] default_path_policy: Required to be set if default_mount is enabled. Specifies the behavior for requests using the default EST label. Can be sign-verbatim or a role given by role:<role_name>.
        :param pulumi.Input[_builtins.bool] enable_sentinel_parsing: If set, parse out fields from the provided CSR making them available for Sentinel policies.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether EST is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] label_to_path_policy: Configures a pairing of an EST label with the redirected behavior for requests hitting that role. The path policy can be sign-verbatim or a role given by role:<role_name>. Labels must be unique across Vault cluster, and will register .well-known/est/<label> URL paths.
        :param pulumi.Input[_builtins.str] namespace: The namespace of the target resource.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        """
        pulumi.set(__self__, "backend", backend)
        if audit_fields is not None:
            pulumi.set(__self__, "audit_fields", audit_fields)
        if authenticators is not None:
            pulumi.set(__self__, "authenticators", authenticators)
        if default_mount is not None:
            pulumi.set(__self__, "default_mount", default_mount)
        if default_path_policy is not None:
            pulumi.set(__self__, "default_path_policy", default_path_policy)
        if enable_sentinel_parsing is not None:
            pulumi.set(__self__, "enable_sentinel_parsing", enable_sentinel_parsing)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if label_to_path_policy is not None:
            pulumi.set(__self__, "label_to_path_policy", label_to_path_policy)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Input[_builtins.str]:
        """
        The path to the PKI secret backend to
        read the EST configuration from, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="auditFields")
    def audit_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Fields parsed from the CSR that appear in the audit and can be used by sentinel policies.

        <a id="nestedatt--authenticators"></a>
        """
        return pulumi.get(self, "audit_fields")

    @audit_fields.setter
    def audit_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audit_fields", value)

    @_builtins.property
    @pulumi.getter
    def authenticators(self) -> Optional[pulumi.Input['BackendConfigEstAuthenticatorsArgs']]:
        """
        Lists the mount accessors EST should delegate authentication requests towards (see below for nested schema).
        """
        return pulumi.get(self, "authenticators")

    @authenticators.setter
    def authenticators(self, value: Optional[pulumi.Input['BackendConfigEstAuthenticatorsArgs']]):
        pulumi.set(self, "authenticators", value)

    @_builtins.property
    @pulumi.getter(name="defaultMount")
    def default_mount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, this mount will register the default `.well-known/est` URL path. Only a single mount can enable this across a Vault cluster.
        """
        return pulumi.get(self, "default_mount")

    @default_mount.setter
    def default_mount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default_mount", value)

    @_builtins.property
    @pulumi.getter(name="defaultPathPolicy")
    def default_path_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required to be set if default_mount is enabled. Specifies the behavior for requests using the default EST label. Can be sign-verbatim or a role given by role:<role_name>.
        """
        return pulumi.get(self, "default_path_policy")

    @default_path_policy.setter
    def default_path_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_path_policy", value)

    @_builtins.property
    @pulumi.getter(name="enableSentinelParsing")
    def enable_sentinel_parsing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, parse out fields from the provided CSR making them available for Sentinel policies.
        """
        return pulumi.get(self, "enable_sentinel_parsing")

    @enable_sentinel_parsing.setter
    def enable_sentinel_parsing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_sentinel_parsing", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether EST is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="labelToPathPolicy")
    def label_to_path_policy(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Configures a pairing of an EST label with the redirected behavior for requests hitting that role. The path policy can be sign-verbatim or a role given by role:<role_name>. Labels must be unique across Vault cluster, and will register .well-known/est/<label> URL paths.
        """
        return pulumi.get(self, "label_to_path_policy")

    @label_to_path_policy.setter
    def label_to_path_policy(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "label_to_path_policy", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace of the target resource.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class _BackendConfigEstState:
    def __init__(__self__, *,
                 audit_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authenticators: Optional[pulumi.Input['BackendConfigEstAuthenticatorsArgs']] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 default_mount: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_path_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_sentinel_parsing: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 label_to_path_policy: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 last_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BackendConfigEst resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_fields: Fields parsed from the CSR that appear in the audit and can be used by sentinel policies.
               
               <a id="nestedatt--authenticators"></a>
        :param pulumi.Input['BackendConfigEstAuthenticatorsArgs'] authenticators: Lists the mount accessors EST should delegate authentication requests towards (see below for nested schema).
        :param pulumi.Input[_builtins.str] backend: The path to the PKI secret backend to
               read the EST configuration from, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.bool] default_mount: If set, this mount will register the default `.well-known/est` URL path. Only a single mount can enable this across a Vault cluster.
        :param pulumi.Input[_builtins.str] default_path_policy: Required to be set if default_mount is enabled. Specifies the behavior for requests using the default EST label. Can be sign-verbatim or a role given by role:<role_name>.
        :param pulumi.Input[_builtins.bool] enable_sentinel_parsing: If set, parse out fields from the provided CSR making them available for Sentinel policies.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether EST is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] label_to_path_policy: Configures a pairing of an EST label with the redirected behavior for requests hitting that role. The path policy can be sign-verbatim or a role given by role:<role_name>. Labels must be unique across Vault cluster, and will register .well-known/est/<label> URL paths.
        :param pulumi.Input[_builtins.str] last_updated: A read-only timestamp representing the last time the configuration was updated.
        :param pulumi.Input[_builtins.str] namespace: The namespace of the target resource.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        """
        if audit_fields is not None:
            pulumi.set(__self__, "audit_fields", audit_fields)
        if authenticators is not None:
            pulumi.set(__self__, "authenticators", authenticators)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if default_mount is not None:
            pulumi.set(__self__, "default_mount", default_mount)
        if default_path_policy is not None:
            pulumi.set(__self__, "default_path_policy", default_path_policy)
        if enable_sentinel_parsing is not None:
            pulumi.set(__self__, "enable_sentinel_parsing", enable_sentinel_parsing)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if label_to_path_policy is not None:
            pulumi.set(__self__, "label_to_path_policy", label_to_path_policy)
        if last_updated is not None:
            pulumi.set(__self__, "last_updated", last_updated)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter(name="auditFields")
    def audit_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Fields parsed from the CSR that appear in the audit and can be used by sentinel policies.

        <a id="nestedatt--authenticators"></a>
        """
        return pulumi.get(self, "audit_fields")

    @audit_fields.setter
    def audit_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audit_fields", value)

    @_builtins.property
    @pulumi.getter
    def authenticators(self) -> Optional[pulumi.Input['BackendConfigEstAuthenticatorsArgs']]:
        """
        Lists the mount accessors EST should delegate authentication requests towards (see below for nested schema).
        """
        return pulumi.get(self, "authenticators")

    @authenticators.setter
    def authenticators(self, value: Optional[pulumi.Input['BackendConfigEstAuthenticatorsArgs']]):
        pulumi.set(self, "authenticators", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the PKI secret backend to
        read the EST configuration from, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="defaultMount")
    def default_mount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, this mount will register the default `.well-known/est` URL path. Only a single mount can enable this across a Vault cluster.
        """
        return pulumi.get(self, "default_mount")

    @default_mount.setter
    def default_mount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default_mount", value)

    @_builtins.property
    @pulumi.getter(name="defaultPathPolicy")
    def default_path_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required to be set if default_mount is enabled. Specifies the behavior for requests using the default EST label. Can be sign-verbatim or a role given by role:<role_name>.
        """
        return pulumi.get(self, "default_path_policy")

    @default_path_policy.setter
    def default_path_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_path_policy", value)

    @_builtins.property
    @pulumi.getter(name="enableSentinelParsing")
    def enable_sentinel_parsing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, parse out fields from the provided CSR making them available for Sentinel policies.
        """
        return pulumi.get(self, "enable_sentinel_parsing")

    @enable_sentinel_parsing.setter
    def enable_sentinel_parsing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_sentinel_parsing", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether EST is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="labelToPathPolicy")
    def label_to_path_policy(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Configures a pairing of an EST label with the redirected behavior for requests hitting that role. The path policy can be sign-verbatim or a role given by role:<role_name>. Labels must be unique across Vault cluster, and will register .well-known/est/<label> URL paths.
        """
        return pulumi.get(self, "label_to_path_policy")

    @label_to_path_policy.setter
    def label_to_path_policy(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "label_to_path_policy", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A read-only timestamp representing the last time the configuration was updated.
        """
        return pulumi.get(self, "last_updated")

    @last_updated.setter
    def last_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace of the target resource.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)


@pulumi.type_token("vault:pkiSecret/backendConfigEst:BackendConfigEst")
class BackendConfigEst(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authenticators: Optional[pulumi.Input[Union['BackendConfigEstAuthenticatorsArgs', 'BackendConfigEstAuthenticatorsArgsDict']]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 default_mount: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_path_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_sentinel_parsing: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 label_to_path_policy: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Allows setting the EST configuration on a PKI Secret Backend

        ## Import

        The PKI config cluster can be imported using the resource's `id`.
        In the case of the example above the `id` would be `pki-root/config/est`,
        where the `pki-root` component is the resource's `backend`, e.g.

        ```sh
        $ pulumi import vault:pkiSecret/backendConfigEst:BackendConfigEst example pki-root/config/est
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_fields: Fields parsed from the CSR that appear in the audit and can be used by sentinel policies.
               
               <a id="nestedatt--authenticators"></a>
        :param pulumi.Input[Union['BackendConfigEstAuthenticatorsArgs', 'BackendConfigEstAuthenticatorsArgsDict']] authenticators: Lists the mount accessors EST should delegate authentication requests towards (see below for nested schema).
        :param pulumi.Input[_builtins.str] backend: The path to the PKI secret backend to
               read the EST configuration from, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.bool] default_mount: If set, this mount will register the default `.well-known/est` URL path. Only a single mount can enable this across a Vault cluster.
        :param pulumi.Input[_builtins.str] default_path_policy: Required to be set if default_mount is enabled. Specifies the behavior for requests using the default EST label. Can be sign-verbatim or a role given by role:<role_name>.
        :param pulumi.Input[_builtins.bool] enable_sentinel_parsing: If set, parse out fields from the provided CSR making them available for Sentinel policies.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether EST is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] label_to_path_policy: Configures a pairing of an EST label with the redirected behavior for requests hitting that role. The path policy can be sign-verbatim or a role given by role:<role_name>. Labels must be unique across Vault cluster, and will register .well-known/est/<label> URL paths.
        :param pulumi.Input[_builtins.str] namespace: The namespace of the target resource.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackendConfigEstArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows setting the EST configuration on a PKI Secret Backend

        ## Import

        The PKI config cluster can be imported using the resource's `id`.
        In the case of the example above the `id` would be `pki-root/config/est`,
        where the `pki-root` component is the resource's `backend`, e.g.

        ```sh
        $ pulumi import vault:pkiSecret/backendConfigEst:BackendConfigEst example pki-root/config/est
        ```

        :param str resource_name: The name of the resource.
        :param BackendConfigEstArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackendConfigEstArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authenticators: Optional[pulumi.Input[Union['BackendConfigEstAuthenticatorsArgs', 'BackendConfigEstAuthenticatorsArgsDict']]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 default_mount: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_path_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_sentinel_parsing: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 label_to_path_policy: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackendConfigEstArgs.__new__(BackendConfigEstArgs)

            __props__.__dict__["audit_fields"] = audit_fields
            __props__.__dict__["authenticators"] = authenticators
            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            __props__.__dict__["default_mount"] = default_mount
            __props__.__dict__["default_path_policy"] = default_path_policy
            __props__.__dict__["enable_sentinel_parsing"] = enable_sentinel_parsing
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["label_to_path_policy"] = label_to_path_policy
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["last_updated"] = None
        super(BackendConfigEst, __self__).__init__(
            'vault:pkiSecret/backendConfigEst:BackendConfigEst',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audit_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            authenticators: Optional[pulumi.Input[Union['BackendConfigEstAuthenticatorsArgs', 'BackendConfigEstAuthenticatorsArgsDict']]] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            default_mount: Optional[pulumi.Input[_builtins.bool]] = None,
            default_path_policy: Optional[pulumi.Input[_builtins.str]] = None,
            enable_sentinel_parsing: Optional[pulumi.Input[_builtins.bool]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            label_to_path_policy: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            last_updated: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None) -> 'BackendConfigEst':
        """
        Get an existing BackendConfigEst resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_fields: Fields parsed from the CSR that appear in the audit and can be used by sentinel policies.
               
               <a id="nestedatt--authenticators"></a>
        :param pulumi.Input[Union['BackendConfigEstAuthenticatorsArgs', 'BackendConfigEstAuthenticatorsArgsDict']] authenticators: Lists the mount accessors EST should delegate authentication requests towards (see below for nested schema).
        :param pulumi.Input[_builtins.str] backend: The path to the PKI secret backend to
               read the EST configuration from, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.bool] default_mount: If set, this mount will register the default `.well-known/est` URL path. Only a single mount can enable this across a Vault cluster.
        :param pulumi.Input[_builtins.str] default_path_policy: Required to be set if default_mount is enabled. Specifies the behavior for requests using the default EST label. Can be sign-verbatim or a role given by role:<role_name>.
        :param pulumi.Input[_builtins.bool] enable_sentinel_parsing: If set, parse out fields from the provided CSR making them available for Sentinel policies.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether EST is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] label_to_path_policy: Configures a pairing of an EST label with the redirected behavior for requests hitting that role. The path policy can be sign-verbatim or a role given by role:<role_name>. Labels must be unique across Vault cluster, and will register .well-known/est/<label> URL paths.
        :param pulumi.Input[_builtins.str] last_updated: A read-only timestamp representing the last time the configuration was updated.
        :param pulumi.Input[_builtins.str] namespace: The namespace of the target resource.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackendConfigEstState.__new__(_BackendConfigEstState)

        __props__.__dict__["audit_fields"] = audit_fields
        __props__.__dict__["authenticators"] = authenticators
        __props__.__dict__["backend"] = backend
        __props__.__dict__["default_mount"] = default_mount
        __props__.__dict__["default_path_policy"] = default_path_policy
        __props__.__dict__["enable_sentinel_parsing"] = enable_sentinel_parsing
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["label_to_path_policy"] = label_to_path_policy
        __props__.__dict__["last_updated"] = last_updated
        __props__.__dict__["namespace"] = namespace
        return BackendConfigEst(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="auditFields")
    def audit_fields(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Fields parsed from the CSR that appear in the audit and can be used by sentinel policies.

        <a id="nestedatt--authenticators"></a>
        """
        return pulumi.get(self, "audit_fields")

    @_builtins.property
    @pulumi.getter
    def authenticators(self) -> pulumi.Output['outputs.BackendConfigEstAuthenticators']:
        """
        Lists the mount accessors EST should delegate authentication requests towards (see below for nested schema).
        """
        return pulumi.get(self, "authenticators")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[_builtins.str]:
        """
        The path to the PKI secret backend to
        read the EST configuration from, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="defaultMount")
    def default_mount(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set, this mount will register the default `.well-known/est` URL path. Only a single mount can enable this across a Vault cluster.
        """
        return pulumi.get(self, "default_mount")

    @_builtins.property
    @pulumi.getter(name="defaultPathPolicy")
    def default_path_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Required to be set if default_mount is enabled. Specifies the behavior for requests using the default EST label. Can be sign-verbatim or a role given by role:<role_name>.
        """
        return pulumi.get(self, "default_path_policy")

    @_builtins.property
    @pulumi.getter(name="enableSentinelParsing")
    def enable_sentinel_parsing(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set, parse out fields from the provided CSR making them available for Sentinel policies.
        """
        return pulumi.get(self, "enable_sentinel_parsing")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether EST is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="labelToPathPolicy")
    def label_to_path_policy(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Configures a pairing of an EST label with the redirected behavior for requests hitting that role. The path policy can be sign-verbatim or a role given by role:<role_name>. Labels must be unique across Vault cluster, and will register .well-known/est/<label> URL paths.
        """
        return pulumi.get(self, "label_to_path_policy")

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> pulumi.Output[_builtins.str]:
        """
        A read-only timestamp representing the last time the configuration was updated.
        """
        return pulumi.get(self, "last_updated")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace of the target resource.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

