# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBackendConfigCmpv2Result',
    'AwaitableGetBackendConfigCmpv2Result',
    'get_backend_config_cmpv2',
    'get_backend_config_cmpv2_output',
]

@pulumi.output_type
class GetBackendConfigCmpv2Result:
    """
    A collection of values returned by getBackendConfigCmpv2.
    """
    def __init__(__self__, audit_fields=None, authenticators=None, backend=None, default_path_policy=None, disabled_validations=None, enable_sentinel_parsing=None, enabled=None, id=None, last_updated=None, namespace=None):
        if audit_fields and not isinstance(audit_fields, list):
            raise TypeError("Expected argument 'audit_fields' to be a list")
        pulumi.set(__self__, "audit_fields", audit_fields)
        if authenticators and not isinstance(authenticators, list):
            raise TypeError("Expected argument 'authenticators' to be a list")
        pulumi.set(__self__, "authenticators", authenticators)
        if backend and not isinstance(backend, str):
            raise TypeError("Expected argument 'backend' to be a str")
        pulumi.set(__self__, "backend", backend)
        if default_path_policy and not isinstance(default_path_policy, str):
            raise TypeError("Expected argument 'default_path_policy' to be a str")
        pulumi.set(__self__, "default_path_policy", default_path_policy)
        if disabled_validations and not isinstance(disabled_validations, list):
            raise TypeError("Expected argument 'disabled_validations' to be a list")
        pulumi.set(__self__, "disabled_validations", disabled_validations)
        if enable_sentinel_parsing and not isinstance(enable_sentinel_parsing, bool):
            raise TypeError("Expected argument 'enable_sentinel_parsing' to be a bool")
        pulumi.set(__self__, "enable_sentinel_parsing", enable_sentinel_parsing)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated and not isinstance(last_updated, str):
            raise TypeError("Expected argument 'last_updated' to be a str")
        pulumi.set(__self__, "last_updated", last_updated)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter(name="auditFields")
    def audit_fields(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "audit_fields")

    @_builtins.property
    @pulumi.getter
    def authenticators(self) -> Sequence['outputs.GetBackendConfigCmpv2AuthenticatorResult']:
        return pulumi.get(self, "authenticators")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> _builtins.str:
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="defaultPathPolicy")
    def default_path_policy(self) -> _builtins.str:
        return pulumi.get(self, "default_path_policy")

    @_builtins.property
    @pulumi.getter(name="disabledValidations")
    def disabled_validations(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "disabled_validations")

    @_builtins.property
    @pulumi.getter(name="enableSentinelParsing")
    def enable_sentinel_parsing(self) -> _builtins.bool:
        return pulumi.get(self, "enable_sentinel_parsing")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> _builtins.str:
        return pulumi.get(self, "last_updated")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "namespace")


class AwaitableGetBackendConfigCmpv2Result(GetBackendConfigCmpv2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackendConfigCmpv2Result(
            audit_fields=self.audit_fields,
            authenticators=self.authenticators,
            backend=self.backend,
            default_path_policy=self.default_path_policy,
            disabled_validations=self.disabled_validations,
            enable_sentinel_parsing=self.enable_sentinel_parsing,
            enabled=self.enabled,
            id=self.id,
            last_updated=self.last_updated,
            namespace=self.namespace)


def get_backend_config_cmpv2(backend: Optional[_builtins.str] = None,
                             disabled_validations: Optional[Sequence[_builtins.str]] = None,
                             namespace: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackendConfigCmpv2Result:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_vault as vault

    pki = vault.Mount("pki",
        path="pki",
        type="pki",
        description="PKI secret engine mount")
    cmpv2_config = vault.pkiSecret.get_backend_config_cmpv2_output(backend=pki.path)
    ```


    :param _builtins.str backend: The path to the PKI secret backend to
           read the CMPv2 configuration from, with no leading or trailing `/`s.
           
           # Attributes Reference
    :param Sequence[_builtins.str] disabled_validations: A comma-separated list of validations not to perform on CMPv2 messages.
    :param _builtins.str namespace: The namespace of the target resource.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
           *Available only for Vault Enterprise*.
    """
    __args__ = dict()
    __args__['backend'] = backend
    __args__['disabledValidations'] = disabled_validations
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vault:pkiSecret/getBackendConfigCmpv2:getBackendConfigCmpv2', __args__, opts=opts, typ=GetBackendConfigCmpv2Result).value

    return AwaitableGetBackendConfigCmpv2Result(
        audit_fields=pulumi.get(__ret__, 'audit_fields'),
        authenticators=pulumi.get(__ret__, 'authenticators'),
        backend=pulumi.get(__ret__, 'backend'),
        default_path_policy=pulumi.get(__ret__, 'default_path_policy'),
        disabled_validations=pulumi.get(__ret__, 'disabled_validations'),
        enable_sentinel_parsing=pulumi.get(__ret__, 'enable_sentinel_parsing'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        last_updated=pulumi.get(__ret__, 'last_updated'),
        namespace=pulumi.get(__ret__, 'namespace'))
def get_backend_config_cmpv2_output(backend: Optional[pulumi.Input[_builtins.str]] = None,
                                    disabled_validations: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                    namespace: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBackendConfigCmpv2Result]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_vault as vault

    pki = vault.Mount("pki",
        path="pki",
        type="pki",
        description="PKI secret engine mount")
    cmpv2_config = vault.pkiSecret.get_backend_config_cmpv2_output(backend=pki.path)
    ```


    :param _builtins.str backend: The path to the PKI secret backend to
           read the CMPv2 configuration from, with no leading or trailing `/`s.
           
           # Attributes Reference
    :param Sequence[_builtins.str] disabled_validations: A comma-separated list of validations not to perform on CMPv2 messages.
    :param _builtins.str namespace: The namespace of the target resource.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
           *Available only for Vault Enterprise*.
    """
    __args__ = dict()
    __args__['backend'] = backend
    __args__['disabledValidations'] = disabled_validations
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vault:pkiSecret/getBackendConfigCmpv2:getBackendConfigCmpv2', __args__, opts=opts, typ=GetBackendConfigCmpv2Result)
    return __ret__.apply(lambda __response__: GetBackendConfigCmpv2Result(
        audit_fields=pulumi.get(__response__, 'audit_fields'),
        authenticators=pulumi.get(__response__, 'authenticators'),
        backend=pulumi.get(__response__, 'backend'),
        default_path_policy=pulumi.get(__response__, 'default_path_policy'),
        disabled_validations=pulumi.get(__response__, 'disabled_validations'),
        enable_sentinel_parsing=pulumi.get(__response__, 'enable_sentinel_parsing'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        last_updated=pulumi.get(__response__, 'last_updated'),
        namespace=pulumi.get(__response__, 'namespace')))
