# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetBackendIssuerResult',
    'AwaitableGetBackendIssuerResult',
    'get_backend_issuer',
    'get_backend_issuer_output',
]

@pulumi.output_type
class GetBackendIssuerResult:
    """
    A collection of values returned by getBackendIssuer.
    """
    def __init__(__self__, backend=None, ca_chains=None, certificate=None, disable_critical_extension_checks=None, disable_name_checks=None, disable_name_constraint_checks=None, disable_path_length_checks=None, id=None, issuer_id=None, issuer_name=None, issuer_ref=None, key_id=None, leaf_not_after_behavior=None, manual_chains=None, namespace=None, usage=None):
        if backend and not isinstance(backend, str):
            raise TypeError("Expected argument 'backend' to be a str")
        pulumi.set(__self__, "backend", backend)
        if ca_chains and not isinstance(ca_chains, list):
            raise TypeError("Expected argument 'ca_chains' to be a list")
        pulumi.set(__self__, "ca_chains", ca_chains)
        if certificate and not isinstance(certificate, str):
            raise TypeError("Expected argument 'certificate' to be a str")
        pulumi.set(__self__, "certificate", certificate)
        if disable_critical_extension_checks and not isinstance(disable_critical_extension_checks, bool):
            raise TypeError("Expected argument 'disable_critical_extension_checks' to be a bool")
        pulumi.set(__self__, "disable_critical_extension_checks", disable_critical_extension_checks)
        if disable_name_checks and not isinstance(disable_name_checks, bool):
            raise TypeError("Expected argument 'disable_name_checks' to be a bool")
        pulumi.set(__self__, "disable_name_checks", disable_name_checks)
        if disable_name_constraint_checks and not isinstance(disable_name_constraint_checks, bool):
            raise TypeError("Expected argument 'disable_name_constraint_checks' to be a bool")
        pulumi.set(__self__, "disable_name_constraint_checks", disable_name_constraint_checks)
        if disable_path_length_checks and not isinstance(disable_path_length_checks, bool):
            raise TypeError("Expected argument 'disable_path_length_checks' to be a bool")
        pulumi.set(__self__, "disable_path_length_checks", disable_path_length_checks)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if issuer_id and not isinstance(issuer_id, str):
            raise TypeError("Expected argument 'issuer_id' to be a str")
        pulumi.set(__self__, "issuer_id", issuer_id)
        if issuer_name and not isinstance(issuer_name, str):
            raise TypeError("Expected argument 'issuer_name' to be a str")
        pulumi.set(__self__, "issuer_name", issuer_name)
        if issuer_ref and not isinstance(issuer_ref, str):
            raise TypeError("Expected argument 'issuer_ref' to be a str")
        pulumi.set(__self__, "issuer_ref", issuer_ref)
        if key_id and not isinstance(key_id, str):
            raise TypeError("Expected argument 'key_id' to be a str")
        pulumi.set(__self__, "key_id", key_id)
        if leaf_not_after_behavior and not isinstance(leaf_not_after_behavior, str):
            raise TypeError("Expected argument 'leaf_not_after_behavior' to be a str")
        pulumi.set(__self__, "leaf_not_after_behavior", leaf_not_after_behavior)
        if manual_chains and not isinstance(manual_chains, list):
            raise TypeError("Expected argument 'manual_chains' to be a list")
        pulumi.set(__self__, "manual_chains", manual_chains)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if usage and not isinstance(usage, str):
            raise TypeError("Expected argument 'usage' to be a str")
        pulumi.set(__self__, "usage", usage)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> _builtins.str:
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="caChains")
    def ca_chains(self) -> Sequence[_builtins.str]:
        """
        The CA chain as a list of format specific certificates.
        """
        return pulumi.get(self, "ca_chains")

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> _builtins.str:
        """
        Certificate associated with this issuer.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="disableCriticalExtensionChecks")
    def disable_critical_extension_checks(self) -> Optional[_builtins.bool]:
        """
        This determines whether this
        issuer is able to issue certificates where the chain of trust (including the
        issued certificate) contain critical extensions not processed by Vault.
        """
        return pulumi.get(self, "disable_critical_extension_checks")

    @_builtins.property
    @pulumi.getter(name="disableNameChecks")
    def disable_name_checks(self) -> Optional[_builtins.bool]:
        """
        This determines whether this issuer is able
        to issue certificates where the chain of trust (including the final issued
        certificate) contains a link in which the subject of the issuing certificate
        does not match the named issuer of the certificate it signed.
        """
        return pulumi.get(self, "disable_name_checks")

    @_builtins.property
    @pulumi.getter(name="disableNameConstraintChecks")
    def disable_name_constraint_checks(self) -> Optional[_builtins.bool]:
        """
        This determines whether this
        issuer is able to issue certificates where the chain of trust (including the
        final issued certificate) violates the name constraints critical extension of
        one of the issuer certificates in the chain.
        """
        return pulumi.get(self, "disable_name_constraint_checks")

    @_builtins.property
    @pulumi.getter(name="disablePathLengthChecks")
    def disable_path_length_checks(self) -> Optional[_builtins.bool]:
        """
        This determines whether this issuer
        is able to issue certificates where the chain of trust (including the final
        issued certificate) is longer than allowed by a certificate authority in that
        chain.
        """
        return pulumi.get(self, "disable_path_length_checks")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="issuerId")
    def issuer_id(self) -> _builtins.str:
        """
        ID of the issuer.
        """
        return pulumi.get(self, "issuer_id")

    @_builtins.property
    @pulumi.getter(name="issuerName")
    def issuer_name(self) -> _builtins.str:
        """
        Name of the issuer.
        """
        return pulumi.get(self, "issuer_name")

    @_builtins.property
    @pulumi.getter(name="issuerRef")
    def issuer_ref(self) -> _builtins.str:
        return pulumi.get(self, "issuer_ref")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        """
        ID of the key used by the issuer.
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="leafNotAfterBehavior")
    def leaf_not_after_behavior(self) -> _builtins.str:
        """
        Behavior of a leaf's NotAfter field during issuance.
        """
        return pulumi.get(self, "leaf_not_after_behavior")

    @_builtins.property
    @pulumi.getter(name="manualChains")
    def manual_chains(self) -> Sequence[_builtins.str]:
        """
        Chain of issuer references to build this issuer's computed 
        CAChain field from, when non-empty.
        """
        return pulumi.get(self, "manual_chains")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def usage(self) -> _builtins.str:
        """
        Allowed usages for this issuer.
        """
        return pulumi.get(self, "usage")


class AwaitableGetBackendIssuerResult(GetBackendIssuerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackendIssuerResult(
            backend=self.backend,
            ca_chains=self.ca_chains,
            certificate=self.certificate,
            disable_critical_extension_checks=self.disable_critical_extension_checks,
            disable_name_checks=self.disable_name_checks,
            disable_name_constraint_checks=self.disable_name_constraint_checks,
            disable_path_length_checks=self.disable_path_length_checks,
            id=self.id,
            issuer_id=self.issuer_id,
            issuer_name=self.issuer_name,
            issuer_ref=self.issuer_ref,
            key_id=self.key_id,
            leaf_not_after_behavior=self.leaf_not_after_behavior,
            manual_chains=self.manual_chains,
            namespace=self.namespace,
            usage=self.usage)


def get_backend_issuer(backend: Optional[_builtins.str] = None,
                       disable_critical_extension_checks: Optional[_builtins.bool] = None,
                       disable_name_checks: Optional[_builtins.bool] = None,
                       disable_name_constraint_checks: Optional[_builtins.bool] = None,
                       disable_path_length_checks: Optional[_builtins.bool] = None,
                       issuer_ref: Optional[_builtins.str] = None,
                       namespace: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackendIssuerResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_vault as vault

    pki = vault.Mount("pki",
        path="pki",
        type="pki",
        description="PKI secret engine mount")
    root = vault.pkisecret.SecretBackendRootCert("root",
        backend=pki.path,
        type="internal",
        common_name="example",
        ttl="86400",
        issuer_name="example")
    example = root.issuer_id.apply(lambda issuer_id: vault.pkiSecret.get_backend_issuer_output(backend=root.path,
        issuer_ref=issuer_id))
    ```


    :param _builtins.str backend: The path to the PKI secret backend to
           read the issuer from, with no leading or trailing `/`s.
    :param _builtins.bool disable_critical_extension_checks: This determines whether this
           issuer is able to issue certificates where the chain of trust (including the
           issued certificate) contain critical extensions not processed by Vault.
    :param _builtins.bool disable_name_checks: This determines whether this issuer is able
           to issue certificates where the chain of trust (including the final issued
           certificate) contains a link in which the subject of the issuing certificate
           does not match the named issuer of the certificate it signed.
    :param _builtins.bool disable_name_constraint_checks: This determines whether this
           issuer is able to issue certificates where the chain of trust (including the
           final issued certificate) violates the name constraints critical extension of
           one of the issuer certificates in the chain.
    :param _builtins.bool disable_path_length_checks: This determines whether this issuer
           is able to issue certificates where the chain of trust (including the final
           issued certificate) is longer than allowed by a certificate authority in that
           chain.
    :param _builtins.str issuer_ref: Reference to an existing issuer.
    :param _builtins.str namespace: The namespace of the target resource.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
           *Available only for Vault Enterprise*.
    """
    __args__ = dict()
    __args__['backend'] = backend
    __args__['disableCriticalExtensionChecks'] = disable_critical_extension_checks
    __args__['disableNameChecks'] = disable_name_checks
    __args__['disableNameConstraintChecks'] = disable_name_constraint_checks
    __args__['disablePathLengthChecks'] = disable_path_length_checks
    __args__['issuerRef'] = issuer_ref
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vault:pkiSecret/getBackendIssuer:getBackendIssuer', __args__, opts=opts, typ=GetBackendIssuerResult).value

    return AwaitableGetBackendIssuerResult(
        backend=pulumi.get(__ret__, 'backend'),
        ca_chains=pulumi.get(__ret__, 'ca_chains'),
        certificate=pulumi.get(__ret__, 'certificate'),
        disable_critical_extension_checks=pulumi.get(__ret__, 'disable_critical_extension_checks'),
        disable_name_checks=pulumi.get(__ret__, 'disable_name_checks'),
        disable_name_constraint_checks=pulumi.get(__ret__, 'disable_name_constraint_checks'),
        disable_path_length_checks=pulumi.get(__ret__, 'disable_path_length_checks'),
        id=pulumi.get(__ret__, 'id'),
        issuer_id=pulumi.get(__ret__, 'issuer_id'),
        issuer_name=pulumi.get(__ret__, 'issuer_name'),
        issuer_ref=pulumi.get(__ret__, 'issuer_ref'),
        key_id=pulumi.get(__ret__, 'key_id'),
        leaf_not_after_behavior=pulumi.get(__ret__, 'leaf_not_after_behavior'),
        manual_chains=pulumi.get(__ret__, 'manual_chains'),
        namespace=pulumi.get(__ret__, 'namespace'),
        usage=pulumi.get(__ret__, 'usage'))
def get_backend_issuer_output(backend: Optional[pulumi.Input[_builtins.str]] = None,
                              disable_critical_extension_checks: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                              disable_name_checks: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                              disable_name_constraint_checks: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                              disable_path_length_checks: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                              issuer_ref: Optional[pulumi.Input[_builtins.str]] = None,
                              namespace: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBackendIssuerResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_vault as vault

    pki = vault.Mount("pki",
        path="pki",
        type="pki",
        description="PKI secret engine mount")
    root = vault.pkisecret.SecretBackendRootCert("root",
        backend=pki.path,
        type="internal",
        common_name="example",
        ttl="86400",
        issuer_name="example")
    example = root.issuer_id.apply(lambda issuer_id: vault.pkiSecret.get_backend_issuer_output(backend=root.path,
        issuer_ref=issuer_id))
    ```


    :param _builtins.str backend: The path to the PKI secret backend to
           read the issuer from, with no leading or trailing `/`s.
    :param _builtins.bool disable_critical_extension_checks: This determines whether this
           issuer is able to issue certificates where the chain of trust (including the
           issued certificate) contain critical extensions not processed by Vault.
    :param _builtins.bool disable_name_checks: This determines whether this issuer is able
           to issue certificates where the chain of trust (including the final issued
           certificate) contains a link in which the subject of the issuing certificate
           does not match the named issuer of the certificate it signed.
    :param _builtins.bool disable_name_constraint_checks: This determines whether this
           issuer is able to issue certificates where the chain of trust (including the
           final issued certificate) violates the name constraints critical extension of
           one of the issuer certificates in the chain.
    :param _builtins.bool disable_path_length_checks: This determines whether this issuer
           is able to issue certificates where the chain of trust (including the final
           issued certificate) is longer than allowed by a certificate authority in that
           chain.
    :param _builtins.str issuer_ref: Reference to an existing issuer.
    :param _builtins.str namespace: The namespace of the target resource.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
           *Available only for Vault Enterprise*.
    """
    __args__ = dict()
    __args__['backend'] = backend
    __args__['disableCriticalExtensionChecks'] = disable_critical_extension_checks
    __args__['disableNameChecks'] = disable_name_checks
    __args__['disableNameConstraintChecks'] = disable_name_constraint_checks
    __args__['disablePathLengthChecks'] = disable_path_length_checks
    __args__['issuerRef'] = issuer_ref
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vault:pkiSecret/getBackendIssuer:getBackendIssuer', __args__, opts=opts, typ=GetBackendIssuerResult)
    return __ret__.apply(lambda __response__: GetBackendIssuerResult(
        backend=pulumi.get(__response__, 'backend'),
        ca_chains=pulumi.get(__response__, 'ca_chains'),
        certificate=pulumi.get(__response__, 'certificate'),
        disable_critical_extension_checks=pulumi.get(__response__, 'disable_critical_extension_checks'),
        disable_name_checks=pulumi.get(__response__, 'disable_name_checks'),
        disable_name_constraint_checks=pulumi.get(__response__, 'disable_name_constraint_checks'),
        disable_path_length_checks=pulumi.get(__response__, 'disable_path_length_checks'),
        id=pulumi.get(__response__, 'id'),
        issuer_id=pulumi.get(__response__, 'issuer_id'),
        issuer_name=pulumi.get(__response__, 'issuer_name'),
        issuer_ref=pulumi.get(__response__, 'issuer_ref'),
        key_id=pulumi.get(__response__, 'key_id'),
        leaf_not_after_behavior=pulumi.get(__response__, 'leaf_not_after_behavior'),
        manual_chains=pulumi.get(__response__, 'manual_chains'),
        namespace=pulumi.get(__response__, 'namespace'),
        usage=pulumi.get(__response__, 'usage')))
