# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PluginArgs', 'Plugin']

@pulumi.input_type
class PluginArgs:
    def __init__(__self__, *,
                 command: pulumi.Input[_builtins.str],
                 sha256: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_image: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Plugin resource.
        :param pulumi.Input[_builtins.str] command: Command to execute the plugin, relative to the server's configured `plugin_directory`.
        :param pulumi.Input[_builtins.str] sha256: SHA256 sum of the plugin binary.
        :param pulumi.Input[_builtins.str] type: Type of plugin; one of "auth", "secret", or "database".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] args: List of additional args to pass to the plugin.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] envs: List of additional environment variables to run the plugin with in KEY=VALUE form.
        :param pulumi.Input[_builtins.str] name: Name of the plugin.
        :param pulumi.Input[_builtins.str] oci_image: Specifies OCI image to run. If specified, setting
               `command`, `args`, and `env` will update the container's entrypoint, args, and
               environment variables (append-only) respectively.
        :param pulumi.Input[_builtins.str] runtime: Vault plugin runtime to use if `oci_image` is specified.
        :param pulumi.Input[_builtins.str] version: Semantic version of the plugin.
        """
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "sha256", sha256)
        pulumi.set(__self__, "type", type)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oci_image is not None:
            pulumi.set(__self__, "oci_image", oci_image)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def command(self) -> pulumi.Input[_builtins.str]:
        """
        Command to execute the plugin, relative to the server's configured `plugin_directory`.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "command", value)

    @_builtins.property
    @pulumi.getter
    def sha256(self) -> pulumi.Input[_builtins.str]:
        """
        SHA256 sum of the plugin binary.
        """
        return pulumi.get(self, "sha256")

    @sha256.setter
    def sha256(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sha256", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of plugin; one of "auth", "secret", or "database".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of additional args to pass to the plugin.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "args", value)

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of additional environment variables to run the plugin with in KEY=VALUE form.
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "envs", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the plugin.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ociImage")
    def oci_image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies OCI image to run. If specified, setting
        `command`, `args`, and `env` will update the container's entrypoint, args, and
        environment variables (append-only) respectively.
        """
        return pulumi.get(self, "oci_image")

    @oci_image.setter
    def oci_image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oci_image", value)

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Vault plugin runtime to use if `oci_image` is specified.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Semantic version of the plugin.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _PluginState:
    def __init__(__self__, *,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 command: Optional[pulumi.Input[_builtins.str]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_image: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 sha256: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Plugin resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] args: List of additional args to pass to the plugin.
        :param pulumi.Input[_builtins.str] command: Command to execute the plugin, relative to the server's configured `plugin_directory`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] envs: List of additional environment variables to run the plugin with in KEY=VALUE form.
        :param pulumi.Input[_builtins.str] name: Name of the plugin.
        :param pulumi.Input[_builtins.str] oci_image: Specifies OCI image to run. If specified, setting
               `command`, `args`, and `env` will update the container's entrypoint, args, and
               environment variables (append-only) respectively.
        :param pulumi.Input[_builtins.str] runtime: Vault plugin runtime to use if `oci_image` is specified.
        :param pulumi.Input[_builtins.str] sha256: SHA256 sum of the plugin binary.
        :param pulumi.Input[_builtins.str] type: Type of plugin; one of "auth", "secret", or "database".
        :param pulumi.Input[_builtins.str] version: Semantic version of the plugin.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oci_image is not None:
            pulumi.set(__self__, "oci_image", oci_image)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if sha256 is not None:
            pulumi.set(__self__, "sha256", sha256)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of additional args to pass to the plugin.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "args", value)

    @_builtins.property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Command to execute the plugin, relative to the server's configured `plugin_directory`.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "command", value)

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of additional environment variables to run the plugin with in KEY=VALUE form.
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "envs", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the plugin.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ociImage")
    def oci_image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies OCI image to run. If specified, setting
        `command`, `args`, and `env` will update the container's entrypoint, args, and
        environment variables (append-only) respectively.
        """
        return pulumi.get(self, "oci_image")

    @oci_image.setter
    def oci_image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oci_image", value)

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Vault plugin runtime to use if `oci_image` is specified.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime", value)

    @_builtins.property
    @pulumi.getter
    def sha256(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SHA256 sum of the plugin binary.
        """
        return pulumi.get(self, "sha256")

    @sha256.setter
    def sha256(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sha256", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of plugin; one of "auth", "secret", or "database".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Semantic version of the plugin.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("vault:index/plugin:Plugin")
class Plugin(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 command: Optional[pulumi.Input[_builtins.str]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_image: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 sha256: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        jwt = vault.Plugin("jwt",
            type="auth",
            name="jwt",
            command="vault-plugin-auth-jwt",
            version="v0.17.0",
            sha256="6bd0a803ed742aa3ce35e4fa23d2c8d550e6c1567bf63410cec489c28b68b0fc",
            envs=["HTTP_PROXY=http://proxy.example.com:8080"])
        jwt_auth = vault.AuthBackend("jwt_auth", type=jwt.name)
        ```

        ## Import

        Plugins can be imported using `:type/name/:name` or `:type/version/:version/name/:name` as the ID if the version is non-empty, e.g.

        ```sh
        $ pulumi import vault:index/plugin:Plugin jwt auth/name/jwt
        ```
        ```sh
        $ pulumi import vault:index/plugin:Plugin jwt auth/version/v0.17.0/name/jwt
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] args: List of additional args to pass to the plugin.
        :param pulumi.Input[_builtins.str] command: Command to execute the plugin, relative to the server's configured `plugin_directory`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] envs: List of additional environment variables to run the plugin with in KEY=VALUE form.
        :param pulumi.Input[_builtins.str] name: Name of the plugin.
        :param pulumi.Input[_builtins.str] oci_image: Specifies OCI image to run. If specified, setting
               `command`, `args`, and `env` will update the container's entrypoint, args, and
               environment variables (append-only) respectively.
        :param pulumi.Input[_builtins.str] runtime: Vault plugin runtime to use if `oci_image` is specified.
        :param pulumi.Input[_builtins.str] sha256: SHA256 sum of the plugin binary.
        :param pulumi.Input[_builtins.str] type: Type of plugin; one of "auth", "secret", or "database".
        :param pulumi.Input[_builtins.str] version: Semantic version of the plugin.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PluginArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        jwt = vault.Plugin("jwt",
            type="auth",
            name="jwt",
            command="vault-plugin-auth-jwt",
            version="v0.17.0",
            sha256="6bd0a803ed742aa3ce35e4fa23d2c8d550e6c1567bf63410cec489c28b68b0fc",
            envs=["HTTP_PROXY=http://proxy.example.com:8080"])
        jwt_auth = vault.AuthBackend("jwt_auth", type=jwt.name)
        ```

        ## Import

        Plugins can be imported using `:type/name/:name` or `:type/version/:version/name/:name` as the ID if the version is non-empty, e.g.

        ```sh
        $ pulumi import vault:index/plugin:Plugin jwt auth/name/jwt
        ```
        ```sh
        $ pulumi import vault:index/plugin:Plugin jwt auth/version/v0.17.0/name/jwt
        ```

        :param str resource_name: The name of the resource.
        :param PluginArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PluginArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 command: Optional[pulumi.Input[_builtins.str]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_image: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 sha256: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PluginArgs.__new__(PluginArgs)

            __props__.__dict__["args"] = args
            if command is None and not opts.urn:
                raise TypeError("Missing required property 'command'")
            __props__.__dict__["command"] = command
            __props__.__dict__["envs"] = None if envs is None else pulumi.Output.secret(envs)
            __props__.__dict__["name"] = name
            __props__.__dict__["oci_image"] = oci_image
            __props__.__dict__["runtime"] = runtime
            if sha256 is None and not opts.urn:
                raise TypeError("Missing required property 'sha256'")
            __props__.__dict__["sha256"] = sha256
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["version"] = version
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["envs"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Plugin, __self__).__init__(
            'vault:index/plugin:Plugin',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            args: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            command: Optional[pulumi.Input[_builtins.str]] = None,
            envs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            oci_image: Optional[pulumi.Input[_builtins.str]] = None,
            runtime: Optional[pulumi.Input[_builtins.str]] = None,
            sha256: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'Plugin':
        """
        Get an existing Plugin resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] args: List of additional args to pass to the plugin.
        :param pulumi.Input[_builtins.str] command: Command to execute the plugin, relative to the server's configured `plugin_directory`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] envs: List of additional environment variables to run the plugin with in KEY=VALUE form.
        :param pulumi.Input[_builtins.str] name: Name of the plugin.
        :param pulumi.Input[_builtins.str] oci_image: Specifies OCI image to run. If specified, setting
               `command`, `args`, and `env` will update the container's entrypoint, args, and
               environment variables (append-only) respectively.
        :param pulumi.Input[_builtins.str] runtime: Vault plugin runtime to use if `oci_image` is specified.
        :param pulumi.Input[_builtins.str] sha256: SHA256 sum of the plugin binary.
        :param pulumi.Input[_builtins.str] type: Type of plugin; one of "auth", "secret", or "database".
        :param pulumi.Input[_builtins.str] version: Semantic version of the plugin.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PluginState.__new__(_PluginState)

        __props__.__dict__["args"] = args
        __props__.__dict__["command"] = command
        __props__.__dict__["envs"] = envs
        __props__.__dict__["name"] = name
        __props__.__dict__["oci_image"] = oci_image
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["sha256"] = sha256
        __props__.__dict__["type"] = type
        __props__.__dict__["version"] = version
        return Plugin(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def args(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of additional args to pass to the plugin.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def command(self) -> pulumi.Output[_builtins.str]:
        """
        Command to execute the plugin, relative to the server's configured `plugin_directory`.
        """
        return pulumi.get(self, "command")

    @_builtins.property
    @pulumi.getter
    def envs(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of additional environment variables to run the plugin with in KEY=VALUE form.
        """
        return pulumi.get(self, "envs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the plugin.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ociImage")
    def oci_image(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies OCI image to run. If specified, setting
        `command`, `args`, and `env` will update the container's entrypoint, args, and
        environment variables (append-only) respectively.
        """
        return pulumi.get(self, "oci_image")

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Vault plugin runtime to use if `oci_image` is specified.
        """
        return pulumi.get(self, "runtime")

    @_builtins.property
    @pulumi.getter
    def sha256(self) -> pulumi.Output[_builtins.str]:
        """
        SHA256 sum of the plugin binary.
        """
        return pulumi.get(self, "sha256")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of plugin; one of "auth", "secret", or "database".
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Semantic version of the plugin.
        """
        return pulumi.get(self, "version")

