# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecretBackendRoleArgs', 'SecretBackendRole']

@pulumi.input_type
class SecretBackendRoleArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[_builtins.str],
                 key_type: pulumi.Input[_builtins.str],
                 algorithm_signer: Optional[pulumi.Input[_builtins.str]] = None,
                 allow_bare_domains: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_empty_principals: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_host_certificates: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_subdomains: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_certificates: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_key_ids: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_critical_options: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_domains: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_domains_template: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_extensions: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_user_key_configs: Optional[pulumi.Input[Sequence[pulumi.Input['SecretBackendRoleAllowedUserKeyConfigArgs']]]] = None,
                 allowed_users: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_users_template: Optional[pulumi.Input[_builtins.bool]] = None,
                 cidr_list: Optional[pulumi.Input[_builtins.str]] = None,
                 default_critical_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 default_extensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 default_user: Optional[pulumi.Input[_builtins.str]] = None,
                 default_user_template: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_id_format: Optional[pulumi.Input[_builtins.str]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 not_before_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SecretBackendRole resource.
        :param pulumi.Input[_builtins.str] backend: The path where the SSH secret backend is mounted.
        :param pulumi.Input[_builtins.str] key_type: Specifies the type of credentials generated by this role. This can be either `otp`, `dynamic` or `ca`.
        :param pulumi.Input[_builtins.str] algorithm_signer: When supplied, this value specifies a signing algorithm for the key. Possible values: ssh-rsa, rsa-sha2-256, rsa-sha2-512.
        :param pulumi.Input[_builtins.bool] allow_bare_domains: Specifies if host certificates that are requested are allowed to use the base domains listed in `allowed_domains`.
        :param pulumi.Input[_builtins.bool] allow_empty_principals: Allow signing certificates with no
               valid principals (e.g. any valid principal). For backwards compatibility
               only. The default of false is highly recommended.
        :param pulumi.Input[_builtins.bool] allow_host_certificates: Specifies if certificates are allowed to be signed for use as a 'host'.
        :param pulumi.Input[_builtins.bool] allow_subdomains: Specifies if host certificates that are requested are allowed to be subdomains of those listed in `allowed_domains`.
        :param pulumi.Input[_builtins.bool] allow_user_certificates: Specifies if certificates are allowed to be signed for use as a 'user'.
        :param pulumi.Input[_builtins.bool] allow_user_key_ids: Specifies if users can override the key ID for a signed certificate with the `key_id` field.
        :param pulumi.Input[_builtins.str] allowed_critical_options: Specifies a comma-separated list of critical options that certificates can have when signed.
        :param pulumi.Input[_builtins.str] allowed_domains: The list of domains for which a client can request a host certificate.
        :param pulumi.Input[_builtins.bool] allowed_domains_template: Specifies if `allowed_domains` can be declared using
               identity template policies. Non-templated domains are also permitted.
        :param pulumi.Input[_builtins.str] allowed_extensions: Specifies a comma-separated list of extensions that certificates can have when signed.
        :param pulumi.Input[Sequence[pulumi.Input['SecretBackendRoleAllowedUserKeyConfigArgs']]] allowed_user_key_configs: Set of configuration blocks to define allowed  
               user key configuration, like key type and their lengths. Can be specified multiple times.
               *See Configuration-Options for more info*
        :param pulumi.Input[_builtins.str] allowed_users: Specifies a comma-separated list of usernames that are to be allowed, only if certain usernames are to be allowed.
        :param pulumi.Input[_builtins.bool] allowed_users_template: Specifies if `allowed_users` can be declared using identity template policies. Non-templated users are also permitted.
        :param pulumi.Input[_builtins.str] cidr_list: The comma-separated string of CIDR blocks for which this role is applicable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] default_critical_options: Specifies a map of critical options that certificates have when signed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] default_extensions: Specifies a map of extensions that certificates have when signed.
        :param pulumi.Input[_builtins.str] default_user: Specifies the default username for which a credential will be generated.
        :param pulumi.Input[_builtins.bool] default_user_template: If set, `default_users` can be specified using identity template values. A non-templated user is also permitted.
        :param pulumi.Input[_builtins.str] key_id_format: Specifies a custom format for the key id of a signed certificate.
        :param pulumi.Input[_builtins.str] max_ttl: Specifies the maximum Time To Live value.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the role to create.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] not_before_duration: Specifies the duration by which to backdate the ValidAfter property. Uses duration format strings.
        :param pulumi.Input[_builtins.str] ttl: Specifies the Time To Live value.
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "key_type", key_type)
        if algorithm_signer is not None:
            pulumi.set(__self__, "algorithm_signer", algorithm_signer)
        if allow_bare_domains is not None:
            pulumi.set(__self__, "allow_bare_domains", allow_bare_domains)
        if allow_empty_principals is not None:
            pulumi.set(__self__, "allow_empty_principals", allow_empty_principals)
        if allow_host_certificates is not None:
            pulumi.set(__self__, "allow_host_certificates", allow_host_certificates)
        if allow_subdomains is not None:
            pulumi.set(__self__, "allow_subdomains", allow_subdomains)
        if allow_user_certificates is not None:
            pulumi.set(__self__, "allow_user_certificates", allow_user_certificates)
        if allow_user_key_ids is not None:
            pulumi.set(__self__, "allow_user_key_ids", allow_user_key_ids)
        if allowed_critical_options is not None:
            pulumi.set(__self__, "allowed_critical_options", allowed_critical_options)
        if allowed_domains is not None:
            pulumi.set(__self__, "allowed_domains", allowed_domains)
        if allowed_domains_template is not None:
            pulumi.set(__self__, "allowed_domains_template", allowed_domains_template)
        if allowed_extensions is not None:
            pulumi.set(__self__, "allowed_extensions", allowed_extensions)
        if allowed_user_key_configs is not None:
            pulumi.set(__self__, "allowed_user_key_configs", allowed_user_key_configs)
        if allowed_users is not None:
            pulumi.set(__self__, "allowed_users", allowed_users)
        if allowed_users_template is not None:
            pulumi.set(__self__, "allowed_users_template", allowed_users_template)
        if cidr_list is not None:
            pulumi.set(__self__, "cidr_list", cidr_list)
        if default_critical_options is not None:
            pulumi.set(__self__, "default_critical_options", default_critical_options)
        if default_extensions is not None:
            pulumi.set(__self__, "default_extensions", default_extensions)
        if default_user is not None:
            pulumi.set(__self__, "default_user", default_user)
        if default_user_template is not None:
            pulumi.set(__self__, "default_user_template", default_user_template)
        if key_id_format is not None:
            pulumi.set(__self__, "key_id_format", key_id_format)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if not_before_duration is not None:
            pulumi.set(__self__, "not_before_duration", not_before_duration)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Input[_builtins.str]:
        """
        The path where the SSH secret backend is mounted.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of credentials generated by this role. This can be either `otp`, `dynamic` or `ca`.
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_type", value)

    @_builtins.property
    @pulumi.getter(name="algorithmSigner")
    def algorithm_signer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When supplied, this value specifies a signing algorithm for the key. Possible values: ssh-rsa, rsa-sha2-256, rsa-sha2-512.
        """
        return pulumi.get(self, "algorithm_signer")

    @algorithm_signer.setter
    def algorithm_signer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "algorithm_signer", value)

    @_builtins.property
    @pulumi.getter(name="allowBareDomains")
    def allow_bare_domains(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if host certificates that are requested are allowed to use the base domains listed in `allowed_domains`.
        """
        return pulumi.get(self, "allow_bare_domains")

    @allow_bare_domains.setter
    def allow_bare_domains(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_bare_domains", value)

    @_builtins.property
    @pulumi.getter(name="allowEmptyPrincipals")
    def allow_empty_principals(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow signing certificates with no
        valid principals (e.g. any valid principal). For backwards compatibility
        only. The default of false is highly recommended.
        """
        return pulumi.get(self, "allow_empty_principals")

    @allow_empty_principals.setter
    def allow_empty_principals(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_empty_principals", value)

    @_builtins.property
    @pulumi.getter(name="allowHostCertificates")
    def allow_host_certificates(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if certificates are allowed to be signed for use as a 'host'.
        """
        return pulumi.get(self, "allow_host_certificates")

    @allow_host_certificates.setter
    def allow_host_certificates(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_host_certificates", value)

    @_builtins.property
    @pulumi.getter(name="allowSubdomains")
    def allow_subdomains(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if host certificates that are requested are allowed to be subdomains of those listed in `allowed_domains`.
        """
        return pulumi.get(self, "allow_subdomains")

    @allow_subdomains.setter
    def allow_subdomains(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_subdomains", value)

    @_builtins.property
    @pulumi.getter(name="allowUserCertificates")
    def allow_user_certificates(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if certificates are allowed to be signed for use as a 'user'.
        """
        return pulumi.get(self, "allow_user_certificates")

    @allow_user_certificates.setter
    def allow_user_certificates(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_user_certificates", value)

    @_builtins.property
    @pulumi.getter(name="allowUserKeyIds")
    def allow_user_key_ids(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if users can override the key ID for a signed certificate with the `key_id` field.
        """
        return pulumi.get(self, "allow_user_key_ids")

    @allow_user_key_ids.setter
    def allow_user_key_ids(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_user_key_ids", value)

    @_builtins.property
    @pulumi.getter(name="allowedCriticalOptions")
    def allowed_critical_options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comma-separated list of critical options that certificates can have when signed.
        """
        return pulumi.get(self, "allowed_critical_options")

    @allowed_critical_options.setter
    def allowed_critical_options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allowed_critical_options", value)

    @_builtins.property
    @pulumi.getter(name="allowedDomains")
    def allowed_domains(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The list of domains for which a client can request a host certificate.
        """
        return pulumi.get(self, "allowed_domains")

    @allowed_domains.setter
    def allowed_domains(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allowed_domains", value)

    @_builtins.property
    @pulumi.getter(name="allowedDomainsTemplate")
    def allowed_domains_template(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if `allowed_domains` can be declared using
        identity template policies. Non-templated domains are also permitted.
        """
        return pulumi.get(self, "allowed_domains_template")

    @allowed_domains_template.setter
    def allowed_domains_template(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allowed_domains_template", value)

    @_builtins.property
    @pulumi.getter(name="allowedExtensions")
    def allowed_extensions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comma-separated list of extensions that certificates can have when signed.
        """
        return pulumi.get(self, "allowed_extensions")

    @allowed_extensions.setter
    def allowed_extensions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allowed_extensions", value)

    @_builtins.property
    @pulumi.getter(name="allowedUserKeyConfigs")
    def allowed_user_key_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretBackendRoleAllowedUserKeyConfigArgs']]]]:
        """
        Set of configuration blocks to define allowed  
        user key configuration, like key type and their lengths. Can be specified multiple times.
        *See Configuration-Options for more info*
        """
        return pulumi.get(self, "allowed_user_key_configs")

    @allowed_user_key_configs.setter
    def allowed_user_key_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretBackendRoleAllowedUserKeyConfigArgs']]]]):
        pulumi.set(self, "allowed_user_key_configs", value)

    @_builtins.property
    @pulumi.getter(name="allowedUsers")
    def allowed_users(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comma-separated list of usernames that are to be allowed, only if certain usernames are to be allowed.
        """
        return pulumi.get(self, "allowed_users")

    @allowed_users.setter
    def allowed_users(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allowed_users", value)

    @_builtins.property
    @pulumi.getter(name="allowedUsersTemplate")
    def allowed_users_template(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if `allowed_users` can be declared using identity template policies. Non-templated users are also permitted.
        """
        return pulumi.get(self, "allowed_users_template")

    @allowed_users_template.setter
    def allowed_users_template(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allowed_users_template", value)

    @_builtins.property
    @pulumi.getter(name="cidrList")
    def cidr_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The comma-separated string of CIDR blocks for which this role is applicable.
        """
        return pulumi.get(self, "cidr_list")

    @cidr_list.setter
    def cidr_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cidr_list", value)

    @_builtins.property
    @pulumi.getter(name="defaultCriticalOptions")
    def default_critical_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies a map of critical options that certificates have when signed.
        """
        return pulumi.get(self, "default_critical_options")

    @default_critical_options.setter
    def default_critical_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "default_critical_options", value)

    @_builtins.property
    @pulumi.getter(name="defaultExtensions")
    def default_extensions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies a map of extensions that certificates have when signed.
        """
        return pulumi.get(self, "default_extensions")

    @default_extensions.setter
    def default_extensions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "default_extensions", value)

    @_builtins.property
    @pulumi.getter(name="defaultUser")
    def default_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default username for which a credential will be generated.
        """
        return pulumi.get(self, "default_user")

    @default_user.setter
    def default_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_user", value)

    @_builtins.property
    @pulumi.getter(name="defaultUserTemplate")
    def default_user_template(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, `default_users` can be specified using identity template values. A non-templated user is also permitted.
        """
        return pulumi.get(self, "default_user_template")

    @default_user_template.setter
    def default_user_template(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default_user_template", value)

    @_builtins.property
    @pulumi.getter(name="keyIdFormat")
    def key_id_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a custom format for the key id of a signed certificate.
        """
        return pulumi.get(self, "key_id_format")

    @key_id_format.setter
    def key_id_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_id_format", value)

    @_builtins.property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the maximum Time To Live value.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_ttl", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the role to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="notBeforeDuration")
    def not_before_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the duration by which to backdate the ValidAfter property. Uses duration format strings.
        """
        return pulumi.get(self, "not_before_duration")

    @not_before_duration.setter
    def not_before_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "not_before_duration", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Time To Live value.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _SecretBackendRoleState:
    def __init__(__self__, *,
                 algorithm_signer: Optional[pulumi.Input[_builtins.str]] = None,
                 allow_bare_domains: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_empty_principals: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_host_certificates: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_subdomains: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_certificates: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_key_ids: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_critical_options: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_domains: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_domains_template: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_extensions: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_user_key_configs: Optional[pulumi.Input[Sequence[pulumi.Input['SecretBackendRoleAllowedUserKeyConfigArgs']]]] = None,
                 allowed_users: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_users_template: Optional[pulumi.Input[_builtins.bool]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 cidr_list: Optional[pulumi.Input[_builtins.str]] = None,
                 default_critical_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 default_extensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 default_user: Optional[pulumi.Input[_builtins.str]] = None,
                 default_user_template: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_id_format: Optional[pulumi.Input[_builtins.str]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 not_before_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecretBackendRole resources.
        :param pulumi.Input[_builtins.str] algorithm_signer: When supplied, this value specifies a signing algorithm for the key. Possible values: ssh-rsa, rsa-sha2-256, rsa-sha2-512.
        :param pulumi.Input[_builtins.bool] allow_bare_domains: Specifies if host certificates that are requested are allowed to use the base domains listed in `allowed_domains`.
        :param pulumi.Input[_builtins.bool] allow_empty_principals: Allow signing certificates with no
               valid principals (e.g. any valid principal). For backwards compatibility
               only. The default of false is highly recommended.
        :param pulumi.Input[_builtins.bool] allow_host_certificates: Specifies if certificates are allowed to be signed for use as a 'host'.
        :param pulumi.Input[_builtins.bool] allow_subdomains: Specifies if host certificates that are requested are allowed to be subdomains of those listed in `allowed_domains`.
        :param pulumi.Input[_builtins.bool] allow_user_certificates: Specifies if certificates are allowed to be signed for use as a 'user'.
        :param pulumi.Input[_builtins.bool] allow_user_key_ids: Specifies if users can override the key ID for a signed certificate with the `key_id` field.
        :param pulumi.Input[_builtins.str] allowed_critical_options: Specifies a comma-separated list of critical options that certificates can have when signed.
        :param pulumi.Input[_builtins.str] allowed_domains: The list of domains for which a client can request a host certificate.
        :param pulumi.Input[_builtins.bool] allowed_domains_template: Specifies if `allowed_domains` can be declared using
               identity template policies. Non-templated domains are also permitted.
        :param pulumi.Input[_builtins.str] allowed_extensions: Specifies a comma-separated list of extensions that certificates can have when signed.
        :param pulumi.Input[Sequence[pulumi.Input['SecretBackendRoleAllowedUserKeyConfigArgs']]] allowed_user_key_configs: Set of configuration blocks to define allowed  
               user key configuration, like key type and their lengths. Can be specified multiple times.
               *See Configuration-Options for more info*
        :param pulumi.Input[_builtins.str] allowed_users: Specifies a comma-separated list of usernames that are to be allowed, only if certain usernames are to be allowed.
        :param pulumi.Input[_builtins.bool] allowed_users_template: Specifies if `allowed_users` can be declared using identity template policies. Non-templated users are also permitted.
        :param pulumi.Input[_builtins.str] backend: The path where the SSH secret backend is mounted.
        :param pulumi.Input[_builtins.str] cidr_list: The comma-separated string of CIDR blocks for which this role is applicable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] default_critical_options: Specifies a map of critical options that certificates have when signed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] default_extensions: Specifies a map of extensions that certificates have when signed.
        :param pulumi.Input[_builtins.str] default_user: Specifies the default username for which a credential will be generated.
        :param pulumi.Input[_builtins.bool] default_user_template: If set, `default_users` can be specified using identity template values. A non-templated user is also permitted.
        :param pulumi.Input[_builtins.str] key_id_format: Specifies a custom format for the key id of a signed certificate.
        :param pulumi.Input[_builtins.str] key_type: Specifies the type of credentials generated by this role. This can be either `otp`, `dynamic` or `ca`.
        :param pulumi.Input[_builtins.str] max_ttl: Specifies the maximum Time To Live value.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the role to create.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] not_before_duration: Specifies the duration by which to backdate the ValidAfter property. Uses duration format strings.
        :param pulumi.Input[_builtins.str] ttl: Specifies the Time To Live value.
        """
        if algorithm_signer is not None:
            pulumi.set(__self__, "algorithm_signer", algorithm_signer)
        if allow_bare_domains is not None:
            pulumi.set(__self__, "allow_bare_domains", allow_bare_domains)
        if allow_empty_principals is not None:
            pulumi.set(__self__, "allow_empty_principals", allow_empty_principals)
        if allow_host_certificates is not None:
            pulumi.set(__self__, "allow_host_certificates", allow_host_certificates)
        if allow_subdomains is not None:
            pulumi.set(__self__, "allow_subdomains", allow_subdomains)
        if allow_user_certificates is not None:
            pulumi.set(__self__, "allow_user_certificates", allow_user_certificates)
        if allow_user_key_ids is not None:
            pulumi.set(__self__, "allow_user_key_ids", allow_user_key_ids)
        if allowed_critical_options is not None:
            pulumi.set(__self__, "allowed_critical_options", allowed_critical_options)
        if allowed_domains is not None:
            pulumi.set(__self__, "allowed_domains", allowed_domains)
        if allowed_domains_template is not None:
            pulumi.set(__self__, "allowed_domains_template", allowed_domains_template)
        if allowed_extensions is not None:
            pulumi.set(__self__, "allowed_extensions", allowed_extensions)
        if allowed_user_key_configs is not None:
            pulumi.set(__self__, "allowed_user_key_configs", allowed_user_key_configs)
        if allowed_users is not None:
            pulumi.set(__self__, "allowed_users", allowed_users)
        if allowed_users_template is not None:
            pulumi.set(__self__, "allowed_users_template", allowed_users_template)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if cidr_list is not None:
            pulumi.set(__self__, "cidr_list", cidr_list)
        if default_critical_options is not None:
            pulumi.set(__self__, "default_critical_options", default_critical_options)
        if default_extensions is not None:
            pulumi.set(__self__, "default_extensions", default_extensions)
        if default_user is not None:
            pulumi.set(__self__, "default_user", default_user)
        if default_user_template is not None:
            pulumi.set(__self__, "default_user_template", default_user_template)
        if key_id_format is not None:
            pulumi.set(__self__, "key_id_format", key_id_format)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if not_before_duration is not None:
            pulumi.set(__self__, "not_before_duration", not_before_duration)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter(name="algorithmSigner")
    def algorithm_signer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When supplied, this value specifies a signing algorithm for the key. Possible values: ssh-rsa, rsa-sha2-256, rsa-sha2-512.
        """
        return pulumi.get(self, "algorithm_signer")

    @algorithm_signer.setter
    def algorithm_signer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "algorithm_signer", value)

    @_builtins.property
    @pulumi.getter(name="allowBareDomains")
    def allow_bare_domains(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if host certificates that are requested are allowed to use the base domains listed in `allowed_domains`.
        """
        return pulumi.get(self, "allow_bare_domains")

    @allow_bare_domains.setter
    def allow_bare_domains(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_bare_domains", value)

    @_builtins.property
    @pulumi.getter(name="allowEmptyPrincipals")
    def allow_empty_principals(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow signing certificates with no
        valid principals (e.g. any valid principal). For backwards compatibility
        only. The default of false is highly recommended.
        """
        return pulumi.get(self, "allow_empty_principals")

    @allow_empty_principals.setter
    def allow_empty_principals(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_empty_principals", value)

    @_builtins.property
    @pulumi.getter(name="allowHostCertificates")
    def allow_host_certificates(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if certificates are allowed to be signed for use as a 'host'.
        """
        return pulumi.get(self, "allow_host_certificates")

    @allow_host_certificates.setter
    def allow_host_certificates(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_host_certificates", value)

    @_builtins.property
    @pulumi.getter(name="allowSubdomains")
    def allow_subdomains(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if host certificates that are requested are allowed to be subdomains of those listed in `allowed_domains`.
        """
        return pulumi.get(self, "allow_subdomains")

    @allow_subdomains.setter
    def allow_subdomains(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_subdomains", value)

    @_builtins.property
    @pulumi.getter(name="allowUserCertificates")
    def allow_user_certificates(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if certificates are allowed to be signed for use as a 'user'.
        """
        return pulumi.get(self, "allow_user_certificates")

    @allow_user_certificates.setter
    def allow_user_certificates(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_user_certificates", value)

    @_builtins.property
    @pulumi.getter(name="allowUserKeyIds")
    def allow_user_key_ids(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if users can override the key ID for a signed certificate with the `key_id` field.
        """
        return pulumi.get(self, "allow_user_key_ids")

    @allow_user_key_ids.setter
    def allow_user_key_ids(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_user_key_ids", value)

    @_builtins.property
    @pulumi.getter(name="allowedCriticalOptions")
    def allowed_critical_options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comma-separated list of critical options that certificates can have when signed.
        """
        return pulumi.get(self, "allowed_critical_options")

    @allowed_critical_options.setter
    def allowed_critical_options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allowed_critical_options", value)

    @_builtins.property
    @pulumi.getter(name="allowedDomains")
    def allowed_domains(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The list of domains for which a client can request a host certificate.
        """
        return pulumi.get(self, "allowed_domains")

    @allowed_domains.setter
    def allowed_domains(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allowed_domains", value)

    @_builtins.property
    @pulumi.getter(name="allowedDomainsTemplate")
    def allowed_domains_template(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if `allowed_domains` can be declared using
        identity template policies. Non-templated domains are also permitted.
        """
        return pulumi.get(self, "allowed_domains_template")

    @allowed_domains_template.setter
    def allowed_domains_template(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allowed_domains_template", value)

    @_builtins.property
    @pulumi.getter(name="allowedExtensions")
    def allowed_extensions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comma-separated list of extensions that certificates can have when signed.
        """
        return pulumi.get(self, "allowed_extensions")

    @allowed_extensions.setter
    def allowed_extensions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allowed_extensions", value)

    @_builtins.property
    @pulumi.getter(name="allowedUserKeyConfigs")
    def allowed_user_key_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretBackendRoleAllowedUserKeyConfigArgs']]]]:
        """
        Set of configuration blocks to define allowed  
        user key configuration, like key type and their lengths. Can be specified multiple times.
        *See Configuration-Options for more info*
        """
        return pulumi.get(self, "allowed_user_key_configs")

    @allowed_user_key_configs.setter
    def allowed_user_key_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretBackendRoleAllowedUserKeyConfigArgs']]]]):
        pulumi.set(self, "allowed_user_key_configs", value)

    @_builtins.property
    @pulumi.getter(name="allowedUsers")
    def allowed_users(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comma-separated list of usernames that are to be allowed, only if certain usernames are to be allowed.
        """
        return pulumi.get(self, "allowed_users")

    @allowed_users.setter
    def allowed_users(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allowed_users", value)

    @_builtins.property
    @pulumi.getter(name="allowedUsersTemplate")
    def allowed_users_template(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if `allowed_users` can be declared using identity template policies. Non-templated users are also permitted.
        """
        return pulumi.get(self, "allowed_users_template")

    @allowed_users_template.setter
    def allowed_users_template(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allowed_users_template", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path where the SSH secret backend is mounted.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="cidrList")
    def cidr_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The comma-separated string of CIDR blocks for which this role is applicable.
        """
        return pulumi.get(self, "cidr_list")

    @cidr_list.setter
    def cidr_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cidr_list", value)

    @_builtins.property
    @pulumi.getter(name="defaultCriticalOptions")
    def default_critical_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies a map of critical options that certificates have when signed.
        """
        return pulumi.get(self, "default_critical_options")

    @default_critical_options.setter
    def default_critical_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "default_critical_options", value)

    @_builtins.property
    @pulumi.getter(name="defaultExtensions")
    def default_extensions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies a map of extensions that certificates have when signed.
        """
        return pulumi.get(self, "default_extensions")

    @default_extensions.setter
    def default_extensions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "default_extensions", value)

    @_builtins.property
    @pulumi.getter(name="defaultUser")
    def default_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default username for which a credential will be generated.
        """
        return pulumi.get(self, "default_user")

    @default_user.setter
    def default_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_user", value)

    @_builtins.property
    @pulumi.getter(name="defaultUserTemplate")
    def default_user_template(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, `default_users` can be specified using identity template values. A non-templated user is also permitted.
        """
        return pulumi.get(self, "default_user_template")

    @default_user_template.setter
    def default_user_template(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default_user_template", value)

    @_builtins.property
    @pulumi.getter(name="keyIdFormat")
    def key_id_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a custom format for the key id of a signed certificate.
        """
        return pulumi.get(self, "key_id_format")

    @key_id_format.setter
    def key_id_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_id_format", value)

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of credentials generated by this role. This can be either `otp`, `dynamic` or `ca`.
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_type", value)

    @_builtins.property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the maximum Time To Live value.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_ttl", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the role to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="notBeforeDuration")
    def not_before_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the duration by which to backdate the ValidAfter property. Uses duration format strings.
        """
        return pulumi.get(self, "not_before_duration")

    @not_before_duration.setter
    def not_before_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "not_before_duration", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Time To Live value.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ttl", value)


@pulumi.type_token("vault:ssh/secretBackendRole:SecretBackendRole")
class SecretBackendRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm_signer: Optional[pulumi.Input[_builtins.str]] = None,
                 allow_bare_domains: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_empty_principals: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_host_certificates: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_subdomains: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_certificates: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_key_ids: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_critical_options: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_domains: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_domains_template: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_extensions: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_user_key_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretBackendRoleAllowedUserKeyConfigArgs', 'SecretBackendRoleAllowedUserKeyConfigArgsDict']]]]] = None,
                 allowed_users: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_users_template: Optional[pulumi.Input[_builtins.bool]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 cidr_list: Optional[pulumi.Input[_builtins.str]] = None,
                 default_critical_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 default_extensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 default_user: Optional[pulumi.Input[_builtins.str]] = None,
                 default_user_template: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_id_format: Optional[pulumi.Input[_builtins.str]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 not_before_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to manage roles in an SSH secret backend
        [SSH secret backend within Vault](https://www.vaultproject.io/docs/secrets/ssh/index.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.Mount("example", type="ssh")
        foo = vault.ssh.SecretBackendRole("foo",
            name="my-role",
            backend=example.path,
            key_type="ca",
            allow_user_certificates=True)
        bar = vault.ssh.SecretBackendRole("bar",
            name="otp-role",
            backend=example.path,
            key_type="otp",
            default_user="default",
            allowed_users="default,baz",
            cidr_list="0.0.0.0/0")
        ```

        ## Import

        SSH secret backend roles can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:ssh/secretBackendRole:SecretBackendRole foo ssh/roles/my-role
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] algorithm_signer: When supplied, this value specifies a signing algorithm for the key. Possible values: ssh-rsa, rsa-sha2-256, rsa-sha2-512.
        :param pulumi.Input[_builtins.bool] allow_bare_domains: Specifies if host certificates that are requested are allowed to use the base domains listed in `allowed_domains`.
        :param pulumi.Input[_builtins.bool] allow_empty_principals: Allow signing certificates with no
               valid principals (e.g. any valid principal). For backwards compatibility
               only. The default of false is highly recommended.
        :param pulumi.Input[_builtins.bool] allow_host_certificates: Specifies if certificates are allowed to be signed for use as a 'host'.
        :param pulumi.Input[_builtins.bool] allow_subdomains: Specifies if host certificates that are requested are allowed to be subdomains of those listed in `allowed_domains`.
        :param pulumi.Input[_builtins.bool] allow_user_certificates: Specifies if certificates are allowed to be signed for use as a 'user'.
        :param pulumi.Input[_builtins.bool] allow_user_key_ids: Specifies if users can override the key ID for a signed certificate with the `key_id` field.
        :param pulumi.Input[_builtins.str] allowed_critical_options: Specifies a comma-separated list of critical options that certificates can have when signed.
        :param pulumi.Input[_builtins.str] allowed_domains: The list of domains for which a client can request a host certificate.
        :param pulumi.Input[_builtins.bool] allowed_domains_template: Specifies if `allowed_domains` can be declared using
               identity template policies. Non-templated domains are also permitted.
        :param pulumi.Input[_builtins.str] allowed_extensions: Specifies a comma-separated list of extensions that certificates can have when signed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretBackendRoleAllowedUserKeyConfigArgs', 'SecretBackendRoleAllowedUserKeyConfigArgsDict']]]] allowed_user_key_configs: Set of configuration blocks to define allowed  
               user key configuration, like key type and their lengths. Can be specified multiple times.
               *See Configuration-Options for more info*
        :param pulumi.Input[_builtins.str] allowed_users: Specifies a comma-separated list of usernames that are to be allowed, only if certain usernames are to be allowed.
        :param pulumi.Input[_builtins.bool] allowed_users_template: Specifies if `allowed_users` can be declared using identity template policies. Non-templated users are also permitted.
        :param pulumi.Input[_builtins.str] backend: The path where the SSH secret backend is mounted.
        :param pulumi.Input[_builtins.str] cidr_list: The comma-separated string of CIDR blocks for which this role is applicable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] default_critical_options: Specifies a map of critical options that certificates have when signed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] default_extensions: Specifies a map of extensions that certificates have when signed.
        :param pulumi.Input[_builtins.str] default_user: Specifies the default username for which a credential will be generated.
        :param pulumi.Input[_builtins.bool] default_user_template: If set, `default_users` can be specified using identity template values. A non-templated user is also permitted.
        :param pulumi.Input[_builtins.str] key_id_format: Specifies a custom format for the key id of a signed certificate.
        :param pulumi.Input[_builtins.str] key_type: Specifies the type of credentials generated by this role. This can be either `otp`, `dynamic` or `ca`.
        :param pulumi.Input[_builtins.str] max_ttl: Specifies the maximum Time To Live value.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the role to create.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] not_before_duration: Specifies the duration by which to backdate the ValidAfter property. Uses duration format strings.
        :param pulumi.Input[_builtins.str] ttl: Specifies the Time To Live value.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage roles in an SSH secret backend
        [SSH secret backend within Vault](https://www.vaultproject.io/docs/secrets/ssh/index.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.Mount("example", type="ssh")
        foo = vault.ssh.SecretBackendRole("foo",
            name="my-role",
            backend=example.path,
            key_type="ca",
            allow_user_certificates=True)
        bar = vault.ssh.SecretBackendRole("bar",
            name="otp-role",
            backend=example.path,
            key_type="otp",
            default_user="default",
            allowed_users="default,baz",
            cidr_list="0.0.0.0/0")
        ```

        ## Import

        SSH secret backend roles can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:ssh/secretBackendRole:SecretBackendRole foo ssh/roles/my-role
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm_signer: Optional[pulumi.Input[_builtins.str]] = None,
                 allow_bare_domains: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_empty_principals: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_host_certificates: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_subdomains: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_certificates: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_user_key_ids: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_critical_options: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_domains: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_domains_template: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_extensions: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_user_key_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretBackendRoleAllowedUserKeyConfigArgs', 'SecretBackendRoleAllowedUserKeyConfigArgsDict']]]]] = None,
                 allowed_users: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_users_template: Optional[pulumi.Input[_builtins.bool]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 cidr_list: Optional[pulumi.Input[_builtins.str]] = None,
                 default_critical_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 default_extensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 default_user: Optional[pulumi.Input[_builtins.str]] = None,
                 default_user_template: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_id_format: Optional[pulumi.Input[_builtins.str]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 not_before_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendRoleArgs.__new__(SecretBackendRoleArgs)

            __props__.__dict__["algorithm_signer"] = algorithm_signer
            __props__.__dict__["allow_bare_domains"] = allow_bare_domains
            __props__.__dict__["allow_empty_principals"] = allow_empty_principals
            __props__.__dict__["allow_host_certificates"] = allow_host_certificates
            __props__.__dict__["allow_subdomains"] = allow_subdomains
            __props__.__dict__["allow_user_certificates"] = allow_user_certificates
            __props__.__dict__["allow_user_key_ids"] = allow_user_key_ids
            __props__.__dict__["allowed_critical_options"] = allowed_critical_options
            __props__.__dict__["allowed_domains"] = allowed_domains
            __props__.__dict__["allowed_domains_template"] = allowed_domains_template
            __props__.__dict__["allowed_extensions"] = allowed_extensions
            __props__.__dict__["allowed_user_key_configs"] = allowed_user_key_configs
            __props__.__dict__["allowed_users"] = allowed_users
            __props__.__dict__["allowed_users_template"] = allowed_users_template
            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            __props__.__dict__["cidr_list"] = cidr_list
            __props__.__dict__["default_critical_options"] = default_critical_options
            __props__.__dict__["default_extensions"] = default_extensions
            __props__.__dict__["default_user"] = default_user
            __props__.__dict__["default_user_template"] = default_user_template
            __props__.__dict__["key_id_format"] = key_id_format
            if key_type is None and not opts.urn:
                raise TypeError("Missing required property 'key_type'")
            __props__.__dict__["key_type"] = key_type
            __props__.__dict__["max_ttl"] = max_ttl
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["not_before_duration"] = not_before_duration
            __props__.__dict__["ttl"] = ttl
        super(SecretBackendRole, __self__).__init__(
            'vault:ssh/secretBackendRole:SecretBackendRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            algorithm_signer: Optional[pulumi.Input[_builtins.str]] = None,
            allow_bare_domains: Optional[pulumi.Input[_builtins.bool]] = None,
            allow_empty_principals: Optional[pulumi.Input[_builtins.bool]] = None,
            allow_host_certificates: Optional[pulumi.Input[_builtins.bool]] = None,
            allow_subdomains: Optional[pulumi.Input[_builtins.bool]] = None,
            allow_user_certificates: Optional[pulumi.Input[_builtins.bool]] = None,
            allow_user_key_ids: Optional[pulumi.Input[_builtins.bool]] = None,
            allowed_critical_options: Optional[pulumi.Input[_builtins.str]] = None,
            allowed_domains: Optional[pulumi.Input[_builtins.str]] = None,
            allowed_domains_template: Optional[pulumi.Input[_builtins.bool]] = None,
            allowed_extensions: Optional[pulumi.Input[_builtins.str]] = None,
            allowed_user_key_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretBackendRoleAllowedUserKeyConfigArgs', 'SecretBackendRoleAllowedUserKeyConfigArgsDict']]]]] = None,
            allowed_users: Optional[pulumi.Input[_builtins.str]] = None,
            allowed_users_template: Optional[pulumi.Input[_builtins.bool]] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            cidr_list: Optional[pulumi.Input[_builtins.str]] = None,
            default_critical_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            default_extensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            default_user: Optional[pulumi.Input[_builtins.str]] = None,
            default_user_template: Optional[pulumi.Input[_builtins.bool]] = None,
            key_id_format: Optional[pulumi.Input[_builtins.str]] = None,
            key_type: Optional[pulumi.Input[_builtins.str]] = None,
            max_ttl: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            not_before_duration: Optional[pulumi.Input[_builtins.str]] = None,
            ttl: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecretBackendRole':
        """
        Get an existing SecretBackendRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] algorithm_signer: When supplied, this value specifies a signing algorithm for the key. Possible values: ssh-rsa, rsa-sha2-256, rsa-sha2-512.
        :param pulumi.Input[_builtins.bool] allow_bare_domains: Specifies if host certificates that are requested are allowed to use the base domains listed in `allowed_domains`.
        :param pulumi.Input[_builtins.bool] allow_empty_principals: Allow signing certificates with no
               valid principals (e.g. any valid principal). For backwards compatibility
               only. The default of false is highly recommended.
        :param pulumi.Input[_builtins.bool] allow_host_certificates: Specifies if certificates are allowed to be signed for use as a 'host'.
        :param pulumi.Input[_builtins.bool] allow_subdomains: Specifies if host certificates that are requested are allowed to be subdomains of those listed in `allowed_domains`.
        :param pulumi.Input[_builtins.bool] allow_user_certificates: Specifies if certificates are allowed to be signed for use as a 'user'.
        :param pulumi.Input[_builtins.bool] allow_user_key_ids: Specifies if users can override the key ID for a signed certificate with the `key_id` field.
        :param pulumi.Input[_builtins.str] allowed_critical_options: Specifies a comma-separated list of critical options that certificates can have when signed.
        :param pulumi.Input[_builtins.str] allowed_domains: The list of domains for which a client can request a host certificate.
        :param pulumi.Input[_builtins.bool] allowed_domains_template: Specifies if `allowed_domains` can be declared using
               identity template policies. Non-templated domains are also permitted.
        :param pulumi.Input[_builtins.str] allowed_extensions: Specifies a comma-separated list of extensions that certificates can have when signed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretBackendRoleAllowedUserKeyConfigArgs', 'SecretBackendRoleAllowedUserKeyConfigArgsDict']]]] allowed_user_key_configs: Set of configuration blocks to define allowed  
               user key configuration, like key type and their lengths. Can be specified multiple times.
               *See Configuration-Options for more info*
        :param pulumi.Input[_builtins.str] allowed_users: Specifies a comma-separated list of usernames that are to be allowed, only if certain usernames are to be allowed.
        :param pulumi.Input[_builtins.bool] allowed_users_template: Specifies if `allowed_users` can be declared using identity template policies. Non-templated users are also permitted.
        :param pulumi.Input[_builtins.str] backend: The path where the SSH secret backend is mounted.
        :param pulumi.Input[_builtins.str] cidr_list: The comma-separated string of CIDR blocks for which this role is applicable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] default_critical_options: Specifies a map of critical options that certificates have when signed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] default_extensions: Specifies a map of extensions that certificates have when signed.
        :param pulumi.Input[_builtins.str] default_user: Specifies the default username for which a credential will be generated.
        :param pulumi.Input[_builtins.bool] default_user_template: If set, `default_users` can be specified using identity template values. A non-templated user is also permitted.
        :param pulumi.Input[_builtins.str] key_id_format: Specifies a custom format for the key id of a signed certificate.
        :param pulumi.Input[_builtins.str] key_type: Specifies the type of credentials generated by this role. This can be either `otp`, `dynamic` or `ca`.
        :param pulumi.Input[_builtins.str] max_ttl: Specifies the maximum Time To Live value.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the role to create.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] not_before_duration: Specifies the duration by which to backdate the ValidAfter property. Uses duration format strings.
        :param pulumi.Input[_builtins.str] ttl: Specifies the Time To Live value.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendRoleState.__new__(_SecretBackendRoleState)

        __props__.__dict__["algorithm_signer"] = algorithm_signer
        __props__.__dict__["allow_bare_domains"] = allow_bare_domains
        __props__.__dict__["allow_empty_principals"] = allow_empty_principals
        __props__.__dict__["allow_host_certificates"] = allow_host_certificates
        __props__.__dict__["allow_subdomains"] = allow_subdomains
        __props__.__dict__["allow_user_certificates"] = allow_user_certificates
        __props__.__dict__["allow_user_key_ids"] = allow_user_key_ids
        __props__.__dict__["allowed_critical_options"] = allowed_critical_options
        __props__.__dict__["allowed_domains"] = allowed_domains
        __props__.__dict__["allowed_domains_template"] = allowed_domains_template
        __props__.__dict__["allowed_extensions"] = allowed_extensions
        __props__.__dict__["allowed_user_key_configs"] = allowed_user_key_configs
        __props__.__dict__["allowed_users"] = allowed_users
        __props__.__dict__["allowed_users_template"] = allowed_users_template
        __props__.__dict__["backend"] = backend
        __props__.__dict__["cidr_list"] = cidr_list
        __props__.__dict__["default_critical_options"] = default_critical_options
        __props__.__dict__["default_extensions"] = default_extensions
        __props__.__dict__["default_user"] = default_user
        __props__.__dict__["default_user_template"] = default_user_template
        __props__.__dict__["key_id_format"] = key_id_format
        __props__.__dict__["key_type"] = key_type
        __props__.__dict__["max_ttl"] = max_ttl
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["not_before_duration"] = not_before_duration
        __props__.__dict__["ttl"] = ttl
        return SecretBackendRole(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="algorithmSigner")
    def algorithm_signer(self) -> pulumi.Output[_builtins.str]:
        """
        When supplied, this value specifies a signing algorithm for the key. Possible values: ssh-rsa, rsa-sha2-256, rsa-sha2-512.
        """
        return pulumi.get(self, "algorithm_signer")

    @_builtins.property
    @pulumi.getter(name="allowBareDomains")
    def allow_bare_domains(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if host certificates that are requested are allowed to use the base domains listed in `allowed_domains`.
        """
        return pulumi.get(self, "allow_bare_domains")

    @_builtins.property
    @pulumi.getter(name="allowEmptyPrincipals")
    def allow_empty_principals(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Allow signing certificates with no
        valid principals (e.g. any valid principal). For backwards compatibility
        only. The default of false is highly recommended.
        """
        return pulumi.get(self, "allow_empty_principals")

    @_builtins.property
    @pulumi.getter(name="allowHostCertificates")
    def allow_host_certificates(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if certificates are allowed to be signed for use as a 'host'.
        """
        return pulumi.get(self, "allow_host_certificates")

    @_builtins.property
    @pulumi.getter(name="allowSubdomains")
    def allow_subdomains(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if host certificates that are requested are allowed to be subdomains of those listed in `allowed_domains`.
        """
        return pulumi.get(self, "allow_subdomains")

    @_builtins.property
    @pulumi.getter(name="allowUserCertificates")
    def allow_user_certificates(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if certificates are allowed to be signed for use as a 'user'.
        """
        return pulumi.get(self, "allow_user_certificates")

    @_builtins.property
    @pulumi.getter(name="allowUserKeyIds")
    def allow_user_key_ids(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if users can override the key ID for a signed certificate with the `key_id` field.
        """
        return pulumi.get(self, "allow_user_key_ids")

    @_builtins.property
    @pulumi.getter(name="allowedCriticalOptions")
    def allowed_critical_options(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a comma-separated list of critical options that certificates can have when signed.
        """
        return pulumi.get(self, "allowed_critical_options")

    @_builtins.property
    @pulumi.getter(name="allowedDomains")
    def allowed_domains(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The list of domains for which a client can request a host certificate.
        """
        return pulumi.get(self, "allowed_domains")

    @_builtins.property
    @pulumi.getter(name="allowedDomainsTemplate")
    def allowed_domains_template(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies if `allowed_domains` can be declared using
        identity template policies. Non-templated domains are also permitted.
        """
        return pulumi.get(self, "allowed_domains_template")

    @_builtins.property
    @pulumi.getter(name="allowedExtensions")
    def allowed_extensions(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a comma-separated list of extensions that certificates can have when signed.
        """
        return pulumi.get(self, "allowed_extensions")

    @_builtins.property
    @pulumi.getter(name="allowedUserKeyConfigs")
    def allowed_user_key_configs(self) -> pulumi.Output[Optional[Sequence['outputs.SecretBackendRoleAllowedUserKeyConfig']]]:
        """
        Set of configuration blocks to define allowed  
        user key configuration, like key type and their lengths. Can be specified multiple times.
        *See Configuration-Options for more info*
        """
        return pulumi.get(self, "allowed_user_key_configs")

    @_builtins.property
    @pulumi.getter(name="allowedUsers")
    def allowed_users(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a comma-separated list of usernames that are to be allowed, only if certain usernames are to be allowed.
        """
        return pulumi.get(self, "allowed_users")

    @_builtins.property
    @pulumi.getter(name="allowedUsersTemplate")
    def allowed_users_template(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if `allowed_users` can be declared using identity template policies. Non-templated users are also permitted.
        """
        return pulumi.get(self, "allowed_users_template")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[_builtins.str]:
        """
        The path where the SSH secret backend is mounted.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="cidrList")
    def cidr_list(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The comma-separated string of CIDR blocks for which this role is applicable.
        """
        return pulumi.get(self, "cidr_list")

    @_builtins.property
    @pulumi.getter(name="defaultCriticalOptions")
    def default_critical_options(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies a map of critical options that certificates have when signed.
        """
        return pulumi.get(self, "default_critical_options")

    @_builtins.property
    @pulumi.getter(name="defaultExtensions")
    def default_extensions(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies a map of extensions that certificates have when signed.
        """
        return pulumi.get(self, "default_extensions")

    @_builtins.property
    @pulumi.getter(name="defaultUser")
    def default_user(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the default username for which a credential will be generated.
        """
        return pulumi.get(self, "default_user")

    @_builtins.property
    @pulumi.getter(name="defaultUserTemplate")
    def default_user_template(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set, `default_users` can be specified using identity template values. A non-templated user is also permitted.
        """
        return pulumi.get(self, "default_user_template")

    @_builtins.property
    @pulumi.getter(name="keyIdFormat")
    def key_id_format(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a custom format for the key id of a signed certificate.
        """
        return pulumi.get(self, "key_id_format")

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the type of credentials generated by this role. This can be either `otp`, `dynamic` or `ca`.
        """
        return pulumi.get(self, "key_type")

    @_builtins.property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the maximum Time To Live value.
        """
        return pulumi.get(self, "max_ttl")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the role to create.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="notBeforeDuration")
    def not_before_duration(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the duration by which to backdate the ValidAfter property. Uses duration format strings.
        """
        return pulumi.get(self, "not_before_duration")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Time To Live value.
        """
        return pulumi.get(self, "ttl")

