# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretBackendKeyArgs', 'SecretBackendKey']

@pulumi.input_type
class SecretBackendKeyArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[_builtins.str],
                 allow_plaintext_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_rotate_period: Optional[pulumi.Input[_builtins.int]] = None,
                 convergent_encryption: Optional[pulumi.Input[_builtins.bool]] = None,
                 deletion_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 derived: Optional[pulumi.Input[_builtins.bool]] = None,
                 exportable: Optional[pulumi.Input[_builtins.bool]] = None,
                 hybrid_key_type_ec: Optional[pulumi.Input[_builtins.str]] = None,
                 hybrid_key_type_pqc: Optional[pulumi.Input[_builtins.str]] = None,
                 key_size: Optional[pulumi.Input[_builtins.int]] = None,
                 min_decryption_version: Optional[pulumi.Input[_builtins.int]] = None,
                 min_encryption_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_set: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SecretBackendKey resource.
        :param pulumi.Input[_builtins.str] backend: The path the transit secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.bool] allow_plaintext_backup: Enables taking backup of entire keyring in the plaintext format. Once set, this cannot be disabled.
               * Refer to Vault API documentation on key backups for more information: [Backup Key](https://www.vaultproject.io/api-docs/secret/transit#backup-key)
        :param pulumi.Input[_builtins.int] auto_rotate_period: Amount of seconds the key should live before being automatically rotated.
               A value of 0 disables automatic rotation for the key.
        :param pulumi.Input[_builtins.bool] convergent_encryption: Whether or not to support convergent encryption, where the same plaintext creates the same ciphertext. This requires `derived` to be set to `true`.
        :param pulumi.Input[_builtins.bool] deletion_allowed: Specifies if the key is allowed to be deleted.
        :param pulumi.Input[_builtins.bool] derived: Specifies if key derivation is to be used. If enabled, all encrypt/decrypt requests to this key must provide a context which is used for key derivation.
        :param pulumi.Input[_builtins.bool] exportable: Enables keys to be exportable. This allows for all valid private keys in the keyring to be exported. Once set, this cannot be disabled.
        :param pulumi.Input[_builtins.str] hybrid_key_type_ec: The elliptic curve algorithm to use for hybrid signatures.
               Supported key types are `ecdsa-p256`, `ecdsa-p384`, `ecdsa-p521`, and `ed25519`.
        :param pulumi.Input[_builtins.str] hybrid_key_type_pqc: The post-quantum algorithm to use for hybrid signatures.
               Currently, ML-DSA is the only supported key type.
        :param pulumi.Input[_builtins.int] key_size: The key size in bytes for algorithms that allow variable key sizes. Currently only applicable to HMAC, where it must be between 32 and 512 bytes.
        :param pulumi.Input[_builtins.int] min_decryption_version: Minimum key version to use for decryption.
        :param pulumi.Input[_builtins.int] min_encryption_version: Minimum key version to use for encryption
        :param pulumi.Input[_builtins.str] name: The name to identify this key within the backend. Must be unique within the backend.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] parameter_set: The parameter set to use for ML-DSA. Required for
               ML-DSA and hybrid keys. Valid values are `44`, `65`, and `87`.
        :param pulumi.Input[_builtins.str] type: Specifies the type of key to create. The currently-supported types are: `aes128-gcm96`, `aes256-gcm96` (default), `chacha20-poly1305`, `ed25519`, `ecdsa-p256`, `ecdsa-p384`, `ecdsa-p521`, `hmac`, `rsa-2048`, `rsa-3072` and `rsa-4096`.
               * Refer to the Vault documentation on transit key types for more information: [Key Types](https://www.vaultproject.io/docs/secrets/transit#key-types)
        """
        pulumi.set(__self__, "backend", backend)
        if allow_plaintext_backup is not None:
            pulumi.set(__self__, "allow_plaintext_backup", allow_plaintext_backup)
        if auto_rotate_period is not None:
            pulumi.set(__self__, "auto_rotate_period", auto_rotate_period)
        if convergent_encryption is not None:
            pulumi.set(__self__, "convergent_encryption", convergent_encryption)
        if deletion_allowed is not None:
            pulumi.set(__self__, "deletion_allowed", deletion_allowed)
        if derived is not None:
            pulumi.set(__self__, "derived", derived)
        if exportable is not None:
            pulumi.set(__self__, "exportable", exportable)
        if hybrid_key_type_ec is not None:
            pulumi.set(__self__, "hybrid_key_type_ec", hybrid_key_type_ec)
        if hybrid_key_type_pqc is not None:
            pulumi.set(__self__, "hybrid_key_type_pqc", hybrid_key_type_pqc)
        if key_size is not None:
            pulumi.set(__self__, "key_size", key_size)
        if min_decryption_version is not None:
            pulumi.set(__self__, "min_decryption_version", min_decryption_version)
        if min_encryption_version is not None:
            pulumi.set(__self__, "min_encryption_version", min_encryption_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if parameter_set is not None:
            pulumi.set(__self__, "parameter_set", parameter_set)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Input[_builtins.str]:
        """
        The path the transit secret backend is mounted at, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="allowPlaintextBackup")
    def allow_plaintext_backup(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables taking backup of entire keyring in the plaintext format. Once set, this cannot be disabled.
        * Refer to Vault API documentation on key backups for more information: [Backup Key](https://www.vaultproject.io/api-docs/secret/transit#backup-key)
        """
        return pulumi.get(self, "allow_plaintext_backup")

    @allow_plaintext_backup.setter
    def allow_plaintext_backup(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_plaintext_backup", value)

    @_builtins.property
    @pulumi.getter(name="autoRotatePeriod")
    def auto_rotate_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount of seconds the key should live before being automatically rotated.
        A value of 0 disables automatic rotation for the key.
        """
        return pulumi.get(self, "auto_rotate_period")

    @auto_rotate_period.setter
    def auto_rotate_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_rotate_period", value)

    @_builtins.property
    @pulumi.getter(name="convergentEncryption")
    def convergent_encryption(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to support convergent encryption, where the same plaintext creates the same ciphertext. This requires `derived` to be set to `true`.
        """
        return pulumi.get(self, "convergent_encryption")

    @convergent_encryption.setter
    def convergent_encryption(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "convergent_encryption", value)

    @_builtins.property
    @pulumi.getter(name="deletionAllowed")
    def deletion_allowed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the key is allowed to be deleted.
        """
        return pulumi.get(self, "deletion_allowed")

    @deletion_allowed.setter
    def deletion_allowed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_allowed", value)

    @_builtins.property
    @pulumi.getter
    def derived(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if key derivation is to be used. If enabled, all encrypt/decrypt requests to this key must provide a context which is used for key derivation.
        """
        return pulumi.get(self, "derived")

    @derived.setter
    def derived(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "derived", value)

    @_builtins.property
    @pulumi.getter
    def exportable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables keys to be exportable. This allows for all valid private keys in the keyring to be exported. Once set, this cannot be disabled.
        """
        return pulumi.get(self, "exportable")

    @exportable.setter
    def exportable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exportable", value)

    @_builtins.property
    @pulumi.getter(name="hybridKeyTypeEc")
    def hybrid_key_type_ec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The elliptic curve algorithm to use for hybrid signatures.
        Supported key types are `ecdsa-p256`, `ecdsa-p384`, `ecdsa-p521`, and `ed25519`.
        """
        return pulumi.get(self, "hybrid_key_type_ec")

    @hybrid_key_type_ec.setter
    def hybrid_key_type_ec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hybrid_key_type_ec", value)

    @_builtins.property
    @pulumi.getter(name="hybridKeyTypePqc")
    def hybrid_key_type_pqc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The post-quantum algorithm to use for hybrid signatures.
        Currently, ML-DSA is the only supported key type.
        """
        return pulumi.get(self, "hybrid_key_type_pqc")

    @hybrid_key_type_pqc.setter
    def hybrid_key_type_pqc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hybrid_key_type_pqc", value)

    @_builtins.property
    @pulumi.getter(name="keySize")
    def key_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The key size in bytes for algorithms that allow variable key sizes. Currently only applicable to HMAC, where it must be between 32 and 512 bytes.
        """
        return pulumi.get(self, "key_size")

    @key_size.setter
    def key_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "key_size", value)

    @_builtins.property
    @pulumi.getter(name="minDecryptionVersion")
    def min_decryption_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum key version to use for decryption.
        """
        return pulumi.get(self, "min_decryption_version")

    @min_decryption_version.setter
    def min_decryption_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_decryption_version", value)

    @_builtins.property
    @pulumi.getter(name="minEncryptionVersion")
    def min_encryption_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum key version to use for encryption
        """
        return pulumi.get(self, "min_encryption_version")

    @min_encryption_version.setter
    def min_encryption_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_encryption_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name to identify this key within the backend. Must be unique within the backend.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="parameterSet")
    def parameter_set(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The parameter set to use for ML-DSA. Required for
        ML-DSA and hybrid keys. Valid values are `44`, `65`, and `87`.
        """
        return pulumi.get(self, "parameter_set")

    @parameter_set.setter
    def parameter_set(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parameter_set", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of key to create. The currently-supported types are: `aes128-gcm96`, `aes256-gcm96` (default), `chacha20-poly1305`, `ed25519`, `ecdsa-p256`, `ecdsa-p384`, `ecdsa-p521`, `hmac`, `rsa-2048`, `rsa-3072` and `rsa-4096`.
        * Refer to the Vault documentation on transit key types for more information: [Key Types](https://www.vaultproject.io/docs/secrets/transit#key-types)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _SecretBackendKeyState:
    def __init__(__self__, *,
                 allow_plaintext_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_rotate_period: Optional[pulumi.Input[_builtins.int]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 convergent_encryption: Optional[pulumi.Input[_builtins.bool]] = None,
                 deletion_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 derived: Optional[pulumi.Input[_builtins.bool]] = None,
                 exportable: Optional[pulumi.Input[_builtins.bool]] = None,
                 hybrid_key_type_ec: Optional[pulumi.Input[_builtins.str]] = None,
                 hybrid_key_type_pqc: Optional[pulumi.Input[_builtins.str]] = None,
                 key_size: Optional[pulumi.Input[_builtins.int]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
                 latest_version: Optional[pulumi.Input[_builtins.int]] = None,
                 min_available_version: Optional[pulumi.Input[_builtins.int]] = None,
                 min_decryption_version: Optional[pulumi.Input[_builtins.int]] = None,
                 min_encryption_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_set: Optional[pulumi.Input[_builtins.str]] = None,
                 supports_decryption: Optional[pulumi.Input[_builtins.bool]] = None,
                 supports_derivation: Optional[pulumi.Input[_builtins.bool]] = None,
                 supports_encryption: Optional[pulumi.Input[_builtins.bool]] = None,
                 supports_signing: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecretBackendKey resources.
        :param pulumi.Input[_builtins.bool] allow_plaintext_backup: Enables taking backup of entire keyring in the plaintext format. Once set, this cannot be disabled.
               * Refer to Vault API documentation on key backups for more information: [Backup Key](https://www.vaultproject.io/api-docs/secret/transit#backup-key)
        :param pulumi.Input[_builtins.int] auto_rotate_period: Amount of seconds the key should live before being automatically rotated.
               A value of 0 disables automatic rotation for the key.
        :param pulumi.Input[_builtins.str] backend: The path the transit secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.bool] convergent_encryption: Whether or not to support convergent encryption, where the same plaintext creates the same ciphertext. This requires `derived` to be set to `true`.
        :param pulumi.Input[_builtins.bool] deletion_allowed: Specifies if the key is allowed to be deleted.
        :param pulumi.Input[_builtins.bool] derived: Specifies if key derivation is to be used. If enabled, all encrypt/decrypt requests to this key must provide a context which is used for key derivation.
        :param pulumi.Input[_builtins.bool] exportable: Enables keys to be exportable. This allows for all valid private keys in the keyring to be exported. Once set, this cannot be disabled.
        :param pulumi.Input[_builtins.str] hybrid_key_type_ec: The elliptic curve algorithm to use for hybrid signatures.
               Supported key types are `ecdsa-p256`, `ecdsa-p384`, `ecdsa-p521`, and `ed25519`.
        :param pulumi.Input[_builtins.str] hybrid_key_type_pqc: The post-quantum algorithm to use for hybrid signatures.
               Currently, ML-DSA is the only supported key type.
        :param pulumi.Input[_builtins.int] key_size: The key size in bytes for algorithms that allow variable key sizes. Currently only applicable to HMAC, where it must be between 32 and 512 bytes.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]] keys: List of key versions in the keyring. This attribute is zero-indexed and will contain a map of values depending on the `type` of the encryption key.
               * for key types `aes128-gcm96`, `aes256-gcm96` and `chacha20-poly1305`, each key version will be a map of a single value `id` which is just a hash of the key's metadata.
               * for key types `ed25519`, `ecdsa-p256`, `ecdsa-p384`, `ecdsa-p521`, `rsa-2048`, `rsa-3072` and `rsa-4096`, each key version will be a map of the following:
        :param pulumi.Input[_builtins.int] latest_version: Latest key version available. This value is 1-indexed, so if `latest_version` is `1`, then the key's information can be referenced from `keys` by selecting element `0`
        :param pulumi.Input[_builtins.int] min_available_version: Minimum key version available for use. If keys have been archived by increasing `min_decryption_version`, this attribute will reflect that change.
        :param pulumi.Input[_builtins.int] min_decryption_version: Minimum key version to use for decryption.
        :param pulumi.Input[_builtins.int] min_encryption_version: Minimum key version to use for encryption
        :param pulumi.Input[_builtins.str] name: The name to identify this key within the backend. Must be unique within the backend.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] parameter_set: The parameter set to use for ML-DSA. Required for
               ML-DSA and hybrid keys. Valid values are `44`, `65`, and `87`.
        :param pulumi.Input[_builtins.bool] supports_decryption: Whether or not the key supports decryption, based on key type.
        :param pulumi.Input[_builtins.bool] supports_derivation: Whether or not the key supports derivation, based on key type.
        :param pulumi.Input[_builtins.bool] supports_encryption: Whether or not the key supports encryption, based on key type.
        :param pulumi.Input[_builtins.bool] supports_signing: Whether or not the key supports signing, based on key type.
        :param pulumi.Input[_builtins.str] type: Specifies the type of key to create. The currently-supported types are: `aes128-gcm96`, `aes256-gcm96` (default), `chacha20-poly1305`, `ed25519`, `ecdsa-p256`, `ecdsa-p384`, `ecdsa-p521`, `hmac`, `rsa-2048`, `rsa-3072` and `rsa-4096`.
               * Refer to the Vault documentation on transit key types for more information: [Key Types](https://www.vaultproject.io/docs/secrets/transit#key-types)
        """
        if allow_plaintext_backup is not None:
            pulumi.set(__self__, "allow_plaintext_backup", allow_plaintext_backup)
        if auto_rotate_period is not None:
            pulumi.set(__self__, "auto_rotate_period", auto_rotate_period)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if convergent_encryption is not None:
            pulumi.set(__self__, "convergent_encryption", convergent_encryption)
        if deletion_allowed is not None:
            pulumi.set(__self__, "deletion_allowed", deletion_allowed)
        if derived is not None:
            pulumi.set(__self__, "derived", derived)
        if exportable is not None:
            pulumi.set(__self__, "exportable", exportable)
        if hybrid_key_type_ec is not None:
            pulumi.set(__self__, "hybrid_key_type_ec", hybrid_key_type_ec)
        if hybrid_key_type_pqc is not None:
            pulumi.set(__self__, "hybrid_key_type_pqc", hybrid_key_type_pqc)
        if key_size is not None:
            pulumi.set(__self__, "key_size", key_size)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if latest_version is not None:
            pulumi.set(__self__, "latest_version", latest_version)
        if min_available_version is not None:
            pulumi.set(__self__, "min_available_version", min_available_version)
        if min_decryption_version is not None:
            pulumi.set(__self__, "min_decryption_version", min_decryption_version)
        if min_encryption_version is not None:
            pulumi.set(__self__, "min_encryption_version", min_encryption_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if parameter_set is not None:
            pulumi.set(__self__, "parameter_set", parameter_set)
        if supports_decryption is not None:
            pulumi.set(__self__, "supports_decryption", supports_decryption)
        if supports_derivation is not None:
            pulumi.set(__self__, "supports_derivation", supports_derivation)
        if supports_encryption is not None:
            pulumi.set(__self__, "supports_encryption", supports_encryption)
        if supports_signing is not None:
            pulumi.set(__self__, "supports_signing", supports_signing)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="allowPlaintextBackup")
    def allow_plaintext_backup(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables taking backup of entire keyring in the plaintext format. Once set, this cannot be disabled.
        * Refer to Vault API documentation on key backups for more information: [Backup Key](https://www.vaultproject.io/api-docs/secret/transit#backup-key)
        """
        return pulumi.get(self, "allow_plaintext_backup")

    @allow_plaintext_backup.setter
    def allow_plaintext_backup(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_plaintext_backup", value)

    @_builtins.property
    @pulumi.getter(name="autoRotatePeriod")
    def auto_rotate_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount of seconds the key should live before being automatically rotated.
        A value of 0 disables automatic rotation for the key.
        """
        return pulumi.get(self, "auto_rotate_period")

    @auto_rotate_period.setter
    def auto_rotate_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_rotate_period", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path the transit secret backend is mounted at, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="convergentEncryption")
    def convergent_encryption(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to support convergent encryption, where the same plaintext creates the same ciphertext. This requires `derived` to be set to `true`.
        """
        return pulumi.get(self, "convergent_encryption")

    @convergent_encryption.setter
    def convergent_encryption(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "convergent_encryption", value)

    @_builtins.property
    @pulumi.getter(name="deletionAllowed")
    def deletion_allowed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the key is allowed to be deleted.
        """
        return pulumi.get(self, "deletion_allowed")

    @deletion_allowed.setter
    def deletion_allowed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_allowed", value)

    @_builtins.property
    @pulumi.getter
    def derived(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if key derivation is to be used. If enabled, all encrypt/decrypt requests to this key must provide a context which is used for key derivation.
        """
        return pulumi.get(self, "derived")

    @derived.setter
    def derived(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "derived", value)

    @_builtins.property
    @pulumi.getter
    def exportable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables keys to be exportable. This allows for all valid private keys in the keyring to be exported. Once set, this cannot be disabled.
        """
        return pulumi.get(self, "exportable")

    @exportable.setter
    def exportable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exportable", value)

    @_builtins.property
    @pulumi.getter(name="hybridKeyTypeEc")
    def hybrid_key_type_ec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The elliptic curve algorithm to use for hybrid signatures.
        Supported key types are `ecdsa-p256`, `ecdsa-p384`, `ecdsa-p521`, and `ed25519`.
        """
        return pulumi.get(self, "hybrid_key_type_ec")

    @hybrid_key_type_ec.setter
    def hybrid_key_type_ec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hybrid_key_type_ec", value)

    @_builtins.property
    @pulumi.getter(name="hybridKeyTypePqc")
    def hybrid_key_type_pqc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The post-quantum algorithm to use for hybrid signatures.
        Currently, ML-DSA is the only supported key type.
        """
        return pulumi.get(self, "hybrid_key_type_pqc")

    @hybrid_key_type_pqc.setter
    def hybrid_key_type_pqc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hybrid_key_type_pqc", value)

    @_builtins.property
    @pulumi.getter(name="keySize")
    def key_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The key size in bytes for algorithms that allow variable key sizes. Currently only applicable to HMAC, where it must be between 32 and 512 bytes.
        """
        return pulumi.get(self, "key_size")

    @key_size.setter
    def key_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "key_size", value)

    @_builtins.property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]]:
        """
        List of key versions in the keyring. This attribute is zero-indexed and will contain a map of values depending on the `type` of the encryption key.
        * for key types `aes128-gcm96`, `aes256-gcm96` and `chacha20-poly1305`, each key version will be a map of a single value `id` which is just a hash of the key's metadata.
        * for key types `ed25519`, `ecdsa-p256`, `ecdsa-p384`, `ecdsa-p521`, `rsa-2048`, `rsa-3072` and `rsa-4096`, each key version will be a map of the following:
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]]):
        pulumi.set(self, "keys", value)

    @_builtins.property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Latest key version available. This value is 1-indexed, so if `latest_version` is `1`, then the key's information can be referenced from `keys` by selecting element `0`
        """
        return pulumi.get(self, "latest_version")

    @latest_version.setter
    def latest_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "latest_version", value)

    @_builtins.property
    @pulumi.getter(name="minAvailableVersion")
    def min_available_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum key version available for use. If keys have been archived by increasing `min_decryption_version`, this attribute will reflect that change.
        """
        return pulumi.get(self, "min_available_version")

    @min_available_version.setter
    def min_available_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_available_version", value)

    @_builtins.property
    @pulumi.getter(name="minDecryptionVersion")
    def min_decryption_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum key version to use for decryption.
        """
        return pulumi.get(self, "min_decryption_version")

    @min_decryption_version.setter
    def min_decryption_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_decryption_version", value)

    @_builtins.property
    @pulumi.getter(name="minEncryptionVersion")
    def min_encryption_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum key version to use for encryption
        """
        return pulumi.get(self, "min_encryption_version")

    @min_encryption_version.setter
    def min_encryption_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_encryption_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name to identify this key within the backend. Must be unique within the backend.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="parameterSet")
    def parameter_set(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The parameter set to use for ML-DSA. Required for
        ML-DSA and hybrid keys. Valid values are `44`, `65`, and `87`.
        """
        return pulumi.get(self, "parameter_set")

    @parameter_set.setter
    def parameter_set(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parameter_set", value)

    @_builtins.property
    @pulumi.getter(name="supportsDecryption")
    def supports_decryption(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not the key supports decryption, based on key type.
        """
        return pulumi.get(self, "supports_decryption")

    @supports_decryption.setter
    def supports_decryption(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "supports_decryption", value)

    @_builtins.property
    @pulumi.getter(name="supportsDerivation")
    def supports_derivation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not the key supports derivation, based on key type.
        """
        return pulumi.get(self, "supports_derivation")

    @supports_derivation.setter
    def supports_derivation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "supports_derivation", value)

    @_builtins.property
    @pulumi.getter(name="supportsEncryption")
    def supports_encryption(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not the key supports encryption, based on key type.
        """
        return pulumi.get(self, "supports_encryption")

    @supports_encryption.setter
    def supports_encryption(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "supports_encryption", value)

    @_builtins.property
    @pulumi.getter(name="supportsSigning")
    def supports_signing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not the key supports signing, based on key type.
        """
        return pulumi.get(self, "supports_signing")

    @supports_signing.setter
    def supports_signing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "supports_signing", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of key to create. The currently-supported types are: `aes128-gcm96`, `aes256-gcm96` (default), `chacha20-poly1305`, `ed25519`, `ecdsa-p256`, `ecdsa-p384`, `ecdsa-p521`, `hmac`, `rsa-2048`, `rsa-3072` and `rsa-4096`.
        * Refer to the Vault documentation on transit key types for more information: [Key Types](https://www.vaultproject.io/docs/secrets/transit#key-types)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("vault:transit/secretBackendKey:SecretBackendKey")
class SecretBackendKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_plaintext_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_rotate_period: Optional[pulumi.Input[_builtins.int]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 convergent_encryption: Optional[pulumi.Input[_builtins.bool]] = None,
                 deletion_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 derived: Optional[pulumi.Input[_builtins.bool]] = None,
                 exportable: Optional[pulumi.Input[_builtins.bool]] = None,
                 hybrid_key_type_ec: Optional[pulumi.Input[_builtins.str]] = None,
                 hybrid_key_type_pqc: Optional[pulumi.Input[_builtins.str]] = None,
                 key_size: Optional[pulumi.Input[_builtins.int]] = None,
                 min_decryption_version: Optional[pulumi.Input[_builtins.int]] = None,
                 min_encryption_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_set: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates an Encryption Keyring on a Transit Secret Backend for Vault.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        transit = vault.Mount("transit",
            path="transit",
            type="transit",
            description="Example description",
            default_lease_ttl_seconds=3600,
            max_lease_ttl_seconds=86400)
        key = vault.transit.SecretBackendKey("key",
            backend=transit.path,
            name="my_key")
        ```

        ## Import

        Transit secret backend keys can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:transit/secretBackendKey:SecretBackendKey key transit/keys/my_key
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_plaintext_backup: Enables taking backup of entire keyring in the plaintext format. Once set, this cannot be disabled.
               * Refer to Vault API documentation on key backups for more information: [Backup Key](https://www.vaultproject.io/api-docs/secret/transit#backup-key)
        :param pulumi.Input[_builtins.int] auto_rotate_period: Amount of seconds the key should live before being automatically rotated.
               A value of 0 disables automatic rotation for the key.
        :param pulumi.Input[_builtins.str] backend: The path the transit secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.bool] convergent_encryption: Whether or not to support convergent encryption, where the same plaintext creates the same ciphertext. This requires `derived` to be set to `true`.
        :param pulumi.Input[_builtins.bool] deletion_allowed: Specifies if the key is allowed to be deleted.
        :param pulumi.Input[_builtins.bool] derived: Specifies if key derivation is to be used. If enabled, all encrypt/decrypt requests to this key must provide a context which is used for key derivation.
        :param pulumi.Input[_builtins.bool] exportable: Enables keys to be exportable. This allows for all valid private keys in the keyring to be exported. Once set, this cannot be disabled.
        :param pulumi.Input[_builtins.str] hybrid_key_type_ec: The elliptic curve algorithm to use for hybrid signatures.
               Supported key types are `ecdsa-p256`, `ecdsa-p384`, `ecdsa-p521`, and `ed25519`.
        :param pulumi.Input[_builtins.str] hybrid_key_type_pqc: The post-quantum algorithm to use for hybrid signatures.
               Currently, ML-DSA is the only supported key type.
        :param pulumi.Input[_builtins.int] key_size: The key size in bytes for algorithms that allow variable key sizes. Currently only applicable to HMAC, where it must be between 32 and 512 bytes.
        :param pulumi.Input[_builtins.int] min_decryption_version: Minimum key version to use for decryption.
        :param pulumi.Input[_builtins.int] min_encryption_version: Minimum key version to use for encryption
        :param pulumi.Input[_builtins.str] name: The name to identify this key within the backend. Must be unique within the backend.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] parameter_set: The parameter set to use for ML-DSA. Required for
               ML-DSA and hybrid keys. Valid values are `44`, `65`, and `87`.
        :param pulumi.Input[_builtins.str] type: Specifies the type of key to create. The currently-supported types are: `aes128-gcm96`, `aes256-gcm96` (default), `chacha20-poly1305`, `ed25519`, `ecdsa-p256`, `ecdsa-p384`, `ecdsa-p521`, `hmac`, `rsa-2048`, `rsa-3072` and `rsa-4096`.
               * Refer to the Vault documentation on transit key types for more information: [Key Types](https://www.vaultproject.io/docs/secrets/transit#key-types)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an Encryption Keyring on a Transit Secret Backend for Vault.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        transit = vault.Mount("transit",
            path="transit",
            type="transit",
            description="Example description",
            default_lease_ttl_seconds=3600,
            max_lease_ttl_seconds=86400)
        key = vault.transit.SecretBackendKey("key",
            backend=transit.path,
            name="my_key")
        ```

        ## Import

        Transit secret backend keys can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:transit/secretBackendKey:SecretBackendKey key transit/keys/my_key
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_plaintext_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_rotate_period: Optional[pulumi.Input[_builtins.int]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 convergent_encryption: Optional[pulumi.Input[_builtins.bool]] = None,
                 deletion_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 derived: Optional[pulumi.Input[_builtins.bool]] = None,
                 exportable: Optional[pulumi.Input[_builtins.bool]] = None,
                 hybrid_key_type_ec: Optional[pulumi.Input[_builtins.str]] = None,
                 hybrid_key_type_pqc: Optional[pulumi.Input[_builtins.str]] = None,
                 key_size: Optional[pulumi.Input[_builtins.int]] = None,
                 min_decryption_version: Optional[pulumi.Input[_builtins.int]] = None,
                 min_encryption_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_set: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendKeyArgs.__new__(SecretBackendKeyArgs)

            __props__.__dict__["allow_plaintext_backup"] = allow_plaintext_backup
            __props__.__dict__["auto_rotate_period"] = auto_rotate_period
            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            __props__.__dict__["convergent_encryption"] = convergent_encryption
            __props__.__dict__["deletion_allowed"] = deletion_allowed
            __props__.__dict__["derived"] = derived
            __props__.__dict__["exportable"] = exportable
            __props__.__dict__["hybrid_key_type_ec"] = hybrid_key_type_ec
            __props__.__dict__["hybrid_key_type_pqc"] = hybrid_key_type_pqc
            __props__.__dict__["key_size"] = key_size
            __props__.__dict__["min_decryption_version"] = min_decryption_version
            __props__.__dict__["min_encryption_version"] = min_encryption_version
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["parameter_set"] = parameter_set
            __props__.__dict__["type"] = type
            __props__.__dict__["keys"] = None
            __props__.__dict__["latest_version"] = None
            __props__.__dict__["min_available_version"] = None
            __props__.__dict__["supports_decryption"] = None
            __props__.__dict__["supports_derivation"] = None
            __props__.__dict__["supports_encryption"] = None
            __props__.__dict__["supports_signing"] = None
        super(SecretBackendKey, __self__).__init__(
            'vault:transit/secretBackendKey:SecretBackendKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_plaintext_backup: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_rotate_period: Optional[pulumi.Input[_builtins.int]] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            convergent_encryption: Optional[pulumi.Input[_builtins.bool]] = None,
            deletion_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
            derived: Optional[pulumi.Input[_builtins.bool]] = None,
            exportable: Optional[pulumi.Input[_builtins.bool]] = None,
            hybrid_key_type_ec: Optional[pulumi.Input[_builtins.str]] = None,
            hybrid_key_type_pqc: Optional[pulumi.Input[_builtins.str]] = None,
            key_size: Optional[pulumi.Input[_builtins.int]] = None,
            keys: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
            latest_version: Optional[pulumi.Input[_builtins.int]] = None,
            min_available_version: Optional[pulumi.Input[_builtins.int]] = None,
            min_decryption_version: Optional[pulumi.Input[_builtins.int]] = None,
            min_encryption_version: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            parameter_set: Optional[pulumi.Input[_builtins.str]] = None,
            supports_decryption: Optional[pulumi.Input[_builtins.bool]] = None,
            supports_derivation: Optional[pulumi.Input[_builtins.bool]] = None,
            supports_encryption: Optional[pulumi.Input[_builtins.bool]] = None,
            supports_signing: Optional[pulumi.Input[_builtins.bool]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecretBackendKey':
        """
        Get an existing SecretBackendKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_plaintext_backup: Enables taking backup of entire keyring in the plaintext format. Once set, this cannot be disabled.
               * Refer to Vault API documentation on key backups for more information: [Backup Key](https://www.vaultproject.io/api-docs/secret/transit#backup-key)
        :param pulumi.Input[_builtins.int] auto_rotate_period: Amount of seconds the key should live before being automatically rotated.
               A value of 0 disables automatic rotation for the key.
        :param pulumi.Input[_builtins.str] backend: The path the transit secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.bool] convergent_encryption: Whether or not to support convergent encryption, where the same plaintext creates the same ciphertext. This requires `derived` to be set to `true`.
        :param pulumi.Input[_builtins.bool] deletion_allowed: Specifies if the key is allowed to be deleted.
        :param pulumi.Input[_builtins.bool] derived: Specifies if key derivation is to be used. If enabled, all encrypt/decrypt requests to this key must provide a context which is used for key derivation.
        :param pulumi.Input[_builtins.bool] exportable: Enables keys to be exportable. This allows for all valid private keys in the keyring to be exported. Once set, this cannot be disabled.
        :param pulumi.Input[_builtins.str] hybrid_key_type_ec: The elliptic curve algorithm to use for hybrid signatures.
               Supported key types are `ecdsa-p256`, `ecdsa-p384`, `ecdsa-p521`, and `ed25519`.
        :param pulumi.Input[_builtins.str] hybrid_key_type_pqc: The post-quantum algorithm to use for hybrid signatures.
               Currently, ML-DSA is the only supported key type.
        :param pulumi.Input[_builtins.int] key_size: The key size in bytes for algorithms that allow variable key sizes. Currently only applicable to HMAC, where it must be between 32 and 512 bytes.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]] keys: List of key versions in the keyring. This attribute is zero-indexed and will contain a map of values depending on the `type` of the encryption key.
               * for key types `aes128-gcm96`, `aes256-gcm96` and `chacha20-poly1305`, each key version will be a map of a single value `id` which is just a hash of the key's metadata.
               * for key types `ed25519`, `ecdsa-p256`, `ecdsa-p384`, `ecdsa-p521`, `rsa-2048`, `rsa-3072` and `rsa-4096`, each key version will be a map of the following:
        :param pulumi.Input[_builtins.int] latest_version: Latest key version available. This value is 1-indexed, so if `latest_version` is `1`, then the key's information can be referenced from `keys` by selecting element `0`
        :param pulumi.Input[_builtins.int] min_available_version: Minimum key version available for use. If keys have been archived by increasing `min_decryption_version`, this attribute will reflect that change.
        :param pulumi.Input[_builtins.int] min_decryption_version: Minimum key version to use for decryption.
        :param pulumi.Input[_builtins.int] min_encryption_version: Minimum key version to use for encryption
        :param pulumi.Input[_builtins.str] name: The name to identify this key within the backend. Must be unique within the backend.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] parameter_set: The parameter set to use for ML-DSA. Required for
               ML-DSA and hybrid keys. Valid values are `44`, `65`, and `87`.
        :param pulumi.Input[_builtins.bool] supports_decryption: Whether or not the key supports decryption, based on key type.
        :param pulumi.Input[_builtins.bool] supports_derivation: Whether or not the key supports derivation, based on key type.
        :param pulumi.Input[_builtins.bool] supports_encryption: Whether or not the key supports encryption, based on key type.
        :param pulumi.Input[_builtins.bool] supports_signing: Whether or not the key supports signing, based on key type.
        :param pulumi.Input[_builtins.str] type: Specifies the type of key to create. The currently-supported types are: `aes128-gcm96`, `aes256-gcm96` (default), `chacha20-poly1305`, `ed25519`, `ecdsa-p256`, `ecdsa-p384`, `ecdsa-p521`, `hmac`, `rsa-2048`, `rsa-3072` and `rsa-4096`.
               * Refer to the Vault documentation on transit key types for more information: [Key Types](https://www.vaultproject.io/docs/secrets/transit#key-types)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendKeyState.__new__(_SecretBackendKeyState)

        __props__.__dict__["allow_plaintext_backup"] = allow_plaintext_backup
        __props__.__dict__["auto_rotate_period"] = auto_rotate_period
        __props__.__dict__["backend"] = backend
        __props__.__dict__["convergent_encryption"] = convergent_encryption
        __props__.__dict__["deletion_allowed"] = deletion_allowed
        __props__.__dict__["derived"] = derived
        __props__.__dict__["exportable"] = exportable
        __props__.__dict__["hybrid_key_type_ec"] = hybrid_key_type_ec
        __props__.__dict__["hybrid_key_type_pqc"] = hybrid_key_type_pqc
        __props__.__dict__["key_size"] = key_size
        __props__.__dict__["keys"] = keys
        __props__.__dict__["latest_version"] = latest_version
        __props__.__dict__["min_available_version"] = min_available_version
        __props__.__dict__["min_decryption_version"] = min_decryption_version
        __props__.__dict__["min_encryption_version"] = min_encryption_version
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["parameter_set"] = parameter_set
        __props__.__dict__["supports_decryption"] = supports_decryption
        __props__.__dict__["supports_derivation"] = supports_derivation
        __props__.__dict__["supports_encryption"] = supports_encryption
        __props__.__dict__["supports_signing"] = supports_signing
        __props__.__dict__["type"] = type
        return SecretBackendKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowPlaintextBackup")
    def allow_plaintext_backup(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enables taking backup of entire keyring in the plaintext format. Once set, this cannot be disabled.
        * Refer to Vault API documentation on key backups for more information: [Backup Key](https://www.vaultproject.io/api-docs/secret/transit#backup-key)
        """
        return pulumi.get(self, "allow_plaintext_backup")

    @_builtins.property
    @pulumi.getter(name="autoRotatePeriod")
    def auto_rotate_period(self) -> pulumi.Output[_builtins.int]:
        """
        Amount of seconds the key should live before being automatically rotated.
        A value of 0 disables automatic rotation for the key.
        """
        return pulumi.get(self, "auto_rotate_period")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[_builtins.str]:
        """
        The path the transit secret backend is mounted at, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="convergentEncryption")
    def convergent_encryption(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether or not to support convergent encryption, where the same plaintext creates the same ciphertext. This requires `derived` to be set to `true`.
        """
        return pulumi.get(self, "convergent_encryption")

    @_builtins.property
    @pulumi.getter(name="deletionAllowed")
    def deletion_allowed(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if the key is allowed to be deleted.
        """
        return pulumi.get(self, "deletion_allowed")

    @_builtins.property
    @pulumi.getter
    def derived(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if key derivation is to be used. If enabled, all encrypt/decrypt requests to this key must provide a context which is used for key derivation.
        """
        return pulumi.get(self, "derived")

    @_builtins.property
    @pulumi.getter
    def exportable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enables keys to be exportable. This allows for all valid private keys in the keyring to be exported. Once set, this cannot be disabled.
        """
        return pulumi.get(self, "exportable")

    @_builtins.property
    @pulumi.getter(name="hybridKeyTypeEc")
    def hybrid_key_type_ec(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The elliptic curve algorithm to use for hybrid signatures.
        Supported key types are `ecdsa-p256`, `ecdsa-p384`, `ecdsa-p521`, and `ed25519`.
        """
        return pulumi.get(self, "hybrid_key_type_ec")

    @_builtins.property
    @pulumi.getter(name="hybridKeyTypePqc")
    def hybrid_key_type_pqc(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The post-quantum algorithm to use for hybrid signatures.
        Currently, ML-DSA is the only supported key type.
        """
        return pulumi.get(self, "hybrid_key_type_pqc")

    @_builtins.property
    @pulumi.getter(name="keySize")
    def key_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The key size in bytes for algorithms that allow variable key sizes. Currently only applicable to HMAC, where it must be between 32 and 512 bytes.
        """
        return pulumi.get(self, "key_size")

    @_builtins.property
    @pulumi.getter
    def keys(self) -> pulumi.Output[Sequence[Mapping[str, _builtins.str]]]:
        """
        List of key versions in the keyring. This attribute is zero-indexed and will contain a map of values depending on the `type` of the encryption key.
        * for key types `aes128-gcm96`, `aes256-gcm96` and `chacha20-poly1305`, each key version will be a map of a single value `id` which is just a hash of the key's metadata.
        * for key types `ed25519`, `ecdsa-p256`, `ecdsa-p384`, `ecdsa-p521`, `rsa-2048`, `rsa-3072` and `rsa-4096`, each key version will be a map of the following:
        """
        return pulumi.get(self, "keys")

    @_builtins.property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> pulumi.Output[_builtins.int]:
        """
        Latest key version available. This value is 1-indexed, so if `latest_version` is `1`, then the key's information can be referenced from `keys` by selecting element `0`
        """
        return pulumi.get(self, "latest_version")

    @_builtins.property
    @pulumi.getter(name="minAvailableVersion")
    def min_available_version(self) -> pulumi.Output[_builtins.int]:
        """
        Minimum key version available for use. If keys have been archived by increasing `min_decryption_version`, this attribute will reflect that change.
        """
        return pulumi.get(self, "min_available_version")

    @_builtins.property
    @pulumi.getter(name="minDecryptionVersion")
    def min_decryption_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Minimum key version to use for decryption.
        """
        return pulumi.get(self, "min_decryption_version")

    @_builtins.property
    @pulumi.getter(name="minEncryptionVersion")
    def min_encryption_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Minimum key version to use for encryption
        """
        return pulumi.get(self, "min_encryption_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name to identify this key within the backend. Must be unique within the backend.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="parameterSet")
    def parameter_set(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The parameter set to use for ML-DSA. Required for
        ML-DSA and hybrid keys. Valid values are `44`, `65`, and `87`.
        """
        return pulumi.get(self, "parameter_set")

    @_builtins.property
    @pulumi.getter(name="supportsDecryption")
    def supports_decryption(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether or not the key supports decryption, based on key type.
        """
        return pulumi.get(self, "supports_decryption")

    @_builtins.property
    @pulumi.getter(name="supportsDerivation")
    def supports_derivation(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether or not the key supports derivation, based on key type.
        """
        return pulumi.get(self, "supports_derivation")

    @_builtins.property
    @pulumi.getter(name="supportsEncryption")
    def supports_encryption(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether or not the key supports encryption, based on key type.
        """
        return pulumi.get(self, "supports_encryption")

    @_builtins.property
    @pulumi.getter(name="supportsSigning")
    def supports_signing(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether or not the key supports signing, based on key type.
        """
        return pulumi.get(self, "supports_signing")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the type of key to create. The currently-supported types are: `aes128-gcm96`, `aes256-gcm96` (default), `chacha20-poly1305`, `ed25519`, `ecdsa-p256`, `ecdsa-p384`, `ecdsa-p521`, `hmac`, `rsa-2048`, `rsa-3072` and `rsa-4096`.
        * Refer to the Vault documentation on transit key types for more information: [Key Types](https://www.vaultproject.io/docs/secrets/transit#key-types)
        """
        return pulumi.get(self, "type")

