from nillanet.model import NN
from nillanet.activations import Activations
from nillanet.loss import Loss
from nillanet.distributions import Distributions
from nillanet.scheduler import Scheduler
from nillanet.initializer import Initializer

d = Distributions()
x,y = d.arithmetic_distribution(10,"subtract")
print(x.shape)
print(y.shape)

a = Activations()
activation = a.tanh
derivative1 = a.tanh_derivative
resolver = a.linear
derivative2 = a.linear_derivative

l = Loss()
loss = l.mae
derivative3 = l.mae_derivative

input = x
output = y
features = x.shape[1]
architecture = [2,4,1]
learning_rate = 0.01
epochs = 1000
scheduler = Scheduler(mode='cosine', lr=learning_rate)
initializer = Initializer(distribution=Initializer.xavier, low=-2, high=2, mean=0, std=1)

model = NN(features,architecture,activation,derivative1,resolver,derivative2,loss,derivative3,learning_rate,scheduler=scheduler,initializer=initializer)
model.summary()

for epoch in range(epochs):
    model.train(input,output,epoch,epochs,verbose=True,step=100,autosave=True)

prediction = model.predict(input)

print("prediction")
print(prediction)
print("expected")
print(y)
