# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.calcom_o_auth_success_response import CalcomOAuthSuccessResponse
from .raw_client import AsyncRawCalcomOauthClient, RawCalcomOauthClient


class CalcomOauthClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCalcomOauthClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCalcomOauthClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCalcomOauthClient
        """
        return self._raw_client

    def authorize_calcom(
        self,
        *,
        instance_id: str,
        client_id: typing.Optional[str] = None,
        redirect_url: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Start Cal.com OAuth flow

        Parameters:
        - instance_id: Identifier for the instance requesting authorization
        - client_id: Optional client ID for white labeling
        - redirect_url: Optional URL to redirect to after authorization completes

        Parameters
        ----------
        instance_id : str
            Unique identifier for the client instance requesting authorization

        client_id : typing.Optional[str]
            Client ID for white labeling, if not provided will use default credentials

        redirect_url : typing.Optional[str]
            Optional URL to redirect to after authorization completes

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.calcom_oauth.authorize_calcom(
            instance_id="instance_id",
        )
        """
        _response = self._raw_client.authorize_calcom(
            instance_id=instance_id, client_id=client_id, redirect_url=redirect_url, request_options=request_options
        )
        return _response.data

    def calcom_client_credentials_auth(
        self,
        *,
        instance_id: str,
        cal_client_id: str,
        cal_secret_key: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CalcomOAuthSuccessResponse:
        """
        Authenticate using Cal.com OAuth client credentials flow for platform-level API access

        This endpoint is used for:
        - Managing managed users
        - Creating OAuth client webhooks
        - Refreshing managed user tokens
        - Managing organization teams and memberships

        Parameters:
        - instance_id: Identifier for the instance requesting authentication
        - x-cal-client-id: OAuth client ID (header)
        - x-cal-secret-key: OAuth client secret (header)

        Parameters
        ----------
        instance_id : str
            Unique identifier for the client instance

        cal_client_id : str
            Cal.com OAuth client ID

        cal_secret_key : str
            Cal.com OAuth client secret

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CalcomOAuthSuccessResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.calcom_oauth.calcom_client_credentials_auth(
            cal_client_id="x-cal-client-id",
            cal_secret_key="x-cal-secret-key",
            instance_id="instance_id",
        )
        """
        _response = self._raw_client.calcom_client_credentials_auth(
            instance_id=instance_id,
            cal_client_id=cal_client_id,
            cal_secret_key=cal_secret_key,
            request_options=request_options,
        )
        return _response.data


class AsyncCalcomOauthClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCalcomOauthClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCalcomOauthClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCalcomOauthClient
        """
        return self._raw_client

    async def authorize_calcom(
        self,
        *,
        instance_id: str,
        client_id: typing.Optional[str] = None,
        redirect_url: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Start Cal.com OAuth flow

        Parameters:
        - instance_id: Identifier for the instance requesting authorization
        - client_id: Optional client ID for white labeling
        - redirect_url: Optional URL to redirect to after authorization completes

        Parameters
        ----------
        instance_id : str
            Unique identifier for the client instance requesting authorization

        client_id : typing.Optional[str]
            Client ID for white labeling, if not provided will use default credentials

        redirect_url : typing.Optional[str]
            Optional URL to redirect to after authorization completes

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.calcom_oauth.authorize_calcom(
                instance_id="instance_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.authorize_calcom(
            instance_id=instance_id, client_id=client_id, redirect_url=redirect_url, request_options=request_options
        )
        return _response.data

    async def calcom_client_credentials_auth(
        self,
        *,
        instance_id: str,
        cal_client_id: str,
        cal_secret_key: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CalcomOAuthSuccessResponse:
        """
        Authenticate using Cal.com OAuth client credentials flow for platform-level API access

        This endpoint is used for:
        - Managing managed users
        - Creating OAuth client webhooks
        - Refreshing managed user tokens
        - Managing organization teams and memberships

        Parameters:
        - instance_id: Identifier for the instance requesting authentication
        - x-cal-client-id: OAuth client ID (header)
        - x-cal-secret-key: OAuth client secret (header)

        Parameters
        ----------
        instance_id : str
            Unique identifier for the client instance

        cal_client_id : str
            Cal.com OAuth client ID

        cal_secret_key : str
            Cal.com OAuth client secret

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CalcomOAuthSuccessResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.calcom_oauth.calcom_client_credentials_auth(
                cal_client_id="x-cal-client-id",
                cal_secret_key="x-cal-secret-key",
                instance_id="instance_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.calcom_client_credentials_auth(
            instance_id=instance_id,
            cal_client_id=cal_client_id,
            cal_secret_key=cal_secret_key,
            request_options=request_options,
        )
        return _response.data
