# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.bad_request_error import BadRequestError
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.calcom_o_auth_error_response import CalcomOAuthErrorResponse
from ..types.calcom_o_auth_success_response import CalcomOAuthSuccessResponse
from ..types.http_validation_error import HttpValidationError


class RawCalcomOauthClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def authorize_calcom(
        self,
        *,
        instance_id: str,
        client_id: typing.Optional[str] = None,
        redirect_url: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.Optional[typing.Any]]:
        """
        Start Cal.com OAuth flow

        Parameters:
        - instance_id: Identifier for the instance requesting authorization
        - client_id: Optional client ID for white labeling
        - redirect_url: Optional URL to redirect to after authorization completes

        Parameters
        ----------
        instance_id : str
            Unique identifier for the client instance requesting authorization

        client_id : typing.Optional[str]
            Client ID for white labeling, if not provided will use default credentials

        redirect_url : typing.Optional[str]
            Optional URL to redirect to after authorization completes

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "oauth/calcom/authorize",
            method="GET",
            params={
                "instance_id": instance_id,
                "client_id": client_id,
                "redirect_url": redirect_url,
            },
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return HttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def calcom_client_credentials_auth(
        self,
        *,
        instance_id: str,
        cal_client_id: str,
        cal_secret_key: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CalcomOAuthSuccessResponse]:
        """
        Authenticate using Cal.com OAuth client credentials flow for platform-level API access

        This endpoint is used for:
        - Managing managed users
        - Creating OAuth client webhooks
        - Refreshing managed user tokens
        - Managing organization teams and memberships

        Parameters:
        - instance_id: Identifier for the instance requesting authentication
        - x-cal-client-id: OAuth client ID (header)
        - x-cal-secret-key: OAuth client secret (header)

        Parameters
        ----------
        instance_id : str
            Unique identifier for the client instance

        cal_client_id : str
            Cal.com OAuth client ID

        cal_secret_key : str
            Cal.com OAuth client secret

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CalcomOAuthSuccessResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "oauth/calcom/client-credentials",
            method="GET",
            params={
                "instance_id": instance_id,
            },
            headers={
                "x-cal-client-id": str(cal_client_id) if cal_client_id is not None else None,
                "x-cal-secret-key": str(cal_secret_key) if cal_secret_key is not None else None,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CalcomOAuthSuccessResponse,
                    parse_obj_as(
                        type_=CalcomOAuthSuccessResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        CalcomOAuthErrorResponse,
                        parse_obj_as(
                            type_=CalcomOAuthErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawCalcomOauthClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def authorize_calcom(
        self,
        *,
        instance_id: str,
        client_id: typing.Optional[str] = None,
        redirect_url: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.Optional[typing.Any]]:
        """
        Start Cal.com OAuth flow

        Parameters:
        - instance_id: Identifier for the instance requesting authorization
        - client_id: Optional client ID for white labeling
        - redirect_url: Optional URL to redirect to after authorization completes

        Parameters
        ----------
        instance_id : str
            Unique identifier for the client instance requesting authorization

        client_id : typing.Optional[str]
            Client ID for white labeling, if not provided will use default credentials

        redirect_url : typing.Optional[str]
            Optional URL to redirect to after authorization completes

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "oauth/calcom/authorize",
            method="GET",
            params={
                "instance_id": instance_id,
                "client_id": client_id,
                "redirect_url": redirect_url,
            },
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return AsyncHttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def calcom_client_credentials_auth(
        self,
        *,
        instance_id: str,
        cal_client_id: str,
        cal_secret_key: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CalcomOAuthSuccessResponse]:
        """
        Authenticate using Cal.com OAuth client credentials flow for platform-level API access

        This endpoint is used for:
        - Managing managed users
        - Creating OAuth client webhooks
        - Refreshing managed user tokens
        - Managing organization teams and memberships

        Parameters:
        - instance_id: Identifier for the instance requesting authentication
        - x-cal-client-id: OAuth client ID (header)
        - x-cal-secret-key: OAuth client secret (header)

        Parameters
        ----------
        instance_id : str
            Unique identifier for the client instance

        cal_client_id : str
            Cal.com OAuth client ID

        cal_secret_key : str
            Cal.com OAuth client secret

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CalcomOAuthSuccessResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "oauth/calcom/client-credentials",
            method="GET",
            params={
                "instance_id": instance_id,
            },
            headers={
                "x-cal-client-id": str(cal_client_id) if cal_client_id is not None else None,
                "x-cal-secret-key": str(cal_secret_key) if cal_secret_key is not None else None,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CalcomOAuthSuccessResponse,
                    parse_obj_as(
                        type_=CalcomOAuthSuccessResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        CalcomOAuthErrorResponse,
                        parse_obj_as(
                            type_=CalcomOAuthErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
