# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawCanvaOauthClient, RawCanvaOauthClient


class CanvaOauthClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCanvaOauthClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCanvaOauthClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCanvaOauthClient
        """
        return self._raw_client

    def authorize_canva(
        self,
        *,
        instance_id: str,
        client_id: typing.Optional[str] = None,
        scope: typing.Optional[str] = None,
        redirect_url: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Start Canva OAuth flow with PKCE

        Parameters:
        - instance_id: Identifier for the instance requesting authorization
        - client_id: Optional client ID for white labeling
        - scope: Optional scopes to request (space-separated, e.g., "design:meta:read profile:read")
        - redirect_url: Optional URL to redirect to after authorization completes

        Parameters
        ----------
        instance_id : str
            Unique identifier for the client instance requesting authorization

        client_id : typing.Optional[str]
            Client ID for white labeling, if not provided will use default credentials

        scope : typing.Optional[str]
            Optional OAuth scopes to request (space-separated string)

        redirect_url : typing.Optional[str]
            Optional URL to redirect to after authorization completes

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.canva_oauth.authorize_canva(
            instance_id="instance_id",
        )
        """
        _response = self._raw_client.authorize_canva(
            instance_id=instance_id,
            client_id=client_id,
            scope=scope,
            redirect_url=redirect_url,
            request_options=request_options,
        )
        return _response.data


class AsyncCanvaOauthClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCanvaOauthClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCanvaOauthClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCanvaOauthClient
        """
        return self._raw_client

    async def authorize_canva(
        self,
        *,
        instance_id: str,
        client_id: typing.Optional[str] = None,
        scope: typing.Optional[str] = None,
        redirect_url: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Start Canva OAuth flow with PKCE

        Parameters:
        - instance_id: Identifier for the instance requesting authorization
        - client_id: Optional client ID for white labeling
        - scope: Optional scopes to request (space-separated, e.g., "design:meta:read profile:read")
        - redirect_url: Optional URL to redirect to after authorization completes

        Parameters
        ----------
        instance_id : str
            Unique identifier for the client instance requesting authorization

        client_id : typing.Optional[str]
            Client ID for white labeling, if not provided will use default credentials

        scope : typing.Optional[str]
            Optional OAuth scopes to request (space-separated string)

        redirect_url : typing.Optional[str]
            Optional URL to redirect to after authorization completes

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.canva_oauth.authorize_canva(
                instance_id="instance_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.authorize_canva(
            instance_id=instance_id,
            client_id=client_id,
            scope=scope,
            redirect_url=redirect_url,
            request_options=request_options,
        )
        return _response.data
