# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawDialpadOauthClient, RawDialpadOauthClient


class DialpadOauthClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDialpadOauthClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDialpadOauthClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDialpadOauthClient
        """
        return self._raw_client

    def authorize_dialpad(
        self,
        *,
        instance_id: str,
        client_id: typing.Optional[str] = None,
        scope: typing.Optional[str] = None,
        redirect_url: typing.Optional[str] = None,
        code_challenge: typing.Optional[str] = None,
        code_challenge_method: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Start Dialpad OAuth flow

        Parameters:
        - instance_id: Identifier for the instance requesting authorization
        - client_id: Optional client ID for white labeling
        - scope: Optional scopes to request (space-separated)
        - redirect_url: Optional URL to redirect to after authorization completes
        - code_challenge: PKCE code challenge for enhanced security
        - code_challenge_method: PKCE code challenge method

        Parameters
        ----------
        instance_id : str
            Unique identifier for the client instance requesting authorization

        client_id : typing.Optional[str]
            Client ID for white labeling, if not provided will use default credentials

        scope : typing.Optional[str]
            Optional OAuth scopes to request (space-separated string)

        redirect_url : typing.Optional[str]
            Optional URL to redirect to after authorization completes

        code_challenge : typing.Optional[str]
            PKCE code challenge for enhanced security

        code_challenge_method : typing.Optional[str]
            PKCE code challenge method (default: S256)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.dialpad_oauth.authorize_dialpad(
            instance_id="instance_id",
        )
        """
        _response = self._raw_client.authorize_dialpad(
            instance_id=instance_id,
            client_id=client_id,
            scope=scope,
            redirect_url=redirect_url,
            code_challenge=code_challenge,
            code_challenge_method=code_challenge_method,
            request_options=request_options,
        )
        return _response.data


class AsyncDialpadOauthClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDialpadOauthClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDialpadOauthClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDialpadOauthClient
        """
        return self._raw_client

    async def authorize_dialpad(
        self,
        *,
        instance_id: str,
        client_id: typing.Optional[str] = None,
        scope: typing.Optional[str] = None,
        redirect_url: typing.Optional[str] = None,
        code_challenge: typing.Optional[str] = None,
        code_challenge_method: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Start Dialpad OAuth flow

        Parameters:
        - instance_id: Identifier for the instance requesting authorization
        - client_id: Optional client ID for white labeling
        - scope: Optional scopes to request (space-separated)
        - redirect_url: Optional URL to redirect to after authorization completes
        - code_challenge: PKCE code challenge for enhanced security
        - code_challenge_method: PKCE code challenge method

        Parameters
        ----------
        instance_id : str
            Unique identifier for the client instance requesting authorization

        client_id : typing.Optional[str]
            Client ID for white labeling, if not provided will use default credentials

        scope : typing.Optional[str]
            Optional OAuth scopes to request (space-separated string)

        redirect_url : typing.Optional[str]
            Optional URL to redirect to after authorization completes

        code_challenge : typing.Optional[str]
            PKCE code challenge for enhanced security

        code_challenge_method : typing.Optional[str]
            PKCE code challenge method (default: S256)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.dialpad_oauth.authorize_dialpad(
                instance_id="instance_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.authorize_dialpad(
            instance_id=instance_id,
            client_id=client_id,
            scope=scope,
            redirect_url=redirect_url,
            code_challenge=code_challenge,
            code_challenge_method=code_challenge_method,
            request_options=request_options,
        )
        return _response.data
