# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.call_tool_response import CallToolResponse
from ..types.connection_type import ConnectionType
from ..types.create_self_hosted_server_response import CreateSelfHostedServerResponse
from ..types.create_server_response import CreateServerResponse
from ..types.external_server_request import ExternalServerRequest
from ..types.get_auth_data_response import GetAuthDataResponse
from ..types.get_instance_response import GetInstanceResponse
from ..types.get_mcp_servers_response import GetMcpServersResponse
from ..types.get_o_auth_url_response import GetOAuthUrlResponse
from ..types.list_tools_response import ListToolsResponse
from ..types.mcp_server_name import McpServerName
from ..types.status_response import StatusResponse
from ..types.strata_add_servers_response import StrataAddServersResponse
from ..types.strata_create_response import StrataCreateResponse
from ..types.strata_delete_servers_response import StrataDeleteServersResponse
from ..types.strata_get_response import StrataGetResponse
from ..types.tool_format import ToolFormat
from .raw_client import AsyncRawMcpServerClient, RawMcpServerClient
from .types.authdata import Authdata
from .types.servers import Servers

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class McpServerClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMcpServerClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawMcpServerClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMcpServerClient
        """
        return self._raw_client

    def call_tools(
        self,
        *,
        server_url: str,
        tool_name: str,
        tool_args: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        connection_type: typing.Optional[ConnectionType] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CallToolResponse:
        """
        Calls a tool on a specific remote MCP server, used for function calling. Eliminates the need for manual MCP code implementation.
        Under the hood, Klavis will instantiates an MCP client and establishes a connection with the remote MCP server to call the tool.

        Parameters
        ----------
        server_url : str
            The full URL for connecting to the MCP server

        tool_name : str
            The name of the tool to call

        tool_args : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The input parameters for the tool

        connection_type : typing.Optional[ConnectionType]
            The connection type to use for the MCP server. Default is STREAMABLE_HTTP.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CallToolResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.mcp_server.call_tools(
            server_url="serverUrl",
            tool_name="toolName",
        )
        """
        _response = self._raw_client.call_tools(
            server_url=server_url,
            tool_name=tool_name,
            tool_args=tool_args,
            connection_type=connection_type,
            request_options=request_options,
        )
        return _response.data

    def list_tools(
        self,
        *,
        server_url: str,
        connection_type: typing.Optional[ConnectionType] = OMIT,
        format: typing.Optional[ToolFormat] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListToolsResponse:
        """
        Lists all tools available for a specific remote MCP server in various AI model formats.

        This eliminates the need for manual MCP code implementation and format conversion.
        Under the hood, Klavis instantiates an MCP client and establishes a connection
        with the remote MCP server to retrieve available tools.

        Parameters
        ----------
        server_url : str
            The full URL for connecting to the MCP server

        connection_type : typing.Optional[ConnectionType]
            The connection type to use for the MCP server. Default is STREAMABLE_HTTP.

        format : typing.Optional[ToolFormat]
            The format to return tools in. Default is MCP Native format for maximum compatibility.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListToolsResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.mcp_server.list_tools(
            server_url="serverUrl",
        )
        """
        _response = self._raw_client.list_tools(
            server_url=server_url, connection_type=connection_type, format=format, request_options=request_options
        )
        return _response.data

    def create_strata_server(
        self,
        *,
        user_id: str,
        servers: typing.Optional[Servers] = OMIT,
        external_servers: typing.Optional[typing.Sequence[ExternalServerRequest]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> StrataCreateResponse:
        """
        Create a Strata MCP server.

        Parameters:
        - servers: Can be 'ALL' to add all available Klavis MCP servers, a list of specific server names, or null to add no servers
        - externalServers: Optional list of external MCP servers to validate and add

        Parameters
        ----------
        user_id : str
            The identifier for the user

        servers : typing.Optional[Servers]
            List of Klavis MCP servers to enable (e.g., 'jira', 'linear'), 'ALL' to add all Klavis MCP servers, or null to add no servers.

        external_servers : typing.Optional[typing.Sequence[ExternalServerRequest]]
            Optional list of external MCP servers to add with their URLs. Each server will be validated before being added.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StrataCreateResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.mcp_server.create_strata_server(
            user_id="userId",
        )
        """
        _response = self._raw_client.create_strata_server(
            user_id=user_id, servers=servers, external_servers=external_servers, request_options=request_options
        )
        return _response.data

    def add_servers_to_strata(
        self,
        *,
        strata_id: str,
        servers: typing.Optional[Servers] = OMIT,
        external_servers: typing.Optional[typing.Sequence[ExternalServerRequest]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> StrataAddServersResponse:
        """
        Add servers to an existing Strata MCP server.

        Parameters:
        - servers: Can be 'ALL' to add all available servers, a list of specific server names, or null to add no servers
        - externalServers: Optional list of external MCP servers to validate and add

        Parameters
        ----------
        strata_id : str
            The strata server ID

        servers : typing.Optional[Servers]
            List of Klavis MCP servers to add (e.g., 'jira', 'linear'), 'ALL' to add all Klavis MCP servers, or null to add no servers.

        external_servers : typing.Optional[typing.Sequence[ExternalServerRequest]]
            Optional list of external MCP servers to add with their URLs. Each server will be validated before being added.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StrataAddServersResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.mcp_server.add_servers_to_strata(
            strata_id="strataId",
        )
        """
        _response = self._raw_client.add_servers_to_strata(
            strata_id=strata_id, servers=servers, external_servers=external_servers, request_options=request_options
        )
        return _response.data

    def delete_servers_from_strata(
        self,
        *,
        strata_id: str,
        servers: typing.Optional[Servers] = OMIT,
        external_servers: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> StrataDeleteServersResponse:
        """
        Delete servers from an existing Strata MCP server.

        Parameters:
        - servers: Can be 'ALL' to delete all Klavis MCP servers, a list of specific server names, or null to delete no servers
        - externalServers: Optional list of external server names to delete

        Returns separate lists for deleted Klavis servers and deleted external servers.

        Parameters
        ----------
        strata_id : str
            The strata server ID

        servers : typing.Optional[Servers]
            List of Klavis MCP servers to delete (e.g., 'jira', 'linear'), 'ALL' to delete all Klavis MCP servers, or null to delete no servers.

        external_servers : typing.Optional[typing.Sequence[str]]
            Optional list of external server names to delete. These are the names of previously added external MCP servers.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StrataDeleteServersResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.mcp_server.delete_servers_from_strata(
            strata_id="strataId",
        )
        """
        _response = self._raw_client.delete_servers_from_strata(
            strata_id=strata_id, servers=servers, external_servers=external_servers, request_options=request_options
        )
        return _response.data

    def get_strata_instance(self, *, request_options: typing.Optional[RequestOptions] = None) -> StrataGetResponse:
        """
        Get information about an existing Strata MCP server instance.
        Returns the strata URL, connected klavis servers, connected external servers (with URLs),
        and authentication URLs for klavis servers.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StrataGetResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.mcp_server.get_strata_instance()
        """
        _response = self._raw_client.get_strata_instance(request_options=request_options)
        return _response.data

    def create_server_instance(
        self,
        *,
        server_name: McpServerName,
        user_id: str,
        platform_name: typing.Optional[str] = OMIT,
        connection_type: typing.Optional[ConnectionType] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateServerResponse:
        """
        Creates a URL for a specified MCP server,
        validating the request with an API key and user details.
        Returns the existing server URL if it already exists for the user.
        If OAuth is configured for the server, also returns the base OAuth authorization URL.

        Parameters
        ----------
        server_name : McpServerName
            The name of the target MCP server. Case-insensitive (e.g., 'google calendar', 'GOOGLE_CALENDAR', 'Google Calendar' are all valid).

        user_id : str
            The identifier for the user requesting the server URL.

        platform_name : typing.Optional[str]
            The name of the platform associated with the user. Optional.

        connection_type : typing.Optional[ConnectionType]
            The connection type to use for the MCP server. Default is STREAMABLE_HTTP.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateServerResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis, McpServerName

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.mcp_server.create_server_instance(
            server_name=McpServerName.AFFINITY,
            user_id="userId",
        )
        """
        _response = self._raw_client.create_server_instance(
            server_name=server_name,
            user_id=user_id,
            platform_name=platform_name,
            connection_type=connection_type,
            request_options=request_options,
        )
        return _response.data

    def create_self_hosted_server_instance(
        self, *, server_name: McpServerName, user_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateSelfHostedServerResponse:
        """
        Creates an instance id for a self-hosted MCP server,
        validating the request with an API key and user details.
        The main purpose of this endpoint is to create an instance id for a self-hosted MCP server.
        The instance id is used to identify and store the auth metadata in the database.
        Returns the existing instance id if it already exists for the user.

        Parameters
        ----------
        server_name : McpServerName
            The name of the target MCP server. Case-insensitive (e.g., 'google calendar', 'GOOGLE_CALENDAR', 'Google Calendar' are all valid).

        user_id : str
            The identifier for the user requesting the server URL.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateSelfHostedServerResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis, McpServerName

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.mcp_server.create_self_hosted_server_instance(
            server_name=McpServerName.AFFINITY,
            user_id="userId",
        )
        """
        _response = self._raw_client.create_self_hosted_server_instance(
            server_name=server_name, user_id=user_id, request_options=request_options
        )
        return _response.data

    def get_server_instance(
        self, instance_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetInstanceResponse:
        """
        Checks the details of a specific server connection instance using its unique ID and API key,
        returning server details like authentication status and associated server/platform info.

        Parameters
        ----------
        instance_id : str
            The ID of the connection instance whose status is being checked. This is returned by the Create API.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetInstanceResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.mcp_server.get_server_instance(
            instance_id="instance_id",
        )
        """
        _response = self._raw_client.get_server_instance(instance_id, request_options=request_options)
        return _response.data

    def delete_instance_auth(
        self, instance_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> StatusResponse:
        """
        Deletes authentication data for a specific server connection instance.

        Parameters
        ----------
        instance_id : str
            The ID of the connection instance to delete auth for.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StatusResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.mcp_server.delete_instance_auth(
            instance_id="instance_id",
        )
        """
        _response = self._raw_client.delete_instance_auth(instance_id, request_options=request_options)
        return _response.data

    def delete_server_instance(
        self, instance_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> StatusResponse:
        """
        Completely removes a server connection instance using its unique ID,
        deleting all associated data from the system.

        Parameters
        ----------
        instance_id : str
            The ID of the connection instance to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StatusResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.mcp_server.delete_server_instance(
            instance_id="instance_id",
        )
        """
        _response = self._raw_client.delete_server_instance(instance_id, request_options=request_options)
        return _response.data

    def get_tools(
        self,
        server_name: McpServerName,
        *,
        format: typing.Optional[ToolFormat] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListToolsResponse:
        """
        Get tools information for any MCP server.

        Parameters
        ----------
        server_name : McpServerName
            The name of the target MCP server. Case-insensitive (e.g., 'google calendar', 'GOOGLE_CALENDAR', 'Google Calendar' are all valid).

        format : typing.Optional[ToolFormat]
            The format to return tools in. Default is MCP Native format for maximum compatibility.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListToolsResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis, McpServerName

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.mcp_server.get_tools(
            server_name=McpServerName.AFFINITY,
        )
        """
        _response = self._raw_client.get_tools(server_name, format=format, request_options=request_options)
        return _response.data

    def get_all_mcp_servers(self, *, request_options: typing.Optional[RequestOptions] = None) -> GetMcpServersResponse:
        """
        Get all MCP servers with their basic information including id, name, description, and tools.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetMcpServersResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.mcp_server.get_all_mcp_servers()
        """
        _response = self._raw_client.get_all_mcp_servers(request_options=request_options)
        return _response.data

    def set_instance_auth(
        self, *, instance_id: str, auth_data: Authdata, request_options: typing.Optional[RequestOptions] = None
    ) -> StatusResponse:
        """
        Sets authentication data for a specific instance.
        Accepts either API key authentication or general authentication data.
        This updates the auth_metadata for the specified instance.

        Parameters
        ----------
        instance_id : str
            The unique identifier for the connection instance

        auth_data : Authdata
            Authentication data

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StatusResponse
            Successful Response

        Examples
        --------
        from klavis import ApiKeyAuth, Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.mcp_server.set_instance_auth(
            instance_id="instanceId",
            auth_data=ApiKeyAuth(
                token="token",
            ),
        )
        """
        _response = self._raw_client.set_instance_auth(
            instance_id=instance_id, auth_data=auth_data, request_options=request_options
        )
        return _response.data

    def get_instance_auth_data(
        self, instance_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetAuthDataResponse:
        """
        Retrieves the auth data for a specific instance that the API key owner controls.
        Includes access token, refresh token, and other authentication data.

        This endpoint includes proper ownership verification to ensure users can only access
        authentication data for instances they own. It also handles token refresh if needed.

        Parameters
        ----------
        instance_id : str
            The ID of the connection instance to get auth data for.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetAuthDataResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.mcp_server.get_instance_auth_data(
            instance_id="instance_id",
        )
        """
        _response = self._raw_client.get_instance_auth_data(instance_id, request_options=request_options)
        return _response.data

    def get_o_auth_url(
        self,
        *,
        server_name: McpServerName,
        instance_id: str,
        client_id: typing.Optional[str] = OMIT,
        scope: typing.Optional[str] = OMIT,
        redirect_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetOAuthUrlResponse:
        """
        Gets the OAuth authorization URL for a specific MCP server and instance.
        Returns the complete OAuth URL with the instance ID as a query parameter.

        Parameters
        ----------
        server_name : McpServerName
            The name of the target MCP server. Case-insensitive (e.g., 'google calendar', 'GOOGLE_CALENDAR', 'Google Calendar' are all valid).

        instance_id : str
            The unique identifier for the connection instance.

        client_id : typing.Optional[str]
            Optional client ID for white labeling. If not provided, will use default credentials.

        scope : typing.Optional[str]
            Optional OAuth scopes to request (comma-separated string).

        redirect_url : typing.Optional[str]
            Optional URL to redirect to after authorization completes.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetOAuthUrlResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis, McpServerName

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.mcp_server.get_o_auth_url(
            server_name=McpServerName.AFFINITY,
            instance_id="instanceId",
        )
        """
        _response = self._raw_client.get_o_auth_url(
            server_name=server_name,
            instance_id=instance_id,
            client_id=client_id,
            scope=scope,
            redirect_url=redirect_url,
            request_options=request_options,
        )
        return _response.data


class AsyncMcpServerClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMcpServerClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMcpServerClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMcpServerClient
        """
        return self._raw_client

    async def call_tools(
        self,
        *,
        server_url: str,
        tool_name: str,
        tool_args: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        connection_type: typing.Optional[ConnectionType] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CallToolResponse:
        """
        Calls a tool on a specific remote MCP server, used for function calling. Eliminates the need for manual MCP code implementation.
        Under the hood, Klavis will instantiates an MCP client and establishes a connection with the remote MCP server to call the tool.

        Parameters
        ----------
        server_url : str
            The full URL for connecting to the MCP server

        tool_name : str
            The name of the tool to call

        tool_args : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The input parameters for the tool

        connection_type : typing.Optional[ConnectionType]
            The connection type to use for the MCP server. Default is STREAMABLE_HTTP.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CallToolResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.mcp_server.call_tools(
                server_url="serverUrl",
                tool_name="toolName",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.call_tools(
            server_url=server_url,
            tool_name=tool_name,
            tool_args=tool_args,
            connection_type=connection_type,
            request_options=request_options,
        )
        return _response.data

    async def list_tools(
        self,
        *,
        server_url: str,
        connection_type: typing.Optional[ConnectionType] = OMIT,
        format: typing.Optional[ToolFormat] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListToolsResponse:
        """
        Lists all tools available for a specific remote MCP server in various AI model formats.

        This eliminates the need for manual MCP code implementation and format conversion.
        Under the hood, Klavis instantiates an MCP client and establishes a connection
        with the remote MCP server to retrieve available tools.

        Parameters
        ----------
        server_url : str
            The full URL for connecting to the MCP server

        connection_type : typing.Optional[ConnectionType]
            The connection type to use for the MCP server. Default is STREAMABLE_HTTP.

        format : typing.Optional[ToolFormat]
            The format to return tools in. Default is MCP Native format for maximum compatibility.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListToolsResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.mcp_server.list_tools(
                server_url="serverUrl",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_tools(
            server_url=server_url, connection_type=connection_type, format=format, request_options=request_options
        )
        return _response.data

    async def create_strata_server(
        self,
        *,
        user_id: str,
        servers: typing.Optional[Servers] = OMIT,
        external_servers: typing.Optional[typing.Sequence[ExternalServerRequest]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> StrataCreateResponse:
        """
        Create a Strata MCP server.

        Parameters:
        - servers: Can be 'ALL' to add all available Klavis MCP servers, a list of specific server names, or null to add no servers
        - externalServers: Optional list of external MCP servers to validate and add

        Parameters
        ----------
        user_id : str
            The identifier for the user

        servers : typing.Optional[Servers]
            List of Klavis MCP servers to enable (e.g., 'jira', 'linear'), 'ALL' to add all Klavis MCP servers, or null to add no servers.

        external_servers : typing.Optional[typing.Sequence[ExternalServerRequest]]
            Optional list of external MCP servers to add with their URLs. Each server will be validated before being added.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StrataCreateResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.mcp_server.create_strata_server(
                user_id="userId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_strata_server(
            user_id=user_id, servers=servers, external_servers=external_servers, request_options=request_options
        )
        return _response.data

    async def add_servers_to_strata(
        self,
        *,
        strata_id: str,
        servers: typing.Optional[Servers] = OMIT,
        external_servers: typing.Optional[typing.Sequence[ExternalServerRequest]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> StrataAddServersResponse:
        """
        Add servers to an existing Strata MCP server.

        Parameters:
        - servers: Can be 'ALL' to add all available servers, a list of specific server names, or null to add no servers
        - externalServers: Optional list of external MCP servers to validate and add

        Parameters
        ----------
        strata_id : str
            The strata server ID

        servers : typing.Optional[Servers]
            List of Klavis MCP servers to add (e.g., 'jira', 'linear'), 'ALL' to add all Klavis MCP servers, or null to add no servers.

        external_servers : typing.Optional[typing.Sequence[ExternalServerRequest]]
            Optional list of external MCP servers to add with their URLs. Each server will be validated before being added.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StrataAddServersResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.mcp_server.add_servers_to_strata(
                strata_id="strataId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.add_servers_to_strata(
            strata_id=strata_id, servers=servers, external_servers=external_servers, request_options=request_options
        )
        return _response.data

    async def delete_servers_from_strata(
        self,
        *,
        strata_id: str,
        servers: typing.Optional[Servers] = OMIT,
        external_servers: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> StrataDeleteServersResponse:
        """
        Delete servers from an existing Strata MCP server.

        Parameters:
        - servers: Can be 'ALL' to delete all Klavis MCP servers, a list of specific server names, or null to delete no servers
        - externalServers: Optional list of external server names to delete

        Returns separate lists for deleted Klavis servers and deleted external servers.

        Parameters
        ----------
        strata_id : str
            The strata server ID

        servers : typing.Optional[Servers]
            List of Klavis MCP servers to delete (e.g., 'jira', 'linear'), 'ALL' to delete all Klavis MCP servers, or null to delete no servers.

        external_servers : typing.Optional[typing.Sequence[str]]
            Optional list of external server names to delete. These are the names of previously added external MCP servers.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StrataDeleteServersResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.mcp_server.delete_servers_from_strata(
                strata_id="strataId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_servers_from_strata(
            strata_id=strata_id, servers=servers, external_servers=external_servers, request_options=request_options
        )
        return _response.data

    async def get_strata_instance(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> StrataGetResponse:
        """
        Get information about an existing Strata MCP server instance.
        Returns the strata URL, connected klavis servers, connected external servers (with URLs),
        and authentication URLs for klavis servers.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StrataGetResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.mcp_server.get_strata_instance()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_strata_instance(request_options=request_options)
        return _response.data

    async def create_server_instance(
        self,
        *,
        server_name: McpServerName,
        user_id: str,
        platform_name: typing.Optional[str] = OMIT,
        connection_type: typing.Optional[ConnectionType] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateServerResponse:
        """
        Creates a URL for a specified MCP server,
        validating the request with an API key and user details.
        Returns the existing server URL if it already exists for the user.
        If OAuth is configured for the server, also returns the base OAuth authorization URL.

        Parameters
        ----------
        server_name : McpServerName
            The name of the target MCP server. Case-insensitive (e.g., 'google calendar', 'GOOGLE_CALENDAR', 'Google Calendar' are all valid).

        user_id : str
            The identifier for the user requesting the server URL.

        platform_name : typing.Optional[str]
            The name of the platform associated with the user. Optional.

        connection_type : typing.Optional[ConnectionType]
            The connection type to use for the MCP server. Default is STREAMABLE_HTTP.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateServerResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis, McpServerName

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.mcp_server.create_server_instance(
                server_name=McpServerName.AFFINITY,
                user_id="userId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_server_instance(
            server_name=server_name,
            user_id=user_id,
            platform_name=platform_name,
            connection_type=connection_type,
            request_options=request_options,
        )
        return _response.data

    async def create_self_hosted_server_instance(
        self, *, server_name: McpServerName, user_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateSelfHostedServerResponse:
        """
        Creates an instance id for a self-hosted MCP server,
        validating the request with an API key and user details.
        The main purpose of this endpoint is to create an instance id for a self-hosted MCP server.
        The instance id is used to identify and store the auth metadata in the database.
        Returns the existing instance id if it already exists for the user.

        Parameters
        ----------
        server_name : McpServerName
            The name of the target MCP server. Case-insensitive (e.g., 'google calendar', 'GOOGLE_CALENDAR', 'Google Calendar' are all valid).

        user_id : str
            The identifier for the user requesting the server URL.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateSelfHostedServerResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis, McpServerName

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.mcp_server.create_self_hosted_server_instance(
                server_name=McpServerName.AFFINITY,
                user_id="userId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_self_hosted_server_instance(
            server_name=server_name, user_id=user_id, request_options=request_options
        )
        return _response.data

    async def get_server_instance(
        self, instance_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetInstanceResponse:
        """
        Checks the details of a specific server connection instance using its unique ID and API key,
        returning server details like authentication status and associated server/platform info.

        Parameters
        ----------
        instance_id : str
            The ID of the connection instance whose status is being checked. This is returned by the Create API.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetInstanceResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.mcp_server.get_server_instance(
                instance_id="instance_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_server_instance(instance_id, request_options=request_options)
        return _response.data

    async def delete_instance_auth(
        self, instance_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> StatusResponse:
        """
        Deletes authentication data for a specific server connection instance.

        Parameters
        ----------
        instance_id : str
            The ID of the connection instance to delete auth for.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StatusResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.mcp_server.delete_instance_auth(
                instance_id="instance_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_instance_auth(instance_id, request_options=request_options)
        return _response.data

    async def delete_server_instance(
        self, instance_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> StatusResponse:
        """
        Completely removes a server connection instance using its unique ID,
        deleting all associated data from the system.

        Parameters
        ----------
        instance_id : str
            The ID of the connection instance to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StatusResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.mcp_server.delete_server_instance(
                instance_id="instance_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_server_instance(instance_id, request_options=request_options)
        return _response.data

    async def get_tools(
        self,
        server_name: McpServerName,
        *,
        format: typing.Optional[ToolFormat] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListToolsResponse:
        """
        Get tools information for any MCP server.

        Parameters
        ----------
        server_name : McpServerName
            The name of the target MCP server. Case-insensitive (e.g., 'google calendar', 'GOOGLE_CALENDAR', 'Google Calendar' are all valid).

        format : typing.Optional[ToolFormat]
            The format to return tools in. Default is MCP Native format for maximum compatibility.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListToolsResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis, McpServerName

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.mcp_server.get_tools(
                server_name=McpServerName.AFFINITY,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_tools(server_name, format=format, request_options=request_options)
        return _response.data

    async def get_all_mcp_servers(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetMcpServersResponse:
        """
        Get all MCP servers with their basic information including id, name, description, and tools.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetMcpServersResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.mcp_server.get_all_mcp_servers()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_all_mcp_servers(request_options=request_options)
        return _response.data

    async def set_instance_auth(
        self, *, instance_id: str, auth_data: Authdata, request_options: typing.Optional[RequestOptions] = None
    ) -> StatusResponse:
        """
        Sets authentication data for a specific instance.
        Accepts either API key authentication or general authentication data.
        This updates the auth_metadata for the specified instance.

        Parameters
        ----------
        instance_id : str
            The unique identifier for the connection instance

        auth_data : Authdata
            Authentication data

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StatusResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import ApiKeyAuth, AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.mcp_server.set_instance_auth(
                instance_id="instanceId",
                auth_data=ApiKeyAuth(
                    token="token",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.set_instance_auth(
            instance_id=instance_id, auth_data=auth_data, request_options=request_options
        )
        return _response.data

    async def get_instance_auth_data(
        self, instance_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetAuthDataResponse:
        """
        Retrieves the auth data for a specific instance that the API key owner controls.
        Includes access token, refresh token, and other authentication data.

        This endpoint includes proper ownership verification to ensure users can only access
        authentication data for instances they own. It also handles token refresh if needed.

        Parameters
        ----------
        instance_id : str
            The ID of the connection instance to get auth data for.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetAuthDataResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.mcp_server.get_instance_auth_data(
                instance_id="instance_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_instance_auth_data(instance_id, request_options=request_options)
        return _response.data

    async def get_o_auth_url(
        self,
        *,
        server_name: McpServerName,
        instance_id: str,
        client_id: typing.Optional[str] = OMIT,
        scope: typing.Optional[str] = OMIT,
        redirect_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetOAuthUrlResponse:
        """
        Gets the OAuth authorization URL for a specific MCP server and instance.
        Returns the complete OAuth URL with the instance ID as a query parameter.

        Parameters
        ----------
        server_name : McpServerName
            The name of the target MCP server. Case-insensitive (e.g., 'google calendar', 'GOOGLE_CALENDAR', 'Google Calendar' are all valid).

        instance_id : str
            The unique identifier for the connection instance.

        client_id : typing.Optional[str]
            Optional client ID for white labeling. If not provided, will use default credentials.

        scope : typing.Optional[str]
            Optional OAuth scopes to request (comma-separated string).

        redirect_url : typing.Optional[str]
            Optional URL to redirect to after authorization completes.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetOAuthUrlResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis, McpServerName

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.mcp_server.get_o_auth_url(
                server_name=McpServerName.AFFINITY,
                instance_id="instanceId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_o_auth_url(
            server_name=server_name,
            instance_id=instance_id,
            client_id=client_id,
            scope=scope,
            redirect_url=redirect_url,
            request_options=request_options,
        )
        return _response.data
