# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawPipedriveOauthClient, RawPipedriveOauthClient


class PipedriveOauthClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPipedriveOauthClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPipedriveOauthClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPipedriveOauthClient
        """
        return self._raw_client

    def authorize_pipedrive(
        self,
        *,
        instance_id: str,
        client_id: typing.Optional[str] = None,
        scope: typing.Optional[str] = None,
        redirect_url: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Start Pipedrive OAuth flow

        Parameters:
        - instance_id: Identifier for the instance requesting authorization
        - client_id: Optional client ID for white labeling
        - scope: Optional scopes to request (space-separated)
        - redirect_url: Optional URL to redirect to after authorization completes

        Parameters
        ----------
        instance_id : str
            Unique identifier for the client instance requesting authorization

        client_id : typing.Optional[str]
            Client ID for white labeling, if not provided will use default credentials

        scope : typing.Optional[str]
            Optional OAuth scopes to request (space-separated string)

        redirect_url : typing.Optional[str]
            Optional URL to redirect to after authorization completes

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.pipedrive_oauth.authorize_pipedrive(
            instance_id="instance_id",
        )
        """
        _response = self._raw_client.authorize_pipedrive(
            instance_id=instance_id,
            client_id=client_id,
            scope=scope,
            redirect_url=redirect_url,
            request_options=request_options,
        )
        return _response.data


class AsyncPipedriveOauthClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPipedriveOauthClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPipedriveOauthClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPipedriveOauthClient
        """
        return self._raw_client

    async def authorize_pipedrive(
        self,
        *,
        instance_id: str,
        client_id: typing.Optional[str] = None,
        scope: typing.Optional[str] = None,
        redirect_url: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Start Pipedrive OAuth flow

        Parameters:
        - instance_id: Identifier for the instance requesting authorization
        - client_id: Optional client ID for white labeling
        - scope: Optional scopes to request (space-separated)
        - redirect_url: Optional URL to redirect to after authorization completes

        Parameters
        ----------
        instance_id : str
            Unique identifier for the client instance requesting authorization

        client_id : typing.Optional[str]
            Client ID for white labeling, if not provided will use default credentials

        scope : typing.Optional[str]
            Optional OAuth scopes to request (space-separated string)

        redirect_url : typing.Optional[str]
            Optional URL to redirect to after authorization completes

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pipedrive_oauth.authorize_pipedrive(
                instance_id="instance_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.authorize_pipedrive(
            instance_id=instance_id,
            client_id=client_id,
            scope=scope,
            redirect_url=redirect_url,
            request_options=request_options,
        )
        return _response.data
