# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawSalesforceOauthClient, RawSalesforceOauthClient


class SalesforceOauthClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSalesforceOauthClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSalesforceOauthClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSalesforceOauthClient
        """
        return self._raw_client

    def authorize_salesforce(
        self,
        *,
        instance_id: str,
        client_id: typing.Optional[str] = None,
        scope: typing.Optional[str] = None,
        redirect_url: typing.Optional[str] = None,
        instance_url: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Start Salesforce OAuth flow

        Parameters:
        - instance_id: Identifier for the instance requesting authorization
        - client_id: Optional client ID for white labeling
        - scope: Optional scopes to request (space-separated)
        - redirect_url: Optional URL to redirect to after authorization completes
        - instance_url: Optional Salesforce instance URL for sandbox or custom domains

        Parameters
        ----------
        instance_id : str
            Unique identifier for the client instance requesting authorization

        client_id : typing.Optional[str]
            Client ID for white labeling, if not provided will use default credentials

        scope : typing.Optional[str]
            Optional OAuth scopes to request (space-separated string)

        redirect_url : typing.Optional[str]
            Optional URL to redirect to after authorization completes

        instance_url : typing.Optional[str]
            Salesforce instance URL (e.g., https://mycompany.salesforce.com). If not provided, will use default login.salesforce.com

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.salesforce_oauth.authorize_salesforce(
            instance_id="instance_id",
        )
        """
        _response = self._raw_client.authorize_salesforce(
            instance_id=instance_id,
            client_id=client_id,
            scope=scope,
            redirect_url=redirect_url,
            instance_url=instance_url,
            request_options=request_options,
        )
        return _response.data


class AsyncSalesforceOauthClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSalesforceOauthClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSalesforceOauthClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSalesforceOauthClient
        """
        return self._raw_client

    async def authorize_salesforce(
        self,
        *,
        instance_id: str,
        client_id: typing.Optional[str] = None,
        scope: typing.Optional[str] = None,
        redirect_url: typing.Optional[str] = None,
        instance_url: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Start Salesforce OAuth flow

        Parameters:
        - instance_id: Identifier for the instance requesting authorization
        - client_id: Optional client ID for white labeling
        - scope: Optional scopes to request (space-separated)
        - redirect_url: Optional URL to redirect to after authorization completes
        - instance_url: Optional Salesforce instance URL for sandbox or custom domains

        Parameters
        ----------
        instance_id : str
            Unique identifier for the client instance requesting authorization

        client_id : typing.Optional[str]
            Client ID for white labeling, if not provided will use default credentials

        scope : typing.Optional[str]
            Optional OAuth scopes to request (space-separated string)

        redirect_url : typing.Optional[str]
            Optional URL to redirect to after authorization completes

        instance_url : typing.Optional[str]
            Salesforce instance URL (e.g., https://mycompany.salesforce.com). If not provided, will use default login.salesforce.com

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.salesforce_oauth.authorize_salesforce(
                instance_id="instance_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.authorize_salesforce(
            instance_id=instance_id,
            client_id=client_id,
            scope=scope,
            redirect_url=redirect_url,
            instance_url=instance_url,
            request_options=request_options,
        )
        return _response.data
