# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawSlackOauthClient, RawSlackOauthClient


class SlackOauthClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSlackOauthClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSlackOauthClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSlackOauthClient
        """
        return self._raw_client

    def authorize_slack(
        self,
        *,
        instance_id: str,
        client_id: typing.Optional[str] = None,
        scope: typing.Optional[str] = None,
        user_scope: typing.Optional[str] = None,
        redirect_url: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Start Slack OAuth flow

        Parameters:
        - instance_id: Identifier for the instance requesting authorization
        - client_id: Optional client ID for white labeling
        - scope: Optional scopes to request (comma-separated)
        - user_scope: Optional user-specific scopes to request (comma-separated)
        - redirect_url: Optional URL to redirect to after authorization completes

        Parameters
        ----------
        instance_id : str
            Unique identifier for the client instance requesting authorization

        client_id : typing.Optional[str]
            Client ID for white labeling, if not provided will use default credentials

        scope : typing.Optional[str]
            Optional OAuth scopes to request (comma-separated string)

        user_scope : typing.Optional[str]
            Optional user-specific OAuth scopes to request (comma-separated string)

        redirect_url : typing.Optional[str]
            Optional URL to redirect to after authorization completes

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.slack_oauth.authorize_slack(
            instance_id="instance_id",
        )
        """
        _response = self._raw_client.authorize_slack(
            instance_id=instance_id,
            client_id=client_id,
            scope=scope,
            user_scope=user_scope,
            redirect_url=redirect_url,
            request_options=request_options,
        )
        return _response.data


class AsyncSlackOauthClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSlackOauthClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSlackOauthClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSlackOauthClient
        """
        return self._raw_client

    async def authorize_slack(
        self,
        *,
        instance_id: str,
        client_id: typing.Optional[str] = None,
        scope: typing.Optional[str] = None,
        user_scope: typing.Optional[str] = None,
        redirect_url: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Start Slack OAuth flow

        Parameters:
        - instance_id: Identifier for the instance requesting authorization
        - client_id: Optional client ID for white labeling
        - scope: Optional scopes to request (comma-separated)
        - user_scope: Optional user-specific scopes to request (comma-separated)
        - redirect_url: Optional URL to redirect to after authorization completes

        Parameters
        ----------
        instance_id : str
            Unique identifier for the client instance requesting authorization

        client_id : typing.Optional[str]
            Client ID for white labeling, if not provided will use default credentials

        scope : typing.Optional[str]
            Optional OAuth scopes to request (comma-separated string)

        user_scope : typing.Optional[str]
            Optional user-specific OAuth scopes to request (comma-separated string)

        redirect_url : typing.Optional[str]
            Optional URL to redirect to after authorization completes

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.slack_oauth.authorize_slack(
                instance_id="instance_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.authorize_slack(
            instance_id=instance_id,
            client_id=client_id,
            scope=scope,
            user_scope=user_scope,
            redirect_url=redirect_url,
            request_options=request_options,
        )
        return _response.data
