# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class CreateServerResponse(UniversalBaseModel):
    server_url: typing_extensions.Annotated[str, FieldMetadata(alias="serverUrl")] = pydantic.Field()
    """
    The full URL for connecting to the MCP server, including the instance ID.
    """

    instance_id: typing_extensions.Annotated[str, FieldMetadata(alias="instanceId")] = pydantic.Field()
    """
    The unique identifier for this specific server connection instance.
    """

    oauth_url: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="oauthUrl")] = pydantic.Field(
        default=None
    )
    """
    The OAuth authorization URL for the specified server, if OAuth is configured.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
