# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .external_server_info import ExternalServerInfo


class StrataCreateResponse(UniversalBaseModel):
    strata_server_url: typing_extensions.Annotated[str, FieldMetadata(alias="strataServerUrl")] = pydantic.Field()
    """
    URL to connect to the Strata MCP server
    """

    strata_id: typing_extensions.Annotated[str, FieldMetadata(alias="strataId")] = pydantic.Field()
    """
    The strata server ID
    """

    added_servers: typing_extensions.Annotated[typing.List[str], FieldMetadata(alias="addedServers")] = pydantic.Field()
    """
    List of Klavis MCP servers that were added
    """

    added_external_servers: typing_extensions.Annotated[
        typing.Optional[typing.List[ExternalServerInfo]], FieldMetadata(alias="addedExternalServers")
    ] = pydantic.Field(default=None)
    """
    List of external MCP servers that were added with name and URL
    """

    oauth_urls: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, str]], FieldMetadata(alias="oauthUrls")
    ] = pydantic.Field(default=None)
    """
    Mapping of server name to OAuth URL
    """

    api_key_urls: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, str]], FieldMetadata(alias="apiKeyUrls")
    ] = pydantic.Field(default=None)
    """
    Mapping of server name to API key setup URL
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
