# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.delete_user_response import DeleteUserResponse
from ..types.get_server_instances_response import GetServerInstancesResponse
from .raw_client import AsyncRawUserClient, RawUserClient


class UserClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawUserClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawUserClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawUserClient
        """
        return self._raw_client

    def get_server_instances_by_user(
        self,
        *,
        user_id: str,
        platform_name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetServerInstancesResponse:
        """
        Get all MCP server instances information by user ID and platform name.

        Parameters
        ----------
        user_id : str
            The external user ID

        platform_name : typing.Optional[str]
            The platform name (optional)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetServerInstancesResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.user.get_server_instances_by_user(
            user_id="user_id",
        )
        """
        _response = self._raw_client.get_server_instances_by_user(
            user_id=user_id, platform_name=platform_name, request_options=request_options
        )
        return _response.data

    def delete_user_by_user_id(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeleteUserResponse:
        """
        Delete a user and all associated data by user_id.
        Users cannot delete their own accounts.
        This operation will permanently remove all user data.

        Parameters
        ----------
        user_id : str
            The identifier for the user to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteUserResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.user.delete_user_by_user_id(
            user_id="user_id",
        )
        """
        _response = self._raw_client.delete_user_by_user_id(user_id, request_options=request_options)
        return _response.data


class AsyncUserClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawUserClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawUserClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawUserClient
        """
        return self._raw_client

    async def get_server_instances_by_user(
        self,
        *,
        user_id: str,
        platform_name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetServerInstancesResponse:
        """
        Get all MCP server instances information by user ID and platform name.

        Parameters
        ----------
        user_id : str
            The external user ID

        platform_name : typing.Optional[str]
            The platform name (optional)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetServerInstancesResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.get_server_instances_by_user(
                user_id="user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_server_instances_by_user(
            user_id=user_id, platform_name=platform_name, request_options=request_options
        )
        return _response.data

    async def delete_user_by_user_id(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeleteUserResponse:
        """
        Delete a user and all associated data by user_id.
        Users cannot delete their own accounts.
        This operation will permanently remove all user data.

        Parameters
        ----------
        user_id : str
            The identifier for the user to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteUserResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.delete_user_by_user_id(
                user_id="user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_user_by_user_id(user_id, request_options=request_options)
        return _response.data
