# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawVercelOauthClient, RawVercelOauthClient


class VercelOauthClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawVercelOauthClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawVercelOauthClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawVercelOauthClient
        """
        return self._raw_client

    def authorize_vercel(
        self,
        *,
        instance_id: str,
        client_id: typing.Optional[str] = None,
        client_slug: typing.Optional[str] = None,
        redirect_url: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Start Vercel OAuth flow using integration pattern

        Parameters:
        - instance_id: Identifier for the instance requesting authorization
        - client_id: Optional client ID for white labeling
        - client_slug: Vercel integration slug (required for integration-based OAuth)
        - redirect_url: Optional URL to redirect to after authorization completes

        Parameters
        ----------
        instance_id : str
            Unique identifier for the client instance requesting authorization

        client_id : typing.Optional[str]
            Client ID for white labeling, if not provided will use default credentials

        client_slug : typing.Optional[str]
            Vercel integration slug (required for integration-based OAuth)

        redirect_url : typing.Optional[str]
            Optional URL to redirect to after authorization completes

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.vercel_oauth.authorize_vercel(
            instance_id="instance_id",
        )
        """
        _response = self._raw_client.authorize_vercel(
            instance_id=instance_id,
            client_id=client_id,
            client_slug=client_slug,
            redirect_url=redirect_url,
            request_options=request_options,
        )
        return _response.data


class AsyncVercelOauthClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawVercelOauthClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawVercelOauthClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawVercelOauthClient
        """
        return self._raw_client

    async def authorize_vercel(
        self,
        *,
        instance_id: str,
        client_id: typing.Optional[str] = None,
        client_slug: typing.Optional[str] = None,
        redirect_url: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Start Vercel OAuth flow using integration pattern

        Parameters:
        - instance_id: Identifier for the instance requesting authorization
        - client_id: Optional client ID for white labeling
        - client_slug: Vercel integration slug (required for integration-based OAuth)
        - redirect_url: Optional URL to redirect to after authorization completes

        Parameters
        ----------
        instance_id : str
            Unique identifier for the client instance requesting authorization

        client_id : typing.Optional[str]
            Client ID for white labeling, if not provided will use default credentials

        client_slug : typing.Optional[str]
            Vercel integration slug (required for integration-based OAuth)

        redirect_url : typing.Optional[str]
            Optional URL to redirect to after authorization completes

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.vercel_oauth.authorize_vercel(
                instance_id="instance_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.authorize_vercel(
            instance_id=instance_id,
            client_id=client_id,
            client_slug=client_slug,
            redirect_url=redirect_url,
            request_options=request_options,
        )
        return _response.data
