# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.o_auth_server_name import OAuthServerName
from ..types.white_labeling_response import WhiteLabelingResponse
from .raw_client import AsyncRawWhiteLabelingClient, RawWhiteLabelingClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class WhiteLabelingClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWhiteLabelingClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawWhiteLabelingClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWhiteLabelingClient
        """
        return self._raw_client

    def create_white_labeling(
        self,
        *,
        client_id: str,
        client_secret: str,
        server_name: OAuthServerName,
        callback_url: typing.Optional[str] = OMIT,
        account_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WhiteLabelingResponse:
        """
        Saves OAuth white labeling information, or updates existing information if the `client_id` matches.

        Parameters
        ----------
        client_id : str
            OAuth client ID

        client_secret : str
            OAuth client secret

        server_name : OAuthServerName
            Optional. The name of the server

        callback_url : typing.Optional[str]
            Optional. OAuth callback URL

        account_id : typing.Optional[str]
            Optional. The UUID of the account

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WhiteLabelingResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis, OAuthServerName

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.white_labeling.create_white_labeling(
            client_id="client_id",
            client_secret="client_secret",
            server_name=OAuthServerName.AIRTABLE,
        )
        """
        _response = self._raw_client.create_white_labeling(
            client_id=client_id,
            client_secret=client_secret,
            server_name=server_name,
            callback_url=callback_url,
            account_id=account_id,
            request_options=request_options,
        )
        return _response.data

    def get_white_labeling_by_client_id(
        self, client_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WhiteLabelingResponse:
        """
        Retrieves white labeling information for a specific OAuth client ID.

        Parameters
        ----------
        client_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WhiteLabelingResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.white_labeling.get_white_labeling_by_client_id(
            client_id="client_id",
        )
        """
        _response = self._raw_client.get_white_labeling_by_client_id(client_id, request_options=request_options)
        return _response.data


class AsyncWhiteLabelingClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWhiteLabelingClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWhiteLabelingClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWhiteLabelingClient
        """
        return self._raw_client

    async def create_white_labeling(
        self,
        *,
        client_id: str,
        client_secret: str,
        server_name: OAuthServerName,
        callback_url: typing.Optional[str] = OMIT,
        account_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WhiteLabelingResponse:
        """
        Saves OAuth white labeling information, or updates existing information if the `client_id` matches.

        Parameters
        ----------
        client_id : str
            OAuth client ID

        client_secret : str
            OAuth client secret

        server_name : OAuthServerName
            Optional. The name of the server

        callback_url : typing.Optional[str]
            Optional. OAuth callback URL

        account_id : typing.Optional[str]
            Optional. The UUID of the account

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WhiteLabelingResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis, OAuthServerName

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.white_labeling.create_white_labeling(
                client_id="client_id",
                client_secret="client_secret",
                server_name=OAuthServerName.AIRTABLE,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_white_labeling(
            client_id=client_id,
            client_secret=client_secret,
            server_name=server_name,
            callback_url=callback_url,
            account_id=account_id,
            request_options=request_options,
        )
        return _response.data

    async def get_white_labeling_by_client_id(
        self, client_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WhiteLabelingResponse:
        """
        Retrieves white labeling information for a specific OAuth client ID.

        Parameters
        ----------
        client_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WhiteLabelingResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.white_labeling.get_white_labeling_by_client_id(
                client_id="client_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_white_labeling_by_client_id(client_id, request_options=request_options)
        return _response.data
