# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from ..types.o_auth_server_name import OAuthServerName
from ..types.white_labeling_response import WhiteLabelingResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawWhiteLabelingClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create_white_labeling(
        self,
        *,
        client_id: str,
        client_secret: str,
        server_name: OAuthServerName,
        callback_url: typing.Optional[str] = OMIT,
        account_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[WhiteLabelingResponse]:
        """
        Saves OAuth white labeling information, or updates existing information if the `client_id` matches.

        Parameters
        ----------
        client_id : str
            OAuth client ID

        client_secret : str
            OAuth client secret

        server_name : OAuthServerName
            Optional. The name of the server

        callback_url : typing.Optional[str]
            Optional. OAuth callback URL

        account_id : typing.Optional[str]
            Optional. The UUID of the account

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WhiteLabelingResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "white-labeling/create",
            method="POST",
            json={
                "client_id": client_id,
                "client_secret": client_secret,
                "server_name": server_name,
                "callback_url": callback_url,
                "account_id": account_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WhiteLabelingResponse,
                    parse_obj_as(
                        type_=WhiteLabelingResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_white_labeling_by_client_id(
        self, client_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[WhiteLabelingResponse]:
        """
        Retrieves white labeling information for a specific OAuth client ID.

        Parameters
        ----------
        client_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WhiteLabelingResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"white-labeling/get/{jsonable_encoder(client_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WhiteLabelingResponse,
                    parse_obj_as(
                        type_=WhiteLabelingResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawWhiteLabelingClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create_white_labeling(
        self,
        *,
        client_id: str,
        client_secret: str,
        server_name: OAuthServerName,
        callback_url: typing.Optional[str] = OMIT,
        account_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[WhiteLabelingResponse]:
        """
        Saves OAuth white labeling information, or updates existing information if the `client_id` matches.

        Parameters
        ----------
        client_id : str
            OAuth client ID

        client_secret : str
            OAuth client secret

        server_name : OAuthServerName
            Optional. The name of the server

        callback_url : typing.Optional[str]
            Optional. OAuth callback URL

        account_id : typing.Optional[str]
            Optional. The UUID of the account

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WhiteLabelingResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "white-labeling/create",
            method="POST",
            json={
                "client_id": client_id,
                "client_secret": client_secret,
                "server_name": server_name,
                "callback_url": callback_url,
                "account_id": account_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WhiteLabelingResponse,
                    parse_obj_as(
                        type_=WhiteLabelingResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_white_labeling_by_client_id(
        self, client_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[WhiteLabelingResponse]:
        """
        Retrieves white labeling information for a specific OAuth client ID.

        Parameters
        ----------
        client_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WhiteLabelingResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"white-labeling/get/{jsonable_encoder(client_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WhiteLabelingResponse,
                    parse_obj_as(
                        type_=WhiteLabelingResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
