# Generated by Django 4.2.21 on 2025-08-28

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('account', '0005_group_last_activity'),
    ]

    operations = [
        migrations.CreateModel(
            name='GeoLocatedIP',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True)),
                ('ip_address', models.GenericIPAddressField(db_index=True, unique=True)),
                ('country_code', models.CharField(blank=True, db_index=True, max_length=3, null=True)),
                ('country_name', models.CharField(blank=True, max_length=100, null=True)),
                ('region', models.CharField(blank=True, db_index=True, max_length=100, null=True)),
                ('city', models.CharField(blank=True, max_length=100, null=True)),
                ('postal_code', models.CharField(blank=True, max_length=20, null=True)),
                ('latitude', models.FloatField(blank=True, null=True)),
                ('longitude', models.FloatField(blank=True, null=True)),
                ('timezone', models.CharField(blank=True, max_length=50, null=True)),
                ('provider', models.CharField(blank=True, max_length=50, null=True)),
                ('data', models.JSONField(blank=True, default=dict)),
                ('expires_at', models.DateTimeField(blank=True, default=None, null=True)),
            ],
            options={
                'verbose_name': 'Geolocated IP',
                'verbose_name_plural': 'Geolocated IPs',
            },
        ),
        migrations.CreateModel(
            name='UserDevice',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('duid', models.CharField(db_index=True, max_length=255)),
                ('device_info', models.JSONField(blank=True, default=dict)),
                ('user_agent_hash', models.CharField(blank=True, db_index=True, max_length=64, null=True)),
                ('last_ip', models.GenericIPAddressField(blank=True, null=True)),
                ('first_seen', models.DateTimeField(auto_now_add=True)),
                ('last_seen', models.DateTimeField(auto_now=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='devices', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['-last_seen'],
                'unique_together': {('user', 'duid')},
            },
        ),
        migrations.CreateModel(
            name='UserDeviceLocation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='device_locations_direct', to=settings.AUTH_USER_MODEL)),
                ('ip_address', models.GenericIPAddressField(db_index=True)),
                ('first_seen', models.DateTimeField(auto_now_add=True)),
                ('last_seen', models.DateTimeField(auto_now=True)),
                ('geolocation', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='device_locations', to='account.geolocatedip')),
                ('user_device', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='locations', to='account.userdevice')),
            ],
            options={
                'ordering': ['-last_seen'],
                'unique_together': {('user', 'user_device', 'ip_address')},
            },
        ),
    ]
