"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk8s_app_ts_1 = require("../cdk8s-app-ts");
const logger_1 = require("../logger");
const util_1 = require("./util");
test('test if cdk8s synth is possible', () => {
    const project = new TestCdk8sAppProject({
        cdk8sVersion: '1.0.0-beta.18',
        name: 'project',
        defaultReleaseBranch: 'main',
        releaseWorkflow: true,
        constructsVersion: '3.3.75',
        cdk8sPlusVersion: '1.0.0-beta.18',
    });
    const output = util_1.synthSnapshot(project);
    // expect a synth script
    expect(output['package.json'].scripts.synth).toContain('npx projen synth');
    // expect a synth task
    expect(output['.projen/tasks.json'].tasks.synth.steps).toStrictEqual([{
            exec: 'cdk8s synth',
        }]);
    // expect build step to contain synth
    expect(output['.projen/tasks.json'].tasks.build.steps).toStrictEqual([
        {
            exec: 'npx projen',
        },
        {
            spawn: 'test',
        },
        {
            spawn: 'compile',
        },
        {
            spawn: 'synth',
        },
    ]);
    expect(output['package.json'].dependencies).toStrictEqual({
        'cdk8s': '^1.0.0-beta.18',
        'cdk8s-plus-17': '^1.0.0-beta.18',
        'constructs': '^3.3.75',
    });
});
test('constructs version undefined', () => {
    const project = new TestCdk8sAppProject({
        cdk8sVersion: '1.0.0-beta.11',
        name: 'project',
        defaultReleaseBranch: 'main',
        releaseWorkflow: true,
    });
    const output = util_1.synthSnapshot(project);
    expect(output['package.json'].dependencies).toStrictEqual({
        'cdk8s': '^1.0.0-beta.11',
        'cdk8s-plus-17': '^1.0.0-beta.11',
        'constructs': '^3.2.34',
    });
});
test('constructs version pinning', () => {
    const project = new TestCdk8sAppProject({
        cdk8sVersion: '1.0.0-beta.18',
        name: 'project',
        defaultReleaseBranch: 'main',
        releaseWorkflow: true,
        constructsVersion: '3.3.75',
        constructsVersionPinning: true,
    });
    const output = util_1.synthSnapshot(project);
    expect(output['package.json'].dependencies).toStrictEqual({
        'cdk8s': '^1.0.0-beta.18',
        'cdk8s-plus-17': '^1.0.0-beta.18',
        'constructs': '3.3.75',
    });
});
test('cdk8sPlusVersion undefined', () => {
    const project = new TestCdk8sAppProject({
        cdk8sVersion: '1.0.0-beta.11',
        name: 'project',
        defaultReleaseBranch: 'main',
        releaseWorkflow: true,
        constructsVersion: '3.3.75',
    });
    const output = util_1.synthSnapshot(project);
    expect(output['package.json'].dependencies).toStrictEqual({
        'cdk8s': '^1.0.0-beta.11',
        'cdk8s-plus-17': '^1.0.0-beta.11',
        'constructs': '^3.3.75',
    });
});
test('cdk8sPlusVersion defined', () => {
    const project = new TestCdk8sAppProject({
        cdk8sVersion: '1.0.0-beta.11',
        name: 'project',
        defaultReleaseBranch: 'main',
        cdk8sPlusVersion: '1.0.0-beta.10',
        releaseWorkflow: true,
        constructsVersion: '3.3.75',
    });
    const output = util_1.synthSnapshot(project);
    expect(output['package.json'].dependencies).toStrictEqual({
        'cdk8s': '^1.0.0-beta.11',
        'cdk8s-plus-17': '^1.0.0-beta.10',
        'constructs': '^3.3.75',
    });
});
test('cdk8sPlusVersion pinning', () => {
    const project = new TestCdk8sAppProject({
        cdk8sVersion: '1.0.0-beta.11',
        name: 'project',
        defaultReleaseBranch: 'main',
        cdk8sPlusVersion: '1.0.0-beta.10',
        cdk8sPlusVersionPinning: true,
        releaseWorkflow: true,
        constructsVersion: '3.3.75',
    });
    const output = util_1.synthSnapshot(project);
    expect(output['package.json'].dependencies).toStrictEqual({
        'cdk8s': '^1.0.0-beta.11',
        'cdk8s-plus-17': '1.0.0-beta.10',
        'constructs': '^3.3.75',
    });
});
class TestCdk8sAppProject extends cdk8s_app_ts_1.Cdk8sTypeScriptApp {
    constructor(options) {
        super({
            outdir: util_1.mkdtemp(),
            logging: {
                level: logger_1.LogLevel.OFF,
            },
            ...options,
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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