"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk8s_construct_1 = require("../cdk8s-construct");
const logger_1 = require("../logger");
const util_1 = require("./util");
test('constructs version defined', () => {
    const project = new TestCdk8sConstructsProject({
        cdk8sVersion: '1.0.0-beta.18',
        name: 'project',
        defaultReleaseBranch: 'main',
        releaseWorkflow: true,
        constructsVersion: '3.3.75',
        repositoryUrl: 'github.com/test/test',
        author: 'test',
        authorAddress: 'test@test.com',
    });
    const output = util_1.synthSnapshot(project);
    expect(output['package.json'].peerDependencies).toStrictEqual({
        'cdk8s': '^1.0.0-beta.18',
        'cdk8s-plus-17': '^1.0.0-beta.18',
        'constructs': '^3.3.75',
    });
});
test('constructs version undefined', () => {
    const project = new TestCdk8sConstructsProject({
        cdk8sVersion: '1.0.0-beta.11',
        name: 'project',
        defaultReleaseBranch: 'main',
        releaseWorkflow: true,
        repositoryUrl: 'github.com/test/test',
        author: 'test',
        authorAddress: 'test@test.com',
    });
    const output = util_1.synthSnapshot(project);
    expect(output['package.json'].peerDependencies).toStrictEqual({
        'cdk8s': '^1.0.0-beta.11',
        'cdk8s-plus-17': '^1.0.0-beta.11',
        'constructs': '^3.2.34',
    });
});
test('constructs version pinning', () => {
    const project = new TestCdk8sConstructsProject({
        cdk8sVersion: '1.0.0-beta.18',
        name: 'project',
        defaultReleaseBranch: 'main',
        releaseWorkflow: true,
        constructsVersion: '3.3.75',
        constructsVersionPinning: true,
        repositoryUrl: 'github.com/test/test',
        author: 'test',
        authorAddress: 'test@test.com',
    });
    const output = util_1.synthSnapshot(project);
    expect(output['package.json'].peerDependencies).toStrictEqual({
        'cdk8s': '^1.0.0-beta.18',
        'cdk8s-plus-17': '^1.0.0-beta.18',
        'constructs': '3.3.75',
    });
});
test('cdk8sPlusVersion undefined', () => {
    const project = new TestCdk8sConstructsProject({
        cdk8sVersion: '1.0.0-beta.11',
        name: 'project',
        defaultReleaseBranch: 'main',
        releaseWorkflow: true,
        repositoryUrl: 'github.com/test/test',
        author: 'test',
        authorAddress: 'test@test.com',
        constructsVersion: '3.3.75',
    });
    const output = util_1.synthSnapshot(project);
    expect(output['package.json'].peerDependencies).toStrictEqual({
        'cdk8s': '^1.0.0-beta.11',
        'cdk8s-plus-17': '^1.0.0-beta.11',
        'constructs': '^3.3.75',
    });
});
test('cdk8sPlusVersion defined', () => {
    const project = new TestCdk8sConstructsProject({
        cdk8sVersion: '1.0.0-beta.11',
        name: 'project',
        defaultReleaseBranch: 'main',
        cdk8sPlusVersion: '1.0.0-beta.10',
        releaseWorkflow: true,
        repositoryUrl: 'github.com/test/test',
        author: 'test',
        authorAddress: 'test@test.com',
        constructsVersion: '3.3.75',
    });
    const output = util_1.synthSnapshot(project);
    expect(output['package.json'].peerDependencies).toStrictEqual({
        'cdk8s': '^1.0.0-beta.11',
        'cdk8s-plus-17': '^1.0.0-beta.10',
        'constructs': '^3.3.75',
    });
});
test('cdk8sPlusVersion pinning', () => {
    const project = new TestCdk8sConstructsProject({
        cdk8sVersion: '1.0.0-beta.11',
        name: 'project',
        defaultReleaseBranch: 'main',
        cdk8sPlusVersion: '1.0.0-beta.10',
        cdk8sPlusVersionPinning: true,
        releaseWorkflow: true,
        repositoryUrl: 'github.com/test/test',
        author: 'test',
        authorAddress: 'test@test.com',
        constructsVersion: '3.3.75',
    });
    const output = util_1.synthSnapshot(project);
    expect(output['package.json'].peerDependencies).toStrictEqual({
        'cdk8s': '^1.0.0-beta.11',
        'cdk8s-plus-17': '1.0.0-beta.10',
        'constructs': '^3.3.75',
    });
});
class TestCdk8sConstructsProject extends cdk8s_construct_1.ConstructLibraryCdk8s {
    constructor(options) {
        super({
            outdir: util_1.mkdtemp(),
            logging: {
                level: logger_1.LogLevel.OFF,
            },
            ...options,
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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