"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const auto_approve_1 = require("../../github/auto-approve");
const node_project_1 = require("../../node-project");
const util_1 = require("../util");
describe('auto-approve', () => {
    test('default', () => {
        const project = createProject();
        new auto_approve_1.AutoApprove(project.github, {
            secret: 'MY_SECRET',
        });
        const snapshot = util_1.synthSnapshot(project);
        expect(snapshot['.github/workflows/auto-approve.yml']).toBeDefined();
        expect(snapshot['.github/workflows/auto-approve.yml']).toMatchSnapshot();
    });
    test('configure options', () => {
        const project = createProject();
        new auto_approve_1.AutoApprove(project.github, {
            secret: 'MY_SECRET',
            label: 'my-approve',
            allowedUsernames: ['bot-1', 'bot-2'],
        });
        const snapshot = util_1.synthSnapshot(project);
        expect(snapshot['.github/workflows/auto-approve.yml']).toMatchSnapshot();
    });
    test('all users', () => {
        const project = createProject();
        new auto_approve_1.AutoApprove(project.github, {
            secret: 'MY_SECRET',
            allowedUsernames: [],
        });
        const snapshot = util_1.synthSnapshot(project);
        expect(snapshot['.github/workflows/auto-approve.yml']).toMatchSnapshot();
    });
});
function createProject(options = {}) {
    return new node_project_1.NodeProject({
        outdir: util_1.mkdtemp(),
        defaultReleaseBranch: 'main',
        name: 'node-project',
        ...options,
    });
}
//# sourceMappingURL=data:application/json;base64,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