"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const github_1 = require("../../github");
const node_project_1 = require("../../node-project");
const util_1 = require("../util");
describe('dependabot', () => {
    test('default', () => {
        const project = createProject();
        new github_1.Dependabot(project.github);
        const snapshot = util_1.synthSnapshot(project);
        expect(snapshot['.github/dependabot.yml']).toBeDefined();
        expect(snapshot['.github/dependabot.yml']).toMatchSnapshot();
    });
    test('private registries', () => {
        const project = createProject();
        const registryName = 'npm-registry-npm-pkg-github-com';
        new github_1.Dependabot(project.github, {
            registries: {
                [registryName]: {
                    type: github_1.DependabotRegistryType.NPM_REGISTRY,
                    url: 'https://npm.pkg.github.com',
                    token: '${{ secrets.TOKEN }}',
                    replacesBase: true,
                    username: 'test',
                    password: '${{ secrets.TOKEN }}',
                    key: 'abc123',
                },
            },
        });
        const snapshot = util_1.synthSnapshot(project);
        const dependabot = snapshot['.github/dependabot.yml'];
        expect(dependabot).toBeDefined();
        expect(dependabot).toMatchSnapshot();
        expect(dependabot).toContain('registries');
        expect(dependabot).toContain(registryName);
    });
});
function createProject(options = {}) {
    return new node_project_1.NodeProject({
        outdir: util_1.mkdtemp(),
        defaultReleaseBranch: 'main',
        name: 'node-project',
        ...options,
    });
}
//# sourceMappingURL=data:application/json;base64,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