"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const logger_1 = require("../../logger");
const node_project_1 = require("../../node-project");
const util_1 = require("../util");
describe('mergify', () => {
    test('default', () => {
        // GIVEN
        const project = createProject();
        // WHEN
        // THEN
        const snapshot = util_1.synthSnapshot(project);
        expect(snapshot['.mergify.yml']).toBeDefined();
        expect(snapshot['.mergify.yml']).toMatchSnapshot();
    });
    test('with options', () => {
        // GIVEN
        const project = createProject({
            autoMergeOptions: {
                approvedReviews: 3,
                blockingLabels: ['do-not-merge', 'missing-tests'],
            },
        });
        // THEN
        const snapshot = util_1.synthSnapshot(project);
        expect(snapshot['.mergify.yml']).toBeDefined();
        expect(snapshot['.mergify.yml']).toContain('- -label~=(do-not-merge|missing-tests)');
        expect(snapshot['.mergify.yml']).toContain('- "#approved-reviews-by>=3"');
        expect(snapshot['.mergify.yml']).toMatchSnapshot();
    });
});
function createProject(options = {}) {
    return new node_project_1.NodeProject({
        outdir: util_1.mkdtemp(),
        defaultReleaseBranch: 'main',
        name: 'node-project',
        logging: {
            level: logger_1.LogLevel.OFF,
        },
        ...options,
    });
}
//# sourceMappingURL=data:application/json;base64,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