"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const stale_util_1 = require("../../github/stale-util");
const util_1 = require("../util");
const defaults = { stale: 10, close: 11, type: 'issue' };
test('default project behavior', () => {
    const project = new util_1.TestProject();
    expect(util_1.synthSnapshot(project)['.github/workflows/stale.yml']).toMatchSnapshot();
});
test('stale disabled', () => {
    const project = new util_1.TestProject({
        stale: false,
    });
    expect(util_1.synthSnapshot(project)['.github/workflows/stale.yml']).toBeUndefined();
});
test('customizations', () => {
    const project = new util_1.TestProject({
        staleOptions: {
            issues: { enabled: false },
            pullRequest: {
                closeMessage: 'closing pull request',
                staleLabel: 'I-AM-STALE',
                daysBeforeStale: 30,
            },
        },
    });
    expect(util_1.synthSnapshot(project)['.github/workflows/stale.yml']).toMatchSnapshot();
});
describe('renderBehavior()', () => {
    test('defaults', () => {
        expect(stale_util_1.renderBehavior(undefined, { stale: 10, close: 11, type: 'issue' })).toStrictEqual({
            closeMessage: "Closing this issue as it hasn't seen activity for a while. Please add a comment @mentioning a maintainer to reopen.",
            daysBeforeClose: 11,
            daysBeforeStale: 10,
            staleLabel: 'stale',
            staleMessage: "This issue is now marked as stale because it hasn't seen activity for a while. Add a comment or it will be closed soon.",
        });
        expect(stale_util_1.renderBehavior(undefined, { stale: 99, close: 65, type: 'xomo' })).toStrictEqual({
            closeMessage: "Closing this xomo as it hasn't seen activity for a while. Please add a comment @mentioning a maintainer to reopen.",
            daysBeforeClose: 65,
            daysBeforeStale: 99,
            staleLabel: 'stale',
            staleMessage: "This xomo is now marked as stale because it hasn't seen activity for a while. Add a comment or it will be closed soon.",
        });
    });
    test('disabled', () => {
        expect(stale_util_1.renderBehavior({ enabled: false }, defaults)).toMatchObject({
            daysBeforeClose: -1,
            daysBeforeStale: -1,
        });
    });
    test('customize', () => {
        const behavior = {
            closeMessage: 'I am the close message',
            daysBeforeClose: 1,
            daysBeforeStale: 2,
            staleLabel: 'my-label',
            staleMessage: 'I am stale',
        };
        expect(stale_util_1.renderBehavior(behavior, defaults)).toStrictEqual({
            closeMessage: 'I am the close message',
            daysBeforeClose: 1,
            daysBeforeStale: 2,
            staleLabel: 'my-label',
            staleMessage: 'I am stale',
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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