"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const task_workflow_1 = require("../../github/task-workflow");
const tasks_1 = require("../../tasks");
const util_1 = require("../util");
describe('task-workflow', () => {
    test('default', () => {
        const project = new util_1.TestProject();
        new task_workflow_1.TaskWorkflow(project.github, {
            name: 'task-workflow',
            task,
            permissions: {},
        });
        const snapshot = util_1.synthSnapshot(project);
        expect(snapshot['.github/workflows/task-workflow.yml']).toBeDefined();
        expect(snapshot['.github/workflows/task-workflow.yml']).toMatchSnapshot();
    });
    test('upload artifacts', () => {
        const project = new util_1.TestProject();
        new task_workflow_1.TaskWorkflow(project.github, {
            name: 'task-workflow',
            task,
            artifactsDirectory: './artifacts/',
            permissions: {},
        });
        const snapshot = util_1.synthSnapshot(project);
        expect(snapshot['.github/workflows/task-workflow.yml']).toMatchSnapshot();
    });
    test('issue comment error', () => {
        const project = new util_1.TestProject();
        expect(() => new task_workflow_1.TaskWorkflow(project.github, {
            name: 'task-workflow',
            task,
            triggers: {
                issueComment: {},
            },
            permissions: {},
        })).toThrow(/Trigger \"issueComment\" should not be used due to a security concern/);
    });
});
const task = new tasks_1.Task('gh-workflow-test', {
    description: 'Task GitHub workflow test',
});
//# sourceMappingURL=data:application/json;base64,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