"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const npm_config_1 = require("../../javascript/npm-config");
const logger_1 = require("../../logger");
const node_project_1 = require("../../node-project");
const util_1 = require("../util");
test('registry is handled correctly', () => {
    const prj = new TestNodeProject({
        name: 'test-project',
        defaultReleaseBranch: 'main',
    });
    const npmrc = new npm_config_1.NpmConfig(prj, {
        registry: 'https://my.registry.com/mirror',
    });
    npmrc.addRegistry('https://my.registry.com/private', '@company');
    const out = util_1.synthSnapshot(prj);
    expect(out['.npmrc']).toMatchSnapshot();
});
test('default registry is used correctly', () => {
    const prj = new TestNodeProject({
        name: 'test-project',
        defaultReleaseBranch: 'main',
    });
    const npmrc = new npm_config_1.NpmConfig(prj);
    npmrc.addRegistry('https://my.registry.com/private', '@company');
    const out = util_1.synthSnapshot(prj);
    expect(out['.npmrc']).toMatchSnapshot();
});
test('override default registry via setter', () => {
    const prj = new TestNodeProject({
        name: 'test-project',
        defaultReleaseBranch: 'main',
    });
    const npmrc = new npm_config_1.NpmConfig(prj, {
        registry: 'https://my.registry.com/mirror',
    });
    npmrc.addRegistry('https://my.registry.com/mirror2');
    npmrc.addRegistry('https://my.registry.com/private', '@company');
    const out = util_1.synthSnapshot(prj);
    expect(out['.npmrc']).toMatchSnapshot();
});
test('generic prop is set correctly', () => {
    const prj = new TestNodeProject({
        name: 'test-project',
        defaultReleaseBranch: 'main',
    });
    const npmrc = new npm_config_1.NpmConfig(prj);
    npmrc.addConfig('key', 'value');
    const out = util_1.synthSnapshot(prj);
    expect(out['.npmrc']).toMatchSnapshot();
});
class TestNodeProject extends node_project_1.NodeProject {
    constructor(options = {}) {
        super({
            outdir: util_1.mkdtemp(),
            name: 'test-node-project',
            logging: {
                level: logger_1.LogLevel.OFF,
            },
            defaultReleaseBranch: 'master',
            ...options,
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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