"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const license_1 = require("../license");
const util_1 = require("./util");
test('apache with defaults', () => {
    const project = new util_1.TestProject();
    new license_1.License(project, {
        spdx: 'Apache-2.0',
    });
    expect(util_1.synthSnapshot(project).LICENSE).toMatchSnapshot();
});
test('fails for MIT with no owner because substitution is required', () => {
    const project = new util_1.TestProject();
    expect(() => new license_1.License(project, {
        spdx: 'MIT',
    })).toThrow(/The MIT license requires \"copyrightOwner\" to be specified/);
});
test('MIT with owner', () => {
    const project = new util_1.TestProject();
    new license_1.License(project, {
        spdx: 'MIT',
        copyrightOwner: 'John Doe',
    });
    expect(util_1.synthSnapshot(project).LICENSE).toMatchSnapshot();
});
test('MIT with owner and period', () => {
    const project = new util_1.TestProject();
    new license_1.License(project, {
        spdx: 'MIT',
        copyrightOwner: 'John Doe',
        copyrightPeriod: '1900-1920',
    });
    expect(util_1.synthSnapshot(project).LICENSE).toMatchSnapshot();
});
//# sourceMappingURL=data:application/json;base64,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