"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const __1 = require("..");
const util_1 = require("./util");
test('file paths are relative to the project outdir', () => {
    // GIVEN
    const p = new util_1.TestProject();
    // WHEN
    const f = new __1.TextFile(p, 'foo/bar.txt');
    // THEN
    expect(f.absolutePath).toBe(path.resolve(p.outdir, f.path));
    expect(path.isAbsolute(f.absolutePath)).toBeTruthy();
});
test('all files added to the project can be enumerated', () => {
    // GIVEN
    const p = new util_1.TestProject();
    new __1.TextFile(p, 'my.txt');
    new __1.JsonFile(p, 'your/file/me.json', { obj: {} });
    // WHEN
    const result = p.files;
    // THEN
    const exp = (e) => expect(result.map(x => x.path).includes(e)).toBeTruthy();
    exp('my.txt');
    exp('your/file/me.json');
});
test('findFile() can be used to find a file either absolute or relative path', () => {
    // GIVEN
    const p = new util_1.TestProject();
    const file = new __1.JsonFile(p, 'your/file/me.json', { obj: {} });
    // WHEN
    const result1 = p.tryFindFile('your/file/me.json');
    const result2 = p.tryFindFile(path.resolve(p.outdir, 'your/file/me.json'));
    // THEN
    expect(result1 === file).toBeTruthy();
    expect(result2 === file).toBeTruthy();
});
test('findFile() will also look up files in subprojects', () => {
    // GIVEN
    const p = new util_1.TestProject();
    const child = new __1.Project({ name: 'foobar', parent: p, outdir: 'subproject/foo/bar' });
    const fchild = new __1.TextFile(child, 'fchild.txt');
    // WHEN
    const result1 = p.tryFindFile('subproject/foo/bar/fchild.txt');
    const result2 = child.tryFindFile('fchild.txt');
    // THEN
    expect(result1 === fchild).toBeTruthy();
    expect(result2 === fchild).toBeTruthy();
});
test('autoApprove is configured', () => {
    var _a;
    // WHEN
    const p = new util_1.TestProject({
        autoApproveOptions: {
            secret: 'MY_SECRET',
        },
    });
    // THEN
    expect(p.autoApprove).toBeDefined();
    expect((_a = p.autoApprove) === null || _a === void 0 ? void 0 : _a.label).toEqual('auto-approve');
});
test('github: false disables github integration', () => {
    // WHEN
    const p = new util_1.TestProject({
        github: false,
    });
    // THEN
    expect(p.github).toBeUndefined();
});
//# sourceMappingURL=data:application/json;base64,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