"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const render_options_1 = require("../../javascript/render-options");
const project_1 = require("../../project");
const projenrc_1 = require("../../python/projenrc");
const util_1 = require("../util");
test('projenrc.py support', () => {
    // GIVEN
    const project = new util_1.TestProject();
    // WHEN
    new projenrc_1.Projenrc(project, {
        projenVersion: '1.2.3',
    });
    // THEN
    expect(util_1.synthSnapshot(project)).toMatchSnapshot();
});
test('generate projenrc in python', () => {
    // GIVEN
    const project = new util_1.TestProject(render_options_1.renderProjenNewOptions('projen.python.PythonProject', {}));
    // WHEN
    new projenrc_1.Projenrc(project);
    // THEN
    expect(util_1.synthSnapshot(project)['.projenrc.py']).toMatchSnapshot();
});
test('javascript values are translated to python', () => {
    // GIVEN
    const project = new util_1.TestProject(render_options_1.renderProjenNewOptions('projen.python.PythonProject', {
        stringArg: 'hello',
        intArg: 123,
        floatArg: 123.45,
        booleanArg: false,
        undefinedArg: undefined,
        nullArg: null,
        objectArg: { foo: 'bar' },
        projectType: project_1.ProjectType.LIB,
    }));
    // WHEN
    new projenrc_1.Projenrc(project);
    // THEN
    expect(util_1.synthSnapshot(project)['.projenrc.py']).toMatchSnapshot();
});
//# sourceMappingURL=data:application/json;base64,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