"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TestProject = void 0;
const path = require("path");
const __1 = require("..");
const sample_file_1 = require("../sample-file");
const util_1 = require("./util");
test('sample file from text contents', () => {
    // GIVEN
    const project = new TestProject();
    // WHEN
    new sample_file_1.SampleFile(project, 'welcome.txt', { contents: 'hello\nworld' });
    // THEN
    expect(util_1.synthSnapshot(project)['welcome.txt']).toMatch('hello\nworld');
});
test('sample file from source', () => {
    // GIVEN
    const project = new TestProject();
    // WHEN
    new sample_file_1.SampleFile(project, 'logo.svg', { sourcePath: path.resolve(__dirname, '..', '..', 'logo', 'projen.svg') });
    // THEN
    expect(util_1.synthSnapshot(project)['logo.svg']).toMatch('<?xml version="1.0" encoding="UTF-8" standalone="no"?>');
});
test('sample directory from files', () => {
    // GIVEN
    const project = new TestProject();
    // WHEN
    new sample_file_1.SampleDir(project, 'public', {
        files: {
            'foo.txt': 'Hello world!',
            'bar.txt': 'Test test test',
        },
    });
    // THEN
    const snapshot = util_1.synthSnapshot(project);
    expect(snapshot['public/foo.txt']).toMatch('Hello world!');
    expect(snapshot['public/bar.txt']).toMatch('Test test test');
});
test('sample directory from source', () => {
    // GIVEN
    const project = new TestProject();
    // WHEN
    new sample_file_1.SampleDir(project, 'public', { sourceDir: path.resolve(__dirname, '..', '..', 'assets', 'web', 'react') });
    // THEN
    const snapshot = util_1.synthSnapshot(project);
    expect(snapshot['public/robots.txt'].length).toBeGreaterThan(0);
    expect(snapshot['public/index.html'].length).toBeGreaterThan(0);
    expect(Object.keys(snapshot['public/manifest.json']).length).toBeGreaterThan(0);
});
test('sample directory from source with overwritten files', () => {
    // GIVEN
    const project = new TestProject();
    // WHEN
    new sample_file_1.SampleDir(project, 'public', {
        files: {
            'index.html': '<!doctype html><body>Hello world!</body>',
        },
        sourceDir: path.resolve(__dirname, '..', '..', 'assets', 'web', 'react'),
    });
    // THEN
    const snapshot = util_1.synthSnapshot(project);
    expect(snapshot['public/index.html']).toMatch('<!doctype html><body>Hello world!</body>');
    expect(snapshot['public/robots.txt'].length).toBeGreaterThan(0);
    expect(Object.keys(snapshot['public/manifest.json']).length).toBeGreaterThan(0);
});
class TestProject extends __1.Project {
    constructor(options = {}) {
        const tmpdir = util_1.mkdtemp();
        super({
            name: 'my-project',
            outdir: tmpdir,
            clobber: false,
            logging: {
                level: __1.LogLevel.OFF,
            },
            ...options,
        });
    }
}
exports.TestProject = TestProject;
//# sourceMappingURL=data:application/json;base64,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