"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const __1 = require("..");
const util_1 = require("./util");
test('lines', () => {
    const project = new util_1.TestProject();
    const hello = new __1.SourceCode(project, 'test.txt');
    hello.line('this is my first source file');
    hello.line(); // empty line
    hello.line('last line');
    expect(util_1.synthSnapshot(project)['test.txt']).toStrictEqual([
        'this is my first source file',
        '',
        'last line',
    ].join('\n'));
});
test('open/close', () => {
    const project = new util_1.TestProject();
    const hello = new __1.SourceCode(project, 'test.txt');
    hello.line('level0');
    hello.open();
    hello.line('level1');
    hello.open();
    hello.line('level2');
    hello.close();
    hello.line('level1');
    hello.close();
    hello.line('level0');
    expect(util_1.synthSnapshot(project)['test.txt']).toStrictEqual([
        'level0',
        '  level1',
        '    level2',
        '  level1',
        'level0',
    ].join('\n'));
});
test('indent', () => {
    const project = new util_1.TestProject();
    const hello = new __1.SourceCode(project, 'test.txt', { indent: 4 });
    hello.line('level0');
    hello.open();
    hello.line('level1');
    hello.close();
    hello.line('level0');
    expect(util_1.synthSnapshot(project)['test.txt']).toStrictEqual([
        'level0',
        '    level1',
        'level0',
    ].join('\n'));
});
test('trailing whitespace is trimmed', () => {
    const project = new util_1.TestProject();
    const hello = new __1.SourceCode(project, 'test.txt', { indent: 4 });
    hello.open();
    hello.line();
    hello.open();
    hello.line('hello, world.   ');
    hello.close();
    hello.close();
    expect(util_1.synthSnapshot(project)['test.txt']).toStrictEqual([
        '',
        '        hello, world.',
    ].join('\n'));
});
//# sourceMappingURL=data:application/json;base64,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