"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const __1 = require("..");
const node_project_1 = require("../node-project");
const tasks_1 = require("../tasks");
const util_1 = require("./util");
test('upgrades command includes all dependencies', () => {
    const project = createProject({
        deps: ['some-dep'],
    });
    const deps = 'jest jest-junit npm-check-updates standard-version some-dep';
    const tasks = util_1.synthSnapshot(project)[tasks_1.Tasks.MANIFEST_FILE].tasks;
    expect(tasks['upgrade-dependencies'].steps[2].exec).toStrictEqual(`yarn upgrade ${deps}`);
});
test('upgrades command includes dependencies added post instantiation', () => {
    const project = createProject({});
    project.addDeps('some-dep');
    const deps = 'jest jest-junit npm-check-updates standard-version some-dep';
    const tasks = util_1.synthSnapshot(project)[tasks_1.Tasks.MANIFEST_FILE].tasks;
    expect(tasks['upgrade-dependencies'].steps[2].exec).toStrictEqual(`yarn upgrade ${deps}`);
});
test('upgrades command doesnt include ignored packages', () => {
    const project = createProject({
        projenUpgradeSecret: 'PROJEN_SECRET',
        deps: ['dep1', 'dep2'],
        depsUpgrade: node_project_1.DependenciesUpgradeMechanism.githubWorkflow({
            exclude: ['dep2'],
        }),
    });
    const deps = 'jest jest-junit npm-check-updates standard-version dep1';
    const tasks = util_1.synthSnapshot(project)[tasks_1.Tasks.MANIFEST_FILE].tasks;
    expect(tasks['upgrade-dependencies'].steps[2].exec).toStrictEqual(`yarn upgrade ${deps}`);
});
test('upgrades command includes only included packages', () => {
    const project = createProject({
        projenUpgradeSecret: 'PROJEN_SECRET',
        deps: ['dep1', 'dep2'],
        depsUpgrade: node_project_1.DependenciesUpgradeMechanism.githubWorkflow({
            include: ['dep1'],
        }),
    });
    const deps = 'dep1';
    const tasks = util_1.synthSnapshot(project)[tasks_1.Tasks.MANIFEST_FILE].tasks;
    expect(tasks['upgrade-dependencies'].steps[2].exec).toStrictEqual(`yarn upgrade ${deps}`);
});
test('default options', () => {
    const project = createProject({
        projenUpgradeSecret: 'PROJEN_SECRET',
    });
    const snapshot = util_1.synthSnapshot(project);
    expect(snapshot['.github/workflows/upgrade-dependencies.yml']).toBeDefined();
    expect(snapshot['.github/workflows/upgrade-dependencies.yml']).toMatchSnapshot();
});
test('custom options', () => {
    const project = createProject({
        projenUpgradeSecret: 'PROJEN_SECRET',
        depsUpgrade: node_project_1.DependenciesUpgradeMechanism.githubWorkflow({
            workflowOptions: {
                schedule: __1.UpgradeDependenciesSchedule.MONTHLY,
            },
        }),
    });
    const snapshot = util_1.synthSnapshot(project);
    expect(snapshot['.github/workflows/upgrade-dependencies.yml']).toBeDefined();
    expect(snapshot['.github/workflows/upgrade-dependencies.yml']).toMatchSnapshot();
});
function createProject(options = {}) {
    return new __1.NodeProject({
        outdir: util_1.mkdtemp(),
        defaultReleaseBranch: 'main',
        name: 'node-project',
        ...options,
    });
}
//# sourceMappingURL=data:application/json;base64,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