import { Project, ProjectOptions } from '..';
import { Task } from '../tasks';
export declare class TestProject extends Project {
    constructor(options?: Omit<ProjectOptions, 'name'>);
    runTaskCommand(task: Task): string;
    postSynthesize(): void;
}
export declare function execProjenCLI(workdir: string, args?: string[]): void;
export interface SynthOutput {
    [filePath: string]: any;
}
export declare function mkdtemp(): string;
/**
 * Creates a snapshot of the files generated by a project. Ignores any non-text
 * files so that the snapshots are human readable.
 */
export declare function synthSnapshot(project: Project): any;
export declare function synthSnapshotWithPost(project: Project): SynthOutput;
export interface DirectorySnapshotOptions {
    /**
     * Globs of files to exclude.
     * @default [] include all files
     */
    readonly excludeGlobs?: string[];
}
export declare function directorySnapshot(root: string, options?: DirectorySnapshotOptions): SynthOutput;
/**
 * Removes any non-deterministic aspects from the synthesized output.
 * @param dir The output directory.
 */
export declare function sanitizeOutput(dir: string): void;
